/*
 * Decompiled with CFR 0.152.
 */
package softwares.ohsu.cyclicif;

import arrayTiTi.ArrayFeatures;
import displays.Colors;
import displays.Display;
import filesAndFolders.FilesFolders;
import imageTiTi.ImageArithmetic;
import imageTiTi.ImageComparator;
import imageTiTi.ImageConverter;
import imageTiTi.ImageDrawer;
import imageTiTi.ImageFeatures;
import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import imageTiTi.ImageOperations;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import listTiTi.ListIO;
import listTiTi.ListTools;
import measures.cclh.ConnectedComponentLabeling;
import measures.cclh.FillHole;
import measures.cclh.UnionFindCcl;
import measures.hedgehop.DistanceMapComputer;
import morphee.Close;
import morphee.Dilate;
import morphee.Open;
import morphee.StructuringElement;
import morphee.WhiteTopHat;
import morphee.filters.AreaClosing;
import morphee.filters.AreaOpening;
import morphee.geodesic.ClosingByReconstruction;
import morphee.gradients.GradientDE;
import morphee.segmentation.Skiz;
import morphee.segmentation.watershed.Watershed;
import processing.filters.ContrastEqualizer;
import processing.filters.DynamicExpansion;
import processing.filters.gradients.Sobel;
import processing.thresholding.Binary;
import processing.thresholding.Huang;
import processing.thresholding.ImageThresholder;
import processing.thresholding.Li;
import processing.thresholding.Otsu;
import processing.thresholding.Renyi;
import processing.thresholding.TriangleThresholding;
import processing.zprojection.ZProjectionCMM;
import segmentation.cells.DapiMM;
import softwares.ohsu.cyclicif.CycIF_Features;
import softwares.ohsu.cyclicif.CycIF_RoundCycle;
import softwares.ohsu.cyclicif.CycIF_Tools;
import stackTiTi.StackIO;
import utils.LogFile;
import utils.memory.Allocator;

public class CyclicIFv1 {
    private Allocator allocator = Allocator.Instance();
    private String Copyright = "Software version 1.2.5 (2020/06/05) developed by Guillaume THIBAULT for the Gray lab at OHSU. Copyright (c) 2006-Today. All Rights Reserved.";
    private List<CycIF_RoundCycle> rclist = new LinkedList<CycIF_RoundCycle>();
    private final int Magnification;
    private final CycIF_Tools Tools = new CycIF_Tools();
    public Display display = null;
    private final ContrastEqualizer equalizer = new ContrastEqualizer();
    private final DapiMM dapi;
    private final DapiMM dapismall;
    private final DistanceMapComputer dmc = new DistanceMapComputer();
    private final DynamicExpansion dynexp = new DynamicExpansion();
    private final FillHole fh = new FillHole();
    private final GradientDE gradde = new GradientDE();
    private final Skiz skiz = new Skiz();
    private final Sobel sobel = new Sobel();
    private final UnionFindCcl ccl = new UnionFindCcl();
    private final Watershed watershed = new Watershed();
    private final ZProjectionCMM zp = new ZProjectionCMM();
    private ImageThresholder[] thresholders = new ImageThresholder[4];
    private int[] thresholds = new int[this.thresholders.length];
    private final StructuringElement sedisk1 = new StructuringElement(new Object[]{1, -2});
    private final StructuringElement sedisk2 = new StructuringElement(new Object[]{2, -2});
    private final StructuringElement sedisk3 = new StructuringElement(new Object[]{3, -2});
    private final StructuringElement sedisk5 = new StructuringElement(new Object[]{5, -2});
    private final StructuringElement sedisk7 = new StructuringElement(new Object[]{7, -2});
    private final StructuringElement sedisk11 = new StructuringElement(new Object[]{11, -2});
    private final StructuringElement sedisk17 = new StructuringElement(new Object[]{17, -2});
    private final StructuringElement sehex1 = new StructuringElement(new Object[]{1, -9});
    private final StructuringElement sehex17 = new StructuringElement(new Object[]{17, -9});
    private final StructuringElement sehex31 = new StructuringElement(new Object[]{31, -9});
    private final StructuringElement sehex53 = new StructuringElement(new Object[]{53, -9});
    private final StructuringElement sehex73 = new StructuringElement(new Object[]{73, -9});
    private final StructuringElement sehex113 = new StructuringElement(new Object[]{113, -9});
    private final StructuringElement sem3 = new StructuringElement(new Object[]{3, -15});
    private final AreaClosing ac = new AreaClosing();
    private final AreaOpening ao = new AreaOpening();
    private final Binary binary = new Binary();
    private final Close close = new Close();
    private final ClosingByReconstruction clrec = new ClosingByReconstruction();
    private final Dilate dilate = new Dilate();
    private final Open open = new Open();
    private final WhiteTopHat wth = new WhiteTopHat();
    private Huang huang = new Huang();
    private Li li = new Li();
    private Otsu otsu = new Otsu();
    private Renyi renyi = new Renyi();
    private final ArrayFeatures AF = new ArrayFeatures();
    private final ImageFeatures IF = new ImageFeatures();
    public final int TMA = -1;
    public final int CROPS = -2;
    public int Experiment = 0;
    public int Intensity = 0;
    public boolean improvedapi = true;
    public boolean masksegment = true;
    public boolean markersegment = true;
    public boolean nucleisegment = true;
    public boolean cellsegment = true;
    public boolean freememory = true;
    public boolean easymarkers = true;
    public boolean autocrop = this.Experiment == -1;
    private LogFile log = new LogFile();
    public String Segment_WaitForScene = "";
    public boolean SingleWork = false;
    private float CD44radius = 30.0f;
    private float CD45radius = 7.0f;
    private float CKradius = 45.0f;
    private float UNradius = 3.0f;
    private final int CDAreaClosingValue1 = 2000;
    private final int CDAreaClosingValue2 = 3000;
    private final int CDAreaOpeningValue = 100;
    private final int EcadAreaClosingValue1 = 5000;
    private final int EcadAreaClosingValue2 = 7000;
    public String FE_WaitForScene = "";
    public boolean FE_SaveImages = true;
    public boolean FE_SubtractBackground = false;
    public float FE_Rim_Size = 3.0f;
    public boolean FE_BiasedFeaturesOnly = false;
    public boolean FE_DistanceFromBorder = false;
    private int cropBottom = -1;
    private int cropTop = -1;
    private int cropLeft = -1;
    private int cropRight = -1;

    public CyclicIFv1(int Magnification) {
        switch (Magnification) {
            case 20: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Magnification not supported (yet).");
            }
        }
        this.Magnification = Magnification;
        this.dapi = new DapiMM(Magnification, false);
        this.dapismall = new DapiMM(Magnification, true);
        this.thresholders[0] = new Li();
        this.thresholders[1] = new Huang();
        this.thresholders[2] = new Otsu();
        this.thresholders[3] = new TriangleThresholding();
    }

    public void Segment(String inputdir, String outputdir, int nbCPU) throws Exception {
        this.log.StartNewLog(this, "./");
        System.out.println(this.Copyright);
        System.out.println("\n\nProcessing '" + inputdir + "':");
        List<String> scenes = this.Tools.FindScenes(inputdir, "");
        System.out.print(scenes.size() + " scene(s) found: ");
        ListIO.Display(scenes, " ");
        this.Tools.LoadRoundsCyclesTableV1(inputdir, this.rclist);
        List<CycIF_RoundCycle> rc_list = this.rclist;
        this.Tools.CheckRoundCycleList(rc_list, true, this.log, "Ecad", "CD44", "CD45", "CK5", "CK7", "CK14", "CK19");
        File out = new File(outputdir);
        if (!out.exists()) {
            out.mkdirs();
        }
        if (this.improvedapi) {
            this.ImprovedDAPI(inputdir, scenes, outputdir);
        }
        boolean work = this.Segment_WaitForScene.isEmpty();
        String scene = null;
        Iterator<String> iter = scenes.iterator();
        while (iter.hasNext()) {
            try {
                boolean keepworking = true;
                scene = iter.next();
                if (!work) {
                    if (!scene.equalsIgnoreCase(this.Segment_WaitForScene)) continue;
                    work = true;
                }
                BufferedImage imdapi = ImageIO.Read(outputdir + "/Scene " + scene + " - ZProjectionDAPI.png");
                if (this.masksegment) {
                    keepworking &= this.FindMask(imdapi, outputdir, scene, nbCPU);
                }
                if (keepworking) {
                    keepworking &= this.FindCropSize(outputdir, scene, nbCPU);
                }
                BufferedImage unstained = ImageNew.Same((BufferedImage)imdapi);
                ImageOperations.Fill((BufferedImage)unstained, (int)65535);
                if (keepworking) {
                    this.AutoCrop(unstained);
                }
                if (keepworking && this.markersegment) {
                    try {
                        CycIF_RoundCycle rc = this.Tools.FindMarker("Ecad", rc_list);
                        BufferedImage ecad = this.Tools.LoadImage(inputdir, scene, rc.round, rc.cycle);
                        rc = this.Tools.FindMarker("CK7", rc_list);
                        BufferedImage ck7 = this.Tools.LoadImage(inputdir, scene, rc.round, rc.cycle);
                        rc = this.Tools.FindMarker("CK19", rc_list);
                        BufferedImage ck19 = this.Tools.LoadImage(inputdir, scene, rc.round, rc.cycle);
                        BufferedImage ecadseg = this.EcadCksSegmentation(ecad, ck7, ck19, outputdir, scene, nbCPU);
                        ImageComparator.Compare((BufferedImage)ecadseg, (String)"==", (int)0, (BufferedImage)unstained, (int)0, (BufferedImage)unstained);
                        ecadseg = this.allocator.Release(ecadseg);
                        ecad = this.allocator.Release(ecad);
                        ck7 = this.allocator.Release(ck7);
                        ck19 = this.allocator.Release(ck19);
                        rc = null;
                        if (this.freememory) {
                            this.allocator.ClearAll(true);
                        }
                        rc = this.Tools.FindMarker("CD45", rc_list);
                        BufferedImage cd45 = this.Tools.LoadImage(inputdir, scene, rc.round, rc.cycle);
                        BufferedImage cd45seg = this.CD45Segmentation(cd45, outputdir, scene, nbCPU);
                        ImageComparator.Compare((BufferedImage)cd45seg, (String)"==", (int)0, (BufferedImage)unstained, (int)0, (BufferedImage)unstained);
                        cd45seg = this.allocator.Release(cd45seg);
                        cd45 = this.allocator.Release(cd45);
                        rc = null;
                        if (this.freememory) {
                            this.allocator.ClearAll(true);
                        }
                        rc = this.Tools.FindMarker("CD44", rc_list);
                        BufferedImage cd44 = this.Tools.LoadImage(inputdir, scene, rc.round, rc.cycle);
                        BufferedImage cd44seg = this.CD44Segmentation(cd44, outputdir, scene, nbCPU);
                        ImageComparator.Compare((BufferedImage)cd44seg, (String)"==", (int)0, (BufferedImage)unstained, (int)0, (BufferedImage)unstained);
                        cd44seg = this.allocator.Release(cd44seg);
                        cd44 = this.allocator.Release(cd44);
                        rc = null;
                        ImageIO.Write(ImageConverter.UShortGrayToBinary((BufferedImage)unstained), outputdir + "/Scene " + scene + " - Unstained Segmentation.png", 6);
                        unstained = this.allocator.Release(unstained);
                        this.allocator.ClearAll(true);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        this.log.addNewException(ex, new String[0]);
                        this.log.addComment("Cannot find/process marker image for scene " + scene);
                        keepworking = false;
                    }
                    catch (Error e) {
                        e.printStackTrace();
                        this.log.addNewError(e, new String[0]);
                        this.log.addComment("Cannot find/process marker image for scene " + scene);
                        keepworking = false;
                    }
                }
                if (keepworking && this.nucleisegment) {
                    try {
                        BufferedImage mask = ImageConverter.BinaryToUShortGray((BufferedImage)ImageIO.Read(outputdir + "/Scene " + scene + " - Nuclei Safety Mask.png"));
                        BufferedImage imnuclei = null;
                        if (this.Intensity < 0) {
                            imnuclei = ImageIO.Read(outputdir + "/Scene " + scene + " - ZProjectionDAPI CE.png");
                        } else {
                            imnuclei = ImageNew.Clone((BufferedImage)imdapi);
                            if (1 < this.Intensity) {
                                ImageArithmetic.Multiply(imnuclei, this.Intensity, imnuclei, 0, 0, 65535, 65535);
                            }
                        }
                        BufferedImage ecadcks = ImageConverter.BinaryToUShortGray((BufferedImage)ImageIO.Read(outputdir + "/Scene " + scene + " - EcadCks Segmentation.png"));
                        BufferedImage cd45 = ImageConverter.BinaryToUShortGray((BufferedImage)ImageIO.Read(outputdir + "/Scene " + scene + " - CD45 Segmentation.png"));
                        BufferedImage uns = ImageConverter.BinaryToUShortGray((BufferedImage)ImageIO.Read(outputdir + "/Scene " + scene + " - Unstained Segmentation.png"));
                        ImageComparator.Compare((BufferedImage)uns, (String)"!=", (int)0, (BufferedImage)uns, (BufferedImage)ecadcks, (BufferedImage)uns);
                        ImageComparator.Compare((BufferedImage)uns, (String)"!=", (int)0, (BufferedImage)uns, (BufferedImage)cd45, (BufferedImage)uns);
                        BufferedImage maskdil = this.dilate.Filter(uns, this.sedisk11, nbCPU);
                        ImageComparator.Compare((BufferedImage)mask, (String)"<", (BufferedImage)maskdil, (BufferedImage)mask, (BufferedImage)maskdil, (BufferedImage)maskdil);
                        this.SegmentNuclei(imnuclei, maskdil, false, scene, "BigNuclei", outputdir, true, nbCPU);
                        ecadcks = this.allocator.Release(ecadcks);
                        cd45 = this.allocator.Release(cd45);
                        uns = this.allocator.Release(uns);
                        maskdil = this.allocator.Release(maskdil);
                        this.allocator.ClearAll(true);
                        BufferedImage cd44 = ImageConverter.BinaryToUShortGray((BufferedImage)ImageIO.Read(outputdir + "/Scene " + scene + " - CD44 Segmentation.png"));
                        maskdil = this.dilate.Filter(cd44, this.sedisk11, nbCPU);
                        ImageComparator.Compare((BufferedImage)mask, (String)"<", (BufferedImage)maskdil, (BufferedImage)mask, (BufferedImage)maskdil, (BufferedImage)maskdil);
                        this.SegmentNuclei(imnuclei, maskdil, true, scene, "CD44", outputdir, true, nbCPU);
                        cd44 = this.allocator.Release(cd44);
                        maskdil = this.allocator.Release(maskdil);
                        imnuclei = this.allocator.Release(imnuclei);
                        this.allocator.ClearAll(true);
                        this.SplitSegmentations(outputdir, scene);
                        this.allocator.ClearAll(true);
                        this.MergeSegmentations(outputdir, scene);
                        this.allocator.ClearAll(true);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        this.log.addNewException(ex, new String[0]);
                        this.log.addComment("Cannot segment nuclei for scene " + scene);
                        keepworking = false;
                    }
                    catch (Error e) {
                        e.printStackTrace();
                        this.log.addNewError(e, new String[0]);
                        this.log.addComment("Cannot segment nuclei for scene " + scene);
                        keepworking = false;
                    }
                }
                if (keepworking && this.cellsegment) {
                    try {
                        this.SegmentCells(inputdir, outputdir, scene, nbCPU);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        this.log.addNewException(ex, new String[0]);
                        this.log.addComment("Cannot segment cells for scene " + scene);
                        keepworking = false;
                    }
                    catch (Error e) {
                        e.printStackTrace();
                        this.log.addNewError(e, new String[0]);
                        this.log.addComment("Cannot segment cells for scene " + scene);
                        keepworking = false;
                    }
                }
                scene = null;
                if (!this.SingleWork) continue;
                break;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.log.addNewException(ex, new String[0]);
                this.log.addComment("Cannot segment scene " + scene);
            }
            catch (Error e) {
                e.printStackTrace();
                this.log.addNewError(e, new String[0]);
                this.log.addComment("Cannot segment scene " + scene);
            }
        }
        System.out.println("Segmentation done. " + this.Copyright);
        iter = null;
        this.log.Stop();
    }

    public void SegmentDapis(String inputdir, String outputdir, int nbCPU) throws Exception {
        this.log.StartNewLog(this, "./");
        System.out.println(this.Copyright);
        System.out.println("\n\nDapis segmentation of '" + inputdir + "':");
        List<String> scenes = this.Tools.FindScenes(inputdir, "");
        System.out.print(scenes.size() + " scene(s) found: ");
        ListIO.Display(scenes, " ");
        File out = new File(outputdir);
        if (!out.exists()) {
            out.mkdirs();
        }
        boolean work = this.Segment_WaitForScene.isEmpty();
        String scene = null;
        Iterator<String> iter = scenes.iterator();
        while (iter.hasNext()) {
            try {
                scene = iter.next();
                if (!work) {
                    if (!scene.equalsIgnoreCase(this.Segment_WaitForScene)) continue;
                    work = true;
                }
                Object[] dapifiles = new File(inputdir).listFiles(this.Tools.CreateFNF(scene, 1));
                Arrays.sort(dapifiles);
                BufferedImage min = null;
                BufferedImage max = null;
                StringBuilder sb = new StringBuilder(1000);
                double[] averages = new double[dapifiles.length];
                double[] medians = new double[dapifiles.length];
                double[] maxima = new double[dapifiles.length];
                for (int f = 0; f < dapifiles.length; ++f) {
                    BufferedImage imdapi = ImageIO.Read((File)dapifiles[f]);
                    averages[f] = this.IF.Average(imdapi);
                    maxima[f] = this.IF.Maximum(imdapi);
                    this.IF.Ranks(imdapi);
                    medians[f] = this.IF.Rank50();
                    sb.append(((File)dapifiles[f]).getAbsolutePath()).append(":\n");
                    sb.append(" - Maxima = ").append(maxima[f]).append("\n");
                    sb.append(" - Average = ").append(averages[f]).append("\n");
                    sb.append(" - Median = ").append(medians[f]).append("\n");
                    if (min == null) {
                        min = ImageNew.Same((BufferedImage)imdapi);
                        max = ImageNew.Same((BufferedImage)imdapi);
                    }
                    ImageComparator.Compare((BufferedImage)imdapi, (String)"<", (BufferedImage)min, (BufferedImage)imdapi, (BufferedImage)min, (BufferedImage)min);
                    ImageComparator.Compare((BufferedImage)imdapi, (String)">", (BufferedImage)max, (BufferedImage)imdapi, (BufferedImage)max, (BufferedImage)max);
                    this.FindMask(imdapi, outputdir, scene + " - Dapi " + f, nbCPU);
                    this.FindCropSize(outputdir, scene + " - Dapi " + f, nbCPU);
                    try {
                        BufferedImage mask = ImageConverter.BinaryToUShortGray((BufferedImage)ImageIO.Read(outputdir + "/Scene " + scene + " - Dapi " + f + " - Nuclei Safety Mask.png"));
                        BufferedImage maskdil = this.dilate.Filter(mask, this.sedisk11, nbCPU);
                        ImageComparator.Compare((BufferedImage)mask, (String)"<", (BufferedImage)maskdil, (BufferedImage)mask, (BufferedImage)maskdil, (BufferedImage)maskdil);
                        this.SegmentNuclei(imdapi, maskdil, false, scene, "Dapi " + f, outputdir, false, nbCPU);
                        maskdil = this.allocator.Release(maskdil);
                        mask = null;
                        BufferedImage basins = ImageIO.Read(outputdir + "/Watershed - Basins.tif");
                        sb.append(" - #Nuclei = ").append(this.IF.Maximum(basins)).append("\n");
                        sb.append(" - #Pixels = ").append(this.IF.Counter(basins, 0)).append("\n\n");
                        basins = null;
                        this.RenameDapis(scene, "Dapi " + f, outputdir);
                        this.allocator.ClearAll(true);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        this.log.addNewException(ex, "Cannot segment nuclei for scene " + scene);
                    }
                    catch (Error e) {
                        e.printStackTrace();
                        this.log.addNewError(e, "Cannot segment nuclei for scene " + scene);
                    }
                    if (this.SingleWork) break;
                }
                sb.append("\n\nStandard Deviations:\n");
                this.AF.Moments(maxima);
                sb.append(" - Maxima = ").append(this.AF.StandardDeviation()).append("\n");
                this.AF.Moments(averages);
                sb.append(" - Averages = ").append(this.AF.StandardDeviation()).append("\n");
                this.AF.Moments(medians);
                sb.append(" - Medians = ").append(this.AF.StandardDeviation()).append("\n");
                BufferedImage ranges = ImageArithmetic.Subtract(max, min);
                sb.append("\n\nRanges:\n");
                sb.append(" - min = ").append(this.IF.Minimum(ranges)).append("\n");
                sb.append(" - max = ").append(this.IF.Maximum(ranges)).append("\n");
                this.IF.Moments(ranges);
                sb.append(" - Average = ").append(this.IF.Average()).append("\n");
                sb.append(" - Standard Deviation = ").append(this.IF.StandardDeviation()).append("\n");
                this.IF.Ranks(ranges);
                sb.append(" - Median = ").append(this.IF.Rank50()).append("\n");
                sb.append(" - 90% Confidence = ").append(this.IF.Rank95() - this.IF.Rank05()).append("\n");
                sb.append(" - 95% Confidence = ").append(this.IF.Rank975() - this.IF.Rank025()).append("\n");
                DataOutputStream statsfile = new DataOutputStream(new FileOutputStream(outputdir + "/Statistics.txt"));
                statsfile.write(sb.toString().getBytes("ISO-8859-1"));
                statsfile.close();
                statsfile = null;
                sb = null;
                min = this.allocator.Release(min);
                max = this.allocator.Release(max);
                ranges = this.allocator.Release(ranges);
                maxima = null;
                medians = null;
                averages = null;
                scene = null;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.log.addNewException(ex, "Cannot segment scene " + scene);
            }
            catch (Error e) {
                e.printStackTrace();
                this.log.addNewError(e, "Cannot segment scene " + scene);
            }
        }
        System.out.println("Segmentation done. " + this.Copyright + "\n");
        iter = null;
        this.log.Stop();
    }

    private void SegmentNuclei(BufferedImage nuclei, BufferedImage mask, boolean small, String scene, String name, String output, boolean rename, int nbCPU) throws IOException, InterruptedException {
        boolean dirtybackground = false;
        int simplifytexture = 2;
        boolean equalize = false;
        boolean fillholes = true;
        boolean DeleteOnTop = true;
        boolean roi100saver = false;
        int minsurface = 120;
        if (small) {
            this.dapismall.Segmentation(nuclei, false, 2, false, true, true, false, mask, 60, output, nbCPU);
        } else {
            this.dapi.Segmentation(nuclei, false, 2, false, true, true, false, mask, 120, output, nbCPU);
        }
        if (rename) {
            this.Rename(scene, name, output);
        }
    }

    private boolean FindMask(BufferedImage dapi, String outputdir, String scene, int nbCPU) throws IOException {
        BufferedImage dapimp = dapi;
        ImageIO.Write(dapimp, outputdir + "/Scene " + scene + " - ZProjectionDAPI CE.png", 6);
        BufferedImage bin = ImageNew.Same((BufferedImage)dapimp);
        this.huang.Filter(dapimp, bin, nbCPU);
        this.li.Filter(dapimp, bin, nbCPU);
        this.otsu.Filter(dapimp, bin, nbCPU);
        this.renyi.Filter(dapimp, bin, nbCPU);
        int[] thres = new int[]{this.huang.getThreshold(0), this.li.getThreshold(0), this.otsu.getThreshold(0), this.renyi.getThreshold(0)};
        Arrays.sort(thres);
        switch (this.Experiment) {
            case -2: {
                this.binary.Filter(dapimp, thres[0], bin, nbCPU);
                break;
            }
            case -1: {
                this.binary.Filter(dapimp, 3 * (thres[1] + thres[2]) >> 2, bin, nbCPU);
                break;
            }
            default: {
                throw new IllegalStateException("Experiment not supported or not defined.");
            }
        }
        dapimp = this.allocator.Release(dapimp);
        BufferedImage binao = this.ao.Filter(bin, 250, true);
        this.dilate.Filter(binao, this.sedisk2, bin, nbCPU);
        this.fh.Fill(bin, (ConnectedComponentLabeling)this.ccl, 750, true, binao);
        bin = this.allocator.Release(bin);
        ImageIO.Write(ImageConverter.UShortGrayToBinary((BufferedImage)binao), outputdir + "/Scene " + scene + " - Nuclei Safety Mask.png", 6);
        if (ImageTools.isBlack((BufferedImage)binao)) {
            binao = this.allocator.Release(binao);
            this.log.addComment("No nuclei found (empty mask) in scene " + scene);
            return false;
        }
        binao = this.allocator.Release(binao);
        return true;
    }

    public void SplitSegmentations(String outputdir, String scene) throws IOException {
        int i2;
        boolean colecad = false;
        boolean colcd45 = true;
        int colunst = 2;
        String[] markers = new String[]{"EcadCKs", "CD45", "Unstained"};
        BufferedImage basins = ImageIO.Read(outputdir + "/Scene " + scene + " - Nuclei BigNuclei+ Basins.tif");
        int[] ibbasins = ((DataBufferInt)basins.getRaster().getDataBuffer()).getData();
        this.ccl.Label(basins, 0, true);
        int[] labels = this.ccl.Labels1D();
        int[] sizes = this.ccl.Sizes();
        this.ccl.ComputeBoundingBoxes();
        BufferedImage roi = ImageIO.Read(outputdir + "/Scene " + scene + " - Nuclei BigNuclei+ ROI.png");
        if (this.ccl.ConnectedComponentsNumber() == 0) {
            ImageOperations.Fill((BufferedImage)basins, (int)0);
            ImageOperations.Fill((BufferedImage)roi, (int)0);
            for (String marker : markers) {
                ImageIO.Write(basins, outputdir + "/Scene " + scene + " - Nuclei " + marker + "+ Basins.tif", 8);
                ImageIO.Write(roi, outputdir + "/Scene " + scene + " - Nuclei " + marker + "+ Segmentation.png", 6);
                ImageIO.Write(roi, outputdir + "/Scene " + scene + " - Nuclei " + marker + "+ ROI.png", 6);
            }
            roi = null;
            basins = null;
            return;
        }
        int width = basins.getWidth();
        int length = ibbasins.length;
        BufferedImage ecad = ImageConverter.BinaryToGray((BufferedImage)ImageIO.Read(outputdir + "/Scene " + scene + " - EcadCks Segmentation.png"));
        byte[] bbecad = ((DataBufferByte)ecad.getRaster().getDataBuffer()).getData();
        BufferedImage cd45 = ImageConverter.BinaryToGray((BufferedImage)ImageIO.Read(outputdir + "/Scene " + scene + " - CD45 Segmentation.png"));
        byte[] bbcd45 = ((DataBufferByte)cd45.getRaster().getDataBuffer()).getData();
        BufferedImage unst = ImageConverter.BinaryToGray((BufferedImage)ImageIO.Read(outputdir + "/Scene " + scene + " - Unstained Segmentation.png"));
        byte[] bbunst = ((DataBufferByte)unst.getRaster().getDataBuffer()).getData();
        System.arraycopy(this.ccl.Labels1D(), 0, ibbasins, 0, length);
        int[][] overlaps = new int[this.ccl.ConnectedComponentsNumber() + 1][3];
        for (int i3 = 0; i3 < labels.length; ++i3) {
            if (0 >= labels[i3]) continue;
            int label = ibbasins[i3];
            if (0 != bbecad[i3]) {
                int[] nArray = overlaps[label];
                nArray[0] = nArray[0] + 1;
            }
            if (0 != bbcd45[i3]) {
                int[] nArray = overlaps[label];
                nArray[1] = nArray[1] + 1;
            }
            if (0 == bbunst[i3]) continue;
            int[] nArray = overlaps[label];
            nArray[2] = nArray[2] + 1;
        }
        bbunst = null;
        bbcd45 = null;
        bbecad = null;
        unst = null;
        cd45 = null;
        ecad = null;
        BufferedImage imdapi = ImageIO.Read(outputdir + "/Scene " + scene + " - ZProjectionDAPI.png");
        Object[] dapis = new BufferedImage[]{ImageConverter.GrayToColor((BufferedImage)imdapi), ImageConverter.GrayToColor((BufferedImage)imdapi), ImageConverter.GrayToColor((BufferedImage)imdapi)};
        Object[] bass = new BufferedImage[]{ImageNew.Same((BufferedImage)basins), ImageNew.Same((BufferedImage)basins), ImageNew.Same((BufferedImage)basins)};
        Object[] rois = new BufferedImage[]{ImageNew.Same((BufferedImage)roi), ImageNew.Same((BufferedImage)roi), ImageNew.Same((BufferedImage)roi)};
        for (i2 = 1; i2 < this.ccl.ConnectedComponentsNumber() + 1; ++i2) {
            int index = this.AF.MaximumIndex(overlaps[i2]);
            if (!(0.5 < (double)overlaps[i2][index] / (double)sizes[i2])) continue;
            byte[] bbro = ((DataBufferByte)rois[index].getRaster().getDataBuffer()).getData();
            int[] ibbas = ((DataBufferInt)((BufferedImage)bass[index]).getRaster().getDataBuffer()).getData();
            int sx = this.ccl.minx()[i2];
            int sy = this.ccl.miny()[i2];
            int ex = this.ccl.maxx()[i2];
            int ey = this.ccl.maxy()[i2];
            for (int y = sy; y <= ey; ++y) {
                int x = sx;
                int pos = y * width + x;
                while (x <= ex) {
                    if (labels[pos] == i2) {
                        ibbas[pos] = i2;
                        bbro[pos] = -1;
                    }
                    ++x;
                    ++pos;
                }
            }
        }
        for (i2 = 0; i2 < markers.length; ++i2) {
            ImageComparator.Compare((BufferedImage)roi, (String)"!=", (int)200, (BufferedImage)rois[i2], (int)200, (BufferedImage)rois[i2]);
            this.ccl.Label(bass[i2], 0, true);
            System.arraycopy(this.ccl.Labels1D(), 0, ((DataBufferInt)((BufferedImage)bass[i2]).getRaster().getDataBuffer()).getData(), 0, length);
            DapiMM.Paint((BufferedImage)bass[i2], (BufferedImage)rois[i2], (BufferedImage)dapis[i2]);
            ImageIO.Write((BufferedImage)bass[i2], outputdir + "/Scene " + scene + " - Nuclei " + markers[i2] + "+ Basins.tif", 8);
            ImageIO.Write((BufferedImage)dapis[i2], outputdir + "/Scene " + scene + " - Nuclei " + markers[i2] + "+ Segmentation.png", 6);
            ImageIO.Write((BufferedImage)rois[i2], outputdir + "/Scene " + scene + " - Nuclei " + markers[i2] + "+ ROI.png", 6);
        }
        overlaps = null;
        roi = null;
        imdapi = null;
        ibbasins = null;
        basins = null;
        Arrays.fill(dapis, null);
        Arrays.fill(bass, null);
        Arrays.fill(rois, null);
        File file = new File(outputdir + "/Scene " + scene + " - Nuclei BigNuclei+ Basins.tif");
        file.delete();
        file = new File(outputdir + "/Scene " + scene + " - Nuclei BigNuclei+ ROI.png");
        file.delete();
        file = new File(outputdir + "/Scene " + scene + " - Nuclei BigNuclei+ Segmentation.png");
        file.delete();
    }

    public void MergeSegmentations(String outputdir, String scene) throws IOException {
        String marker = "EcadCKs";
        BufferedImage basins = ImageIO.Read(outputdir + "/Scene " + scene + " - Nuclei " + marker + "+ Basins.tif");
        BufferedImage roi = ImageIO.Read(outputdir + "/Scene " + scene + " - Nuclei " + marker + "+ ROI.png");
        this.SortLabeling(outputdir, scene, "CD44", basins, roi);
        this.allocator.ClearAll(true);
        this.SortLabeling(outputdir, scene, "CD45", basins, roi);
        this.allocator.ClearAll(true);
        this.SortLabeling(outputdir, scene, "Unstained", basins, roi);
        this.allocator.ClearAll(true);
        this.dapi.DeleteOnTop(basins);
        this.ccl.Label(basins, 0, true);
        this.dapi.MergeSmallCCs((ConnectedComponentLabeling)this.ccl, 101);
        System.arraycopy(this.ccl.Labels1D(), 0, ((DataBufferInt)basins.getRaster().getDataBuffer()).getData(), 0, this.ccl.Labels1D().length);
        this.ccl.Label(basins, 0, true);
        System.arraycopy(this.ccl.Labels1D(), 0, ((DataBufferInt)basins.getRaster().getDataBuffer()).getData(), 0, this.ccl.Labels1D().length);
        ImageIO.Write(basins, outputdir + "/Scene " + scene + " - Nuclei Segmentation Basins.tif", 8);
        BufferedImage nuclei = ImageIO.Read(outputdir + "/Scene " + scene + " - ZProjectionDAPI.png");
        BufferedImage rgb = ImageConverter.GrayToColor((BufferedImage)nuclei);
        DapiMM.Paint(basins, roi, rgb);
        ImageIO.tag = 1;
        ImageIO.Write(rgb, outputdir + "/Scene " + scene + " - Nuclei Segmentation Full Color.png", 6);
        ImageIO.tag = 0;
        basins = null;
        roi = null;
        nuclei = null;
        rgb = this.allocator.Release(rgb);
        this.allocator.ClearAll(true);
    }

    private void SortLabeling(String outputdir, String scene, String marker, BufferedImage result, BufferedImage resroi) throws IOException {
        int pos;
        int width = result.getWidth();
        BufferedImage roi = ImageIO.Read(outputdir + "/Scene " + scene + " - Nuclei " + marker + "+ ROI.png");
        byte[] bbroi = ((DataBufferByte)roi.getRaster().getDataBuffer()).getData();
        BufferedImage basins = ImageIO.Read(outputdir + "/Scene " + scene + " - Nuclei " + marker + "+ Basins.tif");
        block0 : switch (basins.getType()) {
            case 10: {
                basins = ImageConverter.ByteToInt((BufferedImage)basins);
                break;
            }
            case 11: {
                basins = ImageConverter.ShortToInt((BufferedImage)basins);
                break;
            }
            case 5: 
            case 6: {
                basins = ImageConverter.RGBtoInt((BufferedImage)basins);
                break;
            }
            case 0: {
                switch (result.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        break block0;
                    }
                }
                throw new IllegalStateException("Unsupported basins format. Must not occur.");
            }
            default: {
                throw new IllegalStateException("Unsupported basins format. Must not occur.");
            }
        }
        int[] ibbas = ((DataBufferInt)basins.getRaster().getDataBuffer()).getData();
        BufferedImage overlap = ImageNew.Same((BufferedImage)basins, (int)10);
        byte[] bbover = ((DataBufferByte)overlap.getRaster().getDataBuffer()).getData();
        BufferedImage modif = ImageNew.Same((BufferedImage)basins, (int)10);
        byte[] bbmodif = ((DataBufferByte)modif.getRaster().getDataBuffer()).getData();
        int[] ibres = ((DataBufferInt)result.getRaster().getDataBuffer()).getData();
        byte[] bbresroi = ((DataBufferByte)resroi.getRaster().getDataBuffer()).getData();
        for (int pos2 = 0; pos2 < ibbas.length; ++pos2) {
            bbover[pos2] = (byte)((0 < ibbas[pos2] ? 1 : 0) * (0 < ibres[pos2] ? 1 : 0));
        }
        this.ccl.Label(result, 0, true);
        int[] ressizes = (int[])this.ccl.Sizes().clone();
        int[] reslabels = (int[])this.ccl.Labels1D().clone();
        int[] reslut = new int[ressizes.length];
        System.arraycopy(reslabels, 0, ibres, 0, ibres.length);
        int num = ressizes.length;
        this.ccl.Label(basins, 0, true);
        this.ccl.ComputeBoundingBoxes();
        int[] bassizes = (int[])this.ccl.Sizes().clone();
        int[] baslabels = (int[])this.ccl.Labels1D().clone();
        int[] baslut = new int[bassizes.length];
        int[] basminx = (int[])this.ccl.minx().clone();
        int[] basmaxx = (int[])this.ccl.maxx().clone();
        int[] basminy = (int[])this.ccl.miny().clone();
        int[] basmaxy = (int[])this.ccl.maxy().clone();
        if (!ImageTools.isBlack((BufferedImage)overlap)) {
            this.ccl.Label(overlap, 0, true);
            this.ccl.ComputeBoundingBoxes();
            int[] labels = this.ccl.Labels1D();
            for (int cc = 1; cc < this.ccl.ConnectedComponentsNumber(); ++cc) {
                int x;
                int i2;
                int minx = this.ccl.minx()[cc];
                int maxx = this.ccl.maxx()[cc];
                int miny = this.ccl.miny()[cc];
                int maxy = this.ccl.maxy()[cc];
                LinkedList<Integer> baslist = new LinkedList<Integer>();
                LinkedList<Integer> reslist = new LinkedList<Integer>();
                for (int y = miny; y <= maxy; ++y) {
                    int x2 = minx;
                    int pos3 = y * width + x2;
                    while (x2 <= maxx) {
                        if (labels[pos3] == cc) {
                            if (!ListTools.isInList(reslist, (int)reslabels[pos3])) {
                                reslist.add(reslabels[pos3]);
                            }
                            if (!ListTools.isInList(baslist, (int)baslabels[pos3])) {
                                baslist.add(baslabels[pos3]);
                            }
                        }
                        ++x2;
                        ++pos3;
                    }
                }
                Arrays.fill(reslut, -1);
                for (i2 = 0; i2 < reslist.size(); ++i2) {
                    reslut[((Integer)reslist.get((int)i2)).intValue()] = i2;
                }
                Arrays.fill(baslut, -1);
                for (i2 = 0; i2 < baslist.size(); ++i2) {
                    baslut[((Integer)baslist.get((int)i2)).intValue()] = i2;
                }
                int[][] counts = new int[reslist.size()][baslist.size()];
                for (int y = miny; y <= maxy; ++y) {
                    x = minx;
                    int pos4 = y * width + x;
                    while (x <= maxx) {
                        if (labels[pos4] == cc) {
                            int[] nArray = counts[reslut[reslabels[pos4]]];
                            int n = baslut[baslabels[pos4]];
                            nArray[n] = nArray[n] + 1;
                        }
                        ++x;
                        ++pos4;
                    }
                }
                double[][] basratios = new double[counts.length][counts[0].length];
                for (int y = 0; y < counts.length; ++y) {
                    for (int x3 = 0; x3 < counts[0].length; ++x3) {
                        basratios[y][x3] = (double)counts[y][x3] / (double)bassizes[(Integer)baslist.get(x3)];
                    }
                }
                for (x = 0; x < counts[0].length; ++x) {
                    int label;
                    int nbover = 0;
                    int maxpos = -1;
                    double max = 0.0;
                    for (int y = 0; y < counts.length; ++y) {
                        if (0 >= counts[y][x]) continue;
                        ++nbover;
                        if (!(max < basratios[y][x])) continue;
                        max = basratios[y][x];
                        maxpos = y;
                    }
                    if (nbover == 0 || max < 0.35) {
                        label = (Integer)baslist.get(x);
                        int inx = basminx[label];
                        int axx = basmaxx[label];
                        int iny = basminy[label];
                        int axy = basmaxy[label];
                        for (int j = iny; j <= axy; ++j) {
                            int i3 = inx;
                            int pos5 = j * width + i3;
                            while (i3 <= axx) {
                                if (baslabels[pos5] == label && (bbresroi[pos5] & 0xFF) != 255) {
                                    bbresroi[pos5] = -1;
                                    ibres[pos5] = num;
                                    bbmodif[pos5] = -1;
                                }
                                ++i3;
                                ++pos5;
                            }
                        }
                        ++num;
                        continue;
                    }
                    if (!(0.35 < max)) continue;
                    label = (Integer)baslist.get(x);
                    int lab = (Integer)reslist.get(maxpos);
                    int inx = basminx[label];
                    int axx = basmaxx[label];
                    int iny = basminy[label];
                    int axy = basmaxy[label];
                    for (int j = iny; j <= axy; ++j) {
                        int i4 = inx;
                        int pos6 = j * width + i4;
                        while (i4 <= axx) {
                            if (baslabels[pos6] == label && (bbresroi[pos6] & 0xFF) != 255) {
                                bbresroi[pos6] = -1;
                                ibres[pos6] = lab;
                                bbmodif[pos6] = -1;
                            }
                            ++i4;
                            ++pos6;
                        }
                    }
                }
                Arrays.fill((Object[])counts, null);
                counts = null;
                Arrays.fill((Object[])basratios, null);
                basratios = null;
                reslist.clear();
                baslist.clear();
            }
            labels = null;
        }
        for (pos = 0; pos < ibbas.length; ++pos) {
            if (bbover[pos] == 0) continue;
            ibbas[pos] = 0;
        }
        for (pos = 0; pos < ibbas.length; ++pos) {
            if (bbmodif[pos] == 0) continue;
            ibbas[pos] = 0;
        }
        this.ccl.Label(basins, 0, true);
        baslabels = this.ccl.Labels1D();
        for (pos = 0; pos < ibbas.length; ++pos) {
            if (baslabels[pos] == 0) continue;
            ibres[pos] = num + baslabels[pos];
            bbresroi[pos] = -1;
            bbmodif[pos] = -1;
        }
        this.ccl.Label(result, 0, true);
        System.arraycopy(this.ccl.Labels1D(), 0, ibres, 0, ibres.length);
        for (int i5 = 0; i5 < bbroi.length; ++i5) {
            if ((bbroi[i5] & 0xFF) != 200 || bbresroi[i5] != 0) continue;
            bbresroi[i5] = -56;
        }
        reslut = null;
        reslabels = null;
        ressizes = null;
        basmaxy = null;
        basminy = null;
        basmaxx = null;
        basminx = null;
        baslut = null;
        baslabels = null;
        bassizes = null;
        ibbas = null;
        ibres = null;
        bbresroi = null;
        bbroi = null;
        bbover = null;
        overlap = this.allocator.Release(overlap);
        modif = this.allocator.Release(modif);
    }

    private void Rename(String scene, String name, String output) {
        File f = new File(output + "/Intermediate - WhiteTopHat.png");
        if (f.exists()) {
            f.delete();
        }
        f = null;
        f = new File(output + "/Intermediate - AreaOpening.png");
        if (f.exists()) {
            f.delete();
        }
        f = null;
        f = new File(output + "/Intermediate - UltimateEroded.png");
        if (f.exists()) {
            f.delete();
        }
        f = null;
        f = new File(output + "/Watershed - Markers.png");
        if (f.exists()) {
            f.delete();
        }
        f = null;
        f = new File(output + "/Segmentation - Full Color.png");
        if (f.exists()) {
            f.renameTo(new File(output + "/Scene " + scene + " - Nuclei " + name + "+ Segmentation.png"));
        }
        f = null;
        f = new File(output + "/Segmentation - ROI.png");
        if (f.exists()) {
            f.renameTo(new File(output + "/Scene " + scene + " - Nuclei " + name + "+ ROI.png"));
        }
        f = null;
        f = new File(output + "/Watershed - Basins.tif");
        if (f.exists()) {
            f.renameTo(new File(output + "/Scene " + scene + " - Nuclei " + name + "+ Basins.tif"));
        }
        f = null;
    }

    private void RenameDapis(String scene, String name, String output) {
        File f = new File(output + "/Intermediate - WhiteTopHat.png");
        if (f.exists()) {
            f.delete();
        }
        f = null;
        f = new File(output + "/Intermediate - AreaOpening.png");
        if (f.exists()) {
            f.delete();
        }
        f = null;
        f = new File(output + "/Intermediate - UltimateEroded.png");
        if (f.exists()) {
            f.delete();
        }
        f = null;
        f = new File(output + "/Watershed - Markers.png");
        if (f.exists()) {
            f.delete();
        }
        f = null;
        f = new File(output + "/Segmentation - ROI.png");
        if (f.exists()) {
            f.delete();
        }
        f = null;
        f = new File(output + "/Segmentation - Full Color.png");
        if (f.exists()) {
            f.renameTo(new File(output + "/Scene " + scene + " - " + name + " - Segmentation.png"));
        }
        f = null;
        f = new File(output + "/Scene " + scene + " - " + name + " - ZProjectionDAPI CE.png");
        if (f.exists()) {
            f.renameTo(new File(output + "/Scene " + scene + " - " + name + " - CE.png"));
        }
        f = null;
        f = new File(output + "/Watershed - Basins.tif");
        if (f.exists()) {
            f.renameTo(new File(output + "/Scene " + scene + " - " + name + " - Basins.tif"));
        }
        f = null;
    }

    private void SegmentCells(String inputdir, String outputdir, String scene, int nbCPU) throws Exception {
        int x;
        int y;
        List<CycIF_RoundCycle> rc_list = this.rclist;
        if (this.rclist.isEmpty()) {
            this.Tools.LoadRoundsCyclesTableV1(inputdir, this.rclist);
            this.Tools.CheckRoundCycleList(rc_list, true, this.log, "Ecad", "CD44", "CD45", "CK7", "CK19");
        }
        BufferedImage basins = ImageIO.Read(outputdir + "/Scene " + scene + " - Nuclei Segmentation Basins.tif");
        int max = (int)this.IF.Maximum(basins);
        int background = max + 13;
        if (max == 0) {
            this.log.addComment("Cell segmentation impossible in scene " + scene + ", no nuclei found.");
            ImageIO.Write(basins, outputdir + "/Scene " + scene + " - Cell Segmentation Basins.tif", 8);
            return;
        }
        CycIF_RoundCycle rc = this.Tools.FindMarker("Ecad", rc_list);
        BufferedImage ecad = this.Tools.LoadImage(inputdir, scene, rc.round, rc.cycle);
        rc = null;
        BufferedImage ckmask = ImageIO.Read(outputdir + "/Scene " + scene + " - EcadCks Segmentation.png");
        BufferedImage conv = ImageConverter.BinaryToUShortGray((BufferedImage)ckmask);
        BufferedImage ckseg = this.dilate.Filter(conv, this.sedisk11, nbCPU);
        conv = this.allocator.Release(conv);
        rc = this.Tools.FindMarker("CK7", rc_list);
        BufferedImage ck7 = this.Tools.LoadImage(inputdir, scene, rc.round, rc.cycle);
        rc = null;
        rc = this.Tools.FindMarker("CK19", rc_list);
        BufferedImage ck19 = this.Tools.LoadImage(inputdir, scene, rc.round, rc.cycle);
        rc = null;
        ImageComparator.Compare((BufferedImage)ckseg, (String)"!=", (int)0, (BufferedImage)ecad, (int)0, (BufferedImage)ecad);
        ImageComparator.Compare((BufferedImage)ckseg, (String)"!=", (int)0, (BufferedImage)ck7, (int)0, (BufferedImage)ck7);
        ImageComparator.Compare((BufferedImage)ckseg, (String)"!=", (int)0, (BufferedImage)ck19, (int)0, (BufferedImage)ck19);
        this.dynexp.FilterWithConditions(ecad, 1.0, 0.5, 0, 0, 65535, ecad, nbCPU);
        this.dynexp.FilterWithConditions(ck7, 0.5, 0.5, 0, 0, 65535, ck7, nbCPU);
        this.dynexp.FilterWithConditions(ck19, 0.5, 0.5, 0, 0, 65535, ck19, nbCPU);
        BufferedImage gradient = this.sobel.Filter(ecad, nbCPU);
        BufferedImage maxgrad = ImageNew.Clone((BufferedImage)gradient);
        this.sobel.Filter(ck7, gradient, nbCPU);
        ImageOperations.Maximum((BufferedImage)gradient, (BufferedImage)maxgrad, (BufferedImage)maxgrad);
        this.sobel.Filter(ck19, gradient, nbCPU);
        ImageOperations.Maximum((BufferedImage)gradient, (BufferedImage)maxgrad, (BufferedImage)maxgrad);
        ck7 = this.allocator.Release(ck7);
        ck19 = this.allocator.Release(ck19);
        ecad = this.allocator.Release(ecad);
        rc = this.Tools.FindMarker("CD44", rc_list);
        BufferedImage cd44 = this.Tools.LoadImage(inputdir, scene, rc.round, rc.cycle);
        rc = null;
        BufferedImage cd44mask = ImageIO.Read(outputdir + "/Scene " + scene + " - CD44 Segmentation.png");
        conv = ImageConverter.BinaryToUShortGray((BufferedImage)cd44mask);
        BufferedImage cd44seg = this.dilate.Filter(conv, this.sedisk11, nbCPU);
        conv = this.allocator.Release(conv);
        rc = this.Tools.FindMarker("CD45", rc_list);
        BufferedImage cd45 = this.Tools.LoadImage(inputdir, scene, rc.round, rc.cycle);
        rc = null;
        BufferedImage cd45mask = ImageIO.Read(outputdir + "/Scene " + scene + " - CD45 Segmentation.png");
        conv = ImageConverter.BinaryToUShortGray((BufferedImage)cd45mask);
        BufferedImage cd45seg = this.dilate.Filter(conv, this.sedisk11, nbCPU);
        conv = this.allocator.Release(conv);
        ImageComparator.Compare((BufferedImage)cd44seg, (String)"!=", (int)0, (BufferedImage)cd44, (int)0, (BufferedImage)cd44);
        ImageComparator.Compare((BufferedImage)cd45seg, (String)"!=", (int)0, (BufferedImage)cd45, (int)0, (BufferedImage)cd45);
        this.dynexp.FilterWithConditions(cd44, 1.0, 0.5, 0, 0, 65535, cd44, nbCPU);
        this.dynexp.FilterWithConditions(cd45, 1.0, 0.5, 0, 0, 65535, cd45, nbCPU);
        this.sobel.Filter(cd44, gradient, nbCPU);
        ImageOperations.Maximum((BufferedImage)gradient, (BufferedImage)maxgrad, (BufferedImage)maxgrad);
        this.sobel.Filter(cd45, gradient, nbCPU);
        ImageOperations.Maximum((BufferedImage)gradient, (BufferedImage)maxgrad, (BufferedImage)maxgrad);
        cd44 = this.allocator.Release(cd44);
        cd45 = this.allocator.Release(cd45);
        BufferedImage imdapi = ImageIO.Read(outputdir + "/Scene " + scene + " - ZProjectionDAPI.png");
        double[] radii = this.Tools.FindAdaptedRadii(imdapi, basins, 1.0);
        BufferedImage imdil = this.dilate.Filter(basins, this.sehex53, nbCPU);
        ImageComparator.Compare((BufferedImage)imdil, (String)"!=", (int)0, (int)background, (int)0, (BufferedImage)imdil);
        BufferedImage contour = this.gradde.Filter(imdil, this.sehex1, nbCPU);
        ImageArithmetic.Add(basins, contour, basins);
        imdil = this.allocator.Release(imdil);
        contour = this.allocator.Release(contour);
        this.watershed.watershed(maxgrad, basins, this.sedisk1);
        BufferedImage watbasins = this.watershed.Basins();
        ImageComparator.Compare((BufferedImage)watbasins, (String)"!=", (int)background, (BufferedImage)watbasins, (int)0, (BufferedImage)watbasins);
        ImageComparator.Compare((BufferedImage)basins, (String)"!=", (int)background, (BufferedImage)basins, (int)0, (BufferedImage)basins);
        gradient = this.allocator.Release(gradient);
        maxgrad = this.allocator.Release(maxgrad);
        BufferedImage uns = ImageIO.Read(outputdir + "/Scene " + scene + " - Unstained Segmentation.png");
        conv = ImageConverter.BinaryToUShortGray((BufferedImage)uns);
        BufferedImage unseg = this.dilate.Filter(conv, this.sedisk11, nbCPU);
        conv = this.allocator.Release(conv);
        short[] sbcd44 = ((DataBufferUShort)cd44seg.getRaster().getDataBuffer()).getData();
        short[] sbcd45 = ((DataBufferUShort)cd45seg.getRaster().getDataBuffer()).getData();
        short[] sbcks = ((DataBufferUShort)ckseg.getRaster().getDataBuffer()).getData();
        short[] sbuns = ((DataBufferUShort)unseg.getRaster().getDataBuffer()).getData();
        int[] ibbas = ((DataBufferInt)basins.getRaster().getDataBuffer()).getData();
        boolean colcd44 = false;
        boolean colcd45 = true;
        int colecad = 2;
        int colunst = 3;
        int[][] votes = new int[max + 1][4];
        for (int i2 = 0; i2 < sbcks.length; ++i2) {
            if (0 >= ibbas[i2]) continue;
            int label = ibbas[i2];
            if (sbcd44[i2] != 0) {
                int[] nArray = votes[label];
                nArray[0] = nArray[0] + 1;
            }
            if (sbcd45[i2] != 0) {
                int[] nArray = votes[label];
                nArray[1] = nArray[1] + 1;
            }
            if (sbcks[i2] != 0) {
                int[] nArray = votes[label];
                nArray[2] = nArray[2] + 1;
            }
            if (sbuns[i2] == 0) continue;
            int[] nArray = votes[label];
            nArray[3] = nArray[3] + 1;
        }
        int[] positive = new int[max + 1];
        float[] constraints = new float[max + 1];
        block18: for (int i3 = 0; i3 < positive.length; ++i3) {
            positive[i3] = this.AF.MaximumIndex(votes[i3]);
            switch (positive[i3]) {
                case 0: 
                case 2: {
                    constraints[i3] = (float)radii[i3];
                    continue block18;
                }
                case 3: {
                    constraints[i3] = this.UNradius;
                    continue block18;
                }
                case 1: {
                    constraints[i3] = this.CD45radius;
                    continue block18;
                }
                default: {
                    throw new Error("Must not occur!!!");
                }
            }
        }
        radii = null;
        BufferedImage skizlabels = this.skiz.Filter(basins, this.sem3, false, constraints, nbCPU);
        ImageIO.Write(skizlabels, outputdir + "/Scene " + scene + " - Skiz.tif", 8);
        ImageComparator.Compare((BufferedImage)skizlabels, (String)"==", (BufferedImage)watbasins, (BufferedImage)watbasins, (int)0, (BufferedImage)watbasins);
        ImageIO.Write(watbasins, outputdir + "/Scene " + scene + " - Cell Segmentation Basins.tif", 8);
        BufferedImage dapirgb = ImageConverter.GrayToColor((BufferedImage)imdapi);
        byte[] bbrgb = ((DataBufferByte)dapirgb.getRaster().getDataBuffer()).getData();
        int width = imdapi.getWidth();
        int height = imdapi.getHeight();
        int[] ibwat = ((DataBufferInt)watbasins.getRaster().getDataBuffer()).getData();
        WritableRaster ckras = ckmask.getRaster();
        WritableRaster cd44ras = cd44mask.getRaster();
        WritableRaster cd45ras = cd45mask.getRaster();
        WritableRaster unras = uns.getRaster();
        int pos = 0;
        int posrgb = 0;
        for (y = 0; y < height; ++y) {
            x = 0;
            while (x < width) {
                if (ibwat[pos] != 0) {
                    if (x == 0 || y == 0 || x == width - 1 || y == height - 1 || 0 < x && ibwat[pos - 1] < ibwat[pos] || x < width - 1 && ibwat[pos + 1] < ibwat[pos] || 0 < y && ibwat[pos - width] < ibwat[pos] || y < height - 1 && ibwat[pos + width] < ibwat[pos]) {
                        if (ckras.getSample(x, y, 0) != 0) {
                            bbrgb[posrgb + 2] = -1;
                            bbrgb[posrgb + 1] = 0;
                            bbrgb[posrgb] = 0;
                        } else if (cd44ras.getSample(x, y, 0) != 0) {
                            bbrgb[posrgb] = -1;
                            bbrgb[posrgb + 2] = 0;
                            bbrgb[posrgb + 1] = 0;
                        } else if (cd45ras.getSample(x, y, 0) != 0) {
                            bbrgb[posrgb + 1] = -1;
                            bbrgb[posrgb + 2] = 0;
                            bbrgb[posrgb] = 0;
                        } else if (unras.getSample(x, y, 0) != 0) {
                            bbrgb[posrgb] = 0;
                            bbrgb[posrgb + 2] = -1;
                            bbrgb[posrgb + 1] = -1;
                        } else {
                            bbrgb[posrgb] = 0;
                            bbrgb[posrgb + 1] = -1;
                            bbrgb[posrgb] = -1;
                        }
                    } else if (ckras.getSample(x, y, 0) != 0) {
                        bbrgb[posrgb + 1] = 0;
                        bbrgb[posrgb] = 0;
                    } else if (cd44ras.getSample(x, y, 0) != 0) {
                        bbrgb[posrgb + 2] = 0;
                        bbrgb[posrgb + 1] = 0;
                    } else if (cd45ras.getSample(x, y, 0) != 0) {
                        bbrgb[posrgb + 2] = 0;
                        bbrgb[posrgb] = 0;
                    } else {
                        bbrgb[posrgb] = unras.getSample(x, y, 0) != 0 ? (byte)0 : 0;
                    }
                }
                ++x;
                ++pos;
                posrgb += 3;
            }
        }
        ImageIO.tag = 1;
        ImageIO.Write(dapirgb, outputdir + "/Scene " + scene + " - Cell Segmentation Stainings.png", 6);
        ImageIO.tag = 0;
        ImageConverter.GrayToColor((BufferedImage)imdapi, (BufferedImage)dapirgb);
        pos = 0;
        posrgb = 0;
        for (y = 0; y < height; ++y) {
            x = 0;
            while (x < width) {
                if (ibwat[pos] != 0) {
                    if (x == 0 || y == 0 || x == width - 1 || y == height - 1 || 0 < x && ibwat[pos - 1] < ibwat[pos] || x < width - 1 && ibwat[pos + 1] < ibwat[pos] || 0 < y && ibwat[pos - width] < ibwat[pos] || y < height - 1 && ibwat[pos + width] < ibwat[pos]) {
                        switch (positive[ibwat[pos]]) {
                            case 0: {
                                bbrgb[posrgb] = -1;
                                bbrgb[posrgb + 2] = 0;
                                bbrgb[posrgb + 1] = 0;
                                break;
                            }
                            case 2: {
                                bbrgb[posrgb + 2] = -1;
                                bbrgb[posrgb + 1] = 0;
                                bbrgb[posrgb] = 0;
                                break;
                            }
                            case 3: {
                                bbrgb[posrgb] = 0;
                                bbrgb[posrgb + 2] = -1;
                                bbrgb[posrgb + 1] = -1;
                                break;
                            }
                            case 1: {
                                bbrgb[posrgb + 1] = -1;
                                bbrgb[posrgb + 2] = 0;
                                bbrgb[posrgb] = 0;
                                break;
                            }
                            default: {
                                bbrgb[posrgb] = 0;
                                bbrgb[posrgb + 1] = -1;
                                bbrgb[posrgb] = -1;
                                break;
                            }
                        }
                    } else {
                        switch (positive[ibwat[pos]]) {
                            case 0: {
                                bbrgb[posrgb + 2] = 0;
                                bbrgb[posrgb + 1] = 0;
                                break;
                            }
                            case 2: {
                                bbrgb[posrgb + 1] = 0;
                                bbrgb[posrgb] = 0;
                                break;
                            }
                            case 3: {
                                bbrgb[posrgb] = 0;
                                break;
                            }
                            case 1: {
                                bbrgb[posrgb + 2] = 0;
                                bbrgb[posrgb] = 0;
                                break;
                            }
                            default: {
                                bbrgb[posrgb] = 0;
                            }
                        }
                    }
                }
                ++x;
                ++pos;
                posrgb += 3;
            }
        }
        ImageIO.tag = 1;
        ImageIO.Write(dapirgb, outputdir + "/Scene " + scene + " - Cell Segmentation Full Color.png", 6);
        ImageIO.tag = 0;
        bbrgb = null;
        ibwat = null;
        unras = null;
        cd45ras = null;
        cd44ras = null;
        ckras = null;
        imdapi = this.allocator.Release(imdapi);
        dapirgb = this.allocator.Release(dapirgb);
        uns = this.allocator.Release(uns);
        skizlabels = this.allocator.Release(skizlabels);
        basins = this.allocator.Release(basins);
        cd44mask = this.allocator.Release(cd44mask);
        cd45mask = this.allocator.Release(cd45mask);
        this.allocator.ClearAll(true);
    }

    private BufferedImage CD44Segmentation(BufferedImage cdx, String outputdir, String scene, int nbCPU) throws IOException {
        this.AutoCrop(cdx);
        ImageIO.Write(cdx, outputdir + "/Scene " + scene + " - CD44.png", 6);
        if (this.easymarkers) {
            List<CycIF_RoundCycle> rc_list = this.rclist;
            CycIF_RoundCycle rc = this.Tools.FindMarker("CD44", rc_list);
            BufferedImage imthresh = this.binary.Filter(cdx, rc.minthreshold, nbCPU);
            ImageComparator.Compare((BufferedImage)cdx, (String)"<=", (int)rc.maxthreshold, (BufferedImage)imthresh, (int)0, (BufferedImage)imthresh);
            ImageIO.Write(ImageConverter.UShortGrayToBinary((BufferedImage)imthresh), outputdir + "/Scene " + scene + " - CD44 Segmentation.png", 6);
            return imthresh;
        }
        BufferedImage imgray = ImageConverter.UShortGrayToGray((BufferedImage)cdx, (boolean)true);
        BufferedImage reswth = this.wth.Filter(imgray, this.sehex73, nbCPU);
        double average = (int)this.IF.Average(reswth, 0);
        ImageComparator.Compare((BufferedImage)reswth, (String)">", (int)((int)average), (BufferedImage)reswth, (int)0, (BufferedImage)reswth);
        BufferedImage resclrec = this.clrec.Filter(reswth, this.sedisk11, nbCPU);
        BufferedImage rescl = this.close.Filter(resclrec, this.sedisk7, nbCPU);
        BufferedImage resac = this.ac.Filter(rescl, 4000, true);
        reswth = this.allocator.Release(reswth);
        resclrec = this.allocator.Release(resclrec);
        rescl = this.allocator.Release(rescl);
        for (int i2 = 0; i2 < this.thresholders.length; ++i2) {
            BufferedImage resthres = this.thresholders[i2].Filter(resac, 0, nbCPU);
            resthres = this.allocator.Release(resthres);
            this.thresholds[i2] = this.thresholders[i2].getThreshold(0);
        }
        Arrays.sort(this.thresholds);
        int threshold = this.thresholds[1] + this.thresholds[0] >> 1;
        this.binary.Filter(resac, threshold, resac, nbCPU);
        rescl = this.close.Filter(resac, this.sedisk17, nbCPU);
        BufferedImage resop = this.open.Filter(rescl, this.sehex1, nbCPU);
        this.ac.Filter(resop, resac, 6000, true);
        BufferedImage resao = this.ao.Filter(resac, 100, true);
        BufferedImage res = ImageNew.Same((BufferedImage)cdx);
        ImageComparator.Compare((BufferedImage)resao, (String)">", (int)0, (int)65535, (int)0, (BufferedImage)res);
        ImageIO.Write(ImageConverter.GrayToBinary((BufferedImage)res), outputdir + "/Scene " + scene + " - CD44 Segmentation.png", 6);
        resac = this.allocator.Release(resac);
        resop = this.allocator.Release(resop);
        rescl = this.allocator.Release(rescl);
        resao = this.allocator.Release(resao);
        return res;
    }

    private BufferedImage CD45Segmentation(BufferedImage cdx, String outputdir, String scene, int nbCPU) throws IOException {
        this.AutoCrop(cdx);
        ImageIO.Write(cdx, outputdir + "/Scene " + scene + " - CD45.png", 6);
        if (this.easymarkers) {
            List<CycIF_RoundCycle> rc_list = this.rclist;
            CycIF_RoundCycle rc = this.Tools.FindMarker("CD45", rc_list);
            BufferedImage imthresh = this.binary.Filter(cdx, rc.minthreshold, nbCPU);
            ImageComparator.Compare((BufferedImage)cdx, (String)"<=", (int)rc.maxthreshold, (BufferedImage)imthresh, (int)0, (BufferedImage)imthresh);
            ImageIO.Write(ImageConverter.UShortGrayToBinary((BufferedImage)imthresh), outputdir + "/Scene " + scene + " - CD45 Segmentation.png", 6);
            return imthresh;
        }
        BufferedImage imgray = ImageConverter.UShortGrayToGray((BufferedImage)cdx, (boolean)true);
        BufferedImage reswth = this.wth.Filter(imgray, this.sehex73, nbCPU);
        double average = (int)this.IF.Average(reswth, 0);
        ImageComparator.Compare((BufferedImage)reswth, (String)">", (int)((int)average), (BufferedImage)reswth, (int)0, (BufferedImage)reswth);
        BufferedImage resclrec = this.clrec.Filter(reswth, this.sedisk7, nbCPU);
        BufferedImage rescl = this.close.Filter(resclrec, this.sedisk3, nbCPU);
        BufferedImage resac = this.ac.Filter(rescl, 2000, true);
        reswth = this.allocator.Release(reswth);
        resclrec = this.allocator.Release(resclrec);
        rescl = this.allocator.Release(rescl);
        for (int i2 = 0; i2 < this.thresholders.length; ++i2) {
            BufferedImage resthres = this.thresholders[i2].Filter(resac, 0, nbCPU);
            resthres = this.allocator.Release(resthres);
            this.thresholds[i2] = this.thresholders[i2].getThreshold(0);
        }
        Arrays.sort(this.thresholds);
        int threshold = this.thresholds[1] + this.thresholds[2] >> 1;
        this.binary.Filter(resac, threshold, resac, nbCPU);
        rescl = this.close.Filter(resac, this.sedisk11, nbCPU);
        BufferedImage resop = this.open.Filter(rescl, this.sehex1, nbCPU);
        this.ac.Filter(resop, resac, 3000, true);
        BufferedImage resao = this.ao.Filter(resac, 100, true);
        BufferedImage res = ImageNew.Same((BufferedImage)cdx);
        ImageComparator.Compare((BufferedImage)resao, (String)">", (int)0, (int)65535, (int)0, (BufferedImage)res);
        ImageIO.Write(ImageConverter.GrayToBinary((BufferedImage)res), outputdir + "/Scene " + scene + " - CD45 Segmentation.png", 6);
        resac = this.allocator.Release(resac);
        resop = this.allocator.Release(resop);
        rescl = this.allocator.Release(rescl);
        resao = this.allocator.Release(resao);
        return res;
    }

    private BufferedImage EcadCksSegmentation(BufferedImage ecad, BufferedImage ck7, BufferedImage ck19, String outputdir, String scene, int nbCPU) throws IOException {
        this.AutoCrop(ecad);
        this.AutoCrop(ck7);
        this.AutoCrop(ck19);
        if (!this.easymarkers) {
            this.dynexp.FilterWithConditions(ecad, 1.0, 0.5, 0, 0, 65535, ecad, nbCPU);
            this.dynexp.FilterWithConditions(ck7, 0.5, 0.5, 0, 0, 65535, ck7, nbCPU);
            this.dynexp.FilterWithConditions(ck19, 0.5, 0.5, 0, 0, 65535, ck19, nbCPU);
        }
        ImageIO.Write(ck7, outputdir + "/Scene " + scene + " - CK7.png", 6);
        ImageIO.Write(ecad, outputdir + "/Scene " + scene + " - Ecad.png", 6);
        ImageIO.Write(ck19, outputdir + "/Scene " + scene + " - CK19.png", 6);
        int[] buf = new int[3];
        BufferedImage median = ImageNew.Same((BufferedImage)ck7);
        short[] sb0 = ((DataBufferUShort)ecad.getRaster().getDataBuffer()).getData();
        short[] sb1 = ((DataBufferUShort)ck7.getRaster().getDataBuffer()).getData();
        short[] sb2 = ((DataBufferUShort)ck19.getRaster().getDataBuffer()).getData();
        short[] sb = ((DataBufferUShort)median.getRaster().getDataBuffer()).getData();
        for (int i2 = 0; i2 < sb.length; ++i2) {
            buf[0] = sb0[i2] & 0xFFFF;
            buf[1] = sb1[i2] & 0xFFFF;
            buf[2] = sb2[i2] & 0xFFFF;
            Arrays.sort(buf);
            sb[i2] = (short)buf[1];
        }
        buf = null;
        sb2 = null;
        sb1 = null;
        sb0 = null;
        sb = null;
        ImageIO.Write(median, outputdir + "/Scene " + scene + " - EcadCKs.png", 6);
        ImageOperations.Maximum((BufferedImage)ecad, (BufferedImage)ck7, (BufferedImage)ecad);
        ImageOperations.Maximum((BufferedImage)ecad, (BufferedImage)ck19, (BufferedImage)ecad);
        ImageIO.Write(ecad, outputdir + "/Scene " + scene + " - Ecad+CKs.png", 6);
        if (this.easymarkers) {
            List<CycIF_RoundCycle> rc_list = this.rclist;
            CycIF_RoundCycle rc = this.Tools.FindMarker("Ecad", rc_list);
            BufferedImage imthresh = this.binary.Filter(ecad, rc.minthreshold, nbCPU);
            ImageComparator.Compare((BufferedImage)ecad, (String)"<=", (int)rc.maxthreshold, (BufferedImage)imthresh, (int)0, (BufferedImage)imthresh);
            ImageIO.Write(ImageConverter.UShortGrayToBinary((BufferedImage)imthresh), outputdir + "/Scene " + scene + " - Ecad Segmentation.png", 6);
            BufferedImage imres = ImageNew.Clone((BufferedImage)imthresh);
            rc = this.Tools.FindMarker("CK7", rc_list);
            this.binary.Filter(ck7, rc.minthreshold, imthresh, nbCPU);
            ImageComparator.Compare((BufferedImage)ck7, (String)"<=", (int)rc.maxthreshold, (BufferedImage)imthresh, (int)0, (BufferedImage)imthresh);
            ImageIO.Write(ImageConverter.UShortGrayToBinary((BufferedImage)imthresh), outputdir + "/Scene " + scene + " - CK7 Segmentation.png", 6);
            ImageOperations.Maximum((BufferedImage)imres, (BufferedImage)imthresh, (BufferedImage)imres);
            rc = this.Tools.FindMarker("CK19", rc_list);
            this.binary.Filter(ck19, rc.minthreshold, imthresh, nbCPU);
            ImageComparator.Compare((BufferedImage)ck19, (String)"<=", (int)rc.maxthreshold, (BufferedImage)imthresh, (int)0, (BufferedImage)imthresh);
            ImageIO.Write(ImageConverter.UShortGrayToBinary((BufferedImage)imthresh), outputdir + "/Scene " + scene + " - CK19 Segmentation.png", 6);
            ImageOperations.Maximum((BufferedImage)imres, (BufferedImage)imthresh, (BufferedImage)imres);
            imthresh = this.allocator.Release(imthresh);
            ImageIO.Write(ImageConverter.UShortGrayToBinary((BufferedImage)imres), outputdir + "/Scene " + scene + " - EcadCks Segmentation.png", 6);
            return imres;
        }
        BufferedImage imgray = ImageConverter.UShortGrayToGray((BufferedImage)median, (boolean)true);
        BufferedImage reswth = this.wth.Filter(imgray, this.sehex73, nbCPU);
        int average = (int)this.IF.Average(reswth, 0);
        ImageComparator.Compare((BufferedImage)reswth, (String)">", (int)average, (BufferedImage)reswth, (int)0, (BufferedImage)reswth);
        BufferedImage resclrec = this.clrec.Filter(reswth, this.sedisk17, nbCPU);
        BufferedImage rescl = this.close.Filter(resclrec, this.sedisk7, nbCPU);
        BufferedImage resac = this.ac.Filter(rescl, 5000, true);
        reswth = this.allocator.Release(reswth);
        resclrec = this.allocator.Release(resclrec);
        rescl = this.allocator.Release(rescl);
        this.IF.Ranks(resac, 0);
        int threshold = (int)this.IF.Rank10();
        this.binary.Filter(resac, threshold, resac, nbCPU);
        rescl = this.close.Filter(resac, this.sedisk7, nbCPU);
        BufferedImage resop = this.open.Filter(rescl, this.sedisk5, nbCPU);
        this.ac.Filter(resop, resac, 7000, true);
        ImageIO.Write(ImageConverter.GrayToBinary((BufferedImage)resac), outputdir + "/Scene " + scene + " - EcadCks Segmentation.png", 6);
        rescl = this.allocator.Release(rescl);
        resop = this.allocator.Release(resop);
        return resac;
    }

    public void FeaturesExtraction(String inputdir, String segmentationdir, String featuresdir, int nbCPU) throws Exception {
        CycIF_Features cycif = new CycIF_Features(CycIF_Features.Version.v1, this.Copyright, this.log);
        cycif.FE_BiasedFeaturesOnly = this.FE_BiasedFeaturesOnly;
        cycif.FE_SubtractBackground = this.FE_SubtractBackground;
        cycif.FE_DistanceFromBorder = this.FE_DistanceFromBorder;
        cycif.FE_Rim_Size = this.FE_Rim_Size;
        cycif.FE_SaveImages = this.FE_SaveImages;
        cycif.FE_WaitForScene = this.FE_WaitForScene;
        cycif.FeaturesExtraction(inputdir, inputdir, segmentationdir, featuresdir, this.autocrop, false, nbCPU);
        cycif = null;
    }

    public void ImprovedDAPI(String inputdir, List<String> scenes, String outputdir) throws Exception {
        if (scenes == null) {
            scenes = this.Tools.FindScenes(inputdir, "");
        }
        for (String scene : scenes) {
            Object[] c1s = new File(inputdir).listFiles(this.Tools.CreateFNF(scene, 1));
            Arrays.sort(c1s);
            Object[] stack = StackIO.ReadImageSequence((File[])c1s);
            BufferedImage reszp = ImageNew.Same((BufferedImage)stack[0]);
            this.zp.Classic((BufferedImage[])stack, 2, -9, 13, false, reszp, 4);
            ImageIO.Write(reszp, outputdir + "/Scene " + scene + " - ZProjectionDAPI.png", 6);
            scene = null;
            reszp = null;
            Arrays.fill(c1s, null);
            Arrays.fill(stack, null);
        }
        Iterator<String> iter = null;
    }

    private boolean FindCropSize(String outputdir, String scene, int nbCPU) throws IOException {
        if (!this.autocrop) {
            return true;
        }
        StructuringElement[] stel = new StructuringElement[]{this.sehex113, this.sehex53, this.sehex31, this.sehex17};
        try {
            int imax;
            int nbccl;
            BufferedImage mask = ImageConverter.BinaryToGray((BufferedImage)ImageIO.Read(outputdir + "/Scene " + scene + " - Nuclei Safety Mask.png"));
            BufferedImage imdil = ImageNew.Same((BufferedImage)mask);
            int iter = 0;
            do {
                this.dilate.Filter(mask, stel[iter++], imdil, nbCPU);
                this.ccl.Label(imdil, 0, true);
                this.ccl.DeleteOnBorder(imdil, new int[0]);
                this.ccl.Label(imdil, 0, true);
            } while ((this.ccl.ConnectedComponentsNumber() == 0 || this.AF.Maximum(this.ccl.Sizes(), 1, this.ccl.Sizes().length) < 2500000) && iter < stel.length);
            do {
                nbccl = this.ccl.ConnectedComponentsNumber();
                this.ccl.Label(imdil, 0, true);
                this.ccl.ComputeBoundingBoxes();
                imax = this.AF.MaximumIndex(this.ccl.Sizes(), 1, this.ccl.Sizes().length);
                ImageDrawer.RectangleFull(imdil, this.ccl.minx()[imax], this.ccl.miny()[imax], this.ccl.maxx()[imax], this.ccl.maxy()[imax], Colors.WHITE);
            } while (nbccl != this.ccl.ConnectedComponentsNumber());
            this.cropTop = this.ccl.miny()[imax];
            this.cropLeft = this.ccl.minx()[imax];
            this.cropBottom = mask.getHeight() - this.ccl.maxy()[imax];
            this.cropRight = mask.getWidth() - this.ccl.maxx()[imax];
            mask = this.allocator.Release(mask);
            imdil = this.allocator.Release(imdil);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.log.addNewException(ex, new String[0]);
            this.log.addComment("Cannot find crop size for scene " + scene);
            return false;
        }
        catch (Error e) {
            e.printStackTrace();
            this.log.addNewError(e, new String[0]);
            this.log.addComment("Cannot find crop size for scene " + scene);
            return false;
        }
        return true;
    }

    private void AutoCrop(BufferedImage image) {
        if (!this.autocrop) {
            return;
        }
        ImageDrawer.Borders(image, 0, this.cropTop, this.cropBottom, this.cropLeft, this.cropRight);
    }

    public boolean Rename(String inputdir) {
        File file = new File(inputdir);
        boolean success = true;
        return success &= FilesFolders.ReplaceInName(file, "-3-ROI1", "-Scene-051_");
    }
}

