/*
 * Decompiled with CFR 0.152.
 */
package softwares.ohsu.cyclicif;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import softwares.ohsu.cyclicif.CycIF_RoundCycle;
import utils.LogFile;
import utils.python.PythonLauncher;

public class CyclicIF_ExclusiveMarkers {
    private final String Copyright;
    private final String Python_Path;

    public CyclicIF_ExclusiveMarkers(String Python_Path, String Copyright) {
        this.Python_Path = Python_Path;
        this.Copyright = Copyright;
    }

    public void RunParallel(String Featuresdir, boolean PlotDensity, List<CycIF_RoundCycle> rclist, int nbCPU, LogFile log) throws IOException {
        log.addComment(this.Copyright);
        log.addComment("Starting plotting marker pairs...");
        System.out.println(this.Copyright);
        System.out.println("Starting plotting marker pairs...");
        ExecutorService exser = Executors.newFixedThreadPool(nbCPU);
        for (CycIF_RoundCycle rc : rclist) {
            exser.execute(new Plot(Featuresdir, rc.marker, PlotDensity, log));
        }
        exser.shutdown();
        try {
            exser.awaitTermination(113L, TimeUnit.MINUTES);
        }
        catch (InterruptedException ex) {
            log.addNewException(ex, "Ouch exception while running ExecutorService.awaitTermination.");
            System.out.println("Ouch exception while running ExecutorService.awaitTermination.");
            System.err.println("Ouch exception while running ExecutorService.awaitTermination.");
            ex.printStackTrace();
        }
        System.err.flush();
        System.out.flush();
    }

    private class Plot
    extends Thread {
        final String Featuresdir;
        final String Marker;
        final boolean PlotDensity;
        final LogFile log;

        public Plot(String Featuresdir, String Marker2, boolean PlotDensity, LogFile log) {
            this.Featuresdir = Featuresdir;
            this.Marker = Marker2;
            this.PlotDensity = PlotDensity;
            this.log = log;
        }

        @Override
        public void run() {
            try {
                StringBuilder sb = new StringBuilder(1001);
                sb.append("import sys").append("\n\n");
                sb.append("import FiReTiTiPyLib.CyclicIF.CyclicIF_MarkersExclusiveness as cycME\n\n");
                sb.append("try:\n");
                sb.append("\tcycME.PlotExclusiveness('").append(this.Featuresdir).append("', Density=").append(this.PlotDensity ? "True" : "False");
                sb.append(", Marker='").append(this.Marker).append("')\n");
                sb.append("except Exception as ex:\n");
                sb.append("\tprint(ex)\n");
                sb.append("\tsys.exit(1)\n");
                sb.append("sys.exit(0)\n\n");
                PythonLauncher pl = new PythonLauncher(CyclicIF_ExclusiveMarkers.this.Python_Path);
                if (pl.Run(this.Featuresdir + "/tmp/Script_" + this.Marker + ".py", sb, "-X faulthandler", this.log, true)) {
                    System.out.println("Marker '" + this.Marker + "' pairs plotting done successfully.");
                    this.log.addComment("Marker '" + this.Marker + "' pairs plotting done.");
                } else {
                    System.out.println("Marker '" + this.Marker + "' pairs plotting FAILURE!!!");
                    System.err.println("Marker '" + this.Marker + "' pairs plotting FAILURE!!!");
                    this.log.addNewError(new Error("Marker '" + this.Marker + "' pairs plotting failure."), "Failed to plot.");
                }
            }
            catch (IOException ex) {
                try {
                    this.log.addNewException(ex, "Cannot plot marker");
                }
                catch (IOException ex1) {
                    System.out.println("Exception within the exception.");
                    System.err.println("Exception within the exception.");
                    System.exit(0);
                }
            }
        }
    }
}

