/*
 * Decompiled with CFR 0.152.
 */
package softwares.ohsu.cyclicif;

import arrayTiTi.ArrayFeatures;
import arrayTiTi.ArrayIO;
import displays.Colors;
import displays.Display;
import filesAndFolders.FileNameFilters;
import filesAndFolders.FilesFolders;
import imageTiTi.ImageArithmetic;
import imageTiTi.ImageComparator;
import imageTiTi.ImageConverter;
import imageTiTi.ImageDrawer;
import imageTiTi.ImageFeatures;
import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import imageTiTi.ImageOperations;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import listTiTi.ListIO;
import measures.cclh.UnionFindCcl;
import morphee.Dilate;
import morphee.StructuringElement;
import morphee.WhiteTopHat;
import morphee.gradients.GradientDE;
import morphee.segmentation.Skiz;
import morphee.segmentation.watershed.Watershed;
import processing.filters.DynamicExpansion;
import processing.filters.gradients.Sobel;
import processing.zprojection.ZProjectionCMM;
import segmentation.cells.DapiDL;
import softwares.ohsu.cyclicif.CycIF_Features;
import softwares.ohsu.cyclicif.CycIF_QualityControl;
import softwares.ohsu.cyclicif.CycIF_Registration;
import softwares.ohsu.cyclicif.CycIF_RoundCycle;
import softwares.ohsu.cyclicif.CycIF_Tools;
import softwares.ohsu.cyclicif.CyclicIF_ExclusiveMarkers;
import stackTiTi.StackIO;
import utils.LogFile;
import utils.memory.Allocator;

public class CyclicIF {
    private Allocator allocator = Allocator.Instance();
    private final String Copyright = "Software version 5.6.2 (2022/05/08) developed by Guillaume THIBAULT for the CEDAR / Gray lab at OHSU. Copyright (c) 2006-Today. All Rights Reserved.";
    private List<CycIF_RoundCycle> rclist = new LinkedList<CycIF_RoundCycle>();
    public Display display = null;
    private final CycIF_Tools Tools = new CycIF_Tools();
    private final Dilate dilate = new Dilate();
    private final DynamicExpansion dynexp = new DynamicExpansion();
    private final GradientDE gradde = new GradientDE();
    private final Skiz skiz = new Skiz();
    private final Sobel sobel = new Sobel();
    private final UnionFindCcl ccl = new UnionFindCcl();
    private final Watershed watershed = new Watershed();
    private final WhiteTopHat wth = new WhiteTopHat();
    private final ZProjectionCMM zp = new ZProjectionCMM();
    private final StructuringElement sedisk1 = new StructuringElement(new Object[]{1, -2});
    private final StructuringElement sehex1 = new StructuringElement(new Object[]{1, -9});
    private final StructuringElement sehex17 = new StructuringElement(new Object[]{17, -9});
    private final StructuringElement sehex31 = new StructuringElement(new Object[]{31, -9});
    private final StructuringElement sehex53 = new StructuringElement(new Object[]{53, -9});
    private final StructuringElement sehex113 = new StructuringElement(new Object[]{113, -9});
    private final StructuringElement sem3 = new StructuringElement(new Object[]{3, -15});
    private final ArrayFeatures AF = new ArrayFeatures();
    private final ImageFeatures IF = new ImageFeatures();
    private final int Magnification;
    private final String Python_Path;
    private final int nbCPU;
    public final int TMA = -1;
    public final int CROPS = -2;
    public int Experiment = 0;
    private final String Registration = "OpenCV";
    public boolean Registration_Reverse = false;
    public boolean Improve_Dapi = true;
    public boolean Preprocessing = true;
    public boolean Segment_Cells = true;
    public boolean Background_Subtraction = true;
    private boolean autocrop;
    private LogFile log = new LogFile();
    public String Segment_WaitForScene = "";
    public boolean SingleWork = false;
    public final String SegmentNuclei_Model256 = "MaskRCNN_256x256_Norm=CR - 964_812_873 - 20200619.pt";
    public final String SegmentNuclei_Model512_1 = "MaskRCNN_512x512_Norm=CR - 967_821_884 - 20200624.pt";
    public final String SegmentNuclei_Model512_2 = "MaskRCNN_512x512_Norm=CR - 9686_831_8976 - 20201009.pt";
    public final String SegmentNuclei_CellPose20 = "CellPose-0";
    public final String SegmentNuclei_CellPose0 = "CellPose-10";
    public final String SegmentNuclei_CellPose10 = "CellPose-20";
    public final String SegmentNuclei_CellPose30 = "CellPose-30";
    public final String SegmentNuclei_CellPose40 = "CellPose-40";
    public final String SegmentNuclei_CellPose50 = "CellPose-50";
    public final String SegmentNuclei_CellPose70 = "CellPose-70";
    public float SegmentNuclei_Threshold = 0.07f;
    public int SegmentNuclei_BatchSize = 3;
    public int SegmentNuclei_BorderEffectSize = 73;
    public int SegmentNuclei_CheckOverlap = 7;
    public boolean SegmentNuclei_SaveNuclei = false;
    public String SegmentNuclei_Model = null;
    public String SegmentNuclei_RoundToSegment = "Z-Projection";
    public double SegmentCells_DilationRatio = 1.0;
    public String FE_WaitForScene = "";
    public boolean FE_SaveImages = true;
    public float FE_Rim_Size = 3.0f;
    public boolean FE_BiasedFeaturesOnly = true;
    public boolean FE_DistanceFromBorder = true;
    private int cropBottom = -1;
    private int cropTop = -1;
    private int cropLeft = -1;
    private int cropRight = -1;

    public CyclicIF(int Magnification, String Python_Path, int nbCPU) {
        switch (Magnification) {
            case 20: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Magnification not supported (yet).");
            }
        }
        this.Magnification = Magnification;
        this.Python_Path = Python_Path;
        this.nbCPU = nbCPU;
    }

    public void Registration_And_Segmentation(String inputdir, boolean SkipRegistration, boolean ExitAfterSegmentations) throws Exception {
        if (this.log.isRunning()) {
            this.log.Stop();
        }
        this.log.StartNewLog(this, inputdir);
        if (this.SegmentNuclei_Model == null) {
            System.out.println("No segmentation model selected/defined.");
            Error error = new Error("No segmentation model selected/defined.");
            this.log.addNewError(error, "No segmentation model selected/defined.");
            throw error;
        }
        this.Tools.GenerateRoundsCyclesTable(inputdir, this.log);
        String featuresdir = this.Tools.AddExtension(inputdir, " - Features/");
        this.Tools.LoadRoundsCyclesTable(featuresdir, this.rclist, this.log);
        this.log.Stop();
        this.Register(inputdir, SkipRegistration);
        this.Background_Subtraction = ExitAfterSegmentations ? false : this.Background_Subtraction;
        this.Segment(inputdir, ExitAfterSegmentations);
        if (ExitAfterSegmentations) {
            return;
        }
        this.FeaturesExtraction(inputdir, true);
        this.ExclusiveMarkers(inputdir, false);
        this.Tools.DeleteCSVs(featuresdir, "Mean Intensities");
        this.Tools.UpdateRCTable(featuresdir, this.rclist);
        System.out.println("***************************************************************************");
        System.out.println("*                                  TODO                                   *");
        System.out.println("***************************************************************************");
        System.out.println(" - 1 - Update the 'RoundsCyclesTable.txt' file:");
        System.out.println("     - Double check using the graphics whether the known mutually exclusive marker pairs are indeed exclusive for your dataset.");
        System.out.println("     - Add/Remove mutually exclusive marker pairs based on graphics.");
        System.out.println("     - If necessary, update the parameter 'All' to be more specific.");
        System.out.println("     - If known exclusive marker pairs were not listed, report them to Guillaume.");
        System.out.println(" - 2 - Create a file 'CellTypesTable.txt' if you wish to compute cell types.");
        System.out.println(" - 3 - Start features extraction.");
    }

    private void Register(String inputdir, boolean SkipRegistration) throws Exception {
        String outputdir = this.Tools.AddExtension(inputdir, " - Registration/");
        File fout = new File(outputdir);
        if (!fout.exists()) {
            fout.mkdirs();
        }
        fout = null;
        if (this.log.isRunning()) {
            this.log.Stop();
        }
        this.log.StartNewLog(this, outputdir);
        if (SkipRegistration) {
            System.out.println("\nWARNING - Registration skipped by user.\n");
            this.log.addComment("Registration skipped by user.");
            File[] files = new File(outputdir).listFiles(FileNameFilters.ImagesPNGorTIF);
            if (files == null || files.length == 0) {
                this.log.addComment("No registered images found in '" + outputdir + "'.");
                throw new Error("No registered images found in '" + outputdir + "'.");
            }
            for (File file : files) {
                if (!file.getName().startsWith("Registered-")) continue;
                file.renameTo(new File(file.getAbsolutePath().replace("Registered-", "")));
            }
            List<String> scenes = this.Tools.FindScenes(outputdir, "-");
            if (scenes == null || scenes.isEmpty()) {
                System.out.println("\nWarning - No keyword 'Scene-' found in images naming. All image names are updated with 'Scene-XXX_'.\n");
                this.log.addComment("Warning - No keyword 'Scene-' found in images naming. All image names are updated with 'Scene-XXX_'.");
                this.Tools.UpdateNames(outputdir);
                scenes = this.Tools.FindScenes(outputdir, "");
            }
            scenes.clear();
            scenes = null;
        } else {
            List<String> scenes = this.Tools.FindScenes(inputdir, "-");
            if (scenes == null || scenes.isEmpty()) {
                System.out.println("\nWarning - No keyword 'Scene-' found in images naming. All image names are updated with 'Scene-XXX_'.\n");
                this.log.addComment("Warning - No keyword 'Scene-' found in images naming. All image names are updated with 'Scene-XXX_'.");
                this.Tools.UpdateNames(inputdir);
                scenes = this.Tools.FindScenes(inputdir, "");
            }
            scenes.clear();
            scenes = null;
            CycIF_Registration reg = new CycIF_Registration(this.Python_Path, "Software version 5.6.2 (2022/05/08) developed by Guillaume THIBAULT for the CEDAR / Gray lab at OHSU. Copyright (c) 2006-Today. All Rights Reserved.");
            try {
                if (!reg.Register(inputdir, "OpenCV", 13, this.Registration_Reverse, outputdir, this.log)) {
                    System.exit(1);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.log.addNewException(ex, "Cannot register images.");
                throw new Exception("Registration failure");
            }
            catch (Error e) {
                e.printStackTrace();
                this.log.addNewError(e, "Cannot register images.");
                throw new Error("Registration failure");
            }
        }
        this.log.Stop();
    }

    private void Segment(String InputDir, boolean ExitAfterSegmentations) throws Exception {
        String outputdir = this.Tools.AddExtension(InputDir, " - Segmentation/");
        File out = new File(outputdir);
        if (!out.exists()) {
            out.mkdirs();
        }
        this.log.StartNewLog(this, outputdir);
        this.log.addComment("Software version 5.6.2 (2022/05/08) developed by Guillaume THIBAULT for the CEDAR / Gray lab at OHSU. Copyright (c) 2006-Today. All Rights Reserved.");
        this.log.addComment("Starting segmentation...");
        System.out.println("Software version 5.6.2 (2022/05/08) developed by Guillaume THIBAULT for the CEDAR / Gray lab at OHSU. Copyright (c) 2006-Today. All Rights Reserved.");
        String regdir = this.Tools.AddExtension(InputDir, " - Registration/");
        System.out.println("\n\nProcessing '" + regdir + "':");
        List<String> scenes = this.Tools.FindScenes(regdir, "-");
        System.out.print(scenes.size() + " scene(s) found: ");
        ListIO.Display(scenes, " ");
        System.out.println();
        if (scenes.isEmpty()) {
            System.out.println("\nError - No scene found in '" + regdir + "'. Rename your images accordingly.");
            Error e = new Error("No scene found");
            this.log.addNewError(e, "Cannot find any scene in " + regdir);
            throw e;
        }
        this.Tools.LoadRoundsCyclesTable(this.Tools.AddExtension(InputDir, " - Features/"), this.rclist, this.log);
        if (this.Improve_Dapi) {
            this.ImprovedDAPI(regdir, scenes, outputdir);
        }
        if (this.Preprocessing) {
            this.Tools.Preprocessing(regdir, scenes, this.Segment_WaitForScene, outputdir, this.nbCPU);
        }
        if (this.SegmentNuclei_Model != null) {
            this.SegmentNuclei(regdir, scenes, outputdir);
        }
        boolean bl = this.autocrop = this.Experiment == -1;
        if (this.autocrop && this.Segment_Cells) {
            this.FindCropSize(outputdir, scenes);
        }
        if (this.Segment_Cells) {
            this.SegmentCells(regdir, scenes, outputdir, this.nbCPU);
        }
        System.out.println("Segmentation done. Software version 5.6.2 (2022/05/08) developed by Guillaume THIBAULT for the CEDAR / Gray lab at OHSU. Copyright (c) 2006-Today. All Rights Reserved.");
        this.log.addComment("Segmentation done.\nSoftware version 5.6.2 (2022/05/08) developed by Guillaume THIBAULT for the CEDAR / Gray lab at OHSU. Copyright (c) 2006-Today. All Rights Reserved.");
        if (ExitAfterSegmentations) {
            String txt = "Early exit after segmentaiton.";
            this.log.addComment("Early exit after segmentaiton.");
            System.out.println("Early exit after segmentaiton.\n\n");
            this.log.Stop();
            return;
        }
        if (this.Background_Subtraction) {
            this.Tools.BackgroundSubtraction(regdir, scenes, this.rclist, CycIF_Features.Version.v2, outputdir, this.log, this.nbCPU);
        }
    }

    private void SegmentNuclei(String regdir, List<String> scenes, String outputdir) throws Exception {
        String lc;
        String keyword = "NucleiToSegment";
        String prefix = outputdir + "/Scene ";
        Iterator<String> iter = null;
        DapiDL dapi = new DapiDL(this.Python_Path, this.Magnification);
        switch (lc = this.SegmentNuclei_RoundToSegment.toLowerCase()) {
            case "all": 
            case "everything": 
            case "consensus": 
            case "zprojection": 
            case "z-projection": {
                System.out.println("Nuclei segmentation from z-projection/all/consensus.");
                for (String scene : scenes) {
                    FilesFolders.CopyFile(new File(prefix + scene + " - ZProjectionDAPI CE.png"), new File(prefix + scene + " - NucleiToSegment.png"));
                }
                break;
            }
            default: {
                String str = lc.replaceAll(";", ",");
                str = str.replaceAll("/", ",");
                str = str.replaceAll(":", ",");
                str = str.replaceAll(" ", "");
                String[] split = str.split(",");
                if (split == null || split.length == 1) {
                    int iround = this.Tools.CheckRound(str, this.SegmentNuclei_RoundToSegment, this.rclist, this.log);
                    System.out.println("Nuclei segmentation from single round: " + iround);
                    for (String scene : scenes) {
                        BufferedImage imdapi = this.Tools.LoadImage(regdir, scene, iround, 1);
                        BufferedImage reswth = this.wth.Filter(imdapi, this.sehex53, this.nbCPU);
                        this.dynexp.FilterWithConditions(reswth, 1.0, 0.5, 0, 0, 65535, reswth, this.nbCPU);
                        ImageIO.Write(reswth, prefix + scene + " - NucleiToSegment.png", 6);
                        reswth = this.allocator.Release(reswth);
                        imdapi = null;
                    }
                } else {
                    int[] rounds = new int[split.length];
                    for (int i2 = 0; i2 < split.length; ++i2) {
                        rounds[i2] = this.Tools.CheckRound(split[i2], this.SegmentNuclei_RoundToSegment, this.rclist, this.log);
                    }
                    ArrayIO.Display(rounds, "Nuclei segmentation from multiple rounds", " ");
                    for (String scene : scenes) {
                        Object[] dapis = new BufferedImage[rounds.length];
                        for (int i3 = 0; i3 < dapis.length; ++i3) {
                            dapis[i3] = this.Tools.LoadImage(regdir, scene, rounds[i3], 1);
                        }
                        BufferedImage reszp = ImageNew.Same((BufferedImage)dapis[0]);
                        this.zp.Classic((BufferedImage[])dapis, 2, -9, 13, false, reszp, this.nbCPU);
                        this.dynexp.FilterWithConditions(reszp, 1.0, 0.5, 0, 0, 65535, reszp, this.nbCPU);
                        ImageIO.Write(reszp, prefix + scene + " - NucleiToSegment.png", 6);
                        reszp = this.allocator.Release(reszp);
                        Arrays.fill(dapis, null);
                        dapis = null;
                    }
                }
                str = null;
            }
        }
        this.Tools.DownloadModel(this.SegmentNuclei_Model, this.log);
        dapi.Keyword = "NucleiToSegment.";
        dapi.ModelName = this.SegmentNuclei_Model;
        dapi.Threshold = this.SegmentNuclei_Threshold;
        dapi.BatchSize = this.SegmentNuclei_BatchSize;
        dapi.BorderEffectSize = this.SegmentNuclei_BorderEffectSize;
        dapi.CheckOverlap = this.SegmentNuclei_CheckOverlap;
        dapi.SaveNuclei = this.SegmentNuclei_SaveNuclei;
        if (!dapi.Segmentation(outputdir, false, this.log)) {
            System.exit(1);
        }
        dapi = null;
        for (String scene : scenes) {
            File f;
            File checkdir = new File(prefix + scene + " - Visual Check/");
            if (!checkdir.exists()) {
                checkdir.mkdirs();
            }
            if ((f = new File(prefix + scene + " - NucleiToSegment - Boxes.png")).exists()) {
                f.renameTo(new File(checkdir.getAbsolutePath() + "/Scene " + scene + " - Nuclei Boxes.png"));
            }
            f = null;
            f = new File(prefix + scene + " - NucleiToSegment - Candidates.png");
            if (f.exists()) {
                f.renameTo(new File(checkdir.getAbsolutePath() + "/Scene " + scene + " - Nuclei Candidates.png"));
            }
            f = null;
            f = new File(prefix + scene + " - NucleiToSegment - Foreground.png");
            if (f.exists()) {
                f.renameTo(new File(prefix + scene + " - Nuclei Foreground.png"));
            }
            f = null;
            f = new File(prefix + scene + " - NucleiToSegment - Labels.tif");
            if (f.exists()) {
                f.renameTo(new File(prefix + scene + " - Nuclei Labels.tif"));
            }
            f = null;
            f = new File(prefix + scene + " - NucleiToSegment - Labels.png");
            if (f.exists()) {
                f.renameTo(new File(prefix + scene + " - Nuclei Labels.png"));
            }
            f = null;
            f = new File(prefix + scene + " - NucleiToSegment - Objects/");
            if (f.exists()) {
                f.renameTo(new File(prefix + scene + " - Nuclei/"));
            }
            f = null;
            f = new File(prefix + scene + " - NucleiToSegment - Probabilities.png");
            if (f.exists()) {
                f.renameTo(new File(checkdir.getAbsolutePath() + "/Scene " + scene + " - Nuclei Probabilities.png"));
            }
            f = null;
            this.Tools.OutlineNuclei(scene, this.SegmentNuclei_Model, outputdir, "NucleiToSegment", this.log);
        }
        System.out.println("Nuclei segmentation fully done.");
    }

    private void SegmentCells(String inputdir, List<String> scenes, String outputdir, int nbCPU) throws Exception {
        System.out.println("\n\nStarting cell segmentation.");
        if (this.SegmentCells_DilationRatio <= 0.0) {
            String txt = "Cell segmentation: dilation ratio negative or null: " + this.SegmentCells_DilationRatio + "\n";
            System.out.println(txt);
            System.err.println(txt);
            this.log.addNewError(new Error(txt), "Failed to segment cells.");
        }
        String[] markers = new String[]{"Ecad", "CD44", "CD45", "CK7", "CK19"};
        this.Tools.CheckRoundCycleList(this.rclist, false, this.log, markers);
        String scene = null;
        Iterator<String> iter = scenes.iterator();
        while (iter.hasNext()) {
            try {
                scene = iter.next();
                BufferedImage basins = ImageIO.LoadLabels(outputdir + "/Scene " + scene + " - Nuclei Labels");
                int max = (int)this.IF.Maximum(basins);
                int background = max + 13;
                if (max == 0) {
                    this.log.addComment("Cell segmentation impossible in scene " + scene + ", no nuclei found.");
                    ImageIO.SaveLabels(basins, outputdir + "/Scene " + scene + " - Cell Labels");
                    return;
                }
                BufferedImage gradient = null;
                BufferedImage maxgrad = null;
                for (String marker : markers) {
                    CycIF_RoundCycle rc = this.Tools.FindMarker(marker, this.rclist);
                    if (rc == null) continue;
                    BufferedImage staining = this.Tools.LoadImage(inputdir, scene, rc.round, rc.cycle);
                    this.dynexp.FilterWithConditions(staining, 1.0, 0.5, 0, 0, 65535, staining, nbCPU);
                    if (gradient == null) {
                        gradient = this.sobel.Filter(staining, nbCPU);
                        maxgrad = ImageNew.Clone((BufferedImage)gradient);
                    } else {
                        this.sobel.Filter(staining, gradient, nbCPU);
                        ImageOperations.Maximum((BufferedImage)gradient, (BufferedImage)maxgrad, (BufferedImage)maxgrad);
                    }
                    staining = null;
                }
                BufferedImage imdapi = ImageIO.Read(outputdir + "/Scene " + scene + " - ZProjectionDAPI.png");
                double[] radii = this.Tools.FindAdaptedRadii(imdapi, basins, this.SegmentCells_DilationRatio);
                float[] constraints = new float[max + 1];
                for (int i2 = 0; i2 < constraints.length; ++i2) {
                    constraints[i2] = (float)radii[i2];
                }
                BufferedImage skizlabels = this.skiz.Filter(basins, this.sem3, false, constraints, nbCPU);
                BufferedImage watbasins = null;
                if (maxgrad != null) {
                    BufferedImage imdil = this.dilate.Filter(basins, this.sehex53, nbCPU);
                    ImageComparator.Compare((BufferedImage)imdil, (String)"!=", (int)0, (int)background, (int)0, (BufferedImage)imdil);
                    BufferedImage contour = this.gradde.Filter(imdil, this.sehex1, nbCPU);
                    ImageArithmetic.Add(basins, contour, basins);
                    imdil = this.allocator.Release(imdil);
                    contour = this.allocator.Release(contour);
                    this.watershed.watershed(maxgrad, basins, this.sedisk1);
                    watbasins = this.watershed.Basins();
                    ImageComparator.Compare((BufferedImage)watbasins, (String)"!=", (int)background, (BufferedImage)watbasins, (int)0, (BufferedImage)watbasins);
                    gradient = this.allocator.Release(gradient);
                    maxgrad = this.allocator.Release(maxgrad);
                } else {
                    watbasins = skizlabels;
                }
                basins = null;
                ImageComparator.Compare((BufferedImage)skizlabels, (String)"==", (BufferedImage)watbasins, (BufferedImage)watbasins, (int)0, (BufferedImage)watbasins);
                ImageIO.SaveLabels(watbasins, outputdir + "/Scene " + scene + " - Cell Labels");
                BufferedImage dapirgb = null;
                try {
                    dapirgb = ImageConverter.GrayToColor((BufferedImage)imdapi);
                    if (dapirgb != null) {
                        byte[] bbrgb = ((DataBufferByte)dapirgb.getRaster().getDataBuffer()).getData();
                        int width = imdapi.getWidth();
                        int height = imdapi.getHeight();
                        int[] ibwat = ((DataBufferInt)watbasins.getRaster().getDataBuffer()).getData();
                        int pos = 0;
                        int posrgb = 0;
                        for (int y = 0; y < height; ++y) {
                            int x = 0;
                            while (x < width) {
                                if (ibwat[pos] != 0) {
                                    if (x == 0 || y == 0 || x == width - 1 || y == height - 1 || 0 < x && ibwat[pos - 1] < ibwat[pos] || x < width - 1 && ibwat[pos + 1] < ibwat[pos] || 0 < y && ibwat[pos - width] < ibwat[pos] || y < height - 1 && ibwat[pos + width] < ibwat[pos]) {
                                        bbrgb[posrgb + 2] = -1;
                                        bbrgb[posrgb + 1] = 0;
                                        bbrgb[posrgb] = 0;
                                    } else {
                                        bbrgb[posrgb] = 0;
                                    }
                                }
                                ++x;
                                ++pos;
                                posrgb += 3;
                            }
                        }
                        ImageIO.tag = 1;
                        ImageIO.Write(dapirgb, outputdir + "/Scene " + scene + " - Visual Check/Scene " + scene + " - Cells Segmentation.png", 6);
                        ImageIO.tag = 0;
                        bbrgb = null;
                        ibwat = null;
                    }
                    dapirgb = null;
                }
                catch (NegativeArraySizeException ex) {
                    this.log.addComment("Cells outline: images too big to be converted into RGB format.");
                    System.out.print("WARNING - Cells outline: images too big to be converted into RGB format.");
                }
                imdapi = null;
                skizlabels = this.allocator.Release(skizlabels);
                this.allocator.ClearAll(true);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.log.addNewException(ex, "Cannot segment cells in scene " + scene);
            }
            catch (Error e) {
                e.printStackTrace();
                this.log.addNewError(e, "Cannot segment cells in scene " + scene);
            }
        }
        System.out.println("Cell segmentation done.");
    }

    public void FeaturesExtraction(String inputdir) throws Exception {
        this.FeaturesExtraction(inputdir, false);
    }

    private void FeaturesExtraction(String inputdir, boolean litemode) throws Exception {
        String registrationdir = this.Tools.AddExtension(inputdir, " - Registration/");
        String segmentationdir = this.Tools.AddExtension(inputdir, " - Segmentation/");
        String featuresdir = this.Tools.AddExtension(inputdir, " - Features/");
        File resfile = new File(featuresdir);
        if (!resfile.exists()) {
            resfile.mkdirs();
        }
        resfile = null;
        if (this.log.isRunning()) {
            this.log.Stop();
        }
        this.log.StartNewLog(this, featuresdir);
        CycIF_Features cycif = new CycIF_Features(CycIF_Features.Version.v2, "Software version 5.6.2 (2022/05/08) developed by Guillaume THIBAULT for the CEDAR / Gray lab at OHSU. Copyright (c) 2006-Today. All Rights Reserved.", this.log);
        cycif.FE_BiasedFeaturesOnly = litemode ? true : this.FE_BiasedFeaturesOnly;
        cycif.FE_SubtractBackground = this.Background_Subtraction;
        cycif.FE_DistanceFromBorder = litemode ? false : this.FE_DistanceFromBorder;
        cycif.FE_Rim_Size = this.FE_Rim_Size;
        cycif.FE_SaveImages = litemode ? false : this.FE_SaveImages;
        cycif.FE_WaitForScene = this.FE_WaitForScene;
        cycif.FE_Python_Path = this.Python_Path;
        cycif.FeaturesExtraction(inputdir, registrationdir, segmentationdir, featuresdir, this.autocrop, litemode, this.nbCPU);
        cycif = null;
        this.log.Stop();
    }

    public void ExclusiveMarkers(String Inputdir, boolean PlotDensity) throws Exception {
        String featuresdir = this.Tools.AddExtension(Inputdir, " - Features/");
        if (this.log.isRunning()) {
            this.log.Stop();
        }
        this.log.StartNewLog(this, featuresdir);
        CyclicIF_ExclusiveMarkers em = new CyclicIF_ExclusiveMarkers(this.Python_Path, "Software version 5.6.2 (2022/05/08) developed by Guillaume THIBAULT for the CEDAR / Gray lab at OHSU. Copyright (c) 2006-Today. All Rights Reserved.");
        try {
            em.RunParallel(featuresdir, false, this.rclist, this.nbCPU, this.log);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.log.addNewException(ex, "Cannot compute/plot exclusive marker pairs.");
            throw new Exception("Exclusive marker pairs computation failure.");
        }
        catch (Error e) {
            e.printStackTrace();
            this.log.addNewError(e, "Cannot compute/plot exclusive marker pairs.");
            throw new Error("Exclusive marker pairs computation failure.");
        }
        this.log.Stop();
    }

    private void ImprovedDAPI(String inputdir, List<String> scenes, String outputdir) throws Exception {
        System.out.println("\n\nStarting dapi improvement.");
        if (scenes == null) {
            scenes = this.Tools.FindScenes(inputdir, "-");
        }
        boolean work = this.Segment_WaitForScene.isEmpty();
        for (String scene : scenes) {
            if (!work) {
                if (!scene.equalsIgnoreCase(this.Segment_WaitForScene)) continue;
                work = true;
            }
            Object[] c1s = new File(inputdir).listFiles(this.Tools.CreateFNF(scene, 1));
            Arrays.sort(c1s);
            Object[] stack = StackIO.ReadImageSequence((File[])c1s);
            BufferedImage reszp = ImageNew.Same((BufferedImage)stack[0]);
            this.zp.Classic((BufferedImage[])stack, 2, -9, 13, false, reszp, this.nbCPU);
            ImageIO.Write(reszp, outputdir + "/Scene " + scene + " - ZProjectionDAPI.png", 6);
            scene = null;
            reszp = null;
            Arrays.fill(c1s, null);
            Arrays.fill(stack, null);
        }
        Iterator<String> iter = null;
        System.out.println("Dapi improvement done.");
    }

    public void QualityControl(String InputDir) throws Exception {
        String regdir = this.Tools.AddExtension(InputDir, " - Registration/");
        String segdir = this.Tools.AddExtension(InputDir, " - Segmentation/");
        String featdir = this.Tools.AddExtension(InputDir, " - Features/");
        String qcdir = this.Tools.AddExtension(InputDir, " - Quality Control/");
        File qcfile = new File(qcdir);
        if (!qcfile.exists()) {
            qcfile.mkdirs();
        }
        qcfile = null;
        if (this.log.isRunning()) {
            this.log.Stop();
        }
        this.log.StartNewLog(this, qcdir);
        CycIF_QualityControl qc = new CycIF_QualityControl(this.Magnification, this.Python_Path, "Software version 5.6.2 (2022/05/08) developed by Guillaume THIBAULT for the CEDAR / Gray lab at OHSU. Copyright (c) 2006-Today. All Rights Reserved.", this.nbCPU);
        DapiDL dapi = new DapiDL(this.Python_Path, this.Magnification);
        dapi.ModelName = this.SegmentNuclei_Model;
        dapi.Threshold = this.SegmentNuclei_Threshold;
        dapi.BatchSize = this.SegmentNuclei_BatchSize;
        dapi.BorderEffectSize = this.SegmentNuclei_BorderEffectSize;
        dapi.CheckOverlap = this.SegmentNuclei_CheckOverlap;
        dapi.SaveNuclei = false;
        this.rclist.clear();
        this.Tools.LoadRoundsCyclesTable(featdir, this.rclist, this.log);
        qc.Check(regdir, dapi, this.rclist, segdir, featdir, qcdir, this.log);
        dapi = null;
        this.log.Stop();
    }

    private boolean FindCropSize(String outputdir, List<String> scenes) throws IOException {
        boolean work = this.Segment_WaitForScene.isEmpty();
        StructuringElement[] stel = new StructuringElement[]{this.sehex113, this.sehex53, this.sehex31, this.sehex17};
        for (String scene : scenes) {
            try {
                int imax;
                int nbccl;
                if (!work) {
                    if (!scene.equalsIgnoreCase(this.Segment_WaitForScene)) continue;
                    work = true;
                }
                BufferedImage labels = ImageIO.LoadLabels(outputdir + "/Scene " + scene + " - Nuclei Labels");
                BufferedImage mask = ImageNew.Same((BufferedImage)labels, (int)10);
                ImageComparator.Compare((BufferedImage)labels, (String)"!=", (int)0, (int)255, (int)0, (BufferedImage)mask);
                BufferedImage imdil = ImageNew.Same((BufferedImage)mask);
                int iter = 0;
                do {
                    this.dilate.Filter(mask, stel[iter++], imdil, this.nbCPU);
                    this.ccl.Label(imdil, 0, true);
                    this.ccl.DeleteOnBorder(imdil, new int[]{this.AF.MaximumIndex(this.ccl.Sizes(), 1, this.ccl.Sizes().length)});
                    this.ccl.Label(imdil, 0, true);
                } while ((this.ccl.ConnectedComponentsNumber() == 0 || this.AF.Maximum(this.ccl.Sizes(), 1, this.ccl.Sizes().length) < 2500000) && iter < stel.length);
                boolean count = false;
                do {
                    nbccl = this.ccl.ConnectedComponentsNumber();
                    this.ccl.Label(imdil, 0, true);
                    this.ccl.ComputeBoundingBoxes();
                    imax = this.AF.MaximumIndex(this.ccl.Sizes(), 1, this.ccl.Sizes().length);
                    ImageDrawer.RectangleFull(imdil, this.ccl.minx()[imax], this.ccl.miny()[imax], this.ccl.maxx()[imax], this.ccl.maxy()[imax], Colors.WHITE);
                } while (nbccl != this.ccl.ConnectedComponentsNumber());
                this.cropTop = this.ccl.maxy()[imax];
                this.cropLeft = this.ccl.minx()[imax];
                this.cropBottom = this.ccl.miny()[imax];
                this.cropRight = this.ccl.maxx()[imax];
                this.RemoveOutsideROI(labels);
                ImageIO.SaveLabels(labels, this.ccl.ConnectedComponentsNumber(), outputdir + "/Scene " + scene + " - Nuclei Labels");
                BufferedImage boxes = ImageIO.Read(outputdir + "/Scene " + scene + " - Visual Check/Scene " + scene + " - Nuclei Boxes.png");
                ImageDrawer.Rectangle(boxes, this.cropLeft, this.cropBottom, this.cropRight, this.cropTop, 1, Colors.RED);
                ImageIO.Write(boxes, outputdir + "/Scene " + scene + " - Visual Check/Scene " + scene + " - Nuclei Boxes.png", 6);
                mask = this.allocator.Release(mask);
                imdil = this.allocator.Release(imdil);
                labels = null;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.log.addNewException(ex, new String[0]);
                this.log.addComment("Cannot find crop size for scene " + scene);
                return false;
            }
            catch (Error e) {
                e.printStackTrace();
                this.log.addNewError(e, new String[0]);
                this.log.addComment("Cannot find crop size for scene " + scene);
                return false;
            }
        }
        return true;
    }

    private void RemoveOutsideROI(BufferedImage labels) throws Exception {
        this.ccl.ImportLabels(((DataBufferInt)labels.getRaster().getDataBuffer()).getData(), labels.getWidth(), labels.getHeight());
        this.ccl.ComputeBoundingBoxes();
        int[] xmin = this.ccl.minx();
        int[] xmax = this.ccl.maxx();
        int[] ymin = this.ccl.miny();
        int[] ymax = this.ccl.maxy();
        LinkedList<Integer> toRemove = new LinkedList<Integer>();
        for (int i2 = 1; i2 < this.ccl.ConnectedComponentsNumber(); ++i2) {
            if (xmax[i2] >= this.cropLeft && this.cropRight >= xmin[i2] && ymax[i2] >= this.cropBottom && this.cropTop >= ymin[i2]) continue;
            toRemove.add(i2);
        }
        this.ccl.DeleteCCs(labels, toRemove);
    }
}

