/*
 * Decompiled with CFR 0.152.
 */
package softwares.ohsu.cyclicif;

import algoGeo.convexhull.PseudoConvexHull;
import arrayTiTi.ArrayArithmetic;
import arrayTiTi.ArrayFeatures;
import com.google.common.collect.HashBiMap;
import displays.Colors;
import filesAndFolders.FileFilters;
import filesAndFolders.FileNameFilters;
import filesAndFolders.FilesFolders;
import filesAndFolders.fichiersTabules.FichierTabule;
import imageTiTi.ImageComparator;
import imageTiTi.ImageConverter;
import imageTiTi.ImageDrawer;
import imageTiTi.ImageFeatures;
import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import imageTiTi.ImageOperations;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import java.util.Scanner;
import listTiTi.ListTools;
import mathematics.primitives.pointsTiTi.Coordinates;
import measures.Measures2D;
import measures.cclh.UnionFindCcl;
import measures.hedgehop.DistanceMapComputer;
import morphee.Close;
import morphee.Dilate;
import morphee.StructuringElement;
import morphee.WhiteTopHat;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import processing.filters.DynamicExpansion;
import processing.filters.Invert;
import softwares.ohsu.cyclicif.CycIF_Features;
import softwares.ohsu.cyclicif.CycIF_Restore;
import softwares.ohsu.cyclicif.CycIF_RoundCycle;
import utils.LogFile;
import utils.memory.Allocator;

public class CycIF_Tools {
    private final Allocator allocator = Allocator.Instance();
    private final ArrayFeatures AF = new ArrayFeatures();
    private final DistanceMapComputer dmc = new DistanceMapComputer();
    private final DynamicExpansion dynexp = new DynamicExpansion();
    private final ImageFeatures IF = new ImageFeatures();
    private final Invert invert = new Invert();
    private final PseudoConvexHull pch = new PseudoConvexHull();
    private final UnionFindCcl ccl = new UnionFindCcl();
    private final Close close = new Close();
    private final Dilate dilate = new Dilate();
    private final WhiteTopHat wth = new WhiteTopHat();
    private final StructuringElement sedisk53 = new StructuringElement(new Object[]{53, -2});
    private final StructuringElement sem3 = new StructuringElement(new Object[]{3, -15});
    private final Random random = new Random();
    private final String[][] emp = new String[][]{{"AR-Nuclei", "CK5-Ring", "FOXP3-Nuclei", "ColIV-Ring"}, {"aSMA-Ring", "CK14-Ring", "CD45-Ring", "CK7-Ring", "CK5-Ring", "CK19-Ring", "Ecad-Ring"}, {"CD3-Ring", "CK19-Ring", "CK7-Ring", "CK14-Ring", "CK5-Ring"}, {"CD4-Ring", "CK19-Ring", "CK7-Ring", "CK14-Ring", "CK5-Ring", "Ecad-Ring"}, {"CD8-Ring", "CK19-Ring", "CK7-Ring", "CK14-Ring", "CK5-Ring"}, {"CD20-Ring", "CK14-Ring", "CK7-Ring", "CK5-Ring", "CK19-Ring"}, {"CD31-Ring", "CK5-Ring", "CK19-Ring", "CK14-Ring", "CK7-Ring", "Ecad-Ring"}, {"CD44-Ring", "CK14-Ring", "CK7-Ring", "CK5-Ring", "CK19-Ring", "CD31-Ring"}, {"CD45-Ring", "CK19-Ring", "CK7-Ring", "CK14-Ring", "CK5-Ring", "CK8-Ring", "CD31-Ring"}, {"CD68-Ring", "CK19-Ring", "CK7-Ring", "CD31-Ring", "CK14-Ring"}, {"CK5-Ring", "CD31-Ring", "CD68-Ring", "Vim-Ring", "CD4-Ring", "CD45-Ring"}, {"CK7-Ring", "CD68-Ring", "CD4-Ring", "CD31-Ring", "CD45-Ring", "FOXP3-Nuclei"}, {"CK8-Ring", "CD68-Ring", "CD4-Ring", "CD31-Ring", "CD45-Ring"}, {"CK14-Ring", "CD31-Ring", "CD68-Ring", "Vim-Ring", "aSMA-Ring", "CD20-Ring", "CD45-Ring"}, {"CK17-Ring", "CD31-Ring", "CD68-Ring", "Vim-Ring", "ColI-Ring", "CD45-Ring"}, {"CK19-Ring", "CD68-Ring", "CD4-Ring", "CD31-Ring", "CD45-Ring"}, {"ColI-Ring", "CD45-Ring", "CK19-Ring", "CK7-Ring", "CK14-Ring", "CK5-Ring"}, {"ColIV-Ring", "CK19-Ring", "CK7-Ring", "CK14-Ring", "CK5-Ring", "CD68-Ring", "FOXP3-Nuclei"}, {"cPARP-Nuclei", "Ki67-Nuclei", "CK5-Ring", "CD31-Ring", "CD68-Ring", "", "CK14-Ring"}, {"Ecad-Ring", "CD68-Ring", "CD4-Ring", "CD31-Ring"}, {"ER-Nuclei", "CD68-Ring", "CD4-Ring", "CD31-Ring", "FOXP3-Nuclei"}, {"FOXP3-Nuclei", "CK19-Ring", "CK7-Ring", "CK5-Ring", "CK14-Ring", "CD31-Ring", "CK8-Ring"}, {"gH2AX-Nuclei", "CK8-Ring", "CK14-Ring", "CK5-Ring", "CK7-Ring"}, {"GRNZB-Ring", "CK19-Ring", "CK7-Ring", "CK5-Ring", "CD31-Ring", "CK14-Ring", "aSMA-Ring"}, {"H3K27me3-Nuclei", "CD31-Ring", "CD68-Ring", "CD44-Ring"}, {"H3K4me3-Nuclei", "CD31-Ring", "CD68-Ring", "CD44-Ring", "CK19-Ring"}, {"HER2-Ring", "CD68-Ring", "CD44-Ring", "CD31-Ring", "Vim-Ring", "CD4-Ring"}, {"Ki67-Nuclei", "cPARP-Nuclei"}, {"LaminAC-Nuclei", "CD68-Ring", "CD44-Ring", "CK19-Ring", "CD45-Ring"}, {"LaminB1-Nuclei", "CD68-Ring", "CD44-Ring", "CK19-Ring", "CD45-Ring", "CK14-Ring", "CK7-Ring", "CD31-Ring"}, {"LaminB2-Nuclei", "CD68-Ring", "CD44-Ring", "CK19-Ring", "CD31-Ring", "CK7-Ring", "CK14-Ring"}, {"PCNA-Nuclei", "CK7-Ring", "CD45-Ring", "CD31-Ring", "CD68-Ring", "CK14-Ring", "LaminB2-Nuclei"}, {"PDPN-Ring", "CK19-Ring", "CK7-Ring", "CK14-Ring", "CK5-Ring", "CD31-Ring", "CD68-Ring"}, {"PD1-Nuclei", "CK19-Ring", "CK7-Ring", "CK14-Ring", "CK5-Ring", "CD31-Ring"}, {"PgR-Nuclei", "CD68-Ring", "CK5-Ring", "CD31-Ring", "CD20-Ring", "aSMA-Ring", "Vim-Ring"}, {"pHH3-Nuclei", "CD31-Ring", "CK5-Ring", "CK19-Ring", "CK14-Ring", "GRNZB-Ring"}, {"pS6-Ring", "CK19-Ring", "CK5-Ring", "CK7-Ring", "CK14-Ring"}, {"Vim-Ring", "CK19-Ring", "CK7-Ring", "CD68-Ring", "CD45-Ring", "Ecad-Ring"}};
    private final Object[] ColorsList = new Object[]{Colors.BLUE, Colors.CYAN, Colors.YELLOW, Colors.RED, Colors.GREEN, Colors.PURPLE, Colors.ROSY_BROWN, Colors.DEEP_SKY_BLUE, Colors.MISTY_ROSE, Colors.AQUAMARINE, Colors.PEACH_PUFF, Colors.SALMON};

    public void BackgroundSubtraction(String inputdir, List<String> scenes, List<CycIF_RoundCycle> rclist, CycIF_Features.Version version, String outputdir, LogFile log, int nbCPU) throws IOException {
        System.out.println("\n\nStarting Background subtraction.");
        log.addComment("Starting background subtraction.\n");
        String scene = null;
        Iterator<String> iterscenes = scenes.iterator();
        while (iterscenes.hasNext()) {
            try {
                BufferedImage imwth;
                scene = iterscenes.next();
                BufferedImage nuclei = null;
                switch (version) {
                    case v1: {
                        nuclei = ImageIO.Read(outputdir + "/Scene " + scene + " - Nuclei Segmentation Basins.tif");
                        break;
                    }
                    case v2: {
                        nuclei = ImageIO.LoadLabels(outputdir + "/Scene " + scene + " - Nuclei Labels");
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Version not supported.");
                    }
                }
                BufferedImage cells = null;
                switch (version) {
                    case v1: {
                        cells = ImageIO.Read(outputdir + "/Scene " + scene + " - Cell Segmentation Basins.tif");
                        break;
                    }
                    case v2: {
                        cells = ImageIO.LoadLabels(outputdir + "/Scene " + scene + " - Cell Labels");
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Version not supported.");
                    }
                }
                BufferedImage im = ImageNew.Same((BufferedImage)nuclei, (int)10);
                ImageComparator.Compare((BufferedImage)nuclei, (String)"!=", (int)0, (int)255, (int)0, (BufferedImage)im);
                this.dmc.Compute(im, this.sem3);
                int max = (int)(this.AF.Maximum(this.dmc.getMontanariMap1D()) + 0.5);
                StructuringElement senuclei = new StructuringElement(new Object[]{max + 7, -9});
                ImageComparator.Compare((BufferedImage)cells, (String)"!=", (int)0, (int)255, (int)0, (BufferedImage)im);
                this.dmc.Compute(im, this.sem3);
                max = (int)(this.AF.Maximum(this.dmc.getMontanariMap1D()) + 0.5);
                StructuringElement secells = new StructuringElement(new Object[]{max + 7, -9});
                im = this.allocator.Release(im);
                CycIF_RoundCycle rc = null;
                Iterator<CycIF_RoundCycle> iterrc = rclist.iterator();
                while (iterrc.hasNext()) {
                    try {
                        rc = iterrc.next();
                        BufferedImage staining = this.LoadImage(inputdir, scene, rc.round, rc.cycle);
                        ImageIO.Write(staining, outputdir + "/Scene " + scene + " - " + rc.marker + ".png", 6);
                        imwth = ImageNew.Same((BufferedImage)staining);
                        ImageIO.tag = 1;
                        this.wth.Filter(staining, senuclei, imwth, nbCPU);
                        ImageIO.Write(imwth, outputdir + "/Scene " + scene + " - " + rc.marker + " SBnuclei.png", 6);
                        if (!rc.cycle.equals("c1")) {
                            this.wth.Filter(staining, secells, imwth, nbCPU);
                            ImageIO.Write(imwth, outputdir + "/Scene " + scene + " - " + rc.marker + " SBcells.png", 6);
                        }
                        ImageIO.tag = 0;
                        imwth = this.allocator.Release(imwth);
                        staining = null;
                        rc = null;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        log.addNewException(ex, "Cannot perform background subtraction for marker " + rc.marker + " " + rc.round + " " + rc.cycle);
                    }
                    catch (Error e) {
                        e.printStackTrace();
                        log.addNewError(e, "Cannot background subtraction for marker " + rc.marker + " " + rc.round + " " + rc.cycle);
                    }
                }
                BufferedImage dapi = ImageIO.Read(outputdir + "/Scene " + scene + " - ZProjectionDAPI.png");
                imwth = this.wth.Filter(dapi, senuclei, nbCPU);
                ImageIO.Write(imwth, outputdir + "/Scene " + scene + " - ZProjectionDAPI SB.png", 6);
                imwth = null;
                dapi = null;
                senuclei.Kill();
                secells.Kill();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                log.addNewException(ex, "Cannot background subtraction for scene " + scene);
            }
            catch (Error e) {
                e.printStackTrace();
                log.addNewError(e, "Cannot background subtraction for scene " + scene);
            }
        }
        System.out.println("Background subtraction done. ");
        log.addComment("Background subtraction done.\n");
    }

    public void Preprocessing(String inputdir, List<String> scenes, String WaitForScene, String outputdir, int nbCPU) throws Exception {
        System.out.println("\n\nStarting preprocessing.");
        if (scenes == null) {
            scenes = this.FindScenes(inputdir, "");
        }
        boolean work = WaitForScene.isEmpty();
        for (String scene : scenes) {
            if (!work) {
                if (!scene.equalsIgnoreCase(WaitForScene)) continue;
                work = true;
            }
            BufferedImage imdapi = ImageIO.Read(outputdir + "/Scene " + scene + " - ZProjectionDAPI.png");
            BufferedImage stretched = this.dynexp.FilterWithConditions(imdapi, 1.0, 0.05, -1, 0, 65535, nbCPU);
            ImageIO.Write(stretched, outputdir + "/Scene " + scene + " - ZProjectionDAPI CE.png", 6);
            scene = null;
        }
        Iterator<String> iter = null;
        System.out.println("Preprocessing done.");
    }

    public void Preprocessing(String inputdir, String outputdir, int nbCPU) throws Exception {
        File[] files;
        System.out.println("\n\nStarting Dapis preprocessing.");
        for (File f : files = new File(inputdir).listFiles((dir, name) -> name.contains("_c1_"))) {
            BufferedImage imdapi = ImageIO.Read(f);
            BufferedImage stretched = this.dynexp.FilterWithConditions(imdapi, 1.0, 0.05, -1, 0, 65535, nbCPU);
            String name2 = f.getName();
            if (name2.endsWith(".tif")) {
                name2 = name2.replace(".tif", ".png");
            } else if (name2.endsWith(".TIF")) {
                name2 = name2.replace(".TIF", ".png");
            } else if (name2.endsWith(".tiff")) {
                name2 = name2.replace(".tiff", ".png");
            } else if (name2.endsWith(".TIFF")) {
                name2 = name2.replace(".TIFF", ".png");
            }
            ImageIO.Write(stretched, outputdir + "/" + name2, 6);
            stretched = null;
            imdapi = null;
        }
        System.out.println("Preprocessing done.");
    }

    public double[] FindAdaptedRadii(BufferedImage src, BufferedImage basins, double ratio) {
        this.ccl.ImportLabels(((DataBufferInt)basins.getRaster().getDataBuffer()).getData(), basins.getWidth(), basins.getHeight());
        double[] radii = new double[this.ccl.ConnectedComponentsNumber() + 1];
        BufferedImage[] nuclei = this.ccl.SeparateComponents(src, 1, 1);
        for (int i2 = 1; i2 < nuclei.length; ++i2) {
            if (nuclei[i2] != null) {
                Measures2D measures = new Measures2D(nuclei[i2]);
                measures.EuclidianRadii();
                measures.MainAxes();
                radii[i2] = Math.max(measures.getSmallestRadius(), measures.SecondAxis02.Length()) / 2.0 * ratio;
                measures.Kill();
                measures = null;
                continue;
            }
            radii[i2] = 0.0;
        }
        nuclei = null;
        return radii;
    }

    public float[] ComputeDistances(BufferedImage labels, String outputdir, String scene, int nbCPU) throws IOException {
        int i2;
        BufferedImage im = ImageNew.Same((BufferedImage)labels, (int)10);
        ImageComparator.Compare((BufferedImage)labels, (String)"!=", (int)0, (int)255, (int)0, (BufferedImage)im);
        BufferedImage rgb = ImageConverter.GrayToColor((BufferedImage)im);
        BufferedImage closed = this.close.Filter(im, this.sedisk53, nbCPU);
        ImageNew.Copy((BufferedImage)closed, (BufferedImage)im);
        this.pch.Compute(im, null, nbCPU);
        BufferedImage map = this.pch.Hull();
        ImageComparator.Compare((BufferedImage)map, (String)"==", (int)4, (int)255, (int)0, (BufferedImage)map);
        this.ccl.Label(map, 0, true);
        int[] sizes = this.ccl.Sizes();
        int max = this.AF.Maximum(sizes, 1, sizes.length);
        this.ccl.DeleteSmallerThan(map, max);
        ImageComparator.Compare((BufferedImage)map, (String)"==", (int)255, (BufferedImage)im, (int)0, (BufferedImage)im);
        this.pch.Compute(im, null, nbCPU);
        ImageComparator.Compare((BufferedImage)map, (String)"==", (int)4, (int)255, (int)0, (BufferedImage)map);
        BufferedImage dilated = this.dilate.Filter(map, this.sedisk53, nbCPU);
        this.invert.Filter(dilated, dilated, nbCPU);
        BufferedImage contour = ImageOperations.Contour((BufferedImage)dilated, (boolean)true);
        this.pch.Compute(im, contour, nbCPU);
        ImageComparator.Compare((BufferedImage)map, (String)"==", (int)5, (int)255, (int)0, (BufferedImage)map);
        this.close.Filter(map, this.sedisk53, closed, nbCPU);
        this.ccl.Label(closed, 0, true);
        sizes = this.ccl.Sizes();
        max = this.AF.Maximum(sizes, 1, sizes.length);
        this.ccl.DeleteSmallerThan(closed, max);
        ImageIO.Write(closed, outputdir + "/Scene " + scene + " - Nuclei Area.png", 6);
        contour = ImageOperations.Contour((BufferedImage)closed, (boolean)true);
        ImageDrawer.Draw(rgb, contour, Colors.RED);
        ImageIO.Write(rgb, outputdir + "/Scene " + scene + " - Visual Check/Scene " + scene + " - Nuclei Area.png", 6);
        max = (int)this.IF.Maximum(labels);
        boolean[] touching = new boolean[max + 1];
        Arrays.fill(touching, false);
        float[] distances = new float[max + 1];
        Arrays.fill(distances, Float.MAX_VALUE);
        ImageComparator.Compare((BufferedImage)contour, (String)"!=", (int)0, (int)0, (int)255, (BufferedImage)map);
        this.dmc.Compute(map, this.sem3);
        float[] distmap = this.dmc.getMontanariMap1D();
        int[] iblabels = ((DataBufferInt)labels.getRaster().getDataBuffer()).getData();
        byte[] bbcontour = ((DataBufferByte)closed.getRaster().getDataBuffer()).getData();
        for (i2 = 0; i2 < iblabels.length; ++i2) {
            if (iblabels[i2] == 0) continue;
            int label = iblabels[i2];
            if (distmap[i2] < distances[label]) {
                distances[label] = distmap[i2];
            }
            if (bbcontour[i2] == 0) continue;
            touching[label] = true;
        }
        for (i2 = 0; i2 < touching.length; ++i2) {
            if (touching[i2]) continue;
            distances[i2] = -1.0f;
        }
        rgb = null;
        map = null;
        dilated = null;
        contour = null;
        closed = null;
        System.gc();
        return distances;
    }

    public BufferedImage[] SeparateNucleiCells(UnionFindCcl ccl, BufferedImage staining, boolean autocrop) {
        BufferedImage[] images = new BufferedImage[ccl.ConnectedComponentsNumber() + 1];
        int width = staining.getWidth();
        int height = staining.getHeight();
        int margin = autocrop ? 1 : 0;
        int[] labels = ccl.Labels1D();
        int[] minx = ccl.minx();
        int[] maxx = ccl.maxx();
        int[] miny = ccl.miny();
        int[] maxy = ccl.maxy();
        int[] sizes = ccl.Sizes();
        for (int i2 = 1; i2 < images.length; ++i2) {
            if (0 >= sizes[i2]) continue;
            int sx = minx[i2] - margin < 0 ? 0 : minx[i2] - margin;
            int sy = miny[i2] - margin < 0 ? 0 : miny[i2] - margin;
            int ex = width <= maxx[i2] + margin ? width - 1 : maxx[i2] + margin;
            int ey = height <= maxy[i2] + margin ? height - 1 : maxy[i2] + margin;
            BufferedImage patch = images[i2] = ImageNew.SubImage((BufferedImage)staining, (int)sx, (int)sy, (int)ex, (int)ey);
            short[] sbpatch = ((DataBufferUShort)patch.getRaster().getDataBuffer()).getData();
            int p = 0;
            for (int y = sy; y <= ey; ++y) {
                int x = sx;
                int pos = x + y * width;
                while (x <= ex) {
                    if (labels[pos] != i2) {
                        sbpatch[p] = 0;
                    }
                    ++x;
                    ++pos;
                    ++p;
                }
            }
            if (!autocrop) {
                patch = ImageOperations.Padding((BufferedImage)patch, (int)(patch.getWidth() + 2 * margin), (int)(patch.getHeight() + 2 * margin), (int)0);
            }
            sbpatch = null;
            patch = null;
        }
        return images;
    }

    public BufferedImage[] SeparateCellsMinusNuclei(UnionFindCcl nucccl, UnionFindCcl cellccl, BufferedImage staining, boolean autocrop) {
        BufferedImage[] images = new BufferedImage[nucccl.ConnectedComponentsNumber() + 1];
        int width = staining.getWidth();
        int height = staining.getHeight();
        int margin = autocrop ? 1 : 0;
        int[] minx = cellccl.minx();
        int[] maxx = cellccl.maxx();
        int[] miny = cellccl.miny();
        int[] maxy = cellccl.maxy();
        int[] celllabels = (int[])cellccl.Labels1D().clone();
        ArrayArithmetic.Subtract((int[])celllabels, (int[])nucccl.Labels1D(), (int[])celllabels, (int)0, (int)0);
        int[] sizes = cellccl.Sizes();
        for (int i2 = 1; i2 < images.length; ++i2) {
            if (0 >= sizes[i2]) continue;
            int sx = minx[i2] - margin < 0 ? 0 : minx[i2] - margin;
            int sy = miny[i2] - margin < 0 ? 0 : miny[i2] - margin;
            int ex = width <= maxx[i2] + margin ? width - 1 : maxx[i2] + margin;
            int ey = height <= maxy[i2] + margin ? height - 1 : maxy[i2] + margin;
            BufferedImage patch = images[i2] = ImageNew.SubImage((BufferedImage)staining, (int)sx, (int)sy, (int)ex, (int)ey);
            short[] sbpatch = ((DataBufferUShort)patch.getRaster().getDataBuffer()).getData();
            int p = 0;
            for (int y = sy; y <= ey; ++y) {
                int x = sx;
                int pos = x + y * width;
                while (x <= ex) {
                    if (celllabels[pos] != i2) {
                        sbpatch[p] = 0;
                    }
                    ++x;
                    ++pos;
                    ++p;
                }
            }
            if (!autocrop) {
                patch = ImageOperations.Padding((BufferedImage)patch, (int)(patch.getWidth() + 2), (int)(patch.getHeight() + 2), (int)0);
            }
            sbpatch = null;
            patch = null;
        }
        return images;
    }

    public BufferedImage[] SeparateCellsRim(float[] dm, UnionFindCcl cellccl, BufferedImage staining, float FE_Rim_Size, boolean autocrop) {
        BufferedImage[] images = new BufferedImage[cellccl.ConnectedComponentsNumber() + 1];
        int width = staining.getWidth();
        int height = staining.getHeight();
        int margin = autocrop ? 1 : 0;
        int[] minx = cellccl.minx();
        int[] maxx = cellccl.maxx();
        int[] miny = cellccl.miny();
        int[] maxy = cellccl.maxy();
        int[] celllabels = (int[])cellccl.Labels1D().clone();
        for (int i2 = 0; i2 < celllabels.length; ++i2) {
            if (!(dm[i2] > FE_Rim_Size)) continue;
            celllabels[i2] = 0;
        }
        int[] sizes = cellccl.Sizes();
        for (int i3 = 1; i3 < images.length; ++i3) {
            if (0 >= sizes[i3]) continue;
            int sx = minx[i3] - margin < 0 ? 0 : minx[i3] - margin;
            int sy = miny[i3] - margin < 0 ? 0 : miny[i3] - margin;
            int ex = width <= maxx[i3] + margin ? width - 1 : maxx[i3] + margin;
            int ey = height <= maxy[i3] + margin ? height - 1 : maxy[i3] + margin;
            BufferedImage patch = images[i3] = ImageNew.SubImage((BufferedImage)staining, (int)sx, (int)sy, (int)ex, (int)ey);
            short[] sbpatch = ((DataBufferUShort)patch.getRaster().getDataBuffer()).getData();
            int p = 0;
            for (int y = sy; y <= ey; ++y) {
                int x = sx;
                int pos = x + y * width;
                while (x <= ex) {
                    if (celllabels[pos] != i3) {
                        sbpatch[p] = 0;
                    }
                    ++x;
                    ++pos;
                    ++p;
                }
            }
            if (!autocrop) {
                patch = ImageOperations.Padding((BufferedImage)patch, (int)(patch.getWidth() + 2), (int)(patch.getHeight() + 2), (int)0);
            }
            sbpatch = null;
            patch = null;
        }
        return images;
    }

    public List<String> FindScenes(String dir, String str) throws Exception {
        int length = 5 + str.length();
        LinkedList<String> scenes = new LinkedList<String>();
        File[] images = new File(dir).listFiles(FileNameFilters.ImagesPNGorTIF);
        if (images == null || images.length == 0) {
            throw new Exception("No appropriate images found in '" + dir + "'");
        }
        for (File image : images) {
            int pos = image.getName().indexOf("Scene" + str);
            if (pos < 0) continue;
            int end = pos + length;
            while (image.getName().charAt(end) != '_') {
                ++end;
            }
            String scene = image.getName().substring(pos + length, end);
            if (ListTools.isInList(scenes, (String)scene)) continue;
            scenes.add(scene);
        }
        Collections.sort(scenes);
        return scenes;
    }

    public CycIF_RoundCycle FindMarker(String marker, List<CycIF_RoundCycle> rclist) {
        for (CycIF_RoundCycle rc : rclist) {
            if (rc.marker.equalsIgnoreCase(marker)) {
                return rc;
            }
            rc = null;
        }
        return null;
    }

    public CycIF_RoundCycle FindRound(String round, List<CycIF_RoundCycle> rclist) {
        for (CycIF_RoundCycle rc : rclist) {
            if (rc.round.equalsIgnoreCase(round)) {
                return rc;
            }
            rc = null;
        }
        return null;
    }

    public String FindRound(String str) {
        String[] parts = str.split("_");
        return parts[0].substring(1);
    }

    public File[] FindDapis(String srcdir, String scene) throws Exception {
        File[] dapis = new File(srcdir).listFiles((dir, name) -> name.charAt(0) != '.' && !name.contains("DS_Store") && name.contains("Scene-" + scene) && name.contains("_c1_"));
        if (dapis == null) {
            throw new Exception("No image found.");
        }
        return dapis;
    }

    public int CheckRound(String str, String STR, List<CycIF_RoundCycle> rclist, LogFile log) throws IOException {
        int iround;
        if (str.matches("\\d+")) {
            iround = Integer.parseInt(str);
        } else if (str.charAt(0) == 'r' && str.substring(1).matches("\\d+")) {
            iround = Integer.parseInt(str.substring(1));
        } else {
            String txt = "Wrong round format for nuclei segmentation '" + STR + "'. Expected integer, for example 'R1' or 'R2,R5,R7'.";
            NumberFormatException ex = new NumberFormatException(txt);
            log.addNewException(ex, STR);
            throw ex;
        }
        if (iround < 0) {
            String txt = "Wrong round number/format for nuclei segmentation '" + STR + "'. Negative value.";
            NumberFormatException ex = new NumberFormatException(txt);
            log.addNewException(ex, txt);
            throw ex;
        }
        if (this.FindRound("R" + iround, rclist) == null) {
            String txt = "Given round for nuclei segmentation not found.'" + STR + "'.";
            NumberFormatException ex = new NumberFormatException(txt);
            log.addNewException(ex, txt);
            throw ex;
        }
        return iround;
    }

    public void CheckRoundCycleList(List<CycIF_RoundCycle> rclist, boolean HardCheck, LogFile log, String ... markers) throws Exception {
        int nbwarning = 0;
        for (String marker : markers) {
            if (this.FindMarker(marker, rclist) != null) continue;
            if (HardCheck) {
                throw new Exception(marker + " not found!");
            }
            System.out.println("WARNING - Marker " + marker + " not found!");
            log.addComment("WARNING - Marker " + marker + " not found!");
            ++nbwarning;
        }
        if (0 < nbwarning) {
            System.out.println(markers.length - nbwarning + "/" + markers.length + " markers were found.");
        } else {
            System.out.println("All the markers were found.");
        }
    }

    public void CounterCheckScenes(String dir, List<String> scenes) throws Exception {
        ListIterator<String> iter = scenes.listIterator();
        while (iter.hasNext()) {
            String scene = iter.next();
            File[] images = new File(dir).listFiles((f, name) -> name.charAt(0) != '.' && !name.contains("DS_Store") && name.contains("Scene " + scene));
            if (images.length > 5) continue;
            scenes.remove(scene);
        }
        iter = null;
    }

    public void LoadRoundsCyclesTableV1(String dir, List<CycIF_RoundCycle> rclist) throws Exception {
        if (!rclist.isEmpty()) {
            rclist.clear();
        }
        Scanner scan = new Scanner(new FileInputStream(dir + "/RoundsCyclesTable.txt"));
        int nb = 1;
        while (scan.hasNextLine()) {
            String line = scan.nextLine();
            String[] split = line.split(" ");
            if (split.length != 6) {
                System.out.flush();
                System.err.flush();
                System.err.println("Line: '" + line + "'");
                System.err.flush();
                throw new Exception(split.length + " elements instead of 8 in line " + nb);
            }
            if (split[1].charAt(0) != 'R' && split[1].charAt(0) != 'r') {
                throw new Exception("Line " + nb + " round does not start with R or r");
            }
            if (split[2].charAt(0) != 'C' && split[2].charAt(0) != 'c') {
                throw new Exception("Line " + nb + " cycle does not start with C or c");
            }
            rclist.add(new CycIF_RoundCycle(split[0], split[1], split[2], Integer.valueOf(split[3]), Integer.valueOf(split[4]), split[5]));
            ++nb;
            line = null;
            split = null;
        }
        System.out.println(rclist.size() + " lines found. Coordinates:");
        for (CycIF_RoundCycle rc : rclist) {
            System.out.println(rc.marker + "\t\t" + rc.round + "\t" + rc.cycle + "\t" + rc.minthreshold + " " + rc.maxthreshold + " " + rc.type);
            rc = null;
        }
        Iterator<CycIF_RoundCycle> iter = null;
    }

    public void LoadRoundsCyclesTable(String dir, List<CycIF_RoundCycle> rclist, LogFile log) throws Exception {
        if (!rclist.isEmpty()) {
            rclist.clear();
        }
        Scanner scan = new Scanner(new FileInputStream(dir + "/RoundsCyclesTable.txt"));
        int nb = 1;
        block15: while (scan.hasNextLine()) {
            String line = scan.nextLine();
            if (line.isEmpty()) {
                ++nb;
                continue;
            }
            if (line.charAt(0) == '#' || line.startsWith("//")) continue;
            String[] split = line.split(" ");
            switch (split.length) {
                case 0: {
                    ++nb;
                    continue block15;
                }
                case 1: {
                    if (split[0].isEmpty() || split[0].equalsIgnoreCase("\n") || split[0].equalsIgnoreCase(" ")) {
                        ++nb;
                        continue block15;
                    }
                    String message = "Line " + nb + " a single unknown element: '" + split[0] + "'.";
                    Exception ex = new Exception(message);
                    if (log != null) {
                        log.addNewException(ex, message);
                    }
                    throw ex;
                }
                case 5: {
                    break;
                }
                default: {
                    System.out.flush();
                    System.err.flush();
                    System.err.println("RoundsCyclesTable.txt, line: '" + line + "'");
                    System.err.flush();
                    if (log != null) {
                        log.addComment("RoundsCyclesTable.txt, " + split.length + " elements instead of 5 in line " + nb);
                    }
                    throw new Exception("RoundsCyclesTable.txt, " + split.length + " elements instead of 5 in line " + nb);
                }
            }
            if (split[1].charAt(0) != 'R' && split[1].charAt(0) != 'r') {
                Exception ex = new Exception("Line " + nb + " round does not start with 'R' or 'r'.");
                if (log != null) {
                    log.addNewException(ex, "Line " + nb + " round does not start with 'R' or 'r'.");
                }
                throw ex;
            }
            if (split[2].charAt(0) != 'C' && split[2].charAt(0) != 'c') {
                Exception ex = new Exception("Line " + nb + " cycle does not start with 'C' or 'c'.");
                if (log != null) {
                    log.addNewException(ex, "Line " + nb + " cycle does not start with 'C' or 'c'.");
                }
                throw ex;
            }
            try {
                rclist.add(new CycIF_RoundCycle(split[0], split[1], split[2], split[3], split[4]));
            }
            catch (Exception ex) {
                if (log != null) {
                    log.addNewException(ex, "RoundsCyclesTable.txt, line " + nb + " '" + line + "' has a wrong format.");
                }
                System.err.println("RoundsCyclesTable.txt, line " + nb + " '" + line + "' has a wrong format.");
                ex.printStackTrace();
                throw ex;
            }
            ++nb;
            line = null;
            split = null;
        }
        CycIF_Restore.CheckDependencies(rclist, log);
        int tab = 4;
        System.out.println(rclist.size() + " lines found:");
        for (CycIF_RoundCycle rc : rclist) {
            String gap = "";
            gap = rc.marker.length() < 4 ? "\t\t" : "\t";
            System.out.print(rc.marker + gap + rc.round + "\t" + rc.cycle + "\t");
            switch (rc.mode) {
                case "Manual": {
                    System.out.print("Manual=[" + rc.minthreshold + "," + rc.maxthreshold + "]");
                    break;
                }
                case "Restore": {
                    System.out.print("Restore=[" + rc.restoretype + ",");
                    Iterator<String> it = rc.exclusive.iterator();
                    while (it.hasNext()) {
                        System.out.print(it.next() + ",");
                    }
                    System.out.print(rc.maxthreshold + "]");
                    break;
                }
                default: {
                    throw new Exception("Unknown mode '" + rc.mode + "'.");
                }
            }
            System.out.println(" " + rc.type);
            rc = null;
        }
        Iterator<CycIF_RoundCycle> iter = null;
    }

    public void GenerateRoundsCyclesTable(String inputdir, LogFile log) throws Exception {
        List<String> scenes;
        File outdir = new File(this.AddExtension(inputdir, " - Features/"));
        File rct = new File(outdir.getAbsolutePath() + "/RoundsCyclesTable.txt");
        if (rct.exists()) {
            System.out.println("\nFile 'RoundsCyclesTable.txt' already exists in '" + outdir.getAbsolutePath() + "', generation canceled.");
            log.addComment("File 'RoundsCyclesTable.txt' already exists in '" + outdir.getAbsolutePath() + "', generation canceled.");
            return;
        }
        System.out.println("Generating 'RoundsCyclesTable.txt' file in '" + outdir.getAbsolutePath() + "'.");
        log.addComment("Generating 'RoundsCyclesTable.txt' file in '" + outdir.getAbsolutePath() + "'.");
        if (!outdir.exists()) {
            outdir.mkdirs();
        }
        if ((scenes = this.FindScenes(inputdir, "-")) == null || scenes.isEmpty()) {
            System.out.println("\nWarning - No keyword 'Scene-' found in images naming. All image names are updated with 'Scene-XXX_'.\n");
            log.addComment("Warning - No keyword 'Scene-' found in images naming. All image names are updated with 'Scene-XXX_'.");
            this.UpdateNames(inputdir);
            scenes = this.FindScenes(inputdir, "-");
        }
        String Table = null;
        for (String scene : scenes) {
            String[] Tsplit;
            String table = this.CreateRCTable(inputdir, scene, log);
            if (Table == null) {
                Table = table;
                continue;
            }
            if (Table.equalsIgnoreCase(table)) continue;
            String[] tsplit = table.split("\\n");
            if (tsplit.length != (Tsplit = Table.split("\\n")).length) {
                System.out.println("Scene " + scene + " has different number of markers.");
                Exception ex = new Exception("Scene " + scene + " has different number of markers.");
                log.addNewException(ex, "Different markers among scenes.");
                log.addComment(Table);
                log.addComment(table);
                throw ex;
            }
            for (int s = 0; s < tsplit.length; ++s) {
                String dif = StringUtils.difference((String)tsplit[s], (String)Tsplit[s]);
                if (dif == null || dif.equals("")) continue;
                String txt = "'" + tsplit[s] + "' vs '" + Tsplit[s] + "' => '" + dif + "'.";
                System.out.println("Scene " + scene + " has different markers:" + txt);
                Exception ex = new Exception("Scene " + scene + " has different markers:" + txt);
                log.addNewException(ex, "Different markers among scenes.");
                log.addComment(txt);
                throw ex;
            }
        }
        try (DataOutputStream dos = new DataOutputStream(new FileOutputStream(rct));){
            dos.write(Table.getBytes("ISO-8859-1"));
        }
        catch (Exception ex) {
            String txt = "Cannot write 'RoundsCyclesTable.txt' in '" + outdir.getAbsolutePath() + "'.";
            System.out.println(txt);
            log.addNewException(ex, "Cannot write 'RoundsCyclesTable.txt' in '" + outdir.getAbsolutePath() + "'.");
            throw ex;
        }
        System.out.println("\n" + Table + "\n");
        System.out.println("'RoundsCyclesTable.txt' generation done successfully in '" + outdir.getAbsolutePath() + "'.");
        log.addComment("'RoundsCyclesTable.txt' generation done successfully in '" + outdir.getAbsolutePath() + "'.");
    }

    private String CreateRCTable(String inputdir, String scene, LogFile log) throws Exception {
        StringBuilder sb = new StringBuilder(1000);
        Object[] files = new File(inputdir).listFiles(this.CreateFNF(scene));
        Arrays.sort(files);
        for (Object row : files) {
            String name = ((File)row).getName();
            int pos = name.indexOf(95);
            String Round = name.substring(0, pos);
            int pos2 = name.indexOf(95, pos + 1);
            String markerstring = name.substring(pos + 1, pos2);
            if (markerstring.startsWith("Scene-")) {
                int newpos1 = pos2;
                pos2 = name.indexOf(95, newpos1 + 1);
                markerstring = name.substring(newpos1 + 1, pos2);
            }
            String[] markers = markerstring.split("\\.");
            int pos3 = name.indexOf("_c", pos2 + 1);
            String Cycle = name.substring(pos3 + 1, pos3 + 3);
            int c = Integer.parseInt(Cycle.substring(1));
            try {
                if (Cycle.charAt(1) != '1') {
                    sb.append(markers[c - 2]).append(" ").append(Round).append(" ").append(Cycle).append(" [0,65535] All\n");
                    continue;
                }
                sb.append("Dapi" + Round).append(" ").append(Round).append(" ").append(Cycle).append(" [0,65535] Nuclei\n");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                String txt = "Failed adding marker for row '" + (File)row + "' => Round=" + Round + ", Cycle=" + c;
                log.addNewException(ex, txt);
                System.err.println(txt);
                System.out.println(txt);
                throw ex;
            }
        }
        return sb.toString();
    }

    private String TranformMarkerName_RealToLocal(String Marker2) {
        String marker;
        switch (Marker2.toLowerCase()) {
            case "ar": {
                marker = "AR";
                break;
            }
            case "asma": {
                marker = "aSMA";
                break;
            }
            case "cd3": {
                marker = "CD3";
                break;
            }
            case "cd4": {
                marker = "CD4";
                break;
            }
            case "cd8": {
                marker = "CD8";
                break;
            }
            case "cd20": {
                marker = "CD20";
                break;
            }
            case "cd31": {
                marker = "CD31";
                break;
            }
            case "cd44": {
                marker = "CD44";
                break;
            }
            case "cd45": {
                marker = "CD45";
                break;
            }
            case "cd68": {
                marker = "CD68";
                break;
            }
            case "ck5": {
                marker = "CK5";
                break;
            }
            case "ck7": {
                marker = "CK7";
                break;
            }
            case "ck8": {
                marker = "CK8";
                break;
            }
            case "ck14": {
                marker = "CK14";
                break;
            }
            case "ck17": {
                marker = "CK17";
                break;
            }
            case "ck19": {
                marker = "CK19";
                break;
            }
            case "coli": 
            case "col1": 
            case "collagen1": 
            case "collageni": {
                marker = "ColI";
                break;
            }
            case "coliv": 
            case "col4": 
            case "collageniv": 
            case "collagen4": {
                marker = "ColIV";
                break;
            }
            case "cparp": {
                marker = "cPARP";
                break;
            }
            case "ecad": 
            case "e-cad": 
            case "ecadherin": 
            case "e-cadherin": {
                marker = "Ecad";
                break;
            }
            case "er": {
                marker = "ER";
                break;
            }
            case "foxp3": {
                marker = "FOXP3";
                break;
            }
            case "gh2ax": {
                marker = "gH2AX";
                break;
            }
            case "grnzb": 
            case "grnz-b": 
            case "granzymeb": 
            case "granzyme-b": {
                marker = "GRNZB";
                break;
            }
            case "h3k27me3": {
                marker = "H3K27me3";
                break;
            }
            case "h3k4me3": {
                marker = "H3K4me3";
                break;
            }
            case "her2": {
                marker = "HER2";
                break;
            }
            case "ki67": {
                marker = "Ki67";
                break;
            }
            case "lamac": 
            case "lam-ac": 
            case "laminac": 
            case "lamin-ac": {
                marker = "LaminAC";
                break;
            }
            case "lamb1": 
            case "lam-b1": 
            case "laminb1": 
            case "lamin-b1": {
                marker = "LaminB1";
                break;
            }
            case "lamb2": 
            case "lam-b2": 
            case "laminb2": 
            case "lamin-b2": {
                marker = "LaminB2";
                break;
            }
            case "pcna": {
                marker = "PCNA";
                break;
            }
            case "pdpn": {
                marker = "PDPN";
                break;
            }
            case "pd1": {
                marker = "PD1";
                break;
            }
            case "pgr": {
                marker = "PgR";
                break;
            }
            case "phh3": {
                marker = "pHH3";
                break;
            }
            case "ps6": {
                marker = "pS6";
                break;
            }
            case "vim": 
            case "vimentin": {
                marker = "Vim";
                break;
            }
            default: {
                marker = Marker2;
            }
        }
        return marker;
    }

    private String TranformMarkerName_LocalToReal(String marker, HashBiMap<String, String> map) {
        if (!map.containsValue((Object)marker)) {
            throw new Error("Must not occur.");
        }
        return (String)map.inverse().get((Object)marker);
    }

    private List<String> FindEMP(String marker) {
        for (String[] em : this.emp) {
            String[] split = em[0].split("-");
            if (split == null || split.length != 2) {
                throw new Error("Must not occur: 'split == null || split.length != 2'.");
            }
            if (!marker.equalsIgnoreCase(split[0])) continue;
            ArrayList<String> list = new ArrayList<String>(em.length);
            for (int j = 1; j < em.length; ++j) {
                list.add(em[j]);
            }
            return list;
        }
        return null;
    }

    public void UpdateRCTable(String featuresdir, List<CycIF_RoundCycle> rclist) {
        System.out.println("\n\nUpdating RoundsCyclesTable.txt file for Restore");
        HashBiMap map = HashBiMap.create();
        for (CycIF_RoundCycle rc : rclist) {
            map.put((Object)rc.marker, (Object)this.TranformMarkerName_RealToLocal(rc.marker));
        }
        StringBuilder sb = new StringBuilder(1000);
        for (CycIF_RoundCycle rc : rclist) {
            String marker = this.TranformMarkerName_RealToLocal(rc.marker);
            System.out.println(rc.marker + "/" + marker + ":");
            sb.append(rc.marker).append(" ").append(rc.round).append(" ").append(rc.cycle).append(" [");
            List<String> ems = this.FindEMP(marker);
            if (ems == null) {
                System.out.println(" - No known exclusive marker.");
                sb.append("0,65535] All\n");
                continue;
            }
            boolean atleastone = false;
            for (String em : ems) {
                String[] split = em.split("-");
                if (this.FindMarker(this.TranformMarkerName_RealToLocal(split[0]), rclist) == null) {
                    System.out.println(" - " + split[0] + " is a known exclusive marker for " + rc.marker + ", but it was NOT found.");
                    continue;
                }
                if (atleastone) {
                    sb.append(",");
                } else {
                    sb.append(split[1]).append(",");
                }
                String realmarker = (String)map.inverse().get((Object)split[0]);
                System.out.println(" + " + realmarker + " is a known exclusive marker for " + rc.marker + ", and it was found.");
                sb.append(realmarker).append("/").append(split[1]);
                atleastone = true;
            }
            if (!atleastone) {
                sb.append("0");
            }
            sb.append(",65535] All\n");
        }
        File rct = new File(featuresdir + "/RoundsCyclesTable.txt");
        String Table = sb.toString();
        try (DataOutputStream dos = new DataOutputStream(new FileOutputStream(rct));){
            dos.write(Table.getBytes("ISO-8859-1"));
        }
        catch (Exception ex) {
            System.err.println("Cannot update 'RoundsCyclesTable.txt' in '" + rct.getAbsolutePath() + "'.");
            ex.printStackTrace();
        }
        System.out.println("\nNew updated table:");
        System.out.println(Table);
        System.out.println("'RoundsCyclesTable.txt' updated successfully.\n");
    }

    public FilenameFilter CreateFNF(String scene) {
        return (dir, name) -> name.charAt(0) != '.' && !name.contains("DS_Store") && name.contains("Scene-" + scene);
    }

    public FilenameFilter CreateFNF(String scene, int cycle) {
        String s1 = "Scene-" + scene;
        String s2 = "_c" + cycle + "_";
        return (dir, name) -> name.charAt(0) != '.' && !name.contains("DS_Store") && name.contains(s1) && name.contains(s2);
    }

    public FilenameFilter CreateFNF(String scene, int round, int cycle) {
        String s1 = "Scene-" + scene;
        String s2 = "_c" + cycle + "_";
        return (dir, name) -> name.charAt(0) != '.' && !name.contains("DS_Store") && name.startsWith("R" + round + "_") && name.contains(s1) && name.contains(s2);
    }

    public FilenameFilter CreateFNF(String scene, String round, String cycle) {
        String s1 = "Scene-" + scene;
        String s2 = "_" + cycle + "_";
        return (dir, name) -> name.charAt(0) != '.' && !name.contains("DS_Store") && name.startsWith(round + "_") && name.contains(s1) && name.contains(s2);
    }

    public BufferedImage LoadImage(String srcdir, String scene, int round, int cycle) throws Exception {
        File[] images = new File(srcdir).listFiles(this.CreateFNF(scene, round, cycle));
        if (images == null) {
            throw new Exception("No image found.");
        }
        if (images.length != 1) {
            throw new Exception(images.length + " image(s) found instead of 1.");
        }
        return ImageIO.Read(images[0]);
    }

    public BufferedImage LoadImage(String srcdir, String scene, String round, String cycle) throws Exception {
        File[] images = new File(srcdir).listFiles(this.CreateFNF(scene, round, cycle));
        if (images == null) {
            throw new Exception("No image found.");
        }
        if (images.length != 1) {
            StringBuilder sb = new StringBuilder(1000);
            for (File image : images) {
                sb.append(", '").append(image.getAbsolutePath()).append("'");
            }
            throw new Exception(images.length + " images found instead of 1  in '" + srcdir + "', scene '" + scene + "', round '" + round + "', cycle '" + cycle + "'" + sb.toString());
        }
        return ImageIO.Read(images[0]);
    }

    public void DownloadModel(String modelname, LogFile log) throws IOException {
        if (!modelname.startsWith("MaskRCNN_")) {
            return;
        }
        String urlpath = "https://www.thibault.biz/DeepLearning/CyclicIF/Models/";
        String localpath = "./DeepLearningModels/";
        String webname = modelname.replace(" ", "%20");
        File model = new File("./DeepLearningModels/" + modelname);
        if (model.exists()) {
            String txt = "Model '" + modelname + "' already present in './DeepLearningModels/', no need to download it.";
            System.out.println(txt);
            log.addComment(txt);
            return;
        }
        try {
            String txt = "Downloading model '" + modelname + "'... ";
            System.out.print(txt);
            log.addComment(txt);
            URL webfile = new URL("https://www.thibault.biz/DeepLearning/CyclicIF/Models/" + webname);
            FileUtils.copyURLToFile((URL)webfile, (File)model);
            System.out.println("done successfully.");
            log.addComment("done successfully.");
        }
        catch (Exception ex) {
            String txt = "Cannot download model '" + modelname + "'.";
            System.out.println(txt);
            System.err.println(txt);
            log.addNewException(ex, txt);
            throw ex;
        }
        catch (Error err) {
            String txt = "Cannot download model '" + modelname + "'.";
            System.out.println(txt);
            System.err.println(txt);
            log.addNewError(err, txt);
            throw err;
        }
    }

    public void ColorDapi(String path, boolean OldMode) throws IOException {
        File[] images;
        String extension = OldMode ? "Nuclei Segmentation Basins.tif" : "Nuclei Labels.tif";
        for (File file : images = new File(path).listFiles((dir, name) -> name.charAt(0) != '.' && !name.contains("DS_Store") && name.contains(extension))) {
            BufferedImage labels = ImageIO.Read(file);
            BufferedImage zproj = ImageIO.Read(file.getAbsolutePath().replace(extension, "ZProjectionDAPI CE.png"));
            BufferedImage gray = ImageConverter.UShortGrayToGray((BufferedImage)zproj, (boolean)true);
            BufferedImage rgb = ImageConverter.GrayToColor((BufferedImage)gray);
            ImageDrawer.Cells(rgb, ((DataBufferInt)labels.getRaster().getDataBuffer()).getData(), Colors.RED, Colors.YELLOW);
            ImageIO.Write(rgb, file.getAbsolutePath().replace(extension, "Nuclei Segmentation Full Color.png"), 6);
        }
    }

    public void PrepareImages(BufferedImage staining, BufferedImage stainingce, BufferedImage stainingbyte, BufferedImage stainingrgb, int nbCPU) {
        this.dynexp.FilterWithConditions(staining, 1.0, 0.5, 0, 0, 65535, stainingce, nbCPU);
        ImageConverter.UShortGrayToGray((BufferedImage)stainingce, (boolean)true, (BufferedImage)stainingbyte);
        if (stainingrgb != null) {
            ImageConverter.GrayToColor((BufferedImage)stainingbyte, (BufferedImage)stainingrgb);
        }
    }

    public void OutlineNuclei(String scene, String Segment_Nuclei, String outputdir, String keyword, LogFile log) throws IOException {
        BufferedImage dapi = ImageIO.Read(outputdir + "/Scene " + scene + " - " + keyword + ".png");
        int Width = dapi.getWidth();
        BufferedImage rgb = null;
        try {
            rgb = ImageConverter.GrayToColor((BufferedImage)dapi);
        }
        catch (NegativeArraySizeException ex) {
            log.addComment("Nuclei outline: images too big to be converted into RGB format.");
            System.out.print("WARNING - Nuclei outline: images too big to be converted into RGB format.");
            return;
        }
        ImageIO.verbose = false;
        if (Segment_Nuclei.toLowerCase().startsWith("maskrcnn")) {
            Object[] nuclei = new File(outputdir + "/Scene " + scene + " - Nuclei/").listFiles(FileFilters.ImagesPNG);
            if (nuclei != null && 0 < nuclei.length) {
                Arrays.sort(nuclei);
                for (Object nuc : nuclei) {
                    try {
                        String name = ((File)nuc).getName().substring(0, ((File)nuc).getName().length() - 4);
                        String coordinates = name.substring(name.indexOf(95) + 1, name.length());
                        int xpos = coordinates.indexOf(120);
                        int X = Integer.valueOf(coordinates.substring(0, xpos));
                        int Y = Integer.valueOf(coordinates.substring(xpos + 1, coordinates.length()));
                        BufferedImage nucleus = ImageIO.Read((File)nuc);
                        int width = nucleus.getWidth();
                        int height = nucleus.getHeight();
                        List contour = ImageOperations.Contour((BufferedImage)nucleus, (boolean)true, (int)0, (int)0, (int)(width - 1), (int)(height - 1));
                        for (Coordinates c : contour) {
                            c.X += X;
                            c.Y += Y;
                            c.Pos = c.X + c.Y * Width;
                        }
                        Iterator iter = null;
                        ImageDrawer.Coordinates(rgb, contour, 0, (float[])this.ColorsList[this.random.nextInt(this.ColorsList.length)]);
                        contour.clear();
                        contour = null;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        log.addNewException(ex, "Cannot outline nucleus: '" + ((File)nuc).getAbsolutePath() + "'.");
                    }
                    catch (Error e) {
                        e.printStackTrace();
                        log.addNewError(e, "Cannot outline nucleus: '" + ((File)nuc).getAbsolutePath() + "'.");
                    }
                }
            } else {
                BufferedImage labels = ImageIO.LoadLabels(outputdir + "/Scene " + scene + " - Nuclei Labels");
                ImageDrawer.Contour(rgb, labels, Colors.YELLOW);
                labels = null;
            }
        } else if (Segment_Nuclei.toLowerCase().startsWith("cellpose") || Segment_Nuclei.toLowerCase().startsWith("mesmer")) {
            BufferedImage labels = ImageIO.LoadLabels(outputdir + "/Scene " + scene + " - Nuclei Labels");
            ImageDrawer.Contour(rgb, labels, Colors.YELLOW);
            labels = null;
        } else {
            throw new IllegalArgumentException("Unsupported model name: '" + Segment_Nuclei + "'.");
        }
        ImageIO.verbose = true;
        ImageIO.Write(rgb, outputdir + "/Scene " + scene + " - Visual Check/Scene " + scene + " - Nuclei Outlined.png", 6);
    }

    public void UpdateNames(String dir) throws Exception {
        File[] images = new File(dir).listFiles(FileNameFilters.ImagesPNGorTIF);
        if (images == null || images.length == 0) {
            throw new Exception("No images found in '" + dir + "'");
        }
        for (File image : images) {
            int index = image.getName().indexOf("_");
            String round = image.getName().substring(0, index);
            String name = image.getName().replaceFirst(round + "_", round + "_Scene-XXX_");
            if (image.renameTo(new File(image.getParentFile().getAbsolutePath() + "/" + name))) continue;
            throw new Exception("Cannot rename image '" + image.getAbsolutePath() + "'");
        }
    }

    public String AddExtension(String path, String extension) {
        int pos = path.length() - 1;
        while (path.charAt(pos) == '/') {
            --pos;
        }
        return path.substring(0, pos + 1) + extension;
    }

    public FichierTabule CreateFeaturesFile(FichierTabule example, int nbColumns, int Type2) {
        int i2;
        int[] types = new int[nbColumns];
        Arrays.fill(types, Type2);
        Arrays.fill(types, 0, 5, 0);
        types[6] = 1;
        types[5] = 1;
        types[7] = 2;
        FichierTabule file = new FichierTabule(example.Height(), types, "???");
        for (i2 = 0; i2 < 5; ++i2) {
            file.setColumn(i2, example.getColumnInt(i2));
        }
        file.setColumn(5, example.getColumnDouble(5));
        file.setColumn(6, example.getColumnDouble(6));
        for (i2 = 0; i2 < 7; ++i2) {
            file.setColumnName(i2, example.getColumnName(i2));
        }
        file.setColumnName(7, "To Exclude");
        file.setColumn(7, example.getColumnString(7));
        return file;
    }

    public void DeleteCSVs(String directory) {
        File[] files;
        for (File f : files = new File(directory).listFiles((dir, name) -> name.charAt(0) != '.' && !name.contains("DS_Store") && name.endsWith(".csv"))) {
            FilesFolders.Delete(f);
        }
    }

    public void DeleteCSVs(String Directory, String ToExclude) {
        File[] files;
        for (File f : files = new File(Directory).listFiles((dir, name) -> name.charAt(0) != '.' && !name.contains("DS_Store") && name.endsWith(".csv") && !name.contains(ToExclude))) {
            FilesFolders.Delete(f);
        }
    }
}

