/*
 * Decompiled with CFR 0.152.
 */
package softwares.ohsu.cyclicif;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class CycIF_RoundCycle {
    public final String marker;
    public final String round;
    public final String cycle;
    public int minthreshold;
    public final int maxthreshold;
    public final String restoretype;
    public final String type;
    public final String mode;
    public final List<String> exclusive;

    public CycIF_RoundCycle(String marker, String round, String cycle, int minthreshold, int maxthreshold, String type) {
        this.marker = marker;
        this.round = round;
        this.cycle = cycle;
        this.minthreshold = minthreshold;
        this.maxthreshold = maxthreshold;
        this.mode = "Manual";
        this.exclusive = null;
        this.restoretype = null;
        switch (type.toLowerCase()) {
            case "all": 
            case "everything": {
                this.type = "All";
                break;
            }
            case "cell": 
            case "cells": {
                this.type = "Cell";
                break;
            }
            case "nucleus": 
            case "nuclei": {
                this.type = "Nucleus";
                break;
            }
            case "rim": 
            case "rims": {
                this.type = "Rim";
                break;
            }
            case "ring": 
            case "rings": {
                this.type = "Ring";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type: '" + type + "'.");
            }
        }
    }

    public CycIF_RoundCycle(String marker, String round, String cycle, String thresholds, String type) {
        this.marker = marker;
        this.round = round;
        this.cycle = cycle;
        switch (type.toLowerCase()) {
            case "all": 
            case "everything": {
                this.type = "All";
                break;
            }
            case "cell": 
            case "cells": {
                this.type = "Cells";
                break;
            }
            case "nucleus": 
            case "nuclei": {
                this.type = "Nuclei";
                break;
            }
            case "rim": 
            case "rims": {
                this.type = "Rims";
                break;
            }
            case "ring": 
            case "rings": {
                this.type = "Rings";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type: '" + type + "'.");
            }
        }
        if (thresholds.charAt(0) != '[' || thresholds.charAt(thresholds.length() - 1) != ']') {
            throw new IllegalArgumentException("Manual thresholds or Restore conditions must be given between brackets.");
        }
        String thresh = thresholds.substring(1, thresholds.length() - 1);
        String[] split = thresh.split(",");
        if (split.length <= 1) {
            throw new IllegalArgumentException("Wrong format between the brackets, 1 or less argument found.");
        }
        if (split.length == 2 && StringUtils.isNumeric((String)split[0])) {
            this.mode = "Manual";
            this.exclusive = null;
            this.restoretype = null;
            if (!StringUtils.isNumeric((String)split[1])) {
                throw new IllegalArgumentException("Manual thresholds (integer values) must be given as a range: between brackets, a comma for separation, and no spaces => [min,max]. Got instead '" + thresholds + "'.");
            }
            this.minthreshold = Integer.valueOf(split[0]);
            this.maxthreshold = Integer.valueOf(split[1]);
        } else {
            this.mode = "Restore";
            this.exclusive = new LinkedList<String>();
            switch (split[0].toLowerCase()) {
                case "cell": 
                case "cells": {
                    this.restoretype = "Cells";
                    break;
                }
                case "nucleus": 
                case "nuclei": {
                    this.restoretype = "Nuclei";
                    break;
                }
                case "rim": 
                case "rims": {
                    this.restoretype = "Rims";
                    break;
                }
                case "ring": 
                case "rings": {
                    this.restoretype = "Rings";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown type in Restore first parameter: '" + split[0] + "'. Must be Cell, Ring, or Nucleus.");
                }
            }
            if (!this.restoretype.equalsIgnoreCase(this.type) && !this.type.equalsIgnoreCase("All")) {
                throw new IllegalArgumentException("Cannot compute Restore: " + this.marker + "/" + this.restoretype + " required in Restore, but features not computed. Update last parameter to " + this.restoretype + " or 'All'.");
            }
            block51: for (int i2 = 1; i2 < split.length - 1; ++i2) {
                String[] sp = split[i2].split("/");
                if (sp.length != 2) {
                    throw new IllegalArgumentException("Restore mode expects pairs of Marker/Location. Got instead: '" + split[i2] + "'.");
                }
                switch (sp[1].toLowerCase()) {
                    case "cell": 
                    case "cells": {
                        this.exclusive.add(sp[0] + "/Cells");
                        continue block51;
                    }
                    case "nucleus": 
                    case "nuclei": {
                        this.exclusive.add(sp[0] + "/Nuclei");
                        continue block51;
                    }
                    case "rim": 
                    case "rims": {
                        this.exclusive.add(sp[0] + "/Rims");
                        continue block51;
                    }
                    case "ring": 
                    case "rings": {
                        this.exclusive.add(sp[0] + "/Rings");
                        continue block51;
                    }
                    default: {
                        throw new IllegalArgumentException("Restore mode expects pairs of Marker/Location. Got Unknown location: '" + sp[1] + "'.");
                    }
                }
            }
            if (!StringUtils.isNumeric((String)split[split.length - 1].toLowerCase())) {
                throw new IllegalArgumentException("In Restore mode, last item between brackets must be the maximum threshold. Got instead '" + split[split.length - 1] + "'.");
            }
            this.minthreshold = -1;
            this.maxthreshold = Integer.valueOf(split[split.length - 1]);
        }
    }
}

