/*
 * Decompiled with CFR 0.152.
 */
package softwares.ohsu.cyclicif;

import filesAndFolders.fichiersTabules.FichierTabule;
import filesAndFolders.fichiersTabules.FichierTabuleTools;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import softwares.ohsu.cyclicif.CycIF_RoundCycle;
import softwares.ohsu.cyclicif.CycIF_Tools;
import utils.LogFile;
import utils.python.PythonLauncher;

public class CycIF_Restore {
    private final String Copyright = "RESTORE: Robust intEnSiTy nORmalization mEthod for Multiplexed Imaging. Chang et al. 2019. https://www.biorxiv.org/content/10.1101/792770v1";
    public String Python_Path = "/opt/local/Library/Frameworks/Python.framework/Versions/3.8/bin/python3.8";

    public boolean Restore(List<String> scenes, List<CycIF_RoundCycle> rclist, String featuresdir, LogFile log) throws Exception {
        log.addComment("Starting Restore...");
        log.addComment("RESTORE: Robust intEnSiTy nORmalization mEthod for Multiplexed Imaging. Chang et al. 2019. https://www.biorxiv.org/content/10.1101/792770v1");
        System.out.println("\nStarting... RESTORE: Robust intEnSiTy nORmalization mEthod for Multiplexed Imaging. Chang et al. 2019. https://www.biorxiv.org/content/10.1101/792770v1");
        LinkedList<CallSite> expairs = new LinkedList<CallSite>();
        for (CycIF_RoundCycle rc : rclist) {
            if (rc.mode.equals("Manual")) continue;
            List<String> ex = rc.exclusive;
            for (String str : ex) {
                String[] split = str.split("/");
                if (split.length != 2) {
                    throw new Exception("split.length != 2 => Must not occur.");
                }
                expairs.add((CallSite)((Object)("'" + rc.marker + " - " + rc.restoretype + "', '" + split[0] + " - " + split[1] + "'")));
            }
        }
        FichierTabule Intensities = null;
        for (String scene : scenes) {
            FichierTabule meanint = new FichierTabule(featuresdir + "/Scene " + scene + " - Mean Intensities.csv", true, ",");
            FichierTabule tmp = FichierTabuleTools.AddColumn(meanint, scene);
            tmp.setColumnName(tmp.Width() - 1, "scene");
            if (Intensities == null) {
                Intensities = tmp;
            } else {
                FichierTabule tmp2 = FichierTabuleTools.Merge(Intensities, tmp);
                Intensities.Kill();
                Intensities = tmp2;
                tmp.Kill();
                tmp = null;
            }
            meanint.Kill();
            meanint = null;
        }
        Intensities.SelectWhere("To Exclude", 0, "x");
        FichierTabule tmp = FichierTabuleTools.DeleteSelectedRows(Intensities);
        Intensities.Kill();
        Intensities = FichierTabuleTools.AddColumn(tmp, 0);
        Intensities.setColumnName(Intensities.Width() - 1, "batch");
        tmp.Kill();
        tmp = null;
        File tmpdir = new File(featuresdir + "/tmp/");
        if (!tmpdir.exists()) {
            tmpdir.mkdirs();
        }
        Intensities.setColumnName(0, "cell");
        String[] scenescolumn = Intensities.getColumnString("scene");
        for (int i2 = 0; i2 < scenescolumn.length; ++i2) {
            scenescolumn[i2] = "Scene " + scenescolumn[i2];
        }
        Intensities.Write(tmpdir.getAbsolutePath() + "/Restore.csv", false, ",");
        StringBuilder sb = new StringBuilder(1001);
        sb.append("import os").append("\n");
        sb.append("import pickle").append("\n");
        sb.append("import sys").append("\n");
        sb.append("import pandas as pd").append("\n\n");
        sb.append("from cycIFAAP.Restore.RESTORE.RESTORE import Normalization\n\n");
        sb.append("mi = pd.read_csv('").append(tmpdir.getAbsolutePath()).append("/Restore.csv')").append("\n\n");
        sb.append("pairs = [").append("\n");
        Iterator iterexpairs = expairs.iterator();
        while (iterexpairs.hasNext()) {
            sb.append("\t[").append((String)iterexpairs.next()).append("]");
            if (iterexpairs.hasNext()) {
                sb.append(",");
            }
            sb.append("\n");
        }
        sb.append("]").append("\n\n");
        sb.append("norm = Normalization(mi, pairs, '").append(tmpdir.getAbsolutePath()).append("/')\n");
        sb.append("norm.run()").append("\n\n");
        sb.append("print('Restore Done!')").append("\n");
        sb.append("sys.exit(0)").append("\n");
        PythonLauncher pl = new PythonLauncher(this.Python_Path);
        File script = new File(tmpdir.getAbsolutePath() + "/Script.py");
        if (pl.Run(script.getAbsolutePath(), sb, "-X faulthandler", log, false)) {
            File[] files;
            System.out.println("Restore script successfully executed.");
            script.delete();
            File restorefile = new File(tmpdir.getAbsolutePath() + "/Restore.csv");
            restorefile.delete();
            FichierTabule thresholds = new FichierTabule(tmpdir.getAbsolutePath() + "/Restore_Thresholds.csv", true, ",");
            for (String scene : scenes) {
                File graphics = new File(tmpdir.getAbsolutePath() + "/Scene " + scene + " - Restore.pdf");
                graphics.renameTo(new File(featuresdir + "/Scene " + scene + " - Restore.pdf"));
                thresholds.SelectWhere("Scene", 0, "Scene " + scene);
                FichierTabule scenethresholds = FichierTabuleTools.SaveSelectedRows(thresholds);
                scenethresholds.Write(featuresdir + "/Scene " + scene + " - Restore Thresholds.csv", false, ",");
            }
            File resfile = new File(tmpdir.getAbsolutePath() + "/Restore_Thresholds.csv");
            resfile.delete();
            for (File f : files = new File(tmpdir.getAbsolutePath()).listFiles()) {
                f.delete();
            }
            tmpdir.delete();
            System.out.println("Restore done.\n");
            log.addComment("Restore done.");
            return true;
        }
        System.out.println("Restore script FAILURE!!!");
        System.err.println("Restore script FAILURE!!!");
        log.addNewError(new Error("Restore script failure."), "Failed to execute Restore.");
        return false;
    }

    public static void CheckDependencies(List<CycIF_RoundCycle> rclist, LogFile log) throws Exception {
        CycIF_Tools tools = new CycIF_Tools();
        for (CycIF_RoundCycle rc : rclist) {
            if (rc.mode.equals("Manual")) continue;
            for (String str : rc.exclusive) {
                String[] split = str.split("/");
                String marker = split[0];
                String type = split[1];
                CycIF_RoundCycle rct = tools.FindMarker(marker, rclist);
                if (rct == null) {
                    Exception ex = new Exception("Marker " + rc.marker + " requires Restore with " + str + ", but " + marker + "not found.");
                    log.addNewException(ex, ex.getMessage());
                    throw ex;
                }
                if (rct.type.equalsIgnoreCase(type) || rct.type.equalsIgnoreCase("All")) continue;
                Exception ex = new Exception("Marker " + rc.marker + " requires Restore with " + str + ", but " + type + " is not extracted from " + marker + ".");
                log.addNewException(ex, ex.getMessage());
                throw ex;
            }
        }
    }
}

