/*
 * Decompiled with CFR 0.152.
 */
package softwares.ohsu.cyclicif;

import java.io.IOException;
import utils.LogFile;
import utils.memory.Allocator;
import utils.python.PythonLauncher;

public class CycIF_Registration {
    private final Allocator allocator = Allocator.Instance();
    private final String Copyright;
    private final String Python_Path;

    public CycIF_Registration(String Python_Path, String Copyright) {
        this.Python_Path = Python_Path;
        this.Copyright = Copyright;
    }

    public boolean Register(String InputDir, String Technique, int Iterations, boolean Reverse, String OutputDir, LogFile log) throws IOException {
        boolean success;
        log.addComment(this.Copyright);
        log.addComment("Starting Registration...");
        System.out.println("\n\n" + this.Copyright);
        System.out.println("Starting Registration...");
        switch (Technique.toLowerCase()) {
            case "opencv": {
                success = this.OpenCV(InputDir, Reverse, OutputDir, log);
                break;
            }
            case "stackreg": 
            case "turboreg": {
                throw new IllegalArgumentException("Registration technique not implemented (yet).");
            }
            default: {
                throw new IllegalArgumentException("Registration technique unknow '" + Technique + "'. Expected 'OpenCV' or 'TurboReg'.");
            }
        }
        if (success) {
            log.addComment("Registration done.");
            System.out.println("Registration done.");
            return true;
        }
        log.addComment("Registration failure.");
        System.out.println("Registration failure.");
        System.err.println("Registration failure.");
        return false;
    }

    private boolean OpenCV(String InputDir, boolean Reverse, String OutputDir, LogFile log) throws IOException {
        String path = System.getProperty("user.dir");
        String FiReTiTiPyLib_Path = path + "/FiReTiTiPyLib/";
        StringBuilder sb = new StringBuilder(1001);
        sb.append("import sys").append("\n\n");
        sb.append("from FiReTiTiPyLib.CyclicIF import CyclicIF_Registration").append("\n\n");
        if (Reverse) {
            sb.append("cycreg = CyclicIF_Registration.CyclicIF_Registration(Reverse=True, ").append("\n");
        } else {
            sb.append("cycreg = CyclicIF_Registration.CyclicIF_Registration(Reverse=False, ").append("\n");
        }
        sb.append("Copyright='").append(this.Copyright).append("')\n");
        sb.append("nbErrors = cycreg.Run('").append(InputDir).append("', '").append(OutputDir).append("')").append("\n");
        sb.append("sys.exit(nbErrors)").append("\n\n");
        PythonLauncher pl = new PythonLauncher(this.Python_Path);
        if (!pl.Run(OutputDir + "/tmp/Script.py", sb, "-X faulthandler", log, true)) {
            System.out.println("Registration with OpenCV FAILURE!!!");
            System.err.println("Registration with OpenCV FAILURE!!!");
            log.addNewError(new Error("Registration failure."), "Failed to register.");
            return false;
        }
        System.out.println("Registration with OpenCV done.");
        return true;
    }
}

