/*
 * Decompiled with CFR 0.152.
 */
package softwares.ohsu.cyclicif;

import arrayTiTi.ArrayFeatures;
import filesAndFolders.FilesFolders;
import filesAndFolders.fichiersTabules.FichierTabule;
import imageTiTi.ImageComparator;
import imageTiTi.ImageFeatures;
import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import listTiTi.ListIO;
import measures.Evaluations;
import morphee.StructuringElement;
import morphee.WhiteTopHat;
import processing.filters.DynamicExpansion;
import segmentation.cells.DapiDL;
import softwares.ohsu.cyclicif.CycIF_RoundCycle;
import softwares.ohsu.cyclicif.CycIF_Tools;
import utils.LogFile;
import utils.memory.Allocator;

public class CycIF_QualityControl {
    private final Allocator allocator = Allocator.Instance();
    private final int Magnification;
    private final String Copyright;
    private final String Python_Path;
    private final int nbCPU;
    private final CycIF_Tools Tools = new CycIF_Tools();
    private final ArrayFeatures AF = new ArrayFeatures();
    private final DynamicExpansion dynexp = new DynamicExpansion();
    private final ImageFeatures IF = new ImageFeatures();
    private final StructuringElement sehex53 = new StructuringElement(new Object[]{53, -9});
    private final WhiteTopHat wth = new WhiteTopHat();

    public CycIF_QualityControl(int Magnification, String Python_Path, String Copyright, int nbCPU) {
        switch (Magnification) {
            case 20: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Magnification not supported (yet).");
            }
        }
        this.Magnification = Magnification;
        this.Python_Path = Python_Path;
        this.Copyright = Copyright;
        this.nbCPU = nbCPU;
    }

    public void Check(String regdir, DapiDL dapi, List<CycIF_RoundCycle> rclist, String segdir, String featdir, String qcdir, LogFile log) throws Exception {
        log.addComment(this.Copyright);
        log.addComment("Starting Quality Control.");
        System.out.println("\n\nStarting Quality Control");
        this.SegmentDapis(regdir, dapi, segdir, qcdir, log);
        this.MarkersQuality(regdir, featdir, rclist, qcdir, log);
        log.addComment("Quality Control done.");
        System.out.println("Quality Control done");
    }

    private void SegmentDapis(String regdir, DapiDL dapidl, String segdir, String qcdir, LogFile log) throws Exception {
        File[] unwanted;
        File[] zprojections;
        File[] Dapis;
        System.out.println("\nStarting Dapis segmentation based QC.");
        log.addComment("Starting Dapis segmentation based QC.");
        for (File f : Dapis = new File(regdir).listFiles((dir, name) -> name.contains("_c1_"))) {
            BufferedImage imdapi = ImageIO.Read(f);
            BufferedImage reswth = this.wth.Filter(imdapi, this.sehex53, this.nbCPU);
            this.dynexp.FilterWithConditions(reswth, 1.0, 0.5, 0, 0, 65535, reswth, this.nbCPU);
            ImageIO.Write(reswth, qcdir + "/" + f.getName(), 6);
        }
        dapidl.Keyword = "_c1_";
        if (!dapidl.Segmentation(qcdir, false, log)) {
            System.exit(1);
        }
        for (File f : zprojections = new File(segdir).listFiles((dir, name) -> name.contains("ZProjectionDAPI CE"))) {
            FilesFolders.CopyFile(f, new File(qcdir + "/" + f.getName()));
        }
        dapidl.Keyword = "ZProjection";
        if (!dapidl.Segmentation(qcdir, false, log)) {
            System.exit(1);
        }
        for (File f : unwanted = new File(qcdir).listFiles((dir, name) -> name.contains("Boxes") || name.contains("Candidates") || name.contains("Foreground") || name.contains("Probabilities"))) {
            FilesFolders.Delete(f);
        }
        List<String> scenes = this.Tools.FindScenes(qcdir, "-");
        System.out.print(scenes.size() + " scene(s) found: ");
        ListIO.Display(scenes, " ");
        String Scene = null;
        Iterator<String> iter = scenes.iterator();
        while (iter.hasNext()) {
            try {
                int i2;
                String scene = Scene = iter.next();
                Object[] dapis = new File(regdir).listFiles((dir, name) -> name.contains("Scene-" + scene) && name.contains("_c1_") && !name.endsWith(" - Labels.png"));
                Arrays.sort(dapis);
                Object[] labels = new File(qcdir).listFiles((dir, name) -> name.contains("Scene-" + scene) && name.contains("_c1_") && name.endsWith(" - Labels.png"));
                Arrays.sort(labels);
                if (dapis.length != labels.length) {
                    throw new Exception("dapis.length != labels.length");
                }
                BufferedImage imzproj = ImageIO.Read(segdir + "/Scene " + scene + " - ZProjectionDAPI.png");
                BufferedImage imzprojlabels = ImageIO.Read(qcdir + "/Scene " + scene + " - ZProjectionDAPI CE - Labels.png");
                BufferedImage imzprojnuc = ImageNew.Same((BufferedImage)imzproj);
                ImageComparator.Compare((BufferedImage)imzprojlabels, (String)"!=", (int)0, (BufferedImage)imzproj, (int)0, (BufferedImage)imzprojnuc);
                String[] columns = new String[]{"Image", "#Nuclei", "%Nuclei", "Segmentation Correlation", "Dice", "Mean Intensity", "Normalized Mean Intensity"};
                int[] types = new int[columns.length];
                Arrays.fill(types, 1);
                types[0] = 2;
                FichierTabule features = new FichierTabule(dapis.length + 3, types, "");
                features.setColumnsNames(columns);
                features.setValue(dapis.length, 0, "Z-projection");
                features.setValue(dapis.length, 1, (double)((int)this.IF.Maximum(imzprojlabels)));
                features.setValue(dapis.length, 2, 100.0);
                features.setValue(dapis.length, 3, 1.0);
                features.setValue(dapis.length, 4, 1.0);
                features.setValue(dapis.length, 5, this.IF.Average(imzprojnuc, 0));
                features.setValue(dapis.length, 6, 1.0);
                for (i2 = 0; i2 < dapis.length; ++i2) {
                    BufferedImage imdapi = ImageIO.Read((File)dapis[i2]);
                    BufferedImage imlabels = ImageIO.Read((File)labels[i2]);
                    BufferedImage imnuc = ImageNew.Same((BufferedImage)imdapi);
                    ImageComparator.Compare((BufferedImage)imlabels, (String)"!=", (int)0, (BufferedImage)imdapi, (int)0, (BufferedImage)imnuc);
                    features.setValue(i2, 0, ((File)dapis[i2]).getName());
                    features.setValue(i2, 1, (double)((int)this.IF.Maximum(imlabels)));
                    features.setValue(i2, 2, features.getValueDouble(i2, 1) / features.getValueDouble(dapis.length, 1) * 100.0);
                    Evaluations.DetectionResults res = Evaluations.Detection(imlabels, imzprojlabels, 0.5f, null);
                    features.setValue(i2, 3, res.Accuracy);
                    res = null;
                    features.setValue(i2, 4, Evaluations.Dice(imlabels, imzprojlabels));
                    features.setValue(i2, 5, this.IF.Average(imnuc, 0));
                    features.setValue(i2, 6, features.getValueDouble(i2, 5) / features.getValueDouble(dapis.length, 5));
                    imlabels = null;
                    imdapi = null;
                    imnuc = this.allocator.Release(imnuc);
                }
                features.setValue(dapis.length + 1, 0, "Average");
                features.setValue(dapis.length + 2, 0, "Standard deviation");
                for (i2 = 1; i2 < types.length; ++i2) {
                    double[] column = features.getColumnDouble(i2);
                    this.AF.Moments(column, -1.0, 0, dapis.length);
                    features.setValue(dapis.length + 1, i2, this.AF.Average());
                    features.setValue(dapis.length + 2, i2, this.AF.StandardDeviation());
                }
                features.setSeparator(",");
                features.Write(qcdir + "/Scene " + scene + " - QC Dapis Based.csv", false);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                log.addNewException(ex, "Cannot segment scene " + Scene);
            }
            catch (Error e) {
                e.printStackTrace();
                log.addNewError(e, "Cannot segment scene " + Scene);
            }
        }
        iter = null;
        System.out.println("Dapis based quality control done.\n");
        log.addComment("Dapis based quality control done.");
    }

    private void MarkersQuality(String regdir, String featdir, List<CycIF_RoundCycle> rclist, String qcdir, LogFile log) throws IOException, Exception {
        System.out.println("\nStarting markers quality assessment.\n");
        log.addComment("Starting markers quality assessment.");
        List<String> scenes = this.Tools.FindScenes(regdir, "-");
        System.out.print(scenes.size() + " scene(s) found: ");
        ListIO.Display(scenes, " ");
        int width = -1;
        LinkedList<CycIF_RoundCycle> Restore = new LinkedList<CycIF_RoundCycle>();
        for (CycIF_RoundCycle rc : rclist) {
            if (rc.mode.equalsIgnoreCase("Restore")) {
                Restore.add(rc);
                if (width < rc.exclusive.size()) {
                    width = rc.exclusive.size();
                }
            }
            rc = null;
        }
        if (Restore.isEmpty()) {
            System.out.println("Restore never used, no markers quality possible.\n");
            log.addComment("Restore never used.");
        } else {
            String Scene = null;
            Iterator<String> iterscene = scenes.iterator();
            while (iterscene.hasNext()) {
                try {
                    String scene = Scene = iterscene.next();
                    int[] columns = new int[width + 1];
                    Arrays.fill(columns, 1);
                    columns[0] = 2;
                    FichierTabule results = new FichierTabule(Restore.size(), columns, "");
                    results.setColumnName(0, "Markers");
                    int row = 0;
                    for (CycIF_RoundCycle rc : Restore) {
                        results.setValue(row, 0, rc.marker);
                        FichierTabule baseline = new FichierTabule(featdir + "/Scene " + scene + " - " + rc.marker + " - " + rc.restoretype + ".csv", true, ",");
                        int[] types = new int[]{2, 2};
                        FichierTabule excfil = new FichierTabule(baseline.Height(), types, "");
                        excfil.setColumn(0, baseline.getColumnString(7));
                        excfil.SelectWhere(0, 0, "+");
                        int nbpos = excfil.nbSelected();
                        int col = 1;
                        for (String exc : rc.exclusive) {
                            String[] split = exc.split("/");
                            FichierTabule against = new FichierTabule(featdir + "/Scene " + scene + " - " + split[0] + " - " + split[1] + ".csv", true, ",");
                            excfil.setColumn(1, against.getColumnString(7));
                            excfil.SelectFromSelectionWhere(1, 0, "+");
                            int nbpos2 = excfil.nbSelected();
                            results.setValue(row, col++, 100.0 - (double)nbpos2 / (double)nbpos * 100.0);
                        }
                        ++row;
                    }
                    results.setSeparator(",");
                    results.Write(qcdir + "/Scene " + scene + " - QC Restore Based.csv", false);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    log.addNewException(ex, "Cannot evaluate marker quality for scene " + Scene);
                }
                catch (Error e) {
                    e.printStackTrace();
                    log.addNewError(e, "Cannot evaluate marker quality for scene " + Scene);
                }
            }
        }
        System.out.println("Restore based markers quality done.\n");
        log.addComment("Restore based markers quality done.");
    }
}

