/*
 * Decompiled with CFR 0.152.
 */
package softwares.ohsu.cyclicif;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import softwares.ohsu.cyclicif.CycIF_RoundCycle;
import utils.LogFile;

public class CycIF_Napari {
    public void Napari(List<String> scenes, List<CycIF_RoundCycle> rclist, String segmentationdir, LogFile log) throws Exception {
        log.addComment("Creating Napari files...");
        System.out.println("\nCreating Napari files...");
        for (String scene : scenes) {
            StringBuilder sb = new StringBuilder(1001);
            sb.append("import sys").append("\n");
            sb.append("import napari").append("\n");
            sb.append("import skimage.io as skio").append("\n\n");
            sb.append("from dask_image.imread import imread").append("\n\n");
            sb.append("path = '.'\n\n");
            sb.append("dapi = skio.imread(path + '/Scene ").append(scene).append(" - ZProjectionDAPI CE.png')").append("\n\n");
            sb.append("#boxes = imread(path + '/Scene ").append(scene).append(" - Visual Check/Scene ").append(scene).append(" - Nuclei Boxes.png')").append("\n\n");
            sb.append("nuclabels = skio.imread(path + '/Scene ").append(scene).append(" - Nuclei Labels.png')").append("\n");
            sb.append("celllabels = skio.imread(path + '/Scene ").append(scene).append(" - Cell Labels.png')").append("\n");
            sb.append("colormaps = ['red', 'green', 'blue', 'cyan', 'yellow', 'magenta']").append("\n\n");
            sb.append("markers = [");
            Iterator<CycIF_RoundCycle> iterrc = rclist.iterator();
            while (iterrc.hasNext()) {
                sb.append("'").append(iterrc.next().marker).append("'");
                if (!iterrc.hasNext()) continue;
                sb.append(", ");
            }
            sb.append("]").append("\n");
            sb.append("markers = sorted(markers)").append("\n");
            sb.append("markers.reverse()").append("\n\n");
            sb.append("imMarkers = []").append("\n");
            sb.append("imMarkersPosNuclei = []").append("\n");
            sb.append("imMarkersPosCells = []").append("\n");
            sb.append("count = 0").append("\n");
            sb.append("for marker in markers:").append("\n");
            sb.append("\tcolorindex = count % len(colormaps)").append("\n");
            sb.append("\timMarkers.append({'Marker': marker, 'Image': imread(path + '/Scene ").append(scene).append(" - ' + marker + '.png'), 'ColorMap': colormaps[colorindex]})").append("\n");
            sb.append("\timMarkersPosNuclei.append({'Marker': marker + '+ Nuclei', 'Image': imread(path + '/Scene ").append(scene).append(" - ' + marker + '+ Area Nuclei.png'), 'ColorMap': colormaps[colorindex]})").append("\n");
            sb.append("\timMarkersPosCells.append({'Marker': marker + '+ Cells', 'Image': imread(path + '/Scene ").append(scene).append(" - ' + marker + '+ Area Cells.png'), 'ColorMap': colormaps[colorindex]})").append("\n");
            sb.append("\tcount += 1").append("\n\n");
            sb.append("viewer = napari.Viewer()").append("\n");
            sb.append("with napari.gui_qt():").append("\n");
            sb.append("\tviewer.add_image(dapi, name='Dapis z-projected', visible=True)").append("\n");
            sb.append("\t#viewer.add_image(boxes, rgb=True, name='Nuclei Boxes', visible=False)").append("\n");
            sb.append("\tviewer.add_labels(nuclabels, name='Nuclei Labels', visible=True, blending='additive', opacity=0.5)").append("\n");
            sb.append("\tviewer.add_labels(celllabels, name='Cells Labels', visible=True, blending='additive', opacity=0.5)").append("\n\n");
            sb.append("\tfor marker, markernuc, markercell in zip(imMarkers,imMarkersPosNuclei,imMarkersPosCells):").append("\n");
            sb.append("\t\tviewer.add_image(marker['Image'], name=marker['Marker'], visible=False, opacity=0.5, colormap=marker['ColorMap'])").append("\n");
            sb.append("\t\tviewer.add_labels(markernuc['Image'], name=markernuc['Marker'], visible=False, blending='additive', opacity=0.23, color={255:markernuc['ColorMap']})").append("\n");
            sb.append("\t\tviewer.add_labels(markercell['Image'], name=markercell['Marker'], visible=False, blending='additive', opacity=0.23, color={255:markercell['ColorMap']})").append("\n\n");
            sb.append("sys.exit(0)").append("\n");
            File script = new File(segmentationdir + "/Scene " + scene + " - Napari.py");
            try {
                try (DataOutputStream dos = new DataOutputStream(new FileOutputStream(script));){
                    dos.write(sb.toString().getBytes("ISO-8859-1"));
                    dos.close();
                }
                System.out.println("'" + segmentationdir + "/Scene " + scene + " - Napari.py' successfully written.");
            }
            catch (IOException ex) {
                ex.printStackTrace();
                log.addNewException(ex, "Cannot create Napari file: '" + segmentationdir + "/Scene " + scene + " - Napari.py'");
            }
            catch (Error e) {
                e.printStackTrace();
                log.addNewError(e, "Cannot create Napari file: '" + segmentationdir + "/Scene " + scene + " - Napari.py'");
            }
        }
        System.out.println("Napari files creation done.\n");
        log.addComment("Napari files creation done.");
    }
}

