/*
 * Decompiled with CFR 0.152.
 */
package softwares.ohsu.cyclicif;

import arrayTiTi.ArrayArithmetic;
import arrayTiTi.ArrayFeatures;
import arrayTiTi.ArrayOperations;
import characterization.shapes.shapeIndexes.ShapeIndexesComputer;
import characterization.textures.lbp.LocalBinaryPattern;
import characterization.textures.statisticalmatrices.com.Haralick;
import characterization.textures.statisticalmatrices.thibaultmatrices.dzm.DZMfeatures;
import characterization.textures.statisticalmatrices.thibaultmatrices.szm.SZMfeatures;
import displays.Colors;
import filesAndFolders.fichiersTabules.FichierTabule;
import imageTiTi.ImageComparator;
import imageTiTi.ImageConverter;
import imageTiTi.ImageDrawer;
import imageTiTi.ImageFeatures;
import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import listTiTi.ListIO;
import measures.BasicMeasures;
import measures.Measures2D;
import measures.cclh.UnionFindCcl;
import measures.hedgehop.DistanceMapComputer;
import morphee.StructuringElement;
import morphee.WhiteTopHat;
import morphee.granulometry.PatternSpectrum;
import processing.filters.DynamicExpansion;
import processing.reducer.LinearGLR;
import processing.thresholding.Binary;
import softwares.ohsu.cyclicif.CycIF_CellTypes;
import softwares.ohsu.cyclicif.CycIF_Napari;
import softwares.ohsu.cyclicif.CycIF_Restore;
import softwares.ohsu.cyclicif.CycIF_RoundCycle;
import softwares.ohsu.cyclicif.CycIF_Tools;
import utils.LogFile;
import utils.memory.Allocator;

public class CycIF_Features {
    private final Allocator allocator = Allocator.Instance();
    private final String Copyright;
    private final LogFile log;
    private final Version version;
    private final CycIF_Restore restore = new CycIF_Restore();
    private final CycIF_Tools Tools = new CycIF_Tools();
    private final ArrayFeatures AF = new ArrayFeatures();
    private final Binary binary = new Binary();
    private final DistanceMapComputer dmc = new DistanceMapComputer();
    private final DynamicExpansion dynexp = new DynamicExpansion();
    private final UnionFindCcl ccl = new UnionFindCcl();
    private final WhiteTopHat wth = new WhiteTopHat();
    private final StructuringElement selbp8 = new StructuringElement(new Object[]{1, -13, 8});
    private final StructuringElement sem3 = new StructuringElement(new Object[]{3, -15});
    private final List<CycIF_RoundCycle> rclist = new LinkedList<CycIF_RoundCycle>();
    private final CycIF_CellTypes celltypes = new CycIF_CellTypes();
    private final CycIF_Napari napari = new CycIF_Napari();
    private int nbThreads = 1;
    private int nbFreeThreads = 0;
    private ComputeFeaturesThread[] threads = null;
    public String FE_WaitForScene = "";
    public boolean FE_SaveImages = true;
    public boolean FE_SubtractBackground = false;
    public float FE_Rim_Size = 3.0f;
    public boolean FE_BiasedFeaturesOnly = false;
    public boolean FE_DistanceFromBorder = false;
    public boolean FE_Restore_SSC_Only = false;
    public String FE_Python_Path = "/opt/local/Library/Frameworks/Python.framework/Versions/3.8/bin/python3.8";
    private BasicMeasures basic = null;
    private DZMfeatures dzm = null;
    private Haralick haralick = null;
    private LocalBinaryPattern lbp = null;
    private PatternSpectrum ps = null;
    private SZMfeatures szm = null;
    private ShapeIndexesComputer sic = null;

    public CycIF_Features(Version version, String Copyright, LogFile log) {
        this.version = version;
        this.Copyright = Copyright;
        this.log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void FeaturesExtraction(String inputdir, String registrationdir, String segmentationdir, String featuresdir, boolean autocrop, boolean litemode, int nbCPU) throws Exception {
        BufferedImage stainingrgb;
        this.log.addComment(this.Copyright);
        this.log.addComment("Starting features extraction...");
        System.out.println("\n\n\n" + this.Copyright);
        this.basic = new BasicMeasures();
        this.dzm = new DZMfeatures();
        this.haralick = new Haralick();
        this.lbp = new LocalBinaryPattern();
        this.ps = new PatternSpectrum();
        this.szm = new SZMfeatures();
        this.sic = new ShapeIndexesComputer();
        this.setFeaturesParameters(this.dzm, this.haralick, this.lbp, this.ps, this.szm, this.sic);
        File resfile = new File(featuresdir);
        if (!resfile.exists()) {
            resfile.mkdirs();
        }
        resfile = null;
        System.out.println("Starting features extraction...");
        System.out.println("Processing '" + registrationdir + "':");
        List<String> scenes = this.Tools.FindScenes(registrationdir, "-");
        System.out.print(scenes.size() + " scene(s) found: ");
        ListIO.Display(scenes, " ");
        if (scenes.isEmpty()) {
            System.out.println("\nError - No scene found in '" + registrationdir + "'. Rename your images accordingly.");
            Error e = new Error("No scene found");
            this.log.addNewError(e, "Cannot find any scene in " + registrationdir);
            throw e;
        }
        switch (this.version) {
            case v1: {
                this.Tools.LoadRoundsCyclesTableV1(inputdir, this.rclist);
                break;
            }
            case v2: {
                this.Tools.LoadRoundsCyclesTable(featuresdir, this.rclist, this.log);
                break;
            }
            default: {
                throw new IllegalArgumentException("Version not supported.");
            }
        }
        boolean CellTypeGo = this.celltypes.Test(inputdir, this.rclist, this.log);
        UnionFindCcl cellccl = new UnionFindCcl();
        boolean work = this.FE_WaitForScene.isEmpty();
        this.nbThreads = this.FE_BiasedFeaturesOnly ? 1 : nbCPU;
        if (this.threads == null || this.threads.length != nbCPU) {
            this.nbFreeThreads = 0;
            this.threads = null;
            this.threads = new ComputeFeaturesThread[this.nbThreads];
            for (int i2 = 0; i2 < this.nbThreads; ++i2) {
                this.threads[i2] = new ComputeFeaturesThread(i2, this.log);
                this.threads[i2].start();
            }
            CycIF_Features i2 = this;
            synchronized (i2) {
                while (this.nbFreeThreads != this.nbThreads) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        boolean RestoreFound = false;
        String scene2 = null;
        Iterator<String> iterscenes = scenes.iterator();
        while (iterscenes.hasNext()) {
            try {
                int i3;
                scene2 = iterscenes.next();
                if (!work) {
                    if (!scene2.equalsIgnoreCase(this.FE_WaitForScene)) continue;
                    work = true;
                }
                BufferedImage imdapi = ImageIO.Read(segmentationdir + "/Scene " + scene2 + " - ZProjectionDAPI.png");
                BufferedImage nuclei = null;
                switch (this.version) {
                    case v1: {
                        nuclei = ImageIO.Read(segmentationdir + "/Scene " + scene2 + " - Nuclei Segmentation Basins.tif");
                        break;
                    }
                    case v2: {
                        nuclei = ImageIO.LoadLabels(segmentationdir + "/Scene " + scene2 + " - Nuclei Labels");
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Version not supported.");
                    }
                }
                float[] distmap = this.FE_DistanceFromBorder ? this.Tools.ComputeDistances(nuclei, segmentationdir, scene2, nbCPU) : null;
                this.ccl.ImportLabels(((DataBufferInt)nuclei.getRaster().getDataBuffer()).getData(), nuclei.getWidth(), nuclei.getHeight());
                this.ccl.ComputeBoundingBoxes();
                int[] nuclabels = this.ccl.Labels1D();
                int[] nucsizes = this.ccl.Sizes();
                float[] nucleipos = new float[this.ccl.ConnectedComponentsNumber() + 1];
                BufferedImage cells = null;
                switch (this.version) {
                    case v1: {
                        cells = ImageIO.Read(segmentationdir + "/Scene " + scene2 + " - Cell Segmentation Basins.tif");
                        break;
                    }
                    case v2: {
                        cells = ImageIO.LoadLabels(segmentationdir + "/Scene " + scene2 + " - Cell Labels");
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Version not supported.");
                    }
                }
                cellccl.ImportLabels(((DataBufferInt)cells.getRaster().getDataBuffer()).getData(), cells.getWidth(), cells.getHeight());
                System.arraycopy(((DataBufferInt)cells.getRaster().getDataBuffer()).getData(), 0, cellccl.Labels1D(), 0, cellccl.Labels1D().length);
                cellccl.ComputeBoundingBoxes();
                int[] cellslabels = cellccl.Labels1D();
                int[] cellsizes = cellccl.Sizes();
                float[] cellspos = new float[cellccl.ConnectedComponentsNumber() + 1];
                float[] ringspos = new float[cellccl.ConnectedComponentsNumber() + 1];
                float[] rimpos = new float[cellccl.ConnectedComponentsNumber() + 1];
                int[] rimcount = new int[cellccl.ConnectedComponentsNumber() + 1];
                this.dmc.ComputeGrayLevel(cells, this.sem3, true);
                float[] rimdm = this.dmc.getMontanariMap1D();
                BufferedImage stainingce = ImageNew.Same((BufferedImage)imdapi);
                BufferedImage stainingbyte = ImageNew.Same((BufferedImage)imdapi, (int)10);
                stainingrgb = null;
                try {
                    stainingrgb = ImageNew.Same((BufferedImage)cells, (int)5);
                }
                catch (NegativeArraySizeException ex) {
                    this.log.addComment("Features extraction: images too big to be converted into RGB format.");
                    System.out.print("WARNING - Features extraction: images too big to be converted into RGB format.");
                }
                int numcol = 0;
                Iterator<CycIF_RoundCycle> iterrc = this.rclist.iterator();
                block73: while (iterrc.hasNext()) {
                    switch (iterrc.next().type) {
                        case "Nuclei": 
                        case "Cells": 
                        case "Rings": 
                        case "Rims": {
                            ++numcol;
                            continue block73;
                        }
                        case "All": {
                            numcol += 4;
                            continue block73;
                        }
                    }
                    throw new Exception("Must not occur.");
                }
                int[] types = new int[8 + numcol + 1];
                Arrays.fill(types, 1);
                Arrays.fill(types, 0, 5, 0);
                types[7] = 2;
                FichierTabule MeanIntensities = new FichierTabule(this.ccl.ConnectedComponentsNumber() + 1, types, "Intensities");
                String[] names = new String[]{"Label", "MinX", "MinY", "MaxX", "MaxY", "CentroidX", "CentroidY", "To Exclude"};
                for (int i4 = 0; i4 < names.length; ++i4) {
                    MeanIntensities.setColumnName(i4, names[i4]);
                }
                ArrayOperations.FillIncreasingly((int[])MeanIntensities.getColumnInt(0));
                boolean[] toexclude = new boolean[MeanIntensities.Height()];
                Arrays.fill(toexclude, false);
                toexclude[0] = true;
                numcol = 8;
                CycIF_RoundCycle rc = null;
                iterrc = this.rclist.iterator();
                while (iterrc.hasNext()) {
                    try {
                        rc = iterrc.next();
                        boolean Manual = rc.mode.equalsIgnoreCase("Manual");
                        RestoreFound |= !Manual;
                        BufferedImage staining = this.Tools.LoadImage(registrationdir, scene2, rc.round, rc.cycle);
                        BufferedImage nucstaining = null;
                        BufferedImage cellstaining = null;
                        if (this.FE_SubtractBackground) {
                            Object file = new File(segmentationdir + "/Scene " + scene2 + " - " + rc.marker + " SBnuclei.png");
                            if (!((File)file).exists()) {
                                throw new Exception("Background subtracted images missing. Rerun segmentation with only background subtraction.");
                            }
                            nucstaining = ImageIO.Read((File)file);
                            file = new File(segmentationdir + "/Scene " + scene2 + " - " + rc.marker + " SBcells.png");
                            if (!rc.cycle.equalsIgnoreCase("c1")) {
                                if (!((File)file).exists()) {
                                    throw new Exception("Background subtracted images missing. Rerun segmentation with only background subtraction.");
                                }
                                cellstaining = ImageIO.Read((File)file);
                            } else {
                                cellstaining = nucstaining;
                            }
                        } else {
                            nucstaining = cellstaining = staining;
                        }
                        if (this.FE_SaveImages) {
                            if (!this.FE_SubtractBackground) {
                                ImageIO.Write(staining, segmentationdir + "/Scene " + scene2 + " - " + rc.marker + ".png", 6);
                            }
                            this.Tools.PrepareImages(staining, stainingce, stainingbyte, stainingrgb, nbCPU);
                        }
                        if (Manual) {
                            this.FindPositive(nucstaining, cellstaining, nuclabels, nucsizes, cellslabels, cellsizes, rimcount, rimdm, rc.marker, scene2, rc.minthreshold, rc.maxthreshold, nucleipos, cellspos, ringspos, rimpos, segmentationdir, nbCPU);
                        } else {
                            Arrays.fill(nucleipos, -1.0f);
                            Arrays.fill(cellspos, -1.0f);
                            Arrays.fill(ringspos, -1.0f);
                            Arrays.fill(rimpos, -1.0f);
                        }
                        ImageIO.tag = 1;
                        switch (rc.type) {
                            case "Nuclei": {
                                BufferedImage[] nucleilist = this.Tools.SeparateNucleiCells(this.ccl, nucstaining, autocrop);
                                FichierTabule nucfeatures = this.ComputeFeatures(this.ccl, nucleilist, !Manual ? null : nucleipos, distmap, rc, true, nbCPU);
                                nucfeatures.Write(featuresdir + "/Scene " + scene2 + " - " + rc.marker + " - Nuclei.csv", false, ",");
                                MeanIntensities.setColumn(numcol, nucfeatures.getColumnDouble(10));
                                MeanIntensities.setColumnName(numcol++, rc.marker + " - Nuclei");
                                ArrayArithmetic.Or((boolean[])toexclude, (boolean[])nucfeatures.getExcluded(), (boolean[])toexclude);
                                if (this.FE_SaveImages && Manual && stainingrgb != null) {
                                    ImageDrawer.Cells(stainingrgb, nuclabels, nucleipos, Colors.CYAN, Colors.RED);
                                    ImageIO.Write(stainingrgb, segmentationdir + "/Scene " + scene2 + " - Visual Check/Scene " + scene2 + " - " + rc.marker + " Nuclei+.png", 6);
                                }
                                nucleilist = null;
                                nucleilist = null;
                                nucfeatures.Kill();
                                nucfeatures = null;
                                break;
                            }
                            case "Cells": {
                                BufferedImage[] cellslist = this.Tools.SeparateNucleiCells(cellccl, cellstaining, autocrop);
                                FichierTabule cellfeatures = this.ComputeFeatures(cellccl, cellslist, !Manual ? null : cellspos, distmap, rc, false, nbCPU);
                                cellfeatures.Write(featuresdir + "/Scene " + scene2 + " - " + rc.marker + " - Cells.csv", false, ",");
                                MeanIntensities.setColumn(numcol, cellfeatures.getColumnDouble(10));
                                MeanIntensities.setColumnName(numcol++, rc.marker + " - Cells");
                                ArrayArithmetic.Or((boolean[])toexclude, (boolean[])cellfeatures.getExcluded(), (boolean[])toexclude);
                                if (this.FE_SaveImages && Manual && stainingrgb != null) {
                                    ImageDrawer.Cells(stainingrgb, cellslabels, cellspos, Colors.CYAN, Colors.RED);
                                    ImageIO.Write(stainingrgb, segmentationdir + "/Scene " + scene2 + " - Visual Check/Scene " + scene2 + " - " + rc.marker + " Cells+.png", 6);
                                }
                                cellslist = null;
                                cellslist = null;
                                cellfeatures.Kill();
                                cellfeatures = null;
                                break;
                            }
                            case "Rings": {
                                BufferedImage[] cellsminusnucleilist = this.Tools.SeparateCellsMinusNuclei(this.ccl, cellccl, cellstaining, autocrop);
                                FichierTabule cellminusnucleifeatures = this.ComputeFeatures(cellccl, cellsminusnucleilist, !Manual ? null : ringspos, distmap, rc, false, nbCPU);
                                cellminusnucleifeatures.Write(featuresdir + "/Scene " + scene2 + " - " + rc.marker + " - Rings.csv", false, ",");
                                MeanIntensities.setColumn(numcol, cellminusnucleifeatures.getColumnDouble(10));
                                MeanIntensities.setColumnName(numcol++, rc.marker + " - Rings");
                                ArrayArithmetic.Or((boolean[])toexclude, (boolean[])cellminusnucleifeatures.getExcluded(), (boolean[])toexclude);
                                if (this.FE_SaveImages && Manual && stainingrgb != null) {
                                    ImageDrawer.Cells(stainingrgb, cellslabels, ringspos, Colors.CYAN, Colors.RED);
                                    ImageIO.Write(stainingrgb, segmentationdir + "/Scene " + scene2 + " - Visual Check/Scene " + scene2 + " - " + rc.marker + " Rings+.png", 6);
                                }
                                cellsminusnucleilist = null;
                                cellminusnucleifeatures.Kill();
                                cellminusnucleifeatures = null;
                                break;
                            }
                            case "Rims": {
                                BufferedImage[] cellsrimlist = this.Tools.SeparateCellsRim(rimdm, cellccl, cellstaining, this.FE_Rim_Size, autocrop);
                                FichierTabule cellrimfeatures = this.ComputeFeatures(cellccl, cellsrimlist, !Manual ? null : rimpos, distmap, rc, false, nbCPU);
                                cellrimfeatures.Write(featuresdir + "/Scene " + scene2 + " - " + rc.marker + " - Rims.csv", false, ",");
                                MeanIntensities.setColumn(numcol, cellrimfeatures.getColumnDouble(10));
                                MeanIntensities.setColumnName(numcol++, rc.marker + " - Rims");
                                ArrayArithmetic.Or((boolean[])toexclude, (boolean[])cellrimfeatures.getExcluded(), (boolean[])toexclude);
                                if (this.FE_SaveImages && Manual && stainingrgb != null) {
                                    ImageDrawer.Cells(stainingrgb, cellslabels, rimpos, Colors.CYAN, Colors.RED);
                                    ImageIO.Write(stainingrgb, segmentationdir + "/Scene " + scene2 + " - Visual Check/Scene " + scene2 + " - " + rc.marker + " Rims+.png", 6);
                                }
                                cellsrimlist = null;
                                cellsrimlist = null;
                                cellrimfeatures.Kill();
                                cellrimfeatures = null;
                                break;
                            }
                            case "All": 
                            case "Everything": {
                                BufferedImage[] nuclist = this.Tools.SeparateNucleiCells(this.ccl, nucstaining, autocrop);
                                FichierTabule nucleifeatures = this.ComputeFeatures(this.ccl, nuclist, !Manual ? null : nucleipos, distmap, rc, true, nbCPU);
                                nucleifeatures.Write(featuresdir + "/Scene " + scene2 + " - " + rc.marker + " - Nuclei.csv", false, ",");
                                MeanIntensities.setColumn(numcol, nucleifeatures.getColumnDouble(10));
                                MeanIntensities.setColumnName(numcol++, rc.marker + " - Nuclei");
                                ArrayArithmetic.Or((boolean[])toexclude, (boolean[])nucleifeatures.getExcluded(), (boolean[])toexclude);
                                if (this.FE_SaveImages && Manual && stainingrgb != null) {
                                    ImageDrawer.Cells(stainingrgb, nuclabels, nucleipos, Colors.CYAN, Colors.RED);
                                    ImageIO.Write(stainingrgb, segmentationdir + "/Scene " + scene2 + " - Visual Check/Scene " + scene2 + " - " + rc.marker + " Nuclei+.png", 6);
                                }
                                nuclist = null;
                                nucleifeatures.Kill();
                                nucleifeatures = null;
                                BufferedImage[] celllist = this.Tools.SeparateNucleiCells(cellccl, cellstaining, autocrop);
                                FichierTabule cellsfeatures = this.ComputeFeatures(cellccl, celllist, !Manual ? null : cellspos, distmap, rc, false, nbCPU);
                                cellsfeatures.Write(featuresdir + "/Scene " + scene2 + " - " + rc.marker + " - Cells.csv", false, ",");
                                MeanIntensities.setColumn(numcol, cellsfeatures.getColumnDouble(10));
                                MeanIntensities.setColumnName(numcol++, rc.marker + " - Cells");
                                ArrayArithmetic.Or((boolean[])toexclude, (boolean[])cellsfeatures.getExcluded(), (boolean[])toexclude);
                                if (this.FE_SaveImages && Manual && stainingrgb != null) {
                                    ImageDrawer.Cells(stainingrgb, cellslabels, cellspos, Colors.CYAN, Colors.RED);
                                    ImageIO.Write(stainingrgb, segmentationdir + "/Scene " + scene2 + " - Visual Check/Scene " + scene2 + " - " + rc.marker + " Cells+.png", 6);
                                }
                                BufferedImage[] cellslist = null;
                                cellsfeatures.Kill();
                                cellsfeatures = null;
                                BufferedImage[] cellsminusnuclist = this.Tools.SeparateCellsMinusNuclei(this.ccl, cellccl, cellstaining, autocrop);
                                FichierTabule cellminusnucfeatures = this.ComputeFeatures(cellccl, cellsminusnuclist, !Manual ? null : ringspos, distmap, rc, false, nbCPU);
                                cellminusnucfeatures.Write(featuresdir + "/Scene " + scene2 + " - " + rc.marker + " - Rings.csv", false, ",");
                                MeanIntensities.setColumn(numcol, cellminusnucfeatures.getColumnDouble(10));
                                MeanIntensities.setColumnName(numcol++, rc.marker + " - Rings");
                                ArrayArithmetic.Or((boolean[])toexclude, (boolean[])cellminusnucfeatures.getExcluded(), (boolean[])toexclude);
                                if (this.FE_SaveImages && Manual && stainingrgb != null) {
                                    ImageDrawer.Cells(stainingrgb, cellslabels, ringspos, Colors.CYAN, Colors.RED);
                                    ImageIO.Write(stainingrgb, segmentationdir + "/Scene " + scene2 + " - Visual Check/Scene " + scene2 + " - " + rc.marker + " Rings+.png", 6);
                                }
                                cellsminusnuclist = null;
                                cellminusnucfeatures.Kill();
                                cellminusnucfeatures = null;
                                BufferedImage[] cellrimlist = this.Tools.SeparateCellsRim(rimdm, cellccl, cellstaining, this.FE_Rim_Size, autocrop);
                                FichierTabule cellrimfeats = this.ComputeFeatures(cellccl, cellrimlist, !Manual ? null : rimpos, distmap, rc, false, nbCPU);
                                cellrimfeats.setSeparator(",");
                                cellrimfeats.Write(featuresdir + "/Scene " + scene2 + " - " + rc.marker + " - Rims.csv", false);
                                MeanIntensities.setColumn(numcol, cellrimfeats.getColumnDouble(10));
                                MeanIntensities.setColumnName(numcol++, rc.marker + " - Rims");
                                ArrayArithmetic.Or((boolean[])toexclude, (boolean[])cellrimfeats.getExcluded(), (boolean[])toexclude);
                                if (this.FE_SaveImages && Manual && stainingrgb != null) {
                                    ImageDrawer.Cells(stainingrgb, cellslabels, rimpos, Colors.CYAN, Colors.RED);
                                    ImageIO.Write(stainingrgb, segmentationdir + "/Scene " + scene2 + " - Visual Check/Scene " + scene2 + " - " + rc.marker + " Rims+.png", 6);
                                }
                                cellrimlist = null;
                                cellrimfeats.Kill();
                                FichierTabule cellrimfeatures = null;
                                break;
                            }
                            default: {
                                throw new Error("Unknown type '" + rc.type + "'. Must not occur, you moron!!!");
                            }
                        }
                        ImageIO.tag = 0;
                        cellstaining = null;
                        nucstaining = null;
                        staining = null;
                        rc = null;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        this.log.addNewException(ex, "Cannot extract features for marker " + rc.marker + " " + rc.round + " " + rc.cycle);
                    }
                    catch (Error e) {
                        e.printStackTrace();
                        this.log.addNewError(e, "Cannot extract features for marker " + rc.marker + " " + rc.round + " " + rc.cycle);
                    }
                }
                Arrays.fill(nucleipos, 1.0f);
                BufferedImage[] nucleilist = null;
                if (this.FE_SubtractBackground) {
                    File file = new File(segmentationdir + "/Scene " + scene2 + " - ZProjectionDAPI SB.png");
                    if (!file.exists()) {
                        throw new Exception("Background subtracted images missing. Rerun segmentation with only background subtraction.");
                    }
                    BufferedImage imwth = ImageIO.Read(file);
                    nucleilist = this.Tools.SeparateNucleiCells(this.ccl, imwth, autocrop);
                    imwth = null;
                    file = null;
                } else {
                    nucleilist = this.Tools.SeparateNucleiCells(this.ccl, imdapi, autocrop);
                }
                FichierTabule nucfeatures = this.ComputeFeatures(this.ccl, nucleilist, nucleipos, distmap, this.rclist.get(0), true, nbCPU);
                Arrays.fill(nucfeatures.getColumnString(7), "+");
                Arrays.fill(nucfeatures.getColumnDouble(8), 1.0);
                nucfeatures.setSeparator(",");
                nucfeatures.Write(featuresdir + "/Scene " + scene2 + " - DAPI.csv", false);
                MeanIntensities.setColumn(numcol, nucfeatures.getColumnDouble(10));
                MeanIntensities.setColumnName(numcol++, "Dapi");
                for (i3 = 1; i3 < 5; ++i3) {
                    MeanIntensities.setColumn(i3, nucfeatures.getColumnInt(i3));
                }
                for (i3 = 5; i3 < 7; ++i3) {
                    MeanIntensities.setColumn(i3, nucfeatures.getColumnDouble(i3));
                }
                ArrayArithmetic.Or((boolean[])toexclude, (boolean[])nucfeatures.getExcluded(), (boolean[])toexclude);
                nucleilist = null;
                nucfeatures.Kill();
                nucfeatures = null;
                for (i3 = 0; i3 < toexclude.length; ++i3) {
                    if (toexclude[i3]) {
                        MeanIntensities.setValue(i3, 7, "x");
                        continue;
                    }
                    MeanIntensities.setValue(i3, 7, "o");
                }
                MeanIntensities.setValue(0, 7, this.Copyright);
                MeanIntensities.Write(featuresdir + "/Scene " + scene2 + " - Mean Intensities.csv", false, ",");
                stainingrgb = null;
                stainingbyte = null;
                cells = null;
                nuclei = null;
                imdapi = null;
                distmap = null;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.log.addNewException(ex, "Cannot extract features from scene " + scene2);
            }
            catch (Error e) {
                e.printStackTrace();
                this.log.addNewError(e, "Cannot extract features from scene " + scene2);
            }
        }
        System.out.println("Features extraction: 1st pass done.\n");
        this.log.addComment("Features extraction: 1st pass done.\n");
        this.allocator.ClearAll(true);
        if (!litemode && RestoreFound) {
            this.restore.Python_Path = this.FE_Python_Path;
            if (!this.restore.Restore(scenes, this.rclist, featuresdir, this.log)) {
                return;
            }
            for (String scene2 : scenes) {
                FichierTabule thresholds = new FichierTabule(featuresdir + "/Scene " + scene2 + " - Restore Thresholds.csv", true, ",");
                int colssc = thresholds.ColumnNumber("SSC");
                int colgmm = thresholds.ColumnNumber("GMM");
                BufferedImage imdapi = ImageIO.Read(segmentationdir + "/Scene " + scene2 + " - ZProjectionDAPI.png");
                BufferedImage nuclei = ImageIO.LoadLabels(segmentationdir + "/Scene " + scene2 + " - Nuclei Labels");
                this.ccl.ImportLabels(((DataBufferInt)nuclei.getRaster().getDataBuffer()).getData(), nuclei.getWidth(), nuclei.getHeight());
                this.ccl.ComputeBoundingBoxes();
                int[] nuclabels = this.ccl.Labels1D();
                int[] nucsizes = this.ccl.Sizes();
                float[] nucleipos = new float[this.ccl.ConnectedComponentsNumber() + 1];
                BufferedImage cells = ImageIO.LoadLabels(segmentationdir + "/Scene " + scene2 + " - Cell Labels");
                cellccl.ImportLabels(((DataBufferInt)cells.getRaster().getDataBuffer()).getData(), cells.getWidth(), cells.getHeight());
                System.arraycopy(((DataBufferInt)cells.getRaster().getDataBuffer()).getData(), 0, cellccl.Labels1D(), 0, cellccl.Labels1D().length);
                cellccl.ComputeBoundingBoxes();
                int[] cellslabels = cellccl.Labels1D();
                int[] cellsizes = cellccl.Sizes();
                float[] cellspos = new float[cellccl.ConnectedComponentsNumber() + 1];
                float[] ringspos = new float[cellccl.ConnectedComponentsNumber() + 1];
                float[] rimspos = new float[cellccl.ConnectedComponentsNumber() + 1];
                int[] rimcount = new int[cellccl.ConnectedComponentsNumber() + 1];
                this.dmc.ComputeGrayLevel(cells, this.sem3, true);
                float[] rimdm = this.dmc.getMontanariMap1D();
                stainingrgb = ImageNew.Same((BufferedImage)cells, (int)5);
                BufferedImage stainingbyte = ImageNew.Same((BufferedImage)imdapi, (int)10);
                BufferedImage stainingce = ImageNew.Same((BufferedImage)imdapi);
                for (CycIF_RoundCycle rc : this.rclist) {
                    double threshold;
                    if (rc.mode.equals("Manual")) continue;
                    String marker = rc.marker + " - " + rc.restoretype;
                    double[] values = new double[rc.exclusive.size() * (this.FE_Restore_SSC_Only ? 1 : 2)];
                    int nb = 0;
                    for (String exc : rc.exclusive) {
                        String target = exc.replace("/", " - ");
                        thresholds.SelectWhere("Scene", 0, "Scene " + scene2);
                        thresholds.SelectFromSelectionWhere("Marker1", 0, marker);
                        thresholds.SelectFromSelectionWhere("Marker2", 0, target);
                        if (thresholds.nbSelected() != 1) {
                            throw new Exception(thresholds.nbSelected() + " selected row instead of 1 for Scene " + scene2 + ", " + marker + " vs " + target);
                        }
                        values[nb++] = thresholds.getValueDouble(thresholds.FirstSelected(), colssc);
                        if (this.FE_Restore_SSC_Only) continue;
                        values[nb++] = thresholds.getValueDouble(thresholds.FirstSelected(), colgmm);
                    }
                    Arrays.sort(values);
                    switch (values.length) {
                        case 0: {
                            throw new Exception("Must not occur!");
                        }
                        case 1: {
                            threshold = values[0];
                            break;
                        }
                        case 2: {
                            threshold = (values[0] + values[1]) / 2.0;
                            break;
                        }
                        default: {
                            int median = values.length >> 1;
                            threshold = values.length % 2 == 1 ? values[median] : (values[median - 1] + values[median]) / 2.0;
                        }
                    }
                    System.out.println("Restore - Scene " + scene2 + ", Marker " + rc.marker + " " + Arrays.toString(values) + " => Threshold=" + threshold);
                    this.log.addComment("Restore - Scene " + scene2 + ", marker " + rc.marker + " " + Arrays.toString(values) + " => Threshold=" + threshold);
                    BufferedImage staining = ImageIO.Read(segmentationdir + "/Scene " + scene2 + " - " + rc.marker + ".png");
                    this.Tools.PrepareImages(staining, stainingce, stainingbyte, stainingrgb, nbCPU);
                    staining = null;
                    BufferedImage nucstaining = null;
                    BufferedImage cellstaining = null;
                    if (this.FE_SubtractBackground) {
                        nucstaining = ImageIO.Read(segmentationdir + "/Scene " + scene2 + " - " + rc.marker + " SBcells.png");
                        cellstaining = ImageIO.Read(segmentationdir + "/Scene " + scene2 + " - " + rc.marker + " SBnuclei.png");
                    } else {
                        nucstaining = cellstaining = this.Tools.LoadImage(registrationdir, scene2, rc.round, rc.cycle);
                    }
                    this.FindPositive(nucstaining, cellstaining, nuclabels, nucsizes, cellslabels, cellsizes, rimcount, rimdm, rc.marker, scene2, (int)(threshold + 0.5), rc.maxthreshold, nucleipos, cellspos, ringspos, rimspos, segmentationdir, nbCPU);
                    FichierTabule features = null;
                    switch (rc.type) {
                        case "Nuclei": {
                            features = new FichierTabule(featuresdir + "/Scene " + scene2 + " - " + rc.marker + " - Nuclei.csv", true, ",");
                            features.setColumn(8, nucleipos);
                            this.UpdateFeatures(features, threshold, rc);
                            features.Write(featuresdir + "/Scene " + scene2 + " - " + rc.marker + " - Nuclei.csv", false, ",");
                            if (this.FE_SaveImages) {
                                ImageDrawer.Cells(stainingrgb, nuclabels, features.getColumnString("Positive"), Colors.CYAN, Colors.RED);
                                ImageIO.Write(stainingrgb, segmentationdir + "/Scene " + scene2 + " - Visual Check/Scene " + scene2 + " - " + rc.marker + " Rims+.png", 6);
                            }
                            features.Kill();
                            break;
                        }
                        case "Cells": {
                            features = new FichierTabule(featuresdir + "/Scene " + scene2 + " - " + rc.marker + " - Cells.csv", true, ",");
                            features.setColumn(8, cellspos);
                            this.UpdateFeatures(features, threshold, rc);
                            features.Write(featuresdir + "/Scene " + scene2 + " - " + rc.marker + " - Cells.csv", false, ",");
                            if (this.FE_SaveImages) {
                                ImageDrawer.Cells(stainingrgb, cellslabels, features.getColumnString("Positive"), Colors.CYAN, Colors.RED);
                                ImageIO.Write(stainingrgb, segmentationdir + "/Scene " + scene2 + " - Visual Check/Scene " + scene2 + " - " + rc.marker + " Rims+.png", 6);
                            }
                            features.Kill();
                            break;
                        }
                        case "Rings": {
                            features = new FichierTabule(featuresdir + "/Scene " + scene2 + " - " + rc.marker + " - Rings.csv", true, ",");
                            features.setColumn(8, ringspos);
                            this.UpdateFeatures(features, threshold, rc);
                            features.Write(featuresdir + "/Scene " + scene2 + " - " + rc.marker + " - Rings.csv", false, ",");
                            if (this.FE_SaveImages) {
                                ImageDrawer.Cells(stainingrgb, cellslabels, features.getColumnString("Positive"), Colors.CYAN, Colors.RED);
                                ImageIO.Write(stainingrgb, segmentationdir + "/Scene " + scene2 + " - Visual Check/Scene " + scene2 + " - " + rc.marker + " Rims+.png", 6);
                            }
                            features.Kill();
                            break;
                        }
                        case "Rims": {
                            features = new FichierTabule(featuresdir + "/Scene " + scene2 + " - " + rc.marker + " - Rims.csv", true, ",");
                            features.setColumn(8, rimspos);
                            this.UpdateFeatures(features, threshold, rc);
                            features.Write(featuresdir + "/Scene " + scene2 + " - " + rc.marker + " - Rims.csv", false, ",");
                            if (this.FE_SaveImages) {
                                ImageDrawer.Cells(stainingrgb, cellslabels, features.getColumnString("Positive"), Colors.CYAN, Colors.RED);
                                ImageIO.Write(stainingrgb, segmentationdir + "/Scene " + scene2 + " - Visual Check/Scene " + scene2 + " - " + rc.marker + " Rims+.png", 6);
                            }
                            features.Kill();
                            break;
                        }
                        case "All": {
                            features = new FichierTabule(featuresdir + "/Scene " + scene2 + " - " + rc.marker + " - Nuclei.csv", true, ",");
                            features.setColumn(8, nucleipos);
                            this.UpdateFeatures(features, threshold, rc);
                            features.Write(featuresdir + "/Scene " + scene2 + " - " + rc.marker + " - Nuclei.csv", false, ",");
                            if (this.FE_SaveImages) {
                                ImageDrawer.Cells(stainingrgb, nuclabels, features.getColumnString("Positive"), Colors.CYAN, Colors.RED);
                                ImageIO.Write(stainingrgb, segmentationdir + "/Scene " + scene2 + " - Visual Check/Scene " + scene2 + " - " + rc.marker + " Rims+.png", 6);
                            }
                            features.Kill();
                            features = new FichierTabule(featuresdir + "/Scene " + scene2 + " - " + rc.marker + " - Cells.csv", true, ",");
                            features.setColumn(8, cellspos);
                            this.UpdateFeatures(features, threshold, rc);
                            features.Write(featuresdir + "/Scene " + scene2 + " - " + rc.marker + " - Cells.csv", false, ",");
                            if (this.FE_SaveImages) {
                                ImageDrawer.Cells(stainingrgb, cellslabels, features.getColumnString("Positive"), Colors.CYAN, Colors.RED);
                                ImageIO.Write(stainingrgb, segmentationdir + "/Scene " + scene2 + " - Visual Check/Scene " + scene2 + " - " + rc.marker + " Rims+.png", 6);
                            }
                            features.Kill();
                            features = new FichierTabule(featuresdir + "/Scene " + scene2 + " - " + rc.marker + " - Rings.csv", true, ",");
                            features.setColumn(8, ringspos);
                            this.UpdateFeatures(features, threshold, rc);
                            features.Write(featuresdir + "/Scene " + scene2 + " - " + rc.marker + " - Rings.csv", false, ",");
                            if (this.FE_SaveImages) {
                                ImageDrawer.Cells(stainingrgb, cellslabels, features.getColumnString("Positive"), Colors.CYAN, Colors.RED);
                                ImageIO.Write(stainingrgb, segmentationdir + "/Scene " + scene2 + " - Visual Check/Scene " + scene2 + " - " + rc.marker + " Rims+.png", 6);
                            }
                            features.Kill();
                            features = new FichierTabule(featuresdir + "/Scene " + scene2 + " - " + rc.marker + " - Rims.csv", true, ",");
                            features.setColumn(8, rimspos);
                            this.UpdateFeatures(features, threshold, rc);
                            features.Write(featuresdir + "/Scene " + scene2 + " - " + rc.marker + " - Rims.csv", false, ",");
                            if (this.FE_SaveImages) {
                                ImageDrawer.Cells(stainingrgb, cellslabels, features.getColumnString("Positive"), Colors.CYAN, Colors.RED);
                                ImageIO.Write(stainingrgb, segmentationdir + "/Scene " + scene2 + " - Visual Check/Scene " + scene2 + " - " + rc.marker + " Rims+.png", 6);
                            }
                            features.Kill();
                            break;
                        }
                        default: {
                            throw new Exception("Must not occur.");
                        }
                    }
                    features = null;
                }
            }
            System.out.println("Features extraction: 2nd pass (Restore updates) done.\n");
            this.log.addComment("Features extraction: 2nd pass (Restore updates) done.\n");
        }
        if (!litemode) {
            this.Concatenations(scenes, featuresdir);
        }
        if (!litemode && CellTypeGo) {
            for (String scene2 : scenes) {
                FichierTabule table = new FichierTabule(featuresdir + "/Scene " + scene2 + " - Positiveness.csv", true, ",");
                this.celltypes.Build(inputdir, this.rclist, table, featuresdir, this.log);
                FichierTabule expres = this.celltypes.Run(this.log);
                expres.Write(featuresdir + "/Scene " + scene2 + " - Cell Types.csv", false, ",");
            }
        }
        if (!litemode) {
            System.out.println("Features extraction done.\n" + this.Copyright + "\n");
            this.log.addComment("Features extraction done.\n" + this.Copyright);
        } else {
            System.out.println("Preliminary/Temporary features extraction done.\n" + this.Copyright + "\n");
            this.log.addComment("Preliminary/Temporary features extraction done.\n" + this.Copyright);
        }
        if (!litemode) {
            this.napari.Napari(scenes, this.rclist, segmentationdir, this.log);
        }
    }

    private void FindPositive(BufferedImage nucstaining, BufferedImage cellstaining, int[] nuclabels, int[] nucsizes, int[] cellslabels, int[] cellsizes, int[] rimcount, float[] rimdm, String marker, String scene, int minthreshold, int maxthreshold, float[] nucleipos, float[] cellspos, float[] ringspos, float[] rimpos, String segmentationdir, int nbCPU) throws IOException {
        int i2;
        BufferedImage postain = this.binary.Filter(nucstaining, minthreshold, nbCPU);
        ImageComparator.Compare((BufferedImage)nucstaining, (String)"<=", (int)maxthreshold, (BufferedImage)postain, (int)0, (BufferedImage)postain);
        short[] sbpos = ((DataBufferUShort)postain.getRaster().getDataBuffer()).getData();
        if (this.FE_SaveImages) {
            ImageIO.Write(ImageConverter.UShortGrayToBinary((BufferedImage)postain), segmentationdir + "/Scene " + scene + " - " + marker + "+ Area Nuclei.png", 6);
        }
        Arrays.fill(nucleipos, 0.0f);
        for (i2 = 0; i2 < sbpos.length; ++i2) {
            if (sbpos[i2] == 0) continue;
            int n = nuclabels[i2];
            nucleipos[n] = nucleipos[n] + 1.0f;
        }
        for (i2 = 0; i2 < nucleipos.length; ++i2) {
            int n = i2;
            nucleipos[n] = nucleipos[n] / (float)nucsizes[i2];
        }
        postain = this.binary.Filter(cellstaining, minthreshold, nbCPU);
        ImageComparator.Compare((BufferedImage)cellstaining, (String)"<=", (int)maxthreshold, (BufferedImage)postain, (int)0, (BufferedImage)postain);
        sbpos = ((DataBufferUShort)postain.getRaster().getDataBuffer()).getData();
        if (this.FE_SaveImages) {
            ImageIO.Write(ImageConverter.UShortGrayToBinary((BufferedImage)postain), segmentationdir + "/Scene " + scene + " - " + marker + "+ Area Cells.png", 6);
        }
        Arrays.fill(cellspos, 0.0f);
        for (i2 = 0; i2 < sbpos.length; ++i2) {
            if (sbpos[i2] == 0) continue;
            int n = cellslabels[i2];
            cellspos[n] = cellspos[n] + 1.0f;
        }
        for (i2 = 0; i2 < cellspos.length; ++i2) {
            int n = i2;
            cellspos[n] = cellspos[n] / (float)cellsizes[i2];
        }
        Arrays.fill(ringspos, 0.0f);
        for (i2 = 0; i2 < sbpos.length; ++i2) {
            if (sbpos[i2] == 0 || cellslabels[i2] == 0 || cellslabels[i2] == nuclabels[i2]) continue;
            int n = cellslabels[i2];
            ringspos[n] = ringspos[n] + 1.0f;
        }
        for (i2 = 0; i2 < cellspos.length; ++i2) {
            if (cellsizes[i2] - nucsizes[i2] == 0) {
                ringspos[i2] = 0.0f;
                continue;
            }
            int n = i2;
            ringspos[n] = ringspos[n] / (float)(cellsizes[i2] - nucsizes[i2]);
        }
        Arrays.fill(rimpos, 0.0f);
        Arrays.fill(rimcount, 0);
        for (i2 = 0; i2 < sbpos.length; ++i2) {
            if (cellslabels[i2] == 0 || !(rimdm[i2] <= this.FE_Rim_Size)) continue;
            int n = cellslabels[i2];
            rimcount[n] = rimcount[n] + 1;
            if (sbpos[i2] == 0) continue;
            int n2 = cellslabels[i2];
            rimpos[n2] = rimpos[n2] + 1.0f;
        }
        for (i2 = 0; i2 < rimpos.length; ++i2) {
            if (rimcount[i2] == 0) {
                rimpos[i2] = 0.0f;
                continue;
            }
            int n = i2;
            rimpos[n] = rimpos[n] / (float)rimcount[i2];
        }
        postain = null;
    }

    private void UpdateFeatures(FichierTabule features, double threshold, CycIF_RoundCycle rc) {
        int colpos = features.ColumnNumber("Positive");
        int colmean = features.ColumnNumber("MeanIntensity");
        int coloverlap = features.ColumnNumber("Overlap");
        double min = Double.MAX_VALUE;
        for (int row = 1; row < features.Height(); ++row) {
            if (!features.getValueString(row, colpos).equals("RestoreToCome")) continue;
            double mean = features.getValueDouble(row, colmean);
            if ((double)rc.maxthreshold <= mean) {
                features.setValue(row, colpos, "x");
                continue;
            }
            if (0.5 <= features.getValueDouble(row, coloverlap) || threshold <= mean) {
                features.setValue(row, colpos, "+");
                if (!(mean < min)) continue;
                min = mean;
                continue;
            }
            features.setValue(row, colpos, "-");
        }
        double[] column = features.getColumnDouble("NormalizedMeanIntensity");
        ArrayArithmetic.Divide((double[])column, (double)min, (double[])column);
    }

    private synchronized void setFeaturesParameters(DZMfeatures dzm, Haralick haralick, LocalBinaryPattern lbp, PatternSpectrum ps, SZMfeatures szm, ShapeIndexesComputer sic) {
        dzm.Parameters(64, 1, this.sem3.Clone(), false, false, new LinearGLR(64), 0, true);
        haralick.Parameters(new LinearGLR(64), 64, 0);
        lbp.Parameters(this.selbp8.Clone(), 2, 0);
        ps.Parameters(1, 7, 2, 0, -2);
        szm.Parameters(64, 1, new LinearGLR(64), 0, true);
        sic.Indexes[3] = null;
        sic.Indexes[5] = null;
        sic.Indexes[10] = null;
        Arrays.fill(sic.Indexes, 13, 20, null);
        sic.Indexes[22] = null;
        sic.Indexes[24] = null;
        sic.Indexes[25] = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FichierTabule ComputeFeatures(UnionFindCcl ccl, BufferedImage[] images, float[] overlap, float[] distmap, CycIF_RoundCycle rc, boolean nuclei, int nbCPU) throws IOException {
        int nbPS = this.ps.Features().length;
        int nbLBP = this.lbp.Features().length;
        int nbHaralick = this.haralick.Features().length;
        int nbSZM = this.szm.Features().length;
        int nbDZM = this.dzm.Features().length;
        int nbSI = this.sic.Features().length;
        int[] types = new int[27 + (this.FE_BiasedFeaturesOnly ? 0 : nbPS + nbLBP + nbHaralick + nbSZM + nbDZM + (nuclei ? nbSI + 3 : 0))];
        Arrays.fill(types, 1);
        Arrays.fill(types, 0, 5, 0);
        types[7] = 2;
        types[9] = 0;
        Arrays.fill(types, 15, 27, 0);
        FichierTabule features = new FichierTabule(ccl.ConnectedComponentsNumber() + 1, types, "");
        features.setColumnName(0, "Label");
        features.setColumnName(1, "MinX");
        features.setColumnName(2, "MinY");
        features.setColumnName(3, "MaxX");
        features.setColumnName(4, "MaxY");
        features.setColumnName(5, "CentroidX");
        features.setColumnName(6, "CentroidY");
        features.setColumnName(7, "Positive");
        features.setColumnName(8, "Overlap");
        features.setColumnName(9, "Surface");
        features.setColumnName(10, "MeanIntensity");
        features.setColumnName(11, "NormalizedMeanIntensity");
        features.setColumnName(12, "VarianceIntensity");
        features.setColumnName(13, "SkewnessIntensity");
        features.setColumnName(14, "KurtosisIntensity");
        features.setColumnName(15, "Rank01");
        features.setColumnName(16, "Rank02.5");
        features.setColumnName(17, "Rank05");
        features.setColumnName(18, "Rank10");
        features.setColumnName(19, "Rank25");
        features.setColumnName(20, "Rank50");
        features.setColumnName(21, "Rank75");
        features.setColumnName(22, "Rank90");
        features.setColumnName(23, "Rank95");
        features.setColumnName(24, "Rank97.5");
        features.setColumnName(25, "Rank99");
        features.setColumnName(26, "DistanceFromBorder");
        features.Fill(7, "x");
        if (!this.FE_BiasedFeaturesOnly) {
            int i2;
            int pos = 27;
            String[] names = this.ps.FeaturesNames();
            for (i2 = 0; i2 < nbPS; ++i2) {
                features.setColumnName(pos + i2, names[i2]);
            }
            pos += nbPS;
            names = this.lbp.FeaturesNames();
            for (i2 = 0; i2 < nbLBP; ++i2) {
                features.setColumnName(pos + i2, names[i2]);
            }
            pos += nbLBP;
            names = this.haralick.FeaturesNames();
            for (i2 = 0; i2 < nbHaralick; ++i2) {
                features.setColumnName(pos + i2, names[i2]);
            }
            pos += nbHaralick;
            names = this.szm.FeaturesNames();
            for (i2 = 0; i2 < nbSZM; ++i2) {
                features.setColumnName(pos + i2, names[i2]);
            }
            pos += nbSZM;
            names = this.dzm.FeaturesNames();
            for (i2 = 0; i2 < nbDZM; ++i2) {
                features.setColumnName(pos + i2, names[i2]);
            }
            if (nuclei) {
                pos += nbDZM;
                names = this.sic.FeaturesNames();
                for (i2 = 0; i2 < nbSI; ++i2) {
                    features.setColumnName(pos + i2, names[i2]);
                }
                features.setColumnName(pos + nbSI, "Orientation");
                features.setColumnName(pos + nbSI + 1, "Main Axis");
                features.setColumnName(pos + nbSI + 2, "Secondary Axis");
            }
        }
        features.setValue(0, 7, this.Copyright);
        int step = (features.Height() - 1) / this.nbThreads;
        this.nbFreeThreads = 0;
        int t = 0;
        for (t = 0; t < this.nbThreads - 1; ++t) {
            this.threads[t].Parameters(features, images, t * step, (t + 1) * step, overlap, ccl, distmap, rc, nuclei);
            Object i3 = this.threads[t].lock;
            synchronized (i3) {
                this.threads[t].lock.notify();
                continue;
            }
        }
        this.threads[t].Parameters(features, images, t * step, features.Height(), overlap, ccl, distmap, rc, nuclei);
        Object i3 = this.threads[t].lock;
        synchronized (i3) {
            this.threads[t].lock.notify();
        }
        i3 = this;
        synchronized (i3) {
            while (this.nbFreeThreads != this.nbThreads) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        if (rc.mode.equals("Manual")) {
            double[] means = features.getColumnDouble(11);
            double minmean = Double.MAX_VALUE;
            for (int i4 = 1; i4 < means.length; ++i4) {
                if (!features.getValueString(i4, 7).equals("+") || !(means[i4] < minmean)) continue;
                minmean = means[i4];
            }
            if (65536.0 < minmean) {
                minmean = rc.minthreshold;
            }
            ArrayArithmetic.Divide((double[])means, (double)minmean, (double[])means);
        }
        features.SelectWhere(7, 0, "?");
        features.ExtendSelectionWhere(7, 0, "x");
        features.ExcludeSelected();
        return features;
    }

    private void Concatenations(List<String> scenes, String featuresdir) throws Exception {
        for (String scene : scenes) {
            int i2;
            int nbColumns = 8;
            Iterator<CycIF_RoundCycle> rciter = this.rclist.iterator();
            block29: while (rciter.hasNext()) {
                switch (rciter.next().type) {
                    case "All": {
                        nbColumns += 4;
                        continue block29;
                    }
                    case "Nuclei": 
                    case "Cells": 
                    case "Rims": 
                    case "Rings": {
                        ++nbColumns;
                        continue block29;
                    }
                }
                throw new IllegalStateException("How the F*** is this happening???");
            }
            FichierTabule normint = null;
            FichierTabule positiveness = null;
            int column = 8;
            CycIF_RoundCycle rc = null;
            rciter = this.rclist.iterator();
            block30: while (rciter.hasNext()) {
                try {
                    rc = rciter.next();
                    switch (rc.type) {
                        case "Nuclei": {
                            FichierTabule marker = new FichierTabule(featuresdir + "/Scene " + scene + " - " + rc.marker + " - Nuclei.csv", true, ",");
                            if (positiveness == null) {
                                normint = this.Tools.CreateFeaturesFile(marker, nbColumns, 1);
                                positiveness = this.Tools.CreateFeaturesFile(marker, nbColumns, 2);
                            }
                            positiveness.setColumnName(column, rc.marker + " - Nuclei");
                            positiveness.setColumn(column, marker.getColumnString(7));
                            positiveness.setValue(0, column, "");
                            normint.setColumnName(column, rc.marker + " - Nuclei");
                            normint.setColumn(column++, marker.getColumnDouble(11));
                            marker.Kill();
                            marker = null;
                            continue block30;
                        }
                        case "Cells": {
                            FichierTabule marker = new FichierTabule(featuresdir + "/Scene " + scene + " - " + rc.marker + " - Cells.csv", true, ",");
                            if (positiveness == null) {
                                normint = this.Tools.CreateFeaturesFile(marker, nbColumns, 1);
                                positiveness = this.Tools.CreateFeaturesFile(marker, nbColumns, 2);
                            }
                            positiveness.setColumnName(column, rc.marker + " - Cells");
                            positiveness.setColumn(column, marker.getColumnString(7));
                            positiveness.setValue(0, column, "");
                            normint.setColumnName(column, rc.marker + " - Cells");
                            normint.setColumn(column++, marker.getColumnDouble(11));
                            marker.Kill();
                            marker = null;
                            continue block30;
                        }
                        case "Rims": {
                            FichierTabule marker = new FichierTabule(featuresdir + "/Scene " + scene + " - " + rc.marker + " - Rims.csv", true, ",");
                            if (positiveness == null) {
                                normint = this.Tools.CreateFeaturesFile(marker, nbColumns, 1);
                                positiveness = this.Tools.CreateFeaturesFile(marker, nbColumns, 2);
                            }
                            positiveness.setColumnName(column, rc.marker + " - Rims");
                            positiveness.setColumn(column, marker.getColumnString(7));
                            positiveness.setValue(0, column, "");
                            normint.setColumnName(column, rc.marker + " - Rims");
                            normint.setColumn(column++, marker.getColumnDouble(11));
                            marker.Kill();
                            marker = null;
                            continue block30;
                        }
                        case "Rings": {
                            FichierTabule marker = new FichierTabule(featuresdir + "/Scene " + scene + " - " + rc.marker + " - Rings.csv", true, ",");
                            if (positiveness == null) {
                                normint = this.Tools.CreateFeaturesFile(marker, nbColumns, 1);
                                positiveness = this.Tools.CreateFeaturesFile(marker, nbColumns, 2);
                            }
                            positiveness.setColumnName(column, rc.marker + " - Rings");
                            positiveness.setColumn(column, marker.getColumnString(7));
                            positiveness.setValue(0, column, "");
                            normint.setColumnName(column, rc.marker + " - Rings");
                            normint.setColumn(column++, marker.getColumnDouble(11));
                            marker.Kill();
                            marker = null;
                            continue block30;
                        }
                        case "All": {
                            FichierTabule marker = new FichierTabule(featuresdir + "/Scene " + scene + " - " + rc.marker + " - Nuclei.csv", true, ",");
                            if (positiveness == null) {
                                normint = this.Tools.CreateFeaturesFile(marker, nbColumns, 1);
                                positiveness = this.Tools.CreateFeaturesFile(marker, nbColumns, 2);
                            }
                            positiveness.setColumnName(column, rc.marker + " - Nuclei");
                            positiveness.setColumn(column, marker.getColumnString(7));
                            positiveness.setValue(0, column, "");
                            normint.setColumnName(column, rc.marker + " - Nuclei");
                            normint.setColumn(column++, marker.getColumnDouble(11));
                            marker.Kill();
                            marker = null;
                            marker = new FichierTabule(featuresdir + "/Scene " + scene + " - " + rc.marker + " - Cells.csv", true, ",");
                            positiveness.setColumnName(column, rc.marker + " - Cells");
                            positiveness.setColumn(column, marker.getColumnString(7));
                            positiveness.setValue(0, column, "");
                            normint.setColumnName(column, rc.marker + " - Cells");
                            normint.setColumn(column++, marker.getColumnDouble(11));
                            marker.Kill();
                            marker = null;
                            marker = new FichierTabule(featuresdir + "/Scene " + scene + " - " + rc.marker + " - Rims.csv", true, ",");
                            positiveness.setColumnName(column, rc.marker + " - Rims");
                            positiveness.setColumn(column, marker.getColumnString(7));
                            positiveness.setValue(0, column, "");
                            normint.setColumnName(column, rc.marker + " - Rims");
                            normint.setColumn(column++, marker.getColumnDouble(11));
                            marker.Kill();
                            marker = null;
                            marker = new FichierTabule(featuresdir + "/Scene " + scene + " - " + rc.marker + " - Rings.csv", true, ",");
                            positiveness.setColumnName(column, rc.marker + " - Rings");
                            positiveness.setColumn(column, marker.getColumnString(7));
                            positiveness.setValue(0, column, "");
                            normint.setColumnName(column, rc.marker + " - Rings");
                            normint.setColumn(column++, marker.getColumnDouble(11));
                            marker.Kill();
                            marker = null;
                            continue block30;
                        }
                    }
                    throw new IllegalStateException("How/Why the F*** is this happening???");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    this.log.addNewException(ex, "Cannot compute positiveness for: scene " + scene + " " + rc.marker);
                }
                catch (Error e) {
                    e.printStackTrace();
                    this.log.addNewError(e, "Cannot compute positiveness for: scene " + scene + " " + rc.marker);
                }
            }
            FichierTabule meanint = new FichierTabule(featuresdir + "/Scene " + scene + " - Mean Intensities.csv", true, ",");
            positiveness.setColumn(7, meanint.getColumnString(7));
            positiveness.setValue(0, 7, this.Copyright);
            for (i2 = 1; i2 < 5; ++i2) {
                positiveness.setColumn(i2, meanint.getColumnInt(i2));
            }
            for (i2 = 5; i2 < 7; ++i2) {
                positiveness.setColumn(i2, meanint.getColumnDouble(i2));
            }
            positiveness.Write(featuresdir + "/Scene " + scene + " - Positiveness.csv", false, ",");
            positiveness.Kill();
            positiveness = null;
            normint.setColumn(7, meanint.getColumnString(7));
            normint.setValue(0, 7, this.Copyright);
            for (i2 = 1; i2 < 5; ++i2) {
                normint.setColumn(i2, meanint.getColumnInt(i2));
            }
            for (i2 = 5; i2 < 7; ++i2) {
                normint.setColumn(i2, meanint.getColumnDouble(i2));
            }
            normint.Write(featuresdir + "/Scene " + scene + " - Normalized Mean Intensities.csv", false, ",");
            normint.Kill();
            normint = null;
            meanint.Kill();
            meanint = null;
        }
    }

    private synchronized void addFreeThread() {
        ++this.nbFreeThreads;
        this.notify();
    }

    private class ComputeFeaturesThread
    extends Thread {
        private final ImageFeatures IFt = new ImageFeatures();
        private final BasicMeasures cft_basic;
        private final DZMfeatures cft_dzm;
        private final Haralick cft_haralick;
        private final LocalBinaryPattern cft_lbp;
        private final PatternSpectrum cft_ps;
        private final SZMfeatures cft_szm;
        private final ShapeIndexesComputer cft_sic;
        private final int nbPS;
        private final int nbLBP;
        private final int nbHaralick;
        private final int nbSZM;
        private final int nbDZM;
        private final int nbSI;
        private final LogFile log;
        private int immin = 0;
        private int immax = 0;
        private FichierTabule features = null;
        private BufferedImage[] images = null;
        private float[] overlap = null;
        private CycIF_RoundCycle rc = null;
        private int[] minx = null;
        private int[] maxx = null;
        private int[] miny = null;
        private int[] maxy = null;
        private float[] distmap = null;
        private boolean nuclei = false;
        public final Object lock = new Object();
        private boolean Kill = false;

        public ComputeFeaturesThread(int number, LogFile log) {
            this.cft_basic = new BasicMeasures();
            this.cft_dzm = new DZMfeatures();
            this.cft_haralick = new Haralick();
            this.cft_lbp = new LocalBinaryPattern();
            this.cft_ps = new PatternSpectrum();
            this.cft_szm = new SZMfeatures();
            this.cft_sic = new ShapeIndexesComputer();
            CycIF_Features.this.setFeaturesParameters(this.cft_dzm, this.cft_haralick, this.cft_lbp, this.cft_ps, this.cft_szm, this.cft_sic);
            this.nbPS = this.cft_ps.Features().length;
            this.nbLBP = this.cft_lbp.Features().length;
            this.nbHaralick = this.cft_haralick.Features().length;
            this.nbSZM = this.cft_szm.Features().length;
            this.nbDZM = this.cft_dzm.Features().length;
            this.nbSI = this.cft_sic.Features().length;
            this.log = log;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Kill() {
            this.Kill = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void Parameters(FichierTabule features, BufferedImage[] images, int immin, int immax, float[] overlap, UnionFindCcl ccl, float[] distmap, CycIF_RoundCycle rc, boolean nuclei) {
            this.features = features;
            this.images = images;
            this.immin = immin;
            this.immax = immax;
            this.overlap = overlap;
            this.distmap = distmap;
            this.rc = rc;
            this.nuclei = nuclei;
            this.minx = ccl.minx();
            this.maxx = ccl.maxx();
            this.miny = ccl.miny();
            this.maxy = ccl.maxy();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block12: while (true) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        CycIF_Features.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.Kill) {
                    return;
                }
                int im = this.immin;
                while (true) {
                    if (im >= this.immax) continue block12;
                    this.features.setValue(im, 0, im);
                    if (this.images[im] != null) {
                        try {
                            BufferedImage image = this.images[im];
                            this.features.setValue(im, 1, this.minx[im]);
                            this.features.setValue(im, 2, this.miny[im]);
                            this.features.setValue(im, 3, this.maxx[im]);
                            this.features.setValue(im, 4, this.maxy[im]);
                            this.features.setValue(im, 8, this.overlap == null ? -1.0 : (double)this.overlap[im]);
                            this.features.setValue(im, 26, this.distmap == null ? -1 : (int)this.distmap[im]);
                            if (ImageTools.isBlack((BufferedImage)image)) {
                                this.features.setValue(im, 7, "?");
                            } else {
                                this.cft_basic.Compute(image, true);
                                this.features.setValue(im, 5, (double)this.minx[im] + this.cft_basic.Centroid.X);
                                this.features.setValue(im, 6, (double)this.miny[im] + this.cft_basic.Centroid.Y);
                                this.IFt.Moments(image, 0);
                                this.features.setValue(im, 9, (int)this.IFt.Size());
                                this.features.setValue(im, 10, this.IFt.Average());
                                this.features.setValue(im, 11, this.IFt.Average());
                                this.features.setValue(im, 12, this.IFt.Variance());
                                this.features.setValue(im, 13, this.IFt.Skewness());
                                this.features.setValue(im, 14, this.IFt.Kurtosis());
                                if ((int)this.IFt.Size() < 53) {
                                    this.features.setValue(im, 7, "?");
                                } else {
                                    this.IFt.Ranks(image, 0);
                                    this.features.setValue(im, 15, (int)this.IFt.Rank01());
                                    this.features.setValue(im, 16, (int)this.IFt.Rank025());
                                    this.features.setValue(im, 17, (int)this.IFt.Rank05());
                                    this.features.setValue(im, 18, (int)this.IFt.Rank10());
                                    this.features.setValue(im, 19, (int)this.IFt.Rank25());
                                    this.features.setValue(im, 20, (int)this.IFt.Rank50());
                                    this.features.setValue(im, 21, (int)this.IFt.Rank75());
                                    this.features.setValue(im, 22, (int)this.IFt.Rank90());
                                    this.features.setValue(im, 23, (int)this.IFt.Rank95());
                                    this.features.setValue(im, 24, (int)this.IFt.Rank975());
                                    this.features.setValue(im, 25, (int)this.IFt.Rank99());
                                    if (!CycIF_Features.this.FE_BiasedFeaturesOnly) {
                                        int i2;
                                        int pos = 27;
                                        this.cft_ps.Compute(image, null, this.cft_ps.ForbiddenValue(), 1);
                                        double[] feat = this.cft_ps.Features();
                                        for (i2 = 0; i2 < feat.length; ++i2) {
                                            this.features.setValue(im, pos + i2, feat[i2]);
                                        }
                                        pos += this.nbPS;
                                        this.cft_lbp.Compute(image, null, this.cft_lbp.ForbiddenValue(), 1);
                                        feat = this.cft_lbp.Features();
                                        for (i2 = 0; i2 < feat.length; ++i2) {
                                            this.features.setValue(im, pos + i2, feat[i2]);
                                        }
                                        pos += this.nbLBP;
                                        this.cft_haralick.Compute(image, (BufferedImage)null, this.cft_haralick.ForbiddenValue(), 1);
                                        feat = this.cft_haralick.Features();
                                        for (i2 = 0; i2 < feat.length; ++i2) {
                                            this.features.setValue(im, pos + i2, feat[i2]);
                                        }
                                        pos += this.nbHaralick;
                                        this.cft_szm.Compute(image, null, this.cft_szm.ForbiddenValue(), 1);
                                        feat = this.cft_szm.Features();
                                        for (i2 = 0; i2 < feat.length; ++i2) {
                                            this.features.setValue(im, pos + i2, feat[i2]);
                                        }
                                        pos += this.nbSZM;
                                        this.cft_dzm.Compute(image, null, this.cft_dzm.ForbiddenValue(), 1);
                                        feat = this.cft_dzm.Features();
                                        for (i2 = 0; i2 < feat.length; ++i2) {
                                            this.features.setValue(im, pos + i2, feat[i2]);
                                        }
                                        if (this.nuclei) {
                                            pos += this.nbDZM;
                                            this.cft_sic.Compute(image, null, this.cft_sic.ForbiddenValue(), 1);
                                            feat = this.cft_sic.Features();
                                            for (i2 = 0; i2 < feat.length; ++i2) {
                                                this.features.setValue(im, pos + i2, feat[i2]);
                                            }
                                            Measures2D measures = new Measures2D(image);
                                            measures.MainAxes();
                                            this.features.setValue(im, pos + feat.length, measures.getAnglePA(true));
                                            this.features.setValue(im, pos + feat.length + 1, measures.MainAxis01.Length());
                                            this.features.setValue(im, pos + feat.length + 2, measures.SecondAxis02.Length());
                                            measures.Kill();
                                            measures = null;
                                        }
                                    }
                                    if (this.rc.minthreshold < 0 || this.rc.mode.equalsIgnoreCase("Restore")) {
                                        this.features.setValue(im, 7, "RestoreToCome");
                                    } else if ((double)this.rc.maxthreshold <= this.IFt.Average()) {
                                        this.features.setValue(im, 7, "x");
                                    } else if (0.5f <= this.overlap[im] || (double)this.rc.minthreshold <= this.IFt.Average()) {
                                        this.features.setValue(im, 7, "+");
                                    } else {
                                        this.features.setValue(im, 7, "-");
                                    }
                                    image = null;
                                }
                            }
                        }
                        catch (Exception ex) {
                            try {
                                ex.printStackTrace();
                                this.log.addNewException(ex, "Cannot extract features from " + (this.nuclei ? "nucleus " : "cell/rim/ring ") + im + " " + this.rc.marker + " " + this.rc.round + " " + this.rc.cycle);
                                this.features.setValue(im, 7, "x");
                            }
                            catch (IOException ex1) {
                                ex1.printStackTrace();
                                System.err.println("Log file not accessible, must not occur => Abort!");
                                System.exit(0);
                            }
                        }
                        catch (Error e) {
                            try {
                                e.printStackTrace();
                                this.log.addNewError(e, "Cannot extract features from " + (this.nuclei ? "nucleus " : "cell/rim/ring ") + im + " " + this.rc.marker + " " + this.rc.round + " " + this.rc.cycle);
                                this.features.setValue(im, 7, "x");
                            }
                            catch (IOException ex) {
                                ex.printStackTrace();
                                System.err.println("Log file not accessible, must not occur => Abort!");
                                System.exit(0);
                            }
                        }
                    }
                    ++im;
                }
                break;
            }
        }
    }

    public static enum Version {
        v1,
        v2;

    }
}

