/*
 * Decompiled with CFR 0.152.
 */
package softwares.ohsu.cyclicif;

import filesAndFolders.fichiersTabules.FichierTabule;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import softwares.ohsu.cyclicif.CycIF_RoundCycle;
import softwares.ohsu.cyclicif.CycIF_Tools;
import utils.LogFile;

public class CycIF_CellTypes {
    private final CycIF_Tools Tools = new CycIF_Tools();
    private int nbExpressions = -1;
    private final List<String> ExpressionResults = new LinkedList<String>();
    private BooleanExpression[] expressions;
    private FichierTabule CellTypes;

    public boolean Test(String inputdir, List<CycIF_RoundCycle> rclist, LogFile log) throws Exception {
        String featuresdir = this.Tools.AddExtension(inputdir, " - Features/");
        File table = new File(featuresdir + "/CellTypesTable.txt");
        if (!table.exists()) {
            log.addComment("Warning - No CellTypesTable.txt file found in '" + inputdir + "' => Cell types won't be computed.");
            System.out.println("\nWarning - No CellTypesTable.txt file found in '" + inputdir + "' => Cell types won't be computed.\n");
            return false;
        }
        System.out.println("\nChecking cell type file '" + table.getAbsolutePath() + "'.");
        log.addComment("\nChecking cell type file '" + table.getAbsolutePath() + "'.");
        this.CheckAndBuild(featuresdir, rclist, null, log);
        System.out.println(this.nbExpressions + " expressions found.");
        System.out.println("Cell type checking done successfully.\n");
        log.addComment("Cell type checking done successfully.");
        return true;
    }

    public void Build(String inputdir, List<CycIF_RoundCycle> rclist, FichierTabule positiveness, String featuresdir, LogFile log) throws Exception {
        if (this.expressions != null) {
            Arrays.fill(this.expressions, null);
            this.expressions = null;
        }
        this.expressions = new BooleanExpression[this.nbExpressions];
        this.CheckAndBuild(featuresdir, rclist, positiveness, log);
        System.out.println("Cell type expressions built successfully.");
        log.addComment("Cell type expressions built successfully.");
    }

    public FichierTabule Run(LogFile log) throws Exception {
        int height = this.CellTypes.Height();
        for (int column = 0; column < this.expressions.length; ++column) {
            BooleanExpression exp = this.expressions[column];
            for (int row = 1; row < height; ++row) {
                try {
                    this.CellTypes.setValue(row, 8 + column, exp.interpret(row) ? "+" : "-");
                    continue;
                }
                catch (IllegalStateException isex) {
                    String msg = isex.getMessage();
                    if (msg.length() != 1) continue;
                    switch (msg.charAt(0)) {
                        case '?': 
                        case 'x': {
                            this.CellTypes.setValue(row, 8 + column, msg);
                            break;
                        }
                        default: {
                            log.addNewException(isex, "Unexpected exception, unknown message: '" + isex.getMessage() + "'.");
                            isex.printStackTrace();
                            throw isex;
                        }
                    }
                    continue;
                }
                catch (Exception ex) {
                    log.addNewException(ex, "Unexpected exception: '" + ex.getMessage() + "'.");
                    ex.printStackTrace();
                    throw ex;
                }
            }
        }
        return this.CellTypes;
    }

    private void CheckAndBuild(String featuresdir, List<CycIF_RoundCycle> rclist, FichierTabule positiveness, LogFile log) throws Exception {
        if (positiveness != null) {
            if (this.CellTypes != null) {
                this.CellTypes.Kill();
                this.CellTypes = null;
            }
            this.CellTypes = this.Tools.CreateFeaturesFile(positiveness, 8 + this.nbExpressions, 2);
            Iterator<String> iter = this.ExpressionResults.iterator();
            int i2 = 8;
            while (iter.hasNext()) {
                this.CellTypes.setColumnName(i2++, iter.next());
            }
        } else {
            this.CellTypes = null;
        }
        Scanner scan = new Scanner(new FileInputStream(featuresdir + "/CellTypesTable.txt"));
        this.ExpressionResults.clear();
        this.nbExpressions = 0;
        int nb = 1;
        while (scan.hasNextLine()) {
            IllegalArgumentException ex;
            String message;
            String line = scan.nextLine();
            if (line.isEmpty()) {
                if (positiveness == null) {
                    String message2 = "Warning - CellTypesTable.txt, line " + nb + " is empty.";
                    log.addComment(message2);
                    System.out.println(message2);
                }
                ++nb;
                continue;
            }
            if (line.charAt(0) == '#' || line.startsWith("//")) continue;
            if (positiveness == null && (line.isEmpty() || line.equalsIgnoreCase("\n") || line.equalsIgnoreCase("\r") || line.equalsIgnoreCase("\t") || line.equalsIgnoreCase(" "))) {
                log.addComment("Warning - CellTypesTable.txt, line " + nb + " is empty.");
                System.out.println("Warning - CellTypesTable.txt, line " + nb + " is empty.");
                ++nb;
                continue;
            }
            int equalpos = line.indexOf("=>");
            if (equalpos <= 0) {
                String message3 = "'=>' not found in line " + line + ", cell type equation: '" + line + "'.";
                IllegalArgumentException ex2 = new IllegalArgumentException(message3);
                log.addNewException(ex2, message3);
                throw ex2;
            }
            String expression = line.substring(0, equalpos);
            String result = line.substring(equalpos + 2, line.length()).replace("\n", "").replace(" ", "");
            if (result.contains("_")) {
                message = "Expression result cannot contain character '_' in line " + line + ": '" + result + "'.";
                ex = new IllegalArgumentException(message);
                log.addNewException(ex, message);
                throw ex;
            }
            if (result.contains("-")) {
                message = "Expression result cannot contain character '-' in line " + line + ": '" + result + "'.";
                ex = new IllegalArgumentException(message);
                log.addNewException(ex, message);
                throw ex;
            }
            this.ExpressionResults.add(result);
            expression = expression.replace("(", " ( ");
            expression = expression.replace(")", " ) ");
            expression = expression.replace(" and ", " & ");
            expression = expression.replace(" AND ", " & ");
            expression = expression.replace(" And ", " & ");
            expression = expression.replace(" or ", " | ");
            expression = expression.replace(" OR ", " | ");
            expression = expression.replace(" Or ", " | ");
            expression = expression.replace(" not ", " ! ");
            expression = expression.replace(" NOT ", " ! ");
            expression = expression.replace(" Not ", " ! ");
            if (expression.startsWith("not ")) {
                expression = expression.replaceFirst("not ", "! ");
            }
            if (expression.startsWith("Not ")) {
                expression = expression.replaceFirst("Not ", "! ");
            }
            if (expression.startsWith("NOT ")) {
                expression = expression.replaceFirst("NOT ", "! ");
            }
            Lexer lexer = new Lexer(new ByteArrayInputStream(expression.getBytes()), rclist, positiveness, this.CellTypes, this.ExpressionResults);
            RecursiveDescentParser parser = new RecursiveDescentParser(lexer);
            try {
                BooleanExpression ast = parser.build();
                if (positiveness == null) {
                    System.out.println("Expression found: " + String.format("%s", ast) + " => " + result);
                } else {
                    this.expressions[this.nbExpressions] = ast;
                }
            }
            catch (Exception ex3) {
                IllegalArgumentException exception = new IllegalArgumentException("Line " + nb + " '" + line + "':" + ex3.getMessage());
                log.addNewException(exception, new String[0]);
                ex3.printStackTrace();
                throw exception;
            }
            ++this.nbExpressions;
            ++nb;
            line = null;
        }
    }

    private class Marker
    extends Terminal {
        public Marker(String name, String type, char positive, FichierTabule positiveness) {
            super(name, type, positive, positiveness);
        }

        @Override
        public boolean interpret(int row) {
            char c = this.file.getValueString(row, this.column).charAt(0);
            switch (c) {
                case '-': {
                    return this.positive == '-';
                }
                case '+': {
                    return this.positive == '+';
                }
                case '?': {
                    throw new IllegalStateException("?");
                }
                case 'x': {
                    throw new IllegalStateException("x");
                }
            }
            throw new IllegalStateException("Unknown string, must not occur: '" + this.file.getValueString(row, this.column) + "'.");
        }
    }

    private class Not
    extends NonTerminal {
        private Not() {
        }

        public void setChild(BooleanExpression child) {
            this.setLeft(child);
        }

        @Override
        public void setRight(BooleanExpression right) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean interpret(int row) {
            return !this.left.interpret(row);
        }

        public String toString() {
            return String.format("!%s", this.left);
        }
    }

    private class And
    extends NonTerminal {
        private And() {
        }

        @Override
        public boolean interpret(int row) {
            return this.left.interpret(row) && this.right.interpret(row);
        }

        public String toString() {
            return String.format("(%s & %s)", this.left, this.right);
        }
    }

    private class Or
    extends NonTerminal {
        private Or() {
        }

        @Override
        public boolean interpret(int row) {
            return this.left.interpret(row) || this.right.interpret(row);
        }

        public String toString() {
            return String.format("(%s | %s)", this.left, this.right);
        }
    }

    private abstract class Terminal
    implements BooleanExpression {
        protected final String name;
        protected final String type;
        protected final char positive;
        protected FichierTabule file;
        protected int column;
        protected boolean value;

        public Terminal(String name, String type, char positive, FichierTabule file) {
            this.name = name;
            this.type = type;
            this.positive = positive;
            if (file != null) {
                this.file = file;
                this.column = file.ColumnNumber(name + (String)(type == null ? "" : " - " + type));
            }
        }

        public String toString() {
            return String.format("%s_%s%c", this.name, this.type, Character.valueOf(this.positive));
        }
    }

    private abstract class NonTerminal
    implements BooleanExpression {
        protected BooleanExpression left;
        protected BooleanExpression right;

        private NonTerminal() {
        }

        public void setLeft(BooleanExpression left) {
            this.left = left;
        }

        public void setRight(BooleanExpression right) {
            this.right = right;
        }
    }

    private static interface BooleanExpression {
        public boolean interpret(int var1);
    }

    private class RecursiveDescentParser {
        private final Lexer lexer;
        private int symbol;
        private BooleanExpression root;

        public RecursiveDescentParser(Lexer lexer) {
            this.lexer = lexer;
        }

        public BooleanExpression build() {
            this.expression();
            return this.root;
        }

        private void expression() {
            this.term();
            while (this.symbol == 1) {
                Or or = new Or();
                or.setLeft(this.root);
                this.term();
                or.setRight(this.root);
                this.root = or;
            }
        }

        private void term() {
            this.factor();
            while (this.symbol == 2) {
                And and = new And();
                and.setLeft(this.root);
                this.factor();
                and.setRight(this.root);
                this.root = and;
            }
        }

        private void factor() {
            this.symbol = this.lexer.nextSymbol();
            switch (this.symbol) {
                case 8: {
                    this.root = new Marker(this.lexer.Marker, this.lexer.Type, this.lexer.Positive, this.lexer.ToPass);
                    this.symbol = this.lexer.nextSymbol();
                    break;
                }
                case 3: {
                    Not not = new Not();
                    this.factor();
                    not.setChild(this.root);
                    this.root = not;
                    break;
                }
                case 6: {
                    this.expression();
                    if (this.symbol != 7) {
                        throw new RuntimeException("Expression Malformed, missing closing ')'.");
                    }
                    this.symbol = this.lexer.nextSymbol();
                    break;
                }
                default: {
                    throw new RuntimeException("Expression Malformed");
                }
            }
        }
    }

    private class Lexer {
        private final StreamTokenizer input;
        private int symbol = 0;
        public static final int EOL = -3;
        public static final int EOF = -2;
        public static final int INVALID = -1;
        public static final int NONE = 0;
        public static final int OR = 1;
        public static final int AND = 2;
        public static final int NOT = 3;
        public static final int LEFT = 6;
        public static final int RIGHT = 7;
        public static final int MARKER = 8;
        public String Marker = null;
        public String Type = null;
        public char Positive;
        private final List<CycIF_RoundCycle> rclist;
        private final FichierTabule positiveness;
        private final FichierTabule celltypes;
        private FichierTabule ToPass;
        private final List<String> results;

        public Lexer(InputStream in, List<CycIF_RoundCycle> rclist, FichierTabule positiveness, FichierTabule celltypes, List<String> results) {
            BufferedReader r = new BufferedReader(new InputStreamReader(in));
            this.input = new StreamTokenizer(r);
            this.input.resetSyntax();
            this.input.wordChars(97, 122);
            this.input.wordChars(65, 90);
            this.input.wordChars(48, 57);
            this.input.wordChars(45, 45);
            this.input.wordChars(43, 43);
            this.input.wordChars(95, 95);
            this.input.whitespaceChars(0, 32);
            this.input.whitespaceChars(10, 9);
            this.input.ordinaryChar(40);
            this.input.ordinaryChar(41);
            this.input.ordinaryChar(38);
            this.input.ordinaryChar(124);
            this.input.ordinaryChar(33);
            this.rclist = rclist;
            this.positiveness = positiveness;
            this.celltypes = celltypes;
            this.results = results;
        }

        private void Check(String str) {
            this.Type = null;
            this.Marker = null;
            this.ToPass = null;
            char last = str.charAt(str.length() - 1);
            if (last != '-' && last != '+') {
                throw new IllegalArgumentException("Last character must be '+' or '-' in '" + str + "'.");
            }
            char positive = str.charAt(str.length() - 1);
            int pos = str.indexOf("_");
            if (pos <= 0) {
                String core = str.substring(0, str.length() - 1);
                if (this.results.contains(core)) {
                    this.ToPass = this.celltypes;
                    this.Marker = core;
                    this.Positive = positive;
                    return;
                }
                throw new IllegalArgumentException("Marker '" + str + "' does not contain character '_' to separate marker and location.");
            }
            String marker = str.substring(0, pos);
            String type = str.substring(pos + 1, str.length() - 1);
            switch (type.toLowerCase()) {
                case "all": 
                case "everything": {
                    throw new IllegalArgumentException("All/Everything type not possible for cell types.");
                }
                case "cell": 
                case "cells": {
                    this.Marker = marker;
                    type = "Cells";
                    break;
                }
                case "nucleus": 
                case "nuclei": {
                    this.Marker = marker;
                    type = "Nuclei";
                    break;
                }
                case "rim": 
                case "rims": {
                    this.Marker = marker;
                    type = "Rims";
                    break;
                }
                case "ring": 
                case "rings": {
                    this.Marker = marker;
                    type = "Rings";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown marker location: '" + type + "' in '" + str + "'.");
                }
            }
            for (CycIF_RoundCycle rc : this.rclist) {
                if (rc.marker.equalsIgnoreCase(marker)) {
                    if (rc.type.equalsIgnoreCase(type) || rc.type.equalsIgnoreCase("All")) {
                        this.Marker = rc.marker;
                        this.Type = type;
                        this.Positive = positive;
                        this.ToPass = this.positiveness;
                        return;
                    }
                    throw new IllegalArgumentException("Marker location '" + type + "' in '" + str + "' not extracted/requested in RoundCyclesTable.");
                }
                rc = null;
            }
            throw new IllegalArgumentException("Marker not found '" + str + "'.");
        }

        public int nextSymbol() {
            try {
                switch (this.input.nextToken()) {
                    case 10: {
                        this.symbol = -3;
                        break;
                    }
                    case -1: {
                        this.symbol = -2;
                        break;
                    }
                    case -3: {
                        this.symbol = 8;
                        this.Check(this.input.sval);
                        break;
                    }
                    case 40: {
                        this.symbol = 6;
                        break;
                    }
                    case 41: {
                        this.symbol = 7;
                        break;
                    }
                    case 38: {
                        this.symbol = 2;
                        break;
                    }
                    case 124: {
                        this.symbol = 1;
                        break;
                    }
                    case 33: {
                        this.symbol = 3;
                        break;
                    }
                    default: {
                        this.symbol = -1;
                        break;
                    }
                }
            }
            catch (IOException e) {
                this.symbol = -2;
            }
            return this.symbol;
        }
    }
}

