/*
 * Decompiled with CFR 0.152.
 */
package softwares.ohsu.cousens;

import arrayTiTi.ArrayComparator;
import arrayTiTi.ArrayFeatures;
import filesAndFolders.FichiersDossiersIHM;
import gui.MailBox;
import imageTiTi.ImageComparator;
import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import imageTiTi.ImageOperations;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import listTiTi.Queue;
import mathematics.primitives.pointsTiTi.Coordinates;
import measures.cclh.ConnectedComponentLabeling;
import measures.cclh.FillHole;
import measures.cclh.UnionFindCcl;
import measures.hedgehop.DistanceMapComputer;
import morphee.Close;
import morphee.Erode;
import morphee.Open;
import morphee.StructuringElement;
import morphee.filters.ASFilterOpenClose;
import processing.filters.Invert;
import processing.thresholding.Huang;
import processing.thresholding.MeanThresholding;
import processing.thresholding.MinimumThresholding;
import processing.thresholding.TriangleThresholding;
import utils.times.Chronometer;

public class TissueSegmentation
extends JFrame {
    private static final long serialVersionUID = 1L;
    public static final String Version = "1.10";
    private final String about = "Version 1.10\nAuthor: Guillaume THIBAULT\nWeb: www.thibault.biz\nCopyright (c) 2006-Today\nAll Right Reserved";
    private final String documentation = " - Fill R.O.I Holes: fill the R.O.I holes with a surface smaller than the given value.\n - Fill Segmentation Holes: fill the segmented patterns holes with a size smaller than the given value.\n - Delete R.O.I: delete the patterns (from the R.O.I) with a number of pixels smaller than the given value.\n - Delete Segmentation: delete the segmented patterns with a number of pixels smaller than the given value.\n - Erase when radius: delete the segmented patterns with a radius smaller than the given value.\n - Close valleys, width: fill the valleys having a width smaller than the given value.\n - Invasive margin radius: the invasive margin size/width (dilation radius).\n - Skin thickness: the minimum distance between the exterior part of the skin and the closest tumor tissue.\n";
    private final ArrayFeatures AF = new ArrayFeatures();
    private final FilenameFilter fnf = (dir, name) -> name.charAt(0) != '.' && !name.contains("DS_Store") && (name.contains(".png") || name.contains(".tif"));
    private final ASFilterOpenClose asfoc = new ASFilterOpenClose();
    private final Close close = new Close();
    private final DistanceMapComputer dmc = new DistanceMapComputer();
    private final Erode erode = new Erode();
    private final FillHole fh = new FillHole();
    private final Huang huang = new Huang();
    private final Invert invert = new Invert();
    private final MeanThresholding meanthres = new MeanThresholding();
    private final MinimumThresholding minthres = new MinimumThresholding();
    private final Open open = new Open();
    private final StructuringElement sed3 = new StructuringElement(new Object[]{3, -2});
    private StructuringElement clse = null;
    private StructuringElement opse = null;
    private final StructuringElement sem = new StructuringElement(new Object[]{2, -15});
    private StructuringElement stse = null;
    private final TriangleThresholding triangle = new TriangleThresholding();
    private final UnionFindCcl ufccl = new UnionFindCcl();
    private int dnaholesize = 2003;
    private int p16holesize = 2003;
    private int dnacmpsize = 3001;
    private int p16cmpsize = 3001;
    private int closingradius = 11;
    private int openingradius = 11;
    private int bandradius = 43;
    private int skinthickness = 0;
    private boolean writecolor = true;
    private final int CPU = Runtime.getRuntime().availableProcessors();
    private String currentpath = "~/";
    private Algorithms algo = Algorithms.P16;
    private JComboBox AlgoBox;
    private JMenuItem ItemAbout;
    private JMenuItem ItemQuit;
    private JMenuBar MenuBar;
    private JMenu MenuFile;
    private JMenu MenuHelp;
    private JToggleButton buttonchoose;
    private JToggleButton buttonprocessall;
    private JToggleButton buttonsingleprocess;
    private JCheckBox checkcolor;
    private JLabel jLabel1;
    private JMenuItem jMenuItem1;
    private JLabel labelband;
    private JLabel labelchoose;
    private JLabel labelclose;
    private JLabel labelcmproi;
    private JLabel labelcmpseg;
    private JLabel labeldnaext;
    private JLabel labelholeroi;
    private JLabel labelholeseg;
    private JLabel labelopen;
    private JLabel labelp16ext;
    private JLabel labelskinthickness;
    private JTextField textband;
    private JTextField textchoose;
    private JTextField textclose;
    private JTextField textcmproi;
    private JTextField textcmpseg;
    private JTextField textdna;
    private JTextField textholeroi;
    private JTextField textholeseg;
    private JTextField textopen;
    private JTextField textp16;
    private JTextField textskinthickness;

    public TissueSegmentation() {
        this.initComponents();
        this.setVisible(true);
        this.setTitle("IHC Tissue Segmentation 1.10 (OHSU use only)");
    }

    private void initComponents() {
        this.textchoose = new JTextField();
        this.labelchoose = new JLabel();
        this.buttonsingleprocess = new JToggleButton();
        this.buttonprocessall = new JToggleButton();
        this.labeldnaext = new JLabel();
        this.labelp16ext = new JLabel();
        this.textdna = new JTextField();
        this.textp16 = new JTextField();
        this.labelholeroi = new JLabel();
        this.textholeroi = new JTextField();
        this.textholeseg = new JTextField();
        this.labelholeseg = new JLabel();
        this.labelband = new JLabel();
        this.checkcolor = new JCheckBox();
        this.buttonchoose = new JToggleButton();
        this.textband = new JTextField();
        this.AlgoBox = new JComboBox();
        this.jLabel1 = new JLabel();
        this.textcmproi = new JTextField();
        this.labelcmproi = new JLabel();
        this.labelcmpseg = new JLabel();
        this.textcmpseg = new JTextField();
        this.labelopen = new JLabel();
        this.labelclose = new JLabel();
        this.textopen = new JTextField();
        this.textclose = new JTextField();
        this.labelskinthickness = new JLabel();
        this.textskinthickness = new JTextField();
        this.MenuBar = new JMenuBar();
        this.MenuFile = new JMenu();
        this.ItemQuit = new JMenuItem();
        this.MenuHelp = new JMenu();
        this.ItemAbout = new JMenuItem();
        this.jMenuItem1 = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setResizable(false);
        this.textchoose.setText(this.currentpath);
        this.labelchoose.setText("Directory(ies)");
        this.buttonsingleprocess.setText("Single Process");
        this.buttonsingleprocess.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TissueSegmentation.this.buttonsingleprocessActionPerformed(evt);
            }
        });
        this.buttonprocessall.setText("Process All");
        this.buttonprocessall.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TissueSegmentation.this.buttonprocessallActionPerformed(evt);
            }
        });
        this.labeldnaext.setText("DNA extension");
        this.labelp16ext.setText("P16 extension");
        this.textdna.setText("One");
        this.textp16.setText("Two");
        this.textp16.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TissueSegmentation.this.textp16ActionPerformed(evt);
            }
        });
        this.labelholeroi.setText("Fill R.O.I holes               <=");
        this.labelholeroi.setPreferredSize(new Dimension(110, 16));
        this.textholeroi.setText(String.valueOf(this.dnaholesize));
        this.textholeroi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TissueSegmentation.this.textholeroiActionPerformed(evt);
            }
        });
        this.textholeseg.setText(String.valueOf(this.p16holesize));
        this.textholeseg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TissueSegmentation.this.textholesegActionPerformed(evt);
            }
        });
        this.labelholeseg.setText("Fill Segmentation holes <=");
        this.labelholeseg.setPreferredSize(new Dimension(110, 16));
        this.labelholeseg.setSize(new Dimension(45, 16));
        this.labelband.setText("Invasive margin radius    =");
        this.labelband.setPreferredSize(new Dimension(110, 16));
        this.labelband.setSize(new Dimension(45, 16));
        this.checkcolor.setSelected(this.writecolor);
        this.checkcolor.setText("Save color results?");
        this.checkcolor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TissueSegmentation.this.checkcolorActionPerformed(evt);
            }
        });
        this.buttonchoose.setText("Select");
        this.buttonchoose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TissueSegmentation.this.buttonchooseActionPerformed(evt);
            }
        });
        this.textband.setText(String.valueOf(this.bandradius));
        this.textband.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TissueSegmentation.this.textbandActionPerformed(evt);
            }
        });
        this.AlgoBox.setModel(new DefaultComboBoxModel<String>(new String[]{"P16 only", "Disk", "First", "Sensitive ROI"}));
        this.AlgoBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TissueSegmentation.this.AlgoBoxActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Algorithm");
        this.textcmproi.setText(String.valueOf(this.dnacmpsize));
        this.textcmproi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TissueSegmentation.this.textcmproiActionPerformed(evt);
            }
        });
        this.labelcmproi.setText("Delete R.O.I                   <=");
        this.labelcmproi.setPreferredSize(new Dimension(110, 16));
        this.labelcmpseg.setText("Delete Segmentation     <=");
        this.labelcmpseg.setPreferredSize(new Dimension(110, 16));
        this.labelcmpseg.setSize(new Dimension(45, 16));
        this.textcmpseg.setText(String.valueOf(this.p16cmpsize));
        this.textcmpseg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TissueSegmentation.this.textcmpsegActionPerformed(evt);
            }
        });
        this.labelopen.setText("Erase when radius         <=");
        this.labelopen.setPreferredSize(new Dimension(110, 16));
        this.labelopen.setSize(new Dimension(45, 16));
        this.labelclose.setText("Close valleys, width      <=");
        this.labelclose.setPreferredSize(new Dimension(110, 16));
        this.labelclose.setSize(new Dimension(45, 16));
        this.textopen.setText(String.valueOf(this.openingradius));
        this.textopen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TissueSegmentation.this.textopenActionPerformed(evt);
            }
        });
        this.textclose.setText(String.valueOf(this.closingradius));
        this.textclose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TissueSegmentation.this.textcloseActionPerformed(evt);
            }
        });
        this.labelskinthickness.setText("Skin thickness                 =");
        this.labelskinthickness.setPreferredSize(new Dimension(110, 16));
        this.labelskinthickness.setSize(new Dimension(45, 16));
        this.textskinthickness.setText(String.valueOf(this.skinthickness));
        this.textskinthickness.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TissueSegmentation.this.textskinthicknessActionPerformed(evt);
            }
        });
        this.MenuFile.setText("File");
        this.ItemQuit.setText("Quit");
        this.ItemQuit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TissueSegmentation.this.ItemQuitActionPerformed(evt);
            }
        });
        this.MenuFile.add(this.ItemQuit);
        this.MenuBar.add(this.MenuFile);
        this.MenuHelp.setText("Help");
        this.ItemAbout.setText("About");
        this.ItemAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TissueSegmentation.this.ItemAboutActionPerformed(evt);
            }
        });
        this.MenuHelp.add(this.ItemAbout);
        this.jMenuItem1.setLabel("Documentation");
        this.jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TissueSegmentation.this.jMenuItem1ActionPerformed(evt);
            }
        });
        this.MenuHelp.add(this.jMenuItem1);
        this.MenuBar.add(this.MenuHelp);
        this.setJMenuBar(this.MenuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.labelchoose, -2, 86, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.buttonsingleprocess).addGap(86, 86, 86).addComponent(this.buttonprocessall)).addComponent(this.textchoose, -2, 337, -2)).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(GroupLayout.Alignment.TRAILING, layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.labeldnaext).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.textdna, -2, 102, -2)).addGroup(layout.createSequentialGroup().addComponent(this.labelp16ext).addGap(18, 18, 18).addComponent(this.textp16, -2, 102, -2))).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1, -2, 86, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.AlgoBox, -2, 118, -2))).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(layout.createSequentialGroup().addComponent(this.labelholeseg, -2, 177, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 18, Short.MAX_VALUE).addComponent(this.textholeseg, -2, 103, -2)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.labelcmpseg, -1, 189, Short.MAX_VALUE).addComponent(this.labelcmproi, -1, -1, Short.MAX_VALUE).addComponent(this.labelopen, GroupLayout.Alignment.LEADING, -1, 189, Short.MAX_VALUE).addComponent(this.labelclose, GroupLayout.Alignment.LEADING, -1, 189, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.textcmproi, -2, 103, -2).addComponent(this.textcmpseg, -2, 103, -2).addComponent(this.textopen, -2, 103, -2).addComponent(this.textclose, -2, 103, -2))).addComponent(this.buttonchoose)).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.labelholeroi, -2, 177, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.textholeroi, -2, 103, -2)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.checkcolor)))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.labelskinthickness, -2, 177, -2).addComponent(this.labelband, -2, 177, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.textband, -2, 103, -2).addComponent(this.textskinthickness, GroupLayout.Alignment.TRAILING, -2, 103, -2)))).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(23, 23, 23).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labeldnaext).addComponent(this.textdna, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelp16ext).addComponent(this.textp16, -2, -1, -2))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelholeroi, -2, -1, -2).addComponent(this.textholeroi, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelholeseg, -2, -1, -2).addComponent(this.textholeseg, -2, -1, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelcmproi, -2, -1, -2).addComponent(this.textcmproi, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelcmpseg, -2, -1, -2).addComponent(this.textcmpseg, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelopen, -2, -1, -2).addComponent(this.textopen, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.textclose, -2, -1, -2).addComponent(this.labelclose, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.textband, -2, -1, -2).addComponent(this.labelband, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.textskinthickness, -2, -1, -2).addComponent(this.labelskinthickness, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 12, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkcolor).addComponent(this.AlgoBox, -2, -1, -2).addComponent(this.jLabel1)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelchoose).addComponent(this.textchoose, -2, -1, -2).addComponent(this.buttonchoose)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonsingleprocess).addComponent(this.buttonprocessall)).addContainerGap()));
        this.pack();
    }

    private void ItemQuitActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void buttonsingleprocessActionPerformed(ActionEvent evt) {
        Chronometer chrono = new Chronometer();
        int marker = chrono.NewMarker();
        try {
            this.Segment(this.currentpath);
        }
        catch (Error er) {
            new MailBox(0, er.toString(), "Error: " + er.getMessage());
            er.printStackTrace();
            System.exit(0);
        }
        catch (Exception ex) {
            new MailBox(0, ex.toString(), "Exception: " + ex.getMessage());
            ex.printStackTrace();
            System.exit(0);
        }
        double time = chrono.getTimeSinceMarker(marker);
        chrono.FreeMarker(marker);
        chrono = null;
        System.out.println("Done: single directory processed in " + time + "s");
        new MailBox(0, "Done!\nSingle directory segmented in " + time + "s", "Segmentation over");
    }

    private void textholeroiActionPerformed(ActionEvent evt) {
    }

    private void textholesegActionPerformed(ActionEvent evt) {
    }

    private void checkcolorActionPerformed(ActionEvent evt) {
    }

    private void buttonprocessallActionPerformed(ActionEvent evt) {
        File[] directories = new File(this.currentpath).listFiles(pathname -> pathname.isDirectory());
        if (directories == null) {
            new MailBox(0, "No sub-directories found!", "Nothing to process");
            return;
        }
        this.setEnabled(false);
        Chronometer chrono = new Chronometer();
        int marker = chrono.NewMarker();
        for (int d = 0; d < directories.length; ++d) {
            try {
                this.Segment(directories[d].getAbsolutePath());
                continue;
            }
            catch (Error er) {
                new MailBox(0, er.toString(), "Error: " + er.getMessage());
                er.printStackTrace();
                System.exit(0);
                continue;
            }
            catch (Exception ex) {
                new MailBox(0, ex.toString(), "Exception: " + ex.getMessage());
                ex.printStackTrace();
                System.exit(0);
            }
        }
        double time = chrono.getTimeSinceMarker(marker);
        chrono.FreeMarker(marker);
        chrono = null;
        this.setEnabled(true);
        System.out.println("Done:" + directories.length + " director" + (directories.length == 1 ? "y" : "ies") + " in " + time + "s");
        new MailBox(0, "All Done!\n" + directories.length + " director" + (directories.length == 1 ? "y" : "ies") + " in " + time + "s", "Segmentations over");
    }

    private void ItemAboutActionPerformed(ActionEvent evt) {
        new MailBox(0, "Version 1.10\nAuthor: Guillaume THIBAULT\nWeb: www.thibault.biz\nCopyright (c) 2006-Today\nAll Right Reserved", "About this software");
    }

    private void buttonchooseActionPerformed(ActionEvent evt) {
        File file = FichiersDossiersIHM.ChoisirDossier(this.currentpath, false);
        if (file == null) {
            return;
        }
        this.currentpath = file.getAbsolutePath();
        this.textchoose.setText(file.getAbsolutePath());
        this.textchoose.repaint();
    }

    private void AlgoBoxActionPerformed(ActionEvent evt) {
    }

    private void textp16ActionPerformed(ActionEvent evt) {
    }

    private void textcmproiActionPerformed(ActionEvent evt) {
    }

    private void textbandActionPerformed(ActionEvent evt) {
    }

    private void textcmpsegActionPerformed(ActionEvent evt) {
    }

    private void textopenActionPerformed(ActionEvent evt) {
    }

    private void textcloseActionPerformed(ActionEvent evt) {
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        new MailBox(0, " - Fill R.O.I Holes: fill the R.O.I holes with a surface smaller than the given value.\n - Fill Segmentation Holes: fill the segmented patterns holes with a size smaller than the given value.\n - Delete R.O.I: delete the patterns (from the R.O.I) with a number of pixels smaller than the given value.\n - Delete Segmentation: delete the segmented patterns with a number of pixels smaller than the given value.\n - Erase when radius: delete the segmented patterns with a radius smaller than the given value.\n - Close valleys, width: fill the valleys having a width smaller than the given value.\n - Invasive margin radius: the invasive margin size/width (dilation radius).\n - Skin thickness: the minimum distance between the exterior part of the skin and the closest tumor tissue.\n", "Quick Documentation");
    }

    private void textskinthicknessActionPerformed(ActionEvent evt) {
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(() -> new TissueSegmentation());
    }

    private void Segment(String directory) throws IOException {
        File[] images = new File(directory).listFiles(this.fnf);
        if (images == null) {
            throw new IllegalArgumentException("No images found!");
        }
        File resfile = null;
        switch (this.AlgoBox.getSelectedIndex()) {
            case 0: {
                this.algo = Algorithms.P16;
                resfile = new File(directory + "/Segmentation_P16only/");
                break;
            }
            case 1: {
                this.algo = Algorithms.DISK;
                resfile = new File(directory + "/Segmentation_Disk/");
                break;
            }
            case 2: {
                this.algo = Algorithms.FIRST;
                resfile = new File(directory + "/Segmentation_First/");
                break;
            }
            case 3: {
                this.algo = Algorithms.SENSITIVEROI;
                resfile = new File(directory + "/Segmentation_SensitiveROI/");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown algorithm, must not occur.");
            }
        }
        if (!resfile.exists()) {
            resfile.mkdirs();
        }
        if (!resfile.exists()) {
            throw new IOException("Impossible to create the segmentation directory.");
        }
        this.dnaholesize = Integer.valueOf(this.textholeroi.getText());
        this.dnacmpsize = Integer.valueOf(this.textcmproi.getText());
        this.p16cmpsize = Integer.valueOf(this.textcmpseg.getText());
        this.p16holesize = Integer.valueOf(this.textholeseg.getText());
        this.bandradius = Integer.valueOf(this.textband.getText());
        this.closingradius = Integer.valueOf(this.textclose.getText());
        this.openingradius = Integer.valueOf(this.textopen.getText());
        this.openingradius = Integer.valueOf(this.textopen.getText());
        this.skinthickness = Integer.valueOf(this.textskinthickness.getText());
        this.clse = new StructuringElement(new Object[]{this.closingradius, -2});
        this.opse = new StructuringElement(new Object[]{this.openingradius, -2});
        this.stse = 0 < this.skinthickness ? new StructuringElement(new Object[]{this.skinthickness, -2}) : null;
        this.writecolor = this.checkcolor.isSelected();
        BufferedImage imdna = null;
        BufferedImage imp16 = null;
        BufferedImage imroi = null;
        BufferedImage imseg = null;
        BufferedImage imband = null;
        for (int i2 = 0; i2 < images.length; ++i2) {
            if (images[i2].getName().contains(this.textdna.getText()) && this.algo != Algorithms.P16) {
                imdna = ImageIO.Read(images[i2]);
                continue;
            }
            if (!images[i2].getName().contains(this.textp16.getText())) continue;
            imp16 = ImageIO.Read(images[i2]);
        }
        if (imdna == null && this.algo != Algorithms.P16) {
            throw new Error("No DNA image found into the directory '" + directory + "'.");
        }
        if (imp16 == null) {
            throw new Error("No P16 image found into the directory '" + directory + "'.");
        }
        BufferedImage imtmp = ImageNew.Same(imp16, (int)10);
        imroi = ImageNew.Same((BufferedImage)imtmp);
        imseg = ImageNew.Same((BufferedImage)imtmp);
        imband = ImageNew.Same((BufferedImage)imtmp);
        if (this.algo != Algorithms.P16) {
            this.CreateROI(imdna, imtmp, imroi, this.CPU);
        } else {
            this.CreateROI(imp16, imtmp, imroi, this.CPU);
        }
        ImageIO.Write(imroi, resfile.getAbsolutePath() + "/ROI.png", 6);
        if (this.writecolor) {
            if (this.algo != Algorithms.P16) {
                this.DrawBorders(imroi, 255, 0, 0, imdna);
                ImageIO.Write(imdna, resfile.getAbsolutePath() + "/ROI_DNA.png", 6);
            } else {
                imdna = ImageNew.Clone((BufferedImage)imp16);
                this.DrawBorders(imroi, 0, 255, 0, imdna);
                ImageIO.Write(imdna, resfile.getAbsolutePath() + "/ROI_P16.png", 6);
            }
        }
        this.Segmentation(imp16, imtmp, imroi, imseg, this.CPU);
        ImageIO.Write(imseg, resfile.getAbsolutePath() + "/Segmentation.png", 6);
        if (this.writecolor) {
            ImageNew.Copy((BufferedImage)imp16, (BufferedImage)imdna);
            this.DrawBorders(imseg, 0, 255, 0, imp16);
            ImageIO.Write(imp16, resfile.getAbsolutePath() + "/Segmentation_P16.png", 6);
            ImageNew.Copy((BufferedImage)imdna, (BufferedImage)imp16);
        }
        imdna = null;
        this.NarrowBand(imroi, imtmp, imseg, imband, this.CPU);
        ImageIO.Write(imband, resfile.getAbsolutePath() + "/Band.png", 6);
        if (this.writecolor) {
            this.DrawBorders(imband, 0, 255, 0, imp16);
            ImageIO.Write(imp16, resfile.getAbsolutePath() + "/Band_P16.png", 6);
        }
        this.stse = null;
        this.opse = null;
        this.clse = null;
        images = null;
        imroi = null;
        imseg = null;
        imtmp = null;
        imp16 = null;
        resfile = null;
        images = null;
        this.ufccl.Kill();
        this.dmc.Kill();
        System.gc();
        this.buttonsingleprocess.setSelected(false);
        this.buttonprocessall.setSelected(false);
    }

    private void NarrowBand(BufferedImage imroi, BufferedImage imtmp, BufferedImage imseg, BufferedImage imband, int nbCPU) throws IOException {
        float[] db;
        byte[] bb;
        int width = imroi.getWidth();
        int height = imroi.getHeight();
        this.dmc.Compute(imseg, this.sem);
        switch (imband.getType()) {
            case 10: {
                bb = ((DataBufferByte)imband.getRaster().getDataBuffer()).getData();
                db = this.dmc.getMontanariMap1D();
                ArrayComparator.Compare((float[])db, (String)"<", (float)this.bandradius, (byte)-1, (byte)0, (byte[])bb);
                bb = null;
                db = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        ImageComparator.Compare((BufferedImage)imseg, (String)"!=", (int)0, (BufferedImage)imband, (int)0, (BufferedImage)imband);
        this.invert.Filter(imseg, imtmp, nbCPU);
        if (0 < this.skinthickness) {
            BufferedImage imbigroi = this.erode.Filter(imroi, this.stse, nbCPU);
            this.ufccl.Label(imbigroi, 255, true);
            int[] labels = this.ufccl.Labels1D();
            int[] sizes = this.ufccl.Sizes();
            int maxindex = this.AF.MaximumIndex(sizes, 1, sizes.length);
            ArrayComparator.Compare((int[])labels, (String)"==", (int)maxindex, (int)255, (int)0, (int[])labels);
            byte[] bbband = ((DataBufferByte)imband.getRaster().getDataBuffer()).getData();
            byte[] bbtmp = ((DataBufferByte)imtmp.getRaster().getDataBuffer()).getData();
            byte[] bbbigroi = ((DataBufferByte)imbigroi.getRaster().getDataBuffer()).getData();
            ArrayComparator.CompareUnsigned((byte[])bbbigroi, (String)"!=", (int)0, (byte[])bbtmp, (byte)0, (byte[])bbtmp);
            int pos = 0;
            for (int y = 0; y < height; ++y) {
                int x = 0;
                while (x < width) {
                    if (labels[pos] == 255 && bbband[pos] != 0) {
                        this.Erase(bbband, width, height, x, y, pos);
                    }
                    ++x;
                    ++pos;
                }
            }
        }
        this.dmc.Compute(imtmp, this.sem);
        switch (imband.getType()) {
            case 10: {
                bb = ((DataBufferByte)imtmp.getRaster().getDataBuffer()).getData();
                db = this.dmc.getMontanariMap1D();
                for (int x = 0; x < bb.length; ++x) {
                    bb[x] = db[x] < (float)this.bandradius && bb[x] != 0 ? -1 : 0;
                }
                bb = null;
                db = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        ImageComparator.Compare((BufferedImage)imseg, (String)"==", (int)0, (BufferedImage)imtmp, (int)0, (BufferedImage)imtmp);
        ImageOperations.Maximum((BufferedImage)imband, (BufferedImage)imtmp, (BufferedImage)imband);
        ImageComparator.Compare((BufferedImage)imroi, (String)"==", (int)255, (BufferedImage)imband, (int)0, (BufferedImage)imband);
    }

    private void Erase(byte[] im, int width, int height, int X, int Y, int Pos) {
        Queue<Coordinates> fifo = new Queue<Coordinates>();
        fifo.Push(new Coordinates(X, Y, 0, Pos));
        while (!fifo.Empty()) {
            Coordinates c = (Coordinates)fifo.FrontPop();
            if (im[c.Pos] == -1) {
                im[c.Pos] = 0;
                if (0 < c.X && im[c.Pos - 1] == -1) {
                    fifo.push(new Coordinates(c.X - 1, c.Y, 0, c.Pos - 1));
                }
                if (c.X + 1 < width && im[c.Pos + 1] == -1) {
                    fifo.push(new Coordinates(c.X + 1, c.Y, 0, c.Pos + 1));
                }
                if (0 < c.Y && im[c.Pos - width] == -1) {
                    fifo.push(new Coordinates(c.X, c.Y - 1, 0, c.Pos - width));
                }
                if (c.Y + 1 < height && im[c.Pos + width] == -1) {
                    fifo.push(new Coordinates(c.X, c.Y + 1, 0, c.Pos + width));
                }
                if (0 < c.X && 0 < c.Y && im[c.Pos - width - 1] == -1) {
                    fifo.push(new Coordinates(c.X - 1, c.Y - 1, 0, c.Pos - width - 1));
                }
                if (c.X + 1 < width && 0 < c.Y && im[c.Pos - width + 1] == -1) {
                    fifo.push(new Coordinates(c.X + 1, c.Y - 1, 0, c.Pos - width + 1));
                }
                if (0 < c.X && c.Y + 1 < height && im[c.Pos + width - 1] == -1) {
                    fifo.push(new Coordinates(c.X - 1, c.Y + 1, 0, c.Pos + width - 1));
                }
                if (c.X + 1 < width && c.Y + 1 < height && im[c.Pos + width + 1] == -1) {
                    fifo.push(new Coordinates(c.X + 1, c.Y + 1, 0, c.Pos + width + 1));
                }
            }
            c = null;
        }
    }

    private void Segmentation(BufferedImage imp16, BufferedImage imtmp, BufferedImage imroi, BufferedImage imseg, int nbCPU) throws IOException {
        switch (imp16.getType()) {
            case 5: {
                byte[] bb = ((DataBufferByte)imp16.getRaster().getDataBuffer()).getData();
                byte[] max = ((DataBufferByte)imtmp.getRaster().getDataBuffer()).getData();
                int i2 = 0;
                int x = 0;
                while (x < bb.length) {
                    byte b = bb[x];
                    byte g = bb[x + 1];
                    byte r = bb[x + 2];
                    max[i2] = (byte)Math.max(Math.abs(b - g), Math.max(Math.abs(b - r), Math.abs(g - r)));
                    x += 3;
                    ++i2;
                }
                bb = null;
                max = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image P16 type not supported (yet).");
            }
        }
        this.asfoc.Filter(imtmp, this.sed3, imseg, nbCPU);
        ImageComparator.Compare((BufferedImage)imroi, (String)"!=", (int)0, (BufferedImage)imseg, (int)0, (BufferedImage)imseg);
        switch (this.algo) {
            case P16: 
            case DISK: 
            case SENSITIVEROI: {
                this.triangle.Filter(imseg, imtmp, 0, nbCPU);
                this.huang.Filter(imseg, imseg, 0, nbCPU);
                ImageOperations.Maximum((BufferedImage)imseg, (BufferedImage)imtmp, (BufferedImage)imseg);
                break;
            }
            case FIRST: {
                this.huang.Filter(imseg, imseg, 0, nbCPU);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown algorithm, must not occur.");
            }
        }
        this.close.Filter(imseg, this.clse, imtmp, nbCPU);
        this.open.Filter(imtmp, this.opse, imseg, nbCPU);
        this.fh.Fill(imseg, (ConnectedComponentLabeling)this.ufccl, this.p16holesize, true, imseg);
        this.ufccl.Label(imseg, 0, true);
        this.ufccl.DeleteSmallerThan(imseg, this.p16cmpsize);
    }

    private void CreateROI(BufferedImage source, BufferedImage imtmp, BufferedImage imroi, int nbCPU) throws IOException {
        int thresh = -1;
        switch (this.algo) {
            case DISK: {
                this.huang.Filter(source, imtmp, nbCPU);
                this.invert.Filter(imtmp, imtmp, nbCPU);
                this.close.Filter(imtmp, this.sed3, imroi, nbCPU);
                this.open.Filter(imroi, this.sed3, imtmp, nbCPU);
                break;
            }
            case FIRST: {
                thresh = 19;
                switch (source.getType()) {
                    case 5: {
                        byte[] bbdnabin = ((DataBufferByte)imtmp.getRaster().getDataBuffer()).getData();
                        byte[] bbdna = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                        int i2 = 0;
                        int x = 0;
                        while (x < bbdna.length) {
                            byte b = bbdna[x];
                            byte g = bbdna[x + 1];
                            byte r = bbdna[x + 2];
                            bbdnabin[i2] = thresh < Math.abs(b - g) || thresh < Math.abs(b - r) || thresh < Math.abs(g - r) ? -1 : 0;
                            x += 3;
                            ++i2;
                        }
                        bbdnabin = null;
                        bbdna = null;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Image type not supported (yet). Color image with 3 channels required!");
                    }
                }
                this.open.Filter(imtmp, this.sed3, imroi, nbCPU);
                this.close.Filter(imroi, this.sed3, imtmp, nbCPU);
                break;
            }
            case P16: {
                thresh = 5;
                switch (source.getType()) {
                    case 5: {
                        byte[] bbdnabin = ((DataBufferByte)imtmp.getRaster().getDataBuffer()).getData();
                        byte[] bbdna = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                        int i3 = 0;
                        int x = 0;
                        while (x < bbdna.length) {
                            byte b = bbdna[x];
                            byte g = bbdna[x + 1];
                            byte r = bbdna[x + 2];
                            bbdnabin[i3] = thresh < Math.abs(b - g) || thresh < Math.abs(b - r) || thresh < Math.abs(g - r) ? -1 : 0;
                            x += 3;
                            ++i3;
                        }
                        bbdnabin = null;
                        bbdna = null;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Image type not supported (yet). Color image with 3 channels required!");
                    }
                }
                this.close.Filter(imtmp, this.sed3, imroi, nbCPU);
                this.open.Filter(imroi, this.sed3, imtmp, nbCPU);
                break;
            }
            case SENSITIVEROI: {
                try {
                    this.minthres.Filter(source, imtmp, nbCPU);
                }
                catch (Exception e) {
                    this.meanthres.Filter(source, imtmp, nbCPU);
                }
                this.triangle.Filter(source, imroi, nbCPU);
                ImageOperations.Minimum((BufferedImage)imtmp, (BufferedImage)imroi, (BufferedImage)imtmp);
                this.invert.Filter(imtmp, imtmp, nbCPU);
                this.close.Filter(imtmp, this.sed3, imroi, nbCPU);
                this.open.Filter(imroi, this.sed3, imtmp, nbCPU);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown algorithm, must not occur.");
            }
        }
        this.fh.Fill(imtmp, (ConnectedComponentLabeling)this.ufccl, this.dnaholesize, true, imroi);
        this.ufccl.Label(imroi, 0, true);
        this.ufccl.DeleteSmallerThan(imroi, this.dnacmpsize);
    }

    public void DrawBorders(BufferedImage bassins, int R, int G, int B, BufferedImage result) {
        int width = result.getWidth();
        int height = result.getHeight();
        switch (bassins.getType()) {
            case 10: {
                byte[] bbbas = ((DataBufferByte)bassins.getRaster().getDataBuffer()).getData();
                byte[] bbres = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                int p3 = 0;
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        int v = bbbas[pos] & 0xFF;
                        if (1 < v) {
                            boolean todo = false;
                            if (x == 0 || y == 0 || x == width - 1 || y == height - 1) {
                                todo = true;
                            } else if ((bbbas[pos - 1] & 0xFF) != v) {
                                todo = true;
                            } else if ((bbbas[pos + 1] & 0xFF) != v) {
                                todo = true;
                            } else if ((bbbas[pos - width] & 0xFF) != v) {
                                todo = true;
                            } else if ((bbbas[pos + width] & 0xFF) != v) {
                                todo = true;
                            }
                            if (todo) {
                                bbres[p3] = (byte)B;
                                bbres[p3 + 1] = (byte)G;
                                bbres[p3 + 2] = (byte)R;
                            }
                        }
                        ++x;
                        ++pos;
                        p3 += 3;
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
    }

    private static enum Algorithms {
        FIRST,
        DISK,
        P16,
        SENSITIVEROI;

    }
}

