/*
 * Decompiled with CFR 0.152.
 */
package softwares.ohsu.cousens;

import displays.Colors;
import displays.Display;
import filesAndFolders.FileFilters;
import filesAndFolders.FileNameFilters;
import imageTiTi.ImageComparator;
import imageTiTi.ImageConverter;
import imageTiTi.ImageDrawer;
import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import imageTiTi.ImageOperations;
import imageTiTi.ImageTools;
import init.Initializer;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Arrays;
import measures.cclh.UnionFindCcl;
import morphee.Erode;
import morphee.StructuringElement;
import morphee.filters.ASFilterOpenClose;
import morphee.geodesic.UnderBuild;
import morphee.segmentation.minmax.Maxima;
import morphee.segmentation.watershed.Watershed;
import processing.filters.AbsoluteChannelGap;
import processing.filters.DynamicExpansion;
import processing.filters.Median;
import processing.filters.gradients.Sobel;

public class HematoxylinSegmentation {
    public Display display = null;
    private AbsoluteChannelGap acg = new AbsoluteChannelGap();
    private ASFilterOpenClose asfoc = new ASFilterOpenClose();
    private DynamicExpansion de = new DynamicExpansion();
    private Erode erode = new Erode();
    private Maxima maxima = new Maxima();
    private Median median = new Median();
    private Sobel sobel = new Sobel();
    private UnderBuild ub = new UnderBuild();
    private UnionFindCcl ccl = new UnionFindCcl();
    private Watershed watershed = new Watershed();
    private StructuringElement sesquare1 = new StructuringElement(new Object[]{1, -1});
    private StructuringElement sehex = null;
    private StructuringElement sehex2;

    public HematoxylinSegmentation() {
        this.sehex = this.sehex2 = new StructuringElement(new Object[]{2, -9});
    }

    public HematoxylinSegmentation(int radius) {
        this.sehex2 = new StructuringElement(new Object[]{2, -9});
        this.sehex = new StructuringElement(new Object[]{radius, -9});
    }

    public void Nuclei(String directory, String resdir, int nbCPU) throws Exception {
        Object[] images = new File(directory).listFiles(FileNameFilters.ImagesTIF);
        for (int i2 = 0; i2 < images.length; ++i2) {
            String name = images[i2].getName();
            File resfile = new File(resdir + "/" + name.substring(0, name.length() - 4));
            if (!resfile.exists()) {
                resfile.mkdirs();
            }
            this.Nuclei(directory, name, resfile.getAbsolutePath(), nbCPU);
            name = null;
            resfile = null;
        }
        Arrays.fill(images, null);
        images = null;
    }

    public void Nuclei2(String directory, String resdir, int nbCPU) throws Exception {
        File[] dirs = new File(directory).listFiles(FileFilters.Directories);
        for (int d = 0; d < dirs.length; ++d) {
            String name = null;
            File resfile = null;
            Object[] images = new File(dirs[d].getAbsolutePath()).listFiles(FileNameFilters.ImagesTIF);
            for (int i2 = 0; i2 < images.length; ++i2) {
                name = images[i2].getName();
                resfile = new File(resdir + "/" + dirs[d].getName() + "/" + name.substring(0, name.length() - 4));
                if (!resfile.exists()) {
                    resfile.mkdirs();
                }
                try {
                    this.Nuclei(dirs[d].getAbsolutePath(), name, resfile.getAbsolutePath(), nbCPU);
                }
                catch (Exception e) {
                    System.out.flush();
                    System.err.println("'" + dirs[d].getAbsolutePath() + "' / '" + name + "' / '" + resfile.getAbsolutePath() + "'");
                    System.err.flush();
                    e.printStackTrace();
                    System.err.flush();
                }
                name = null;
                resfile = null;
            }
            Arrays.fill(images, null);
            images = null;
        }
    }

    public void Nuclei3(String directory, int nbCPU) throws Exception {
        Object[] images = new File(directory).listFiles(FileNameFilters.ImagesTIF);
        for (int i2 = 0; i2 < images.length; ++i2) {
            String name = images[i2].getName();
            this.Nuclei(directory, name, directory, nbCPU);
            name = null;
        }
        Arrays.fill(images, null);
        images = null;
    }

    public void Nuclei(String directory, String name, String resdir, int nbCPU) throws Exception {
        BufferedImage nuclei = ImageIO.Read(directory + "/final_mask/" + name.replace(".tif", "_.tif"));
        if (ImageTools.isBlack((BufferedImage)nuclei)) {
            return;
        }
        BufferedImage image = ImageIO.Read(directory + "/" + name);
        BufferedImage imgray = ImageConverter.RGB_To_GrayLevel((BufferedImage)image, (int)1);
        BufferedImage clone = ImageNew.Clone((BufferedImage)image);
        int width = image.getWidth();
        int height = image.getHeight();
        int w1 = width - 1;
        int h1 = height - 1;
        switch (nuclei.getType()) {
            case 12: {
                nuclei = ImageConverter.BinaryToGray((BufferedImage)nuclei);
                break;
            }
            case 10: {
                break;
            }
            case 5: {
                nuclei = ImageConverter.Channel((BufferedImage)nuclei, (int)0);
                ImageComparator.Compare((BufferedImage)nuclei, (String)"<=", (int)127, (int)0, (int)255, (BufferedImage)nuclei);
                break;
            }
            case 6: {
                nuclei = ImageConverter.Channel((BufferedImage)nuclei, (int)1);
                ImageComparator.Compare((BufferedImage)nuclei, (String)"<=", (int)127, (int)0, (int)255, (BufferedImage)nuclei);
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet)");
            }
        }
        BufferedImage nucero = this.erode.Filter(nuclei, this.sehex, nbCPU);
        BufferedImage nucleicleaned = this.ub.Filter(nuclei, nbCPU, nucero);
        ImageIO.Write(nucleicleaned, resdir + "/final_mask/" + name + "_Cleaned.png", 6);
        BufferedImage contour = ImageOperations.Contour((BufferedImage)nucleicleaned, (boolean)false);
        this.sobel.HowCorrect(2);
        BufferedImage imgrad = this.sobel.Filter(imgray, nbCPU);
        BufferedImage imtmpcolor = this.median.Filter(image, this.sesquare1, nbCPU);
        this.median.Filter(imtmpcolor, this.sesquare1, image, nbCPU);
        BufferedImage imacg = this.acg.Filter(image, nbCPU);
        BufferedImage imacg0 = ImageConverter.Channel((BufferedImage)imacg, (int)0);
        BufferedImage im_med_acg_asf = this.asfoc.Filter(imacg0, this.sehex2, nbCPU);
        this.de.Filter(im_med_acg_asf, 0, 255, im_med_acg_asf, nbCPU);
        ImageComparator.Compare((BufferedImage)nuclei, (String)"!=", (int)0, (BufferedImage)im_med_acg_asf, (int)0, (BufferedImage)im_med_acg_asf);
        this.maxima.Filter(im_med_acg_asf, -1, true);
        BufferedImage markers = ImageNew.Integer((int)width, (int)height, (int)1);
        ImageConverter.ArrayToImage((int[])this.maxima.Labels(), (BufferedImage)markers);
        for (int y = 1; y < h1; ++y) {
            for (int x = 1; x < w1; ++x) {
                if (nuclei.getRaster().getSample(x, y, 0) != 0) continue;
                if (nuclei.getRaster().getSample(x + 1, y, 0) != 0 || nuclei.getRaster().getSample(x - 1, y, 0) != 0 || nuclei.getRaster().getSample(x, y + 1, 0) != 0 || nuclei.getRaster().getSample(x, y - 1, 0) != 0 || nuclei.getRaster().getSample(x - 1, y - 1, 0) != 0 || nuclei.getRaster().getSample(x + 1, y - 1, 0) != 0 || nuclei.getRaster().getSample(x - 1, y + 1, 0) != 0 || nuclei.getRaster().getSample(x + 1, y + 1, 0) != 0) {
                    imgrad.getRaster().setSample(x, y, 0, 255);
                    continue;
                }
                markers.getRaster().setSample(x, y, 0, Integer.MAX_VALUE);
            }
        }
        ImageDrawer.Border(markers, 0, 1);
        this.watershed.watershed(imgrad, markers, new StructuringElement(new Object[]{1, -2}));
        ImageComparator.Compare((BufferedImage)nucleicleaned, (String)"!=", (int)0, (BufferedImage)this.watershed.Edges(), (int)0, (BufferedImage)this.watershed.Edges());
        ImageComparator.Compare((BufferedImage)this.watershed.Basins(), (String)"!=", (int)Integer.MAX_VALUE, (BufferedImage)this.watershed.Basins(), (int)0, (BufferedImage)this.watershed.Basins());
        ImageComparator.Compare((BufferedImage)nucleicleaned, (String)"!=", (int)0, (BufferedImage)this.watershed.Basins(), (int)0, (BufferedImage)this.watershed.Basins());
        ImageIO.Write(this.watershed.Edges(), resdir + "/final_outlines/" + name + "_Edges.png", 6);
        ImageDrawer.Draw(clone, this.watershed.Edges(), Colors.BLUE);
        ImageDrawer.Draw(clone, contour, Colors.RED);
        ImageIO.Write(clone, resdir + "/final_outlines/" + name + "_Segmented.png", 6);
        this.ccl.Label(this.watershed.Basins(), 0, true);
        ImageIO.Write(this.watershed.Basins(), resdir + "/final_mask/" + name + "_Labels.tif", 8);
    }

    public static void main(String[] args) throws Exception {
        Initializer.Start();
        if (args == null) {
            throw new Exception("No argument detected, 3 expected, ");
        }
        if (args == null || args.length != 3) {
            throw new Exception(args.length + " argument(s) detected, 3 expected (image directory, min radius, number of threads).");
        }
        HematoxylinSegmentation hs = new HematoxylinSegmentation(Integer.valueOf(args[1]));
        hs.Nuclei3(args[0], Integer.valueOf(args[2]));
        System.exit(0);
    }
}

