/*
 * Decompiled with CFR 0.152.
 */
package softwares.ohsu.cousens;

import arrayTiTi.ArrayFeatures;
import displays.Colors;
import displays.Display;
import filesAndFolders.FileFilters;
import imageTiTi.ImageComparator;
import imageTiTi.ImageConverter;
import imageTiTi.ImageDrawer;
import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import imageTiTi.ImageOperations;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import listTiTi.ListTools;
import listTiTi.Queue;
import mathematics.primitives.pointsTiTi.CoordinatesWeighted;
import measures.cclh.UnionFindCcl;
import morphee.Erode;
import morphee.StructuringElement;
import morphee.filters.ASFilterCloseOpen;
import morphee.geodesic.UnderBuild;
import morphee.segmentation.minmax.Maxima;
import morphee.segmentation.watershed.Watershed;
import processing.filters.DynamicExpansion;
import processing.filters.Invert;
import processing.filters.Median;
import processing.filters.gradients.Sobel;

public class HESegmentation {
    public Display display = null;
    private final ASFilterCloseOpen asfco = new ASFilterCloseOpen();
    private final DynamicExpansion de = new DynamicExpansion();
    private final Erode erode = new Erode();
    private final Invert invert = new Invert();
    private final Maxima maxima = new Maxima();
    private final Median median = new Median();
    private final Sobel sobel = new Sobel();
    private final UnderBuild ub = new UnderBuild();
    private final UnionFindCcl ccl = new UnionFindCcl();
    private final Watershed watershed = new Watershed();
    private final StructuringElement sedisk1 = new StructuringElement(new Object[]{1, -2});
    private final StructuringElement sesquare1 = new StructuringElement(new Object[]{1, -1});
    private final StructuringElement sehex1 = new StructuringElement(new Object[]{1, -9});
    public static FilenameFilter Images = (dir, name) -> name.charAt(0) != '.' && !name.contains("DS_Store") && (name.endsWith(".png") || name.endsWith(".PNG"));
    private final ArrayFeatures AF = new ArrayFeatures();

    public void Nuclei(String directory, int minsize, String resdir, int nbCPU) throws Exception {
        Object[] images;
        for (File file : images = new File(directory).listFiles(Images)) {
            String name = file.getName();
            File resfile = new File(resdir + "/" + name.substring(0, name.length() - 4));
            if (!resfile.exists()) {
                resfile.mkdirs();
            }
            this.Nuclei(directory, name, minsize, resfile.getAbsolutePath(), nbCPU);
            name = null;
            resfile = null;
        }
        Arrays.fill(images, null);
        images = null;
    }

    public void Nuclei2(String directory, int minsize, String resdir, int nbCPU) throws Exception {
        File[] dirs;
        for (File dir : dirs = new File(directory).listFiles(FileFilters.Directories)) {
            Object[] images;
            String name = null;
            File resfile = null;
            for (File file : images = new File(dir.getAbsolutePath()).listFiles(Images)) {
                name = file.getName();
                resfile = new File(resdir + "/" + dir.getName() + "/" + name.substring(0, name.length() - 4));
                if (!resfile.exists()) {
                    resfile.mkdirs();
                }
                try {
                    this.Nuclei(dir.getAbsolutePath(), name, minsize, resfile.getAbsolutePath(), nbCPU);
                }
                catch (Exception e) {
                    System.out.flush();
                    System.err.println("'" + dir.getAbsolutePath() + "' / '" + name + "' / '" + resfile.getAbsolutePath() + "'");
                    System.err.flush();
                    e.printStackTrace();
                    System.err.flush();
                }
                name = null;
                resfile = null;
            }
            Arrays.fill(images, null);
            images = null;
        }
    }

    public void Nuclei(String directory, String name, int minsize, String resdir, int nbCPU) throws Exception {
        int x;
        int y;
        int pos;
        BufferedImage nuclei = ImageIO.Read(directory + "/final_mask/" + name.replace(".png", "_.png"));
        if (ImageTools.isBlack((BufferedImage)nuclei)) {
            System.out.flush();
            System.err.println("Empty mask, nothing to process. Simple Exit!");
            System.err.flush();
            return;
        }
        BufferedImage image = ImageIO.Read(directory + "/" + name);
        BufferedImage imgray = ImageConverter.RGB_To_GrayLevel((BufferedImage)image, (int)1);
        BufferedImage clone = ImageNew.Clone((BufferedImage)image);
        int width = image.getWidth();
        int height = image.getHeight();
        int w1 = width - 1;
        int h1 = height - 1;
        switch (nuclei.getType()) {
            case 12: {
                nuclei = ImageConverter.BinaryToGray((BufferedImage)nuclei);
                break;
            }
            case 10: {
                break;
            }
            case 5: {
                nuclei = ImageConverter.Channel((BufferedImage)nuclei, (int)0);
                ImageComparator.Compare((BufferedImage)nuclei, (String)"<=", (int)127, (int)0, (int)255, (BufferedImage)nuclei);
                break;
            }
            case 6: {
                nuclei = ImageConverter.Channel((BufferedImage)nuclei, (int)1);
                ImageComparator.Compare((BufferedImage)nuclei, (String)"<=", (int)127, (int)0, (int)255, (BufferedImage)nuclei);
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet)");
            }
        }
        BufferedImage markers = ImageNew.Integer((int)width, (int)height, (int)1);
        this.sobel.HowCorrect(2);
        BufferedImage imgrad = this.sobel.Filter(imgray, nbCPU);
        BufferedImage nucerodil = this.erode.Filter(nuclei, this.sesquare1, nbCPU);
        BufferedImage nucleicleaned = this.ub.Filter(nuclei, nbCPU, nucerodil);
        ImageIO.Write(nucleicleaned, resdir + "/" + name + " - Nuclei Cleaned.png", 6);
        BufferedImage imtmpcolor = this.median.Filter(image, this.sesquare1, nbCPU);
        this.median.Filter(imtmpcolor, this.sesquare1, image, nbCPU);
        ImageConverter.RGB_To_GrayLevel((BufferedImage)image, (BufferedImage)imgray, (int)1);
        this.invert.Filter(imgray, imgray, nbCPU);
        BufferedImage im_med_asf = this.asfco.Filter(imgray, this.sehex1, nbCPU);
        this.de.Filter(im_med_asf, 0, 255, im_med_asf, nbCPU);
        ImageComparator.Compare((BufferedImage)nuclei, (String)"!=", (int)0, (BufferedImage)im_med_asf, (int)0, (BufferedImage)im_med_asf);
        this.maxima.Filter(im_med_asf, -1, true);
        ImageConverter.ArrayToImage((int[])this.maxima.Labels(), (BufferedImage)markers);
        switch (nuclei.getType()) {
            case 10: {
                byte[] bbnuc = ((DataBufferByte)nucleicleaned.getRaster().getDataBuffer()).getData();
                byte[] bbgrad = ((DataBufferByte)imgrad.getRaster().getDataBuffer()).getData();
                int[] ibmark = ((DataBufferInt)markers.getRaster().getDataBuffer()).getData();
                for (int y2 = 1; y2 < h1; ++y2) {
                    int x2 = 1;
                    pos = y2 * width + x2;
                    while (x2 < w1) {
                        if (bbnuc[pos] == 0) {
                            if (bbnuc[pos + 1] != 0 || bbnuc[pos - 1] != 0 || bbnuc[pos + width] != 0 || bbnuc[pos - width] != 0 || bbnuc[pos - width - 1] != 0 || bbnuc[pos - width + 1] != 0 || bbnuc[pos + width - 1] != 0 || bbnuc[pos + width + 1] != 0) {
                                bbgrad[pos] = -1;
                            } else {
                                ibmark[pos] = Integer.MAX_VALUE;
                            }
                        }
                        ++x2;
                        ++pos;
                    }
                }
                bbgrad = null;
                bbnuc = null;
                ibmark = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
        ImageDrawer.Border(markers, 0, 1);
        this.watershed.watershed(imgrad, markers, this.sedisk1);
        ImageComparator.Compare((BufferedImage)this.watershed.Basins(), (String)"!=", (int)Integer.MAX_VALUE, (BufferedImage)this.watershed.Basins(), (int)0, (BufferedImage)this.watershed.Basins());
        this.ccl.Label(this.watershed.Basins(), 0, true);
        int[] bassins = ((DataBufferInt)this.watershed.Basins().getRaster().getDataBuffer()).getData();
        byte[] edges = ((DataBufferByte)this.watershed.Edges().getRaster().getDataBuffer()).getData();
        int[] labels = this.ccl.Labels1D();
        System.arraycopy(labels, 0, bassins, 0, labels.length);
        int[] sizes = this.ccl.Sizes();
        pos = 0;
        for (y = 0; y < height; ++y) {
            x = 0;
            while (x < width) {
                if (bassins[pos] != 0 && sizes[labels[pos]] < minsize) {
                    this.ProcessSmallPattern(bassins, labels, sizes, width, height, x, y, pos, minsize);
                }
                ++x;
                ++pos;
            }
        }
        pos = 0;
        for (y = 0; y < height; ++y) {
            x = 0;
            while (x < width) {
                if (edges[pos] != 0) {
                    this.DeleteEdgePixel(bassins, edges, width, height, x, y, pos);
                }
                ++x;
                ++pos;
            }
        }
        BufferedImage contour = ImageOperations.Contour((BufferedImage)this.watershed.Basins(), (boolean)false);
        if (this.AF.Maximum(this.maxima.Labels()) <= 65535) {
            ImageIO.Write(ImageConverter.IntToShort((BufferedImage)this.watershed.Basins()), resdir + "/" + name + " - Masks.png", 6);
        }
        ImageIO.Write(this.watershed.Edges(), resdir + "/" + name + " - Edges.png", 6);
        ImageComparator.Compare((BufferedImage)this.watershed.Basins(), (String)"!=", (int)0, (BufferedImage)this.watershed.Edges(), (int)0, (BufferedImage)this.watershed.Edges());
        ImageDrawer.Draw(clone, this.watershed.Edges(), Colors.BLUE);
        ImageDrawer.Draw(clone, contour, Colors.RED);
        ImageIO.Write(clone, resdir + "/" + name + " - Segmented.png", 6);
    }

    private void ProcessSmallPattern(int[] bassins, int[] labels, int[] sizes, int width, int height, int X, int Y, int Pos, int minsize) throws Exception {
        int label = labels[Pos];
        int size = sizes[label];
        ArrayList<CoordinatesWeighted> pattern = new ArrayList<CoordinatesWeighted>(minsize + 3);
        pattern.add(new CoordinatesWeighted(X, Y, 0, Pos, -1));
        Queue<CoordinatesWeighted> queue = new Queue<CoordinatesWeighted>();
        queue.Push(new CoordinatesWeighted(X, Y, 0, Pos, -1));
        LinkedList<Integer> neighbors = new LinkedList<Integer>();
        while (!queue.Empty()) {
            CoordinatesWeighted c = (CoordinatesWeighted)queue.FrontPop();
            int x = c.X;
            int y = c.Y;
            int p = c.Pos;
            labels[p] = 0;
            if (0 < x) {
                if (labels[p - 1] == label) {
                    queue.Push(new CoordinatesWeighted(x - 1, y, 0, p - 1, -1));
                    pattern.add(new CoordinatesWeighted(x - 1, y, 0, p - 1, -1));
                    labels[p - 1] = 0;
                } else if (!ListTools.isInList(neighbors, (int)labels[p - 1])) {
                    neighbors.add(labels[p - 1]);
                }
            }
            if (x < width - 1) {
                if (labels[p + 1] == label) {
                    queue.Push(new CoordinatesWeighted(x + 1, y, 0, p + 1, -1));
                    pattern.add(new CoordinatesWeighted(x + 1, y, 0, p + 1, -1));
                    labels[p + 1] = 0;
                } else if (!ListTools.isInList(neighbors, (int)labels[p + 1])) {
                    neighbors.add(labels[p + 1]);
                }
            }
            if (0 < y) {
                if (labels[p - width] == label) {
                    queue.Push(new CoordinatesWeighted(x, y - 1, 0, p - width, -1));
                    pattern.add(new CoordinatesWeighted(x, y - 1, 0, p - width, -1));
                    labels[p - width] = 0;
                } else if (!ListTools.isInList(neighbors, (int)labels[p - width])) {
                    neighbors.add(labels[p - width]);
                }
            }
            if (y < height - 1) {
                if (labels[p + width] == label) {
                    queue.Push(new CoordinatesWeighted(x, y + 1, 0, p + width, -1));
                    pattern.add(new CoordinatesWeighted(x, y + 1, 0, p + width, -1));
                    labels[p + width] = 0;
                } else if (!ListTools.isInList(neighbors, (int)labels[p + width])) {
                    neighbors.add(labels[p + width]);
                }
            }
            if (0 < x && 0 < y) {
                if (labels[p - width - 1] == label) {
                    queue.Push(new CoordinatesWeighted(x - 1, y - 1, 0, p - width - 1, -1));
                    pattern.add(new CoordinatesWeighted(x - 1, y - 1, 0, p - width - 1, -1));
                    labels[p - width - 1] = 0;
                } else if (!ListTools.isInList(neighbors, (int)labels[p - width - 1])) {
                    neighbors.add(labels[p - width - 1]);
                }
            }
            if (x < width - 1 && 0 < y) {
                if (labels[p - width + 1] == label) {
                    queue.Push(new CoordinatesWeighted(x + 1, y - 1, 0, p - width + 1, -1));
                    pattern.add(new CoordinatesWeighted(x + 1, y - 1, 0, p - width + 1, -1));
                    labels[p - width + 1] = 0;
                } else if (!ListTools.isInList(neighbors, (int)labels[p - width + 1])) {
                    neighbors.add(labels[p - width + 1]);
                }
            }
            if (0 < x && y < height - 1) {
                if (labels[p + width - 1] == label) {
                    queue.Push(new CoordinatesWeighted(x - 1, y + 1, 0, p + width - 1, -1));
                    pattern.add(new CoordinatesWeighted(x - 1, y + 1, 0, p + width - 1, -1));
                    labels[p + width - 1] = 0;
                } else if (!ListTools.isInList(neighbors, (int)labels[p + width - 1])) {
                    neighbors.add(labels[p + width - 1]);
                }
            }
            if (x >= width - 1 || y >= height - 1) continue;
            if (labels[p + width + 1] == label) {
                queue.Push(new CoordinatesWeighted(x + 1, y + 1, 0, p + width + 1, -1));
                pattern.add(new CoordinatesWeighted(x + 1, y + 1, 0, p + width + 1, -1));
                labels[p + width + 1] = 0;
                continue;
            }
            if (ListTools.isInList(neighbors, (int)labels[p + width + 1])) continue;
            neighbors.add(labels[p + width + 1]);
        }
        if (pattern.size() != size) {
            throw new Exception("pattern.size() != size => " + pattern.size() + " vs " + size);
        }
        if (neighbors.size() == 1 && (Integer)neighbors.get(0) == 0) {
            pattern.clear();
            pattern = null;
            queue = null;
            neighbors.clear();
            neighbors = null;
            return;
        }
        sizes[label] = 0;
        Iterator iter = neighbors.iterator();
        int smallest = (Integer)iter.next();
        while (iter.hasNext()) {
            int lab = (Integer)iter.next();
            if (sizes[lab] >= sizes[smallest]) continue;
            smallest = lab;
        }
        Iterator it = pattern.iterator();
        while (it.hasNext()) {
            int pos = ((CoordinatesWeighted)it.next()).Pos;
            bassins[pos] = labels[pos] = smallest;
        }
        it = null;
        int n = smallest;
        sizes[n] = sizes[n] + pattern.size();
        pattern.clear();
        pattern = null;
        queue = null;
        neighbors.clear();
        neighbors = null;
    }

    private void DeleteEdgePixel(int[] bassins, byte[] edges, int width, int height, int x, int y, int p) {
        LinkedList<Integer> neighbors = new LinkedList<Integer>();
        if (0 < x && !ListTools.isInList(neighbors, (int)bassins[p - 1])) {
            neighbors.add(bassins[p - 1]);
        }
        if (x < width - 1 && !ListTools.isInList(neighbors, (int)bassins[p + 1])) {
            neighbors.add(bassins[p + 1]);
        }
        if (0 < y && !ListTools.isInList(neighbors, (int)bassins[p - width])) {
            neighbors.add(bassins[p - width]);
        }
        if (y < height - 1 && !ListTools.isInList(neighbors, (int)bassins[p + width])) {
            neighbors.add(bassins[p + width]);
        }
        if (0 < x && 0 < y && !ListTools.isInList(neighbors, (int)bassins[p - width - 1])) {
            neighbors.add(bassins[p - width - 1]);
        }
        if (x < width - 1 && 0 < y && !ListTools.isInList(neighbors, (int)bassins[p - width + 1])) {
            neighbors.add(bassins[p - width + 1]);
        }
        if (0 < x && y < height - 1 && !ListTools.isInList(neighbors, (int)bassins[p + width - 1])) {
            neighbors.add(bassins[p + width - 1]);
        }
        if (x < width - 1 && y < height - 1 && !ListTools.isInList(neighbors, (int)bassins[p + width + 1])) {
            neighbors.add(bassins[p + width + 1]);
        }
        if (neighbors.size() <= 1) {
            edges[p] = 0;
        }
        neighbors.clear();
        neighbors = null;
    }

    private void DeleteEdgePixel(int[] bassins, int bassin, byte[] edges, int width, int height, int x, int y, int p) {
        LinkedList<Integer> neighbors = new LinkedList<Integer>();
        if (0 < x && bassins[p - 1] != 0 && bassins[p - 1] != bassin && !ListTools.isInList(neighbors, (int)bassins[p - 1])) {
            neighbors.add(bassins[p - 1]);
        }
        if (x < width - 1 && bassins[p + 1] != 0 && bassins[p + 1] != bassin && !ListTools.isInList(neighbors, (int)bassins[p + 1])) {
            neighbors.add(bassins[p + 1]);
        }
        if (0 < y && bassins[p - width] != 0 && bassins[p - width] != bassin && !ListTools.isInList(neighbors, (int)bassins[p - width])) {
            neighbors.add(bassins[p - width]);
        }
        if (y < height - 1 && bassins[p + width] != 0 && bassins[p + width] != bassin && !ListTools.isInList(neighbors, (int)bassins[p + width])) {
            neighbors.add(bassins[p + width]);
        }
        if (0 < x && 0 < y && bassins[p - width - 1] != 0 && bassins[p - width - 1] != bassin && !ListTools.isInList(neighbors, (int)bassins[p - width - 1])) {
            neighbors.add(bassins[p - width - 1]);
        }
        if (x < width - 1 && 0 < y && bassins[p - width + 1] != 0 && bassins[p - width + 1] != bassin && !ListTools.isInList(neighbors, (int)bassins[p - width + 1])) {
            neighbors.add(bassins[p - width + 1]);
        }
        if (0 < x && y < height - 1 && bassins[p + width - 1] != 0 && bassins[p + width - 1] != bassin && !ListTools.isInList(neighbors, (int)bassins[p + width - 1])) {
            neighbors.add(bassins[p + width - 1]);
        }
        if (x < width - 1 && y < height - 1 && bassins[p + width + 1] != 0 && bassins[p + width + 1] != bassin && !ListTools.isInList(neighbors, (int)bassins[p + width + 1])) {
            neighbors.add(bassins[p + width + 1]);
        }
        if (neighbors.size() <= 1) {
            edges[p] = 0;
        }
        neighbors.clear();
        neighbors = null;
    }

    public static void main(String[] args) {
        if (args == null || args.length != 5) {
            System.err.println("Wrong number of argument: " + (args == null ? 0 : args.length) + " instead of 5.");
            System.exit(1);
        }
        HESegmentation hs = new HESegmentation();
        try {
            hs.Nuclei(args[0], args[1], Integer.valueOf(args[2]), args[3], Integer.valueOf(args[4]));
        }
        catch (Exception ex) {
            System.err.println(ex.getCause());
            System.err.println(ex.getMessage());
            System.err.flush();
            ex.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}

