/*
 * Decompiled with CFR 0.152.
 */
package softwares.ohsu.breastcancer;

import arrayTiTi.ArrayStatistics;
import arrayTiTi.ArrayTools;
import characterization.textures.lbp.LocalBinaryPattern;
import dataMining.classifiers.parameters.ClassifierParameterFunction;
import dataMining.regressions.GenericRegression;
import dv.DV;
import dv.DvIO;
import dv.DvOperations;
import filesAndFolders.fichiersTabules.FichierTabule;
import filesAndFolders.fichiersTabules.FichierTabuleTools;
import imageTiTi.ImageIO;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.lang.invoke.CallSite;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import utils.LogFile;

public class CharacterizeTumor {
    private LocalBinaryPattern characterizer = new LocalBinaryPattern();
    FileFilter ff = file -> {
        if (!file.isFile()) {
            return false;
        }
        if (!file.getName().contains(".png")) {
            return false;
        }
        if (file.getName().contains("BALDERO")) {
            return false;
        }
        if (file.getName().contains("chiFX")) {
            return false;
        }
        if (file.getName().contains("TauInvFXR3")) {
            return false;
        }
        return file.getName().charAt(0) != '.';
    };
    FileFilter ff2 = file -> {
        if (!file.isFile()) {
            return false;
        }
        if (!file.getName().contains(".txt")) {
            return false;
        }
        return file.getName().charAt(0) != '.';
    };

    public void Process(String inputfolder, String outputfile, int nbCPU) throws Exception {
        File[] patients = new File(inputfolder).listFiles();
        LogFile log = new LogFile();
        double[] Features2 = null;
        DataOutputStream Out = new DataOutputStream(new FileOutputStream(outputfile));
        String[] FeaturesNames = this.characterizer.FeaturesNames();
        for (int i2 = 0; i2 < FeaturesNames.length; ++i2) {
            Out.write(String.valueOf("\"" + FeaturesNames[i2] + "\" ").getBytes("ASCII"));
        }
        Out.write(String.valueOf("\"Patient\" \"Visit\" \"Image\"\n").getBytes("ASCII"));
        boolean work = false;
        for (int p = 0; p < patients.length; ++p) {
            File[] visits;
            if (!patients[p].isDirectory() || !work || (visits = patients[p].listFiles()) == null) continue;
            for (int v = 0; v < visits.length; ++v) {
                File[] images;
                if (!visits[v].isDirectory() || (images = visits[v].listFiles(this.ff)) == null) continue;
                for (int i3 = 0; i3 < images.length; ++i3) {
                    try {
                        BufferedImage image = ImageIO.Read(images[i3].getAbsolutePath());
                        String name = images[i3].getName();
                        if (ImageTools.isBlack((BufferedImage)image)) continue;
                        Features2 = this.characterizer.Features();
                        for (int c = 0; c < Features2.length; ++c) {
                            Out.write(String.valueOf(Features2[c] + " ").getBytes("ASCII"));
                        }
                        Out.write(String.valueOf("\"" + patients[p].getName() + "\" \"" + visits[v].getName() + "\" \"" + name + "\"\n").getBytes("ASCII"));
                        image = null;
                        name = null;
                        continue;
                    }
                    catch (Exception E) {
                        E.printStackTrace();
                        log.addNewException(E, new String[0]);
                        continue;
                    }
                    catch (Error E) {
                        E.printStackTrace();
                        log.addNewError(E, new String[0]);
                    }
                }
            }
        }
        System.out.println(log.Resume());
    }

    public void Process3D(String inputfolder, List<String> proteins, String outputfile, int nbCPU) throws Exception {
        File[] patients = new File(inputfolder).listFiles();
        LogFile log = new LogFile();
        double[] Features2 = null;
        DataOutputStream Out = new DataOutputStream(new FileOutputStream(outputfile));
        String[] FeaturesNames = this.characterizer.FeaturesNames();
        for (int i2 = 0; i2 < FeaturesNames.length; ++i2) {
            Out.write(String.valueOf("\"" + FeaturesNames[i2] + "\" ").getBytes("ASCII"));
        }
        Out.write(String.valueOf("\"Patient\" \"Visit\" \"Image\"\n").getBytes("ASCII"));
        boolean work = true;
        for (int p = 0; p < patients.length; ++p) {
            File[] visits;
            if (!patients[p].isDirectory() || !work || (visits = patients[p].listFiles()) == null) continue;
            for (int v = 0; v < visits.length; ++v) {
                if (!visits[v].isDirectory()) continue;
                for (int prot = 0; prot < proteins.size(); ++prot) {
                    try {
                        String protein = proteins.get(prot);
                        FilenameFilter fnf = (file, string) -> string.charAt(0) != '.' && string.contains(".png") && string.contains(protein);
                        DV dv = DvIO.ReadFromStack(visits[v].getAbsolutePath(), fnf);
                        DV dvs = DvOperations.Minimize((DV)dv, (int)1);
                        dv = null;
                        this.characterizer.Compute(dvs, nbCPU);
                        Features2 = this.characterizer.Features();
                        for (int c = 0; c < Features2.length; ++c) {
                            Out.write(String.valueOf(Features2[c] + " ").getBytes("ASCII"));
                        }
                        Out.write(String.valueOf("\"" + patients[p].getName() + "\" \"" + visits[v].getName() + "\" \"" + protein + "\"\n").getBytes("ASCII"));
                        dv = null;
                        dvs = null;
                        continue;
                    }
                    catch (Exception E) {
                        E.printStackTrace();
                        log.addNewException(E, new String[0]);
                        continue;
                    }
                    catch (Error E) {
                        E.printStackTrace();
                        log.addNewError(E, new String[0]);
                    }
                }
            }
        }
        System.out.println(log.Resume());
    }

    public void SortFeatures(String folderpath, List<String> stainings, List<String> visits, FichierTabule scores) {
        File[] features = new File(folderpath).listFiles(this.ff2);
        for (int f = 0; f < features.length; ++f) {
            try {
                FichierTabule file = new FichierTabule(features[f].getAbsolutePath(), true);
                FichierTabule fileup = FichierTabuleTools.AddColumns(file, new int[]{1, 2});
                file.Kill();
                file = null;
                int colrcbscore = fileup.Width() - 2;
                int colrcbclass = fileup.Width() - 1;
                int colinst = fileup.ColumnNumber("Patient");
                fileup.setColumnName(colrcbscore, "RCBscore");
                fileup.setColumnName(colrcbclass, "RCBclass");
                for (int s = 0; s < scores.Height(); ++s) {
                    fileup.SelectWhere(colinst, 0, scores.getValueString(s, 0));
                    fileup.setValueInSelection(colrcbscore, scores.getValueDouble(s, 1));
                    fileup.setValueInSelection(colrcbclass, scores.getValueString(s, 2));
                }
                fileup.SelectNull(colrcbclass);
                fileup.ExcludeSelectedRows();
                FichierTabule finalfile = FichierTabuleTools.DeleteExcludedRows(fileup);
                fileup.Kill();
                fileup = null;
                for (int s = 0; s < stainings.size(); ++s) {
                    String staining = stainings.get(s);
                    for (int v = 0; v < visits.size(); ++v) {
                        String visit = visits.get(v);
                        File result = new File(folderpath + "/SortedFeatures/" + staining + "/" + visit + "/");
                        if (!result.exists()) {
                            result.mkdirs();
                        }
                        finalfile.SelectWhere("Image", 0, staining);
                        finalfile.SelectFromSelectionWhere("Visit", 0, visit);
                        FichierTabule resfile = FichierTabuleTools.SaveSelectedRows(finalfile);
                        resfile.Write(result.getAbsolutePath() + "/" + features[f].getName(), false);
                        resfile.Kill();
                        resfile = null;
                        finalfile.ClearSelectionRows();
                        visit = null;
                        result = null;
                    }
                    staining = null;
                }
                finalfile.Kill();
                finalfile = null;
                continue;
            }
            catch (Exception E) {
                E.printStackTrace();
                System.exit(0);
            }
        }
        features = null;
    }

    public void ComputeCorrelations(String folderpath) throws Exception {
        int nb;
        LinkedList<String> resmap = new LinkedList<String>();
        LinkedList<CallSite> resvv = new LinkedList<CallSite>();
        LinkedList<String> resmethod = new LinkedList<String>();
        LinkedList<String> resfeature = new LinkedList<String>();
        LinkedList<Double> rescorr = new LinkedList<Double>();
        LinkedList<Integer> rescounter = new LinkedList<Integer>();
        int size = 50;
        double[] features = new double[size];
        double[] scores = new double[size];
        File[] maps = new File(folderpath).listFiles();
        double eps = ArrayStatistics.Epsilon;
        ArrayStatistics.Epsilon *= 0.001;
        for (int m = 0; m < maps.length; ++m) {
            if (!maps[m].isDirectory()) continue;
            File[] v1files = new File(maps[m].getAbsolutePath() + "/V1/").listFiles(this.ff2);
            for (int v1 = 0; v1 < v1files.length; ++v1) {
                try {
                    FichierTabule v1file = new FichierTabule(v1files[v1].getAbsolutePath(), true);
                    int nbfeatures = v1file.Width() - 5;
                    int colpatient = v1file.Width() - 5;
                    int colscore = v1file.Width() - 2;
                    for (int vi = 2; vi <= 4; ++vi) {
                        FichierTabule vif = new FichierTabule(maps[m].getAbsolutePath() + "/V" + vi + "/" + v1files[v1].getName(), true);
                        if (vif.Width() != v1file.Width()) {
                            throw new Exception("vif.Width() != v1file.Width()");
                        }
                        for (int feature = 0; feature < nbfeatures; ++feature) {
                            resmap.add(maps[m].getName());
                            resvv.add((CallSite)((Object)("V1V" + vi)));
                            resmethod.add(v1files[v1].getName().replace(".txt", ""));
                            resfeature.add(vif.getColumnName(feature));
                            nb = 0;
                            block10: for (int y = 0; y < v1file.Height(); ++y) {
                                String patient = v1file.getValueString(y, colpatient);
                                vif.SelectWhere(colpatient, 0, patient);
                                if (vif.nbSelected() == 0) continue;
                                if (vif.nbSelected() != 1) {
                                    throw new Exception("vif.nbSelected() != 1");
                                }
                                switch (v1file.ColumnType(feature)) {
                                    case 1: {
                                        double d2;
                                        double d1 = v1file.getValueDouble(y, feature);
                                        if (Double.isNaN(d1) || Double.isNaN(d2 = vif.getValueDouble(vif.FirstSelected(), feature))) continue block10;
                                        features[nb] = d1 - d2;
                                        break;
                                    }
                                    case 0: {
                                        features[nb] = v1file.getValueInt(y, feature) - vif.getValueInt(vif.FirstSelected(), feature);
                                        break;
                                    }
                                    default: {
                                        throw new Error("Should not occur.");
                                    }
                                }
                                scores[nb] = v1file.getValueDouble(y, colscore);
                                ++nb;
                            }
                            rescorr.add(Math.abs(ArrayStatistics.Correlation(features, scores, 0, nb)));
                            rescounter.add(nb);
                        }
                        vif.Kill();
                        vif = null;
                    }
                    v1file.Kill();
                    v1file = null;
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    System.exit(0);
                }
            }
        }
        if (resmap.size() != resvv.size() || resmap.size() != resmethod.size() || resmap.size() != resfeature.size() || resmap.size() != rescorr.size()) {
            throw new Exception("Different lengths.");
        }
        FichierTabule resfile = new FichierTabule(resmap.size(), new int[]{2, 2, 2, 2, 1, 0}, "result");
        nb = 0;
        Iterator itermap = resmap.iterator();
        Iterator itervv = resvv.iterator();
        Iterator itermethod = resmethod.iterator();
        Iterator iterfeature = resfeature.iterator();
        Iterator itercorr = rescorr.iterator();
        Iterator itercounter = rescounter.iterator();
        while (itermap.hasNext()) {
            resfile.setValue(nb, 0, (String)itermap.next());
            resfile.setValue(nb, 1, (String)itervv.next());
            resfile.setValue(nb, 2, (String)itermethod.next());
            resfile.setValue(nb, 3, (String)iterfeature.next());
            resfile.setValue(nb, 4, (Double)itercorr.next());
            resfile.setValue(nb, 5, (Integer)itercounter.next());
            ++nb;
        }
        resfile.setColumnName(0, "Map");
        resfile.setColumnName(1, "V1Vx");
        resfile.setColumnName(2, "Method");
        resfile.setColumnName(3, "Feature");
        resfile.setColumnName(4, "Correlation");
        resfile.setColumnName(5, "Counter");
        if (nb != resfile.Height()) {
            throw new Error("Souci: nb != resfile.Height().");
        }
        resfile.Write("Correlations.txt", false);
        ArrayStatistics.Epsilon = eps;
        maps = null;
    }

    public FichierTabule ComputeModelisationsGR(String folderpath, Object classifier, ClassifierParameterFunction cpf) throws Exception {
        int nb;
        LinkedList<String> resmap = new LinkedList<String>();
        LinkedList<CallSite> resvv = new LinkedList<CallSite>();
        LinkedList<String> resmethod = new LinkedList<String>();
        LinkedList<CallSite> resfeature = new LinkedList<CallSite>();
        LinkedList<Double> rescorr = new LinkedList<Double>();
        LinkedList<Double> resSpear = new LinkedList<Double>();
        LinkedList<Double> resSpearerr = new LinkedList<Double>();
        LinkedList<Double> resSpearstu = new LinkedList<Double>();
        LinkedList<Double> resSpearzsc = new LinkedList<Double>();
        LinkedList<Double> resgkg = new LinkedList<Double>();
        LinkedList<Double> reskena = new LinkedList<Double>();
        LinkedList<Double> reskenb = new LinkedList<Double>();
        LinkedList<Integer> resinstcounter = new LinkedList<Integer>();
        LinkedList<Integer> rescoefcounter = new LinkedList<Integer>();
        LinkedList<String> rescoef = new LinkedList<String>();
        File[] maps = new File(folderpath).listFiles();
        double eps = ArrayStatistics.Epsilon;
        ArrayStatistics.Epsilon *= 0.001;
        GenericRegression regression = new GenericRegression(classifier, cpf);
        for (int m = 0; m < maps.length; ++m) {
            if (!maps[m].isDirectory()) continue;
            File[] v1files = new File(maps[m].getAbsolutePath() + "/V1/").listFiles(this.ff2);
            for (int v1 = 0; v1 < v1files.length; ++v1) {
                try {
                    FichierTabule v1file = new FichierTabule(v1files[v1].getAbsolutePath(), true);
                    int nbfeatures = v1file.Width() - 5;
                    int colpatient = v1file.Width() - 5;
                    for (int vi = 2; vi <= 4; ++vi) {
                        int y;
                        FichierTabule vif = new FichierTabule(maps[m].getAbsolutePath() + "/V" + vi + "/" + v1files[v1].getName(), true);
                        if (vif.Width() != v1file.Width()) {
                            throw new Exception("vif.Width() != v1file.Width()");
                        }
                        FichierTabule workfile = FichierTabuleTools.Clone(v1file);
                        nb = 0;
                        for (y = 0; y < v1file.Height(); ++y) {
                            String patient = v1file.getValueString(y, colpatient);
                            vif.SelectWhere(colpatient, 0, patient);
                            if (vif.nbSelected() == 0) continue;
                            if (vif.nbSelected() != 1) {
                                throw new Exception("vif.nbSelected() != 1");
                            }
                            block10: for (int feature = 0; feature < nbfeatures; ++feature) {
                                switch (v1file.ColumnType(feature)) {
                                    case 1: {
                                        double d2;
                                        double d1 = v1file.getValueDouble(y, feature);
                                        if (Double.isNaN(d1) || Double.isNaN(d2 = vif.getValueDouble(vif.FirstSelected(), feature))) continue block10;
                                        workfile.setValue(nb, feature, d1 - d2);
                                        continue block10;
                                    }
                                    case 0: {
                                        workfile.setValue(nb, feature, v1file.getValueInt(y, feature) - vif.getValueInt(vif.FirstSelected(), feature));
                                        continue block10;
                                    }
                                    default: {
                                        throw new Error("Should not occur.");
                                    }
                                }
                            }
                            ++nb;
                        }
                        workfile.ClearAll();
                        for (y = nb; y < workfile.Height(); ++y) {
                            workfile.setExcluded(y, true);
                        }
                        workfile.setExcludedColumn(workfile.Width() - 5, true);
                        workfile.setExcludedColumn(workfile.Width() - 4, true);
                        workfile.setExcludedColumn(workfile.Width() - 3, true);
                        workfile.setExcludedColumn(workfile.Width() - 1, true);
                        FichierTabule regfile = FichierTabuleTools.DeleteExcluded(workfile);
                        regfile.Target(regfile.Width() - 1);
                        for (int f1 = 0; f1 < nbfeatures - 2; ++f1) {
                            for (int f2 = f1 + 1; f2 < nbfeatures - 1; ++f2) {
                                for (int f3 = f2 + 1; f3 < nbfeatures; ++f3) {
                                    Arrays.fill(regfile.getExcludedColumn(), true);
                                    regfile.setExcludedColumn(regfile.Width() - 1, false);
                                    regfile.setExcludedColumn(f1, false);
                                    regfile.setExcludedColumn(f2, false);
                                    regfile.setExcludedColumn(f3, false);
                                    regfile.Target(regfile.Width() - 1);
                                    resmap.add(maps[m].getName());
                                    resvv.add((CallSite)((Object)("V1V" + vi)));
                                    resmethod.add(v1files[v1].getName().replace(".txt", ""));
                                    resfeature.add((CallSite)((Object)(regfile.getColumnName(f1) + "+" + regfile.getColumnName(f2) + "+" + regfile.getColumnName(f3))));
                                    regression.LearnPredictEvaluate(regfile, 1, regfile.Height() - regfile.nbExcluded());
                                    rescoefcounter.add(0);
                                    rescoef.add("*");
                                    double[] checks = regression.Checks();
                                    rescorr.add(Math.abs(checks[0]));
                                    resSpear.add(Math.abs(checks[1]));
                                    resSpearerr.add(Math.abs(checks[2]));
                                    resSpearstu.add(Math.abs(checks[3]));
                                    resSpearzsc.add(Math.abs(checks[4]));
                                    resgkg.add(Math.abs(checks[5]));
                                    reskena.add(Math.abs(checks[6]));
                                    reskenb.add(Math.abs(checks[7]));
                                    resinstcounter.add(regfile.Height() - regfile.nbExcluded());
                                    checks = null;
                                }
                            }
                        }
                        vif.Kill();
                        vif = null;
                        workfile.Kill();
                        workfile = null;
                        regfile.Kill();
                        regfile = null;
                    }
                    v1file.Kill();
                    v1file = null;
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    System.exit(0);
                }
            }
        }
        if (resmap.size() != resvv.size() || resmap.size() != resmethod.size() || resmap.size() != resfeature.size() || resmap.size() != rescorr.size()) {
            throw new Exception("Different lengths.");
        }
        FichierTabule resfile = new FichierTabule(resmap.size(), new int[]{2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 2}, "result");
        nb = 0;
        Iterator itermap = resmap.iterator();
        Iterator itervv = resvv.iterator();
        Iterator itermethod = resmethod.iterator();
        Iterator iterfeature = resfeature.iterator();
        Iterator itercorr = rescorr.iterator();
        Iterator iterspear = resSpear.iterator();
        Iterator iterspearerr = resSpearerr.iterator();
        Iterator iterspearstu = resSpearstu.iterator();
        Iterator iterspearzsc = resSpearzsc.iterator();
        Iterator itergkg = resgkg.iterator();
        Iterator iterkena = reskena.iterator();
        Iterator iterkenb = reskenb.iterator();
        Iterator iterinstcounter = resinstcounter.iterator();
        Iterator itercoefcounter = rescoefcounter.iterator();
        Iterator itercoef = rescoef.iterator();
        while (itermap.hasNext()) {
            resfile.setValue(nb, 0, (String)itermap.next());
            resfile.setValue(nb, 1, (String)itervv.next());
            resfile.setValue(nb, 2, (String)itermethod.next());
            resfile.setValue(nb, 3, (String)iterfeature.next());
            resfile.setValue(nb, 4, (Double)itercorr.next());
            resfile.setValue(nb, 5, (Double)iterspear.next());
            resfile.setValue(nb, 6, (Double)iterspearerr.next());
            resfile.setValue(nb, 7, (Double)iterspearstu.next());
            resfile.setValue(nb, 8, (Double)iterspearzsc.next());
            resfile.setValue(nb, 9, (Double)itergkg.next());
            resfile.setValue(nb, 10, (Double)iterkena.next());
            resfile.setValue(nb, 11, (Double)iterkenb.next());
            resfile.setValue(nb, 12, (Integer)iterinstcounter.next());
            resfile.setValue(nb, 13, (Integer)itercoefcounter.next());
            resfile.setValue(nb, 14, (String)itercoef.next());
            ++nb;
        }
        resfile.setColumnName(0, "Map");
        resfile.setColumnName(1, "V1Vx");
        resfile.setColumnName(2, "Method");
        resfile.setColumnName(3, "Features");
        resfile.setColumnName(4, "Correlation");
        resfile.setColumnName(5, "Spearman");
        resfile.setColumnName(6, "Spearman Error");
        resfile.setColumnName(7, "Spearman Student");
        resfile.setColumnName(8, "Spearman z-score");
        resfile.setColumnName(9, "Goodman Kruskal Gamma");
        resfile.setColumnName(10, "Kendall-a");
        resfile.setColumnName(11, "Kendall-b");
        resfile.setColumnName(12, "InstCounter");
        resfile.setColumnName(13, "CoefCounter");
        resfile.setColumnName(14, "Coefficients");
        if (nb != resfile.Height()) {
            throw new Error("Souci: nb != resfile.Height().");
        }
        ArrayStatistics.Epsilon = eps;
        maps = null;
        return resfile;
    }

    public FichierTabule ComputeModelisationsGRsingle(String folderpath, int Vi, Object classifier, ClassifierParameterFunction cpf) throws Exception {
        LinkedList<String> resmap = new LinkedList<String>();
        LinkedList<CallSite> resvv = new LinkedList<CallSite>();
        LinkedList<String> resmethod = new LinkedList<String>();
        LinkedList<CallSite> resfeature = new LinkedList<CallSite>();
        LinkedList<Double> rescorr = new LinkedList<Double>();
        LinkedList<Double> resSpear = new LinkedList<Double>();
        LinkedList<Double> resSpearerr = new LinkedList<Double>();
        LinkedList<Double> resSpearstu = new LinkedList<Double>();
        LinkedList<Double> resSpearzsc = new LinkedList<Double>();
        LinkedList<Double> resgkg = new LinkedList<Double>();
        LinkedList<Double> reskena = new LinkedList<Double>();
        LinkedList<Double> reskenb = new LinkedList<Double>();
        LinkedList<Integer> resinstcounter = new LinkedList<Integer>();
        LinkedList<double[]> respred = new LinkedList<double[]>();
        String[] patients = null;
        File[] maps = new File(folderpath).listFiles();
        double eps = ArrayStatistics.Epsilon;
        ArrayStatistics.Epsilon *= 0.001;
        GenericRegression regression = new GenericRegression(classifier, cpf);
        for (int m = 0; m < maps.length; ++m) {
            if (!maps[m].isDirectory()) continue;
            File[] vifiles = new File(maps[m].getAbsolutePath() + "/V" + Vi + "/").listFiles(this.ff2);
            for (int f = 0; f < vifiles.length; ++f) {
                try {
                    FichierTabule vifile = new FichierTabule(vifiles[f].getAbsolutePath(), true);
                    int nbfeatures = vifile.Width() - 5;
                    int colpatient = vifile.Width() - 5;
                    if (patients == null) {
                        patients = (String[])vifile.getColumnString(colpatient).clone();
                    } else if (!ArrayTools.AreEqual(patients, (String[])vifile.getColumnString(colpatient))) {
                        throw new Error("Oups: patent names!");
                    }
                    for (int f1 = 0; f1 < nbfeatures - 2; ++f1) {
                        for (int f2 = f1 + 1; f2 < nbfeatures - 1; ++f2) {
                            for (int f3 = f2 + 1; f3 < nbfeatures; ++f3) {
                                Arrays.fill(vifile.getExcludedColumn(), true);
                                vifile.setExcludedColumn(f1, false);
                                vifile.setExcludedColumn(f2, false);
                                vifile.setExcludedColumn(f3, false);
                                vifile.setExcludedColumn(vifile.Width() - 2, false);
                                vifile.Target(vifile.Width() - 2);
                                resmap.add(maps[m].getName());
                                resvv.add((CallSite)((Object)("V" + Vi)));
                                resmethod.add(vifiles[f].getName().replace(".txt", ""));
                                resfeature.add((CallSite)((Object)(vifile.getColumnName(f1) + "+" + vifile.getColumnName(f2) + "+" + vifile.getColumnName(f3))));
                                regression.LearnPredictEvaluate(vifile, 1, vifile.Height());
                                double[] checks = regression.Checks();
                                rescorr.add(Math.abs(checks[0]));
                                resSpear.add(Math.abs(checks[1]));
                                resSpearerr.add(Math.abs(checks[2]));
                                resSpearstu.add(Math.abs(checks[3]));
                                resSpearzsc.add(Math.abs(checks[4]));
                                resgkg.add(Math.abs(checks[5]));
                                reskena.add(Math.abs(checks[6]));
                                reskenb.add(Math.abs(checks[7]));
                                resinstcounter.add(vifile.Height() - vifile.nbExcluded());
                                respred.add((double[])regression.Predictions().clone());
                                checks = null;
                            }
                        }
                    }
                    vifile.Kill();
                    vifile = null;
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    System.exit(0);
                }
            }
        }
        if (resmap.size() != resvv.size() || resmap.size() != resmethod.size() || resmap.size() != resfeature.size() || resmap.size() != rescorr.size()) {
            throw new Exception("Different lengths.");
        }
        int[] types = new int[13 + ((double[])respred.get(0)).length];
        Arrays.fill(types, 1);
        types[3] = 2;
        types[2] = 2;
        types[1] = 2;
        types[0] = 2;
        types[12] = 0;
        FichierTabule resfile = new FichierTabule(resmap.size(), types, "result");
        resfile.setColumnName(0, "Map");
        resfile.setColumnName(1, "Vx");
        resfile.setColumnName(2, "Method");
        resfile.setColumnName(3, "Features");
        resfile.setColumnName(4, "Correlation");
        resfile.setColumnName(5, "Spearman");
        resfile.setColumnName(6, "Spearman Error");
        resfile.setColumnName(7, "Spearman Student");
        resfile.setColumnName(8, "Spearman z-score");
        resfile.setColumnName(9, "Goodman Kruskal Gamma");
        resfile.setColumnName(10, "Kendall-a");
        resfile.setColumnName(11, "Kendall-b");
        resfile.setColumnName(12, "InstCounter");
        for (int i2 = 0; i2 < patients.length; ++i2) {
            resfile.setColumnName(13 + i2, patients[i2]);
        }
        int nb = 0;
        Iterator itermap = resmap.iterator();
        Iterator itervv = resvv.iterator();
        Iterator itermethod = resmethod.iterator();
        Iterator iterfeature = resfeature.iterator();
        Iterator itercorr = rescorr.iterator();
        Iterator iterspear = resSpear.iterator();
        Iterator iterspearerr = resSpearerr.iterator();
        Iterator iterspearstu = resSpearstu.iterator();
        Iterator iterspearzsc = resSpearzsc.iterator();
        Iterator itergkg = resgkg.iterator();
        Iterator iterkena = reskena.iterator();
        Iterator iterkenb = reskenb.iterator();
        Iterator iterinstcounter = resinstcounter.iterator();
        Iterator iterpred = respred.iterator();
        while (itermap.hasNext()) {
            resfile.setValue(nb, 0, (String)itermap.next());
            resfile.setValue(nb, 1, (String)itervv.next());
            resfile.setValue(nb, 2, (String)itermethod.next());
            resfile.setValue(nb, 3, (String)iterfeature.next());
            resfile.setValue(nb, 4, (Double)itercorr.next());
            resfile.setValue(nb, 5, (Double)iterspear.next());
            resfile.setValue(nb, 6, (Double)iterspearerr.next());
            resfile.setValue(nb, 7, (Double)iterspearstu.next());
            resfile.setValue(nb, 8, (Double)iterspearzsc.next());
            resfile.setValue(nb, 9, (Double)itergkg.next());
            resfile.setValue(nb, 10, (Double)iterkena.next());
            resfile.setValue(nb, 11, (Double)iterkenb.next());
            resfile.setValue(nb, 12, (Integer)iterinstcounter.next());
            double[] preds = (double[])iterpred.next();
            for (int i3 = 0; i3 < preds.length; ++i3) {
                resfile.setValue(nb, 13 + i3, preds[i3]);
            }
            preds = null;
            ++nb;
        }
        if (nb != resfile.Height()) {
            throw new Error("Souci: nb != resfile.Height().");
        }
        ArrayStatistics.Epsilon = eps;
        maps = null;
        return resfile;
    }

    public void SperateFeatures(FichierTabule file) {
        int y;
        FichierTabule result = FichierTabuleTools.DuplicateInstances(file, 3);
        for (y = 0; y < result.Height(); y += 3) {
            String s = result.getValueString(y, 3);
            int pos1 = s.indexOf(43);
            int pos2 = s.indexOf(43, pos1 + 1);
            if (pos1 < 0) {
                System.out.println(s);
            }
            result.setValue(y, 3, s.substring(0, pos1));
            result.setValue(y + 1, 3, s.substring(pos1 + 1, pos2));
            result.setValue(y + 2, 3, s.substring(pos2 + 1));
            s = null;
        }
        result.Write(file.Name() + "_Features.txt", true);
        for (y = 0; y < result.Height(); ++y) {
            String method = result.getValueString(y, 2);
            String feature = result.getValueString(y, 3);
            result.setValue(y, 3, method + "_" + feature);
            feature = null;
            method = null;
        }
        result.Write(file.Name() + "_MethodFeatures.txt", true);
    }
}

