/*
 * Decompiled with CFR 0.152.
 */
package softwares.ohsu.breastcancer;

import arrayTiTi.ArrayArithmetic;
import arrayTiTi.ArrayComparator;
import arrayTiTi.ArrayConverter;
import arrayTiTi.ArrayFeatures;
import arrayTiTi.ArrayTools;
import dataMining.classifiers.GenericClassifier;
import dataMining.classifiers.parameters.ClassifierParameterFunction;
import dataMining.imbalanceDataSet.WeightedSampling;
import dataMining.regressions.GenericRegression;
import filesAndFolders.fichiersTabules.FichierTabule;
import filesAndFolders.fichiersTabules.FichierTabuleTools;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import listTiTi.ListTools;
import mathematics.statistics.CenterReduce;
import mathematics.statistics.OutliersDetectors;

public class BreastTumorsSingleFeatures {
    private final FileFilter fftxtv1 = file -> file.isFile() && file.getName().endsWith("V1.txt") && !file.getName().startsWith(".");
    FilenameFilter fnfres = (dir, name) -> name.contains("Results_") && name.endsWith(".txt");
    private final ArrayFeatures AF = new ArrayFeatures();
    private final int MaxOutliers = 2;

    public void PreprocessFeaturesFiles(List<String> files) throws Exception {
        ArrayList<FichierTabule> ftlist = new ArrayList<FichierTabule>(files.size());
        Iterator<String> iterfiles = files.iterator();
        while (iterfiles.hasNext()) {
            ftlist.add(new FichierTabule(iterfiles.next(), true));
        }
        this.CheckFiles(ftlist);
        for (FichierTabule ft : ftlist) {
            int colfile = ft.ColumnNumber("File");
            List<String> maps = this.FindMaps(ft);
            for (int m = 0; m < maps.size(); ++m) {
                for (int v = 1; v <= 2; ++v) {
                    ft.ClearAll();
                    ft.SelectWhere(colfile, 6, maps.get(m));
                    ft.SelectFromSelectionWhere(colfile, 6, "/V" + v + "/");
                    if (ft.nbSelected() == 0) {
                        throw new IllegalStateException("ft.nbSelected() == 0");
                    }
                    FichierTabule result = FichierTabuleTools.SaveSelectedRows(ft);
                    result.Write(maps.get(m) + "_V" + v + ".txt", false);
                    result.Kill();
                    result = null;
                }
            }
            ft.Kill();
            ft = null;
            maps.clear();
        }
    }

    private List<String> FindMaps(FichierTabule file) {
        int colfile = file.ColumnNumber("File");
        ArrayList<String> maps = new ArrayList<String>(17);
        for (int row = 0; row < file.Height(); ++row) {
            String map = file.getValueString(row, colfile).substring(file.getValueString(row, colfile).lastIndexOf(47) + 1);
            if (ListTools.isInList(maps, (String)map)) continue;
            maps.add(map);
        }
        return maps;
    }

    private void CheckFiles(List<FichierTabule> list) {
        FichierTabule f0 = list.get(0);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            FichierTabule file = list.get(0);
            if (f0.Width() != file.Width()) {
                throw new IllegalArgumentException("Files have different width.");
            }
            if (!ArrayTools.AreEqual((String[])f0.getColumnsNames(), (String[])file.getColumnsNames())) {
                throw new IllegalArgumentException("Files have different columns names.");
            }
            if (!ArrayTools.AreEqual((int[])f0.ColumnType(), (int[])file.ColumnType())) {
                throw new IllegalArgumentException("Files have different columns types.");
            }
            file = null;
        }
        f0 = null;
    }

    public void EvalutateFeatures(String directory, Object classifier, ClassifierParameterFunction cpf, FichierTabule rcbs) throws FileNotFoundException, Exception {
        GenericRegression regression = new GenericRegression(classifier, cpf);
        FichierTabule result = null;
        int colrcb = rcbs.ColumnNumber("RCB");
        ArrayArithmetic.Divide((double[])rcbs.getColumnDouble(colrcb), (double)4.0, (double[])rcbs.getColumnDouble(colrcb));
        File dir = new File(directory);
        if (!dir.exists()) {
            throw new IllegalArgumentException("!dir.exists()");
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("!dir.isDirectory()");
        }
        File[] files = dir.listFiles(this.fftxtv1);
        for (int f = 0; f < files.length; ++f) {
            FichierTabule f1 = new FichierTabule(files[f].getAbsolutePath(), true);
            FichierTabule f2 = new FichierTabule(files[f].getAbsolutePath().replace("_V1.txt", "_V2.txt"), true);
            int colfile = f1.Width() - 1;
            String map = files[f].getName().substring(1, files[f].getName().indexOf("_V1"));
            if (!this.CheckMatching(f1, f2)) {
                System.out.println("No matching => sorts");
                FichierTabuleTools.Sort(f1, colfile);
                FichierTabuleTools.Sort(f2, colfile);
                if (!this.CheckMatching(f1, f2)) {
                    throw new IllegalStateException("Stil no matching :-(");
                }
            }
            String[] colnames = new String[]{"Feature", "RCB", "Patient"};
            int[] types = new int[]{1, 1, 2};
            FichierTabule inst = new FichierTabule(f1.Height(), types, "Instances");
            inst.setColumnsNames(colnames);
            colnames = null;
            types = null;
            block11: for (int row = 0; row < f1.Height(); ++row) {
                String s = f1.getValueString(row, f1.Width() - 1);
                int posend = s.length() - 1;
                while (s.charAt(posend--) != '/') {
                }
                while (s.charAt(posend) != '/') {
                    --posend;
                }
                int posstart = posend - 1;
                while (s.charAt(posstart) != '/') {
                    --posstart;
                }
                inst.setValue(row, 2, s.substring(++posstart, posend));
                s = null;
                rcbs.SelectWhere(0, 0, inst.getValueString(row, 2));
                switch (rcbs.nbSelected()) {
                    case 0: {
                        inst.setExcluded(row, true);
                        continue block11;
                    }
                    case 1: {
                        inst.setValue(row, 1, rcbs.getValueDouble(rcbs.FirstSelected(), colrcb));
                        continue block11;
                    }
                    default: {
                        throw new IllegalStateException("2 <= rcbs.nbSelected() => " + rcbs.nbSelected());
                    }
                }
            }
            if (result == null) {
                int nb = f1.Height() - inst.nbExcluded();
                types = new int[nb + regression.checknames.length + 2];
                Arrays.fill(types, 1);
                types[nb] = 2;
                types[nb + 1] = 2;
                colnames = new String[types.length];
                for (int i2 = 0; i2 < nb; ++i2) {
                    colnames[i2] = "LOO_" + i2;
                }
                colnames[nb] = "Feature";
                colnames[nb + 1] = "Map";
                System.arraycopy(regression.checknames, 0, colnames, nb + 2, regression.checknames.length);
                result = new FichierTabule(f1.Width() - 1, types, "Results");
                result.setColumnsNames(colnames);
                colnames = null;
                types = null;
            }
            inst.Target(1);
            inst.setExcludedColumn(2, true);
            double[] column = new double[f1.Height()];
            for (int col = 0; col < colfile; ++col) {
                int i3;
                if (f1.isExcludedColumn(col)) continue;
                switch (f1.ColumnType(col)) {
                    case 0: {
                        ArrayArithmetic.Subtract((int[])f1.getColumnInt(col), (int[])f2.getColumnInt(col), (int[])f1.getColumnInt(col));
                        CenterReduce.Compute(f1.getColumnInt(col), column);
                        break;
                    }
                    case 1: {
                        ArrayArithmetic.Subtract((double[])f1.getColumnDouble(col), (double[])f2.getColumnDouble(col), (double[])column);
                        CenterReduce.Compute(column);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Column (" + col + ") type not supported.");
                    }
                }
                inst.setColumn(0, column);
                try {
                    regression.LearnPredictEvaluate(inst, 1, inst.Height());
                }
                catch (Exception e) {
                    System.out.flush();
                    System.err.flush();
                    System.err.println("Exception column " + col);
                    e.printStackTrace();
                    System.err.flush();
                    Arrays.fill(regression.Predictions(), 0.0);
                    Arrays.fill(regression.Checks(), 0.0);
                }
                double[] predictions = regression.Predictions();
                double[] checks = regression.Checks();
                ArrayArithmetic.Abs((double[])checks, (double[])checks);
                for (i3 = 0; i3 < predictions.length; ++i3) {
                    result.setValue(col, i3, predictions[i3]);
                }
                result.setValue(col, predictions.length, f1.getColumnName(col));
                result.setValue(col, predictions.length + 1, map);
                for (i3 = 0; i3 < checks.length; ++i3) {
                    result.setValue(col, predictions.length + 2 + i3, checks[i3]);
                }
            }
            result.Write("Results_" + classifier.getClass().getSimpleName() + files[f].getName().substring(0, files[f].getName().lastIndexOf(95)) + ".txt", false);
        }
    }

    private boolean CheckMatching(FichierTabule f1, FichierTabule f2) {
        if (!ArrayTools.AreEqual((int[])f1.ColumnType(), (int[])f2.ColumnType())) {
            throw new IllegalArgumentException("Files have different columns types.");
        }
        if (f1.Height() != f2.Height()) {
            throw new IllegalArgumentException("Files have different height.");
        }
        int colfile = f1.Width() - 1;
        for (int row = 0; row < f1.Height(); ++row) {
            if (f1.getValueString(row, colfile).equalsIgnoreCase(f2.getValueString(row, colfile).replace("/V2/", "/V1/"))) continue;
            return false;
        }
        return true;
    }

    public void EvalutateFeaturesRegression(String directory, Object classifier, ClassifierParameterFunction cpf, FichierTabule rcbs) throws FileNotFoundException, Exception {
        GenericRegression regression = new GenericRegression(classifier, cpf);
        FichierTabule result = null;
        int pos = 0;
        int colrcb = rcbs.ColumnNumber("Necrosis");
        File dir = new File(directory);
        if (!dir.exists()) {
            throw new IllegalArgumentException("!dir.exists()");
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("!dir.isDirectory()");
        }
        File[] files = dir.listFiles(this.fftxtv1);
        for (int f = 0; f < files.length; ++f) {
            FichierTabule f1 = new FichierTabule(files[f].getAbsolutePath(), true);
            FichierTabule f2 = new FichierTabule(files[f].getAbsolutePath().replace("_V1.txt", "_V2.txt"), true);
            int colfile = f1.Width() - 1;
            String map = files[f].getName().substring(1, files[f].getName().indexOf("_V1"));
            if (!this.CheckMatching(f1, f2)) {
                System.out.println("No matching => sorts");
                FichierTabuleTools.Sort(f1, colfile);
                FichierTabuleTools.Sort(f2, colfile);
                if (!this.CheckMatching(f1, f2)) {
                    throw new IllegalStateException("Still no matching :-(");
                }
            }
            String[] colnames = new String[]{"Feature", "Necrosis", "Patient", "NecrosisclassBin", "pCR"};
            int[] types = new int[]{1, 1, 2, 2, 2};
            FichierTabule inst = new FichierTabule(f1.Height(), types, "Instances");
            inst.setColumnsNames(colnames);
            colnames = null;
            types = null;
            inst.Target(1);
            inst.setExcludedColumn(2, true);
            inst.setExcludedColumn(3, true);
            inst.setExcludedColumn(4, true);
            block11: for (int row = 0; row < f1.Height(); ++row) {
                String s = f1.getValueString(row, f1.Width() - 1);
                int posend = s.length() - 1;
                while (s.charAt(posend--) != '/') {
                }
                while (s.charAt(posend) != '/') {
                    --posend;
                }
                int posstart = posend - 1;
                while (s.charAt(posstart) != '/') {
                    --posstart;
                }
                inst.setValue(row, 2, s.substring(++posstart, posend));
                s = null;
                rcbs.SelectWhere(0, 0, inst.getValueString(row, 2));
                switch (rcbs.nbSelected()) {
                    case 0: {
                        inst.setExcluded(row, true);
                        continue block11;
                    }
                    case 1: {
                        inst.setValue(row, 1, rcbs.getValueDouble(rcbs.FirstSelected(), colrcb));
                        continue block11;
                    }
                    default: {
                        throw new IllegalStateException("2 <= rcbs.nbSelected() => " + rcbs.nbSelected());
                    }
                }
            }
            if (result == null) {
                int nb = f1.Height() - inst.nbExcluded();
                types = new int[nb + regression.checknames.length + 3];
                Arrays.fill(types, 1);
                types[0] = 0;
                pos = nb;
                types[nb + 1] = 2;
                types[nb + 2] = 2;
                colnames = new String[types.length];
                colnames[0] = "NB";
                for (int i2 = 0; i2 < nb; ++i2) {
                    colnames[i2 + 1] = "LOO_" + i2;
                }
                colnames[nb + 1] = "Feature";
                colnames[nb + 2] = "Map";
                System.arraycopy(regression.checknames, 0, colnames, nb + 3, regression.checknames.length);
                result = new FichierTabule(f1.Width() - 1, types, "Results");
                result.setColumnsNames(colnames);
                colnames = null;
                types = null;
            }
            double[] column = new double[f1.Height()];
            double[] column2 = new double[f1.Height()];
            int[] columnint = new int[f1.Height()];
            for (int col = 0; col < colfile; ++col) {
                double[] predictions;
                if (f1.isExcludedColumn(col)) continue;
                switch (f1.ColumnType(col)) {
                    case 0: {
                        ArrayArithmetic.Subtract((int[])f2.getColumnInt(col), (int[])f1.getColumnInt(col), (int[])columnint);
                        ArrayConverter.IntToDouble((int[])columnint, (double[])column);
                        ArrayArithmetic.Invert((int[])f1.getColumnInt(col), (double[])column2);
                        ArrayArithmetic.Multiply((double[])column, (double[])column2, (double[])column);
                        CenterReduce.Compute(f1.getColumnInt(col), column);
                        break;
                    }
                    case 1: {
                        ArrayArithmetic.Subtract((double[])f2.getColumnDouble(col), (double[])f1.getColumnDouble(col), (double[])column);
                        ArrayArithmetic.Invert((double[])f1.getColumnDouble(col), (double[])column2);
                        ArrayArithmetic.Multiply((double[])column, (double[])column2, (double[])column);
                        CenterReduce.Compute(column);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Column (" + col + ") type not supported.");
                    }
                }
                FichierTabule toprocess = FichierTabuleTools.Clone(inst);
                toprocess.setColumn(0, column);
                this.Action(toprocess.getColumnDouble(0), toprocess.getExcluded());
                try {
                    if (!f1.getColumnName(col).equalsIgnoreCase("Average")) continue;
                    regression.LearnPredictEvaluate(toprocess, 1, toprocess.Height());
                    predictions = regression.Predictions();
                    FichierTabule fichier = FichierTabuleTools.DeleteExcludedRows(toprocess);
                    FichierTabule fichiernew = FichierTabuleTools.AddColumn(fichier, 0.0);
                    fichiernew.setColumn(5, predictions);
                    fichiernew.setColumnName(5, "Predicted");
                    fichiernew.Write("Regression.txt", false);
                    System.exit(0);
                    continue;
                }
                catch (Exception e) {
                    int i3;
                    System.out.flush();
                    System.err.flush();
                    System.err.println("Exception column " + col);
                    e.printStackTrace();
                    System.err.flush();
                    Arrays.fill(regression.Predictions(), 0.0);
                    Arrays.fill(regression.Checks(), 0.0);
                    predictions = regression.Predictions();
                    result.setValue(col, 0, predictions.length);
                    if (predictions.length != toprocess.Height() - toprocess.nbExcluded()) {
                        throw new Error("Souci");
                    }
                    double[] checks = regression.Checks();
                    ArrayArithmetic.Abs((double[])checks, (double[])checks);
                    for (i3 = 0; i3 < predictions.length; ++i3) {
                        result.setValue(col, i3 + 1, predictions[i3]);
                    }
                    result.setValue(col, pos + 1, f1.getColumnName(col));
                    result.setValue(col, pos + 2, map);
                    for (i3 = 0; i3 < checks.length; ++i3) {
                        result.setValue(col, pos + 3 + i3, checks[i3]);
                    }
                    toprocess.Kill();
                    toprocess = null;
                }
            }
            column2 = null;
            column = null;
            columnint = null;
            result.Write("Results_" + classifier.getClass().getSimpleName() + files[f].getName().substring(0, files[f].getName().lastIndexOf(95)) + ".txt", false);
        }
    }

    private void Action(double[] values, boolean[] excluded) {
        int i2;
        int pos;
        if (values.length != excluded.length) {
            throw new IllegalArgumentException("Souci!");
        }
        double[] data = new double[values.length - this.AF.Integral(excluded)];
        int pos2 = 0;
        for (int i3 = 0; i3 < values.length; ++i3) {
            if (excluded[i3]) continue;
            data[pos2++] = values[i3];
        }
        boolean[] outliers = new boolean[data.length];
        CenterReduce.Compute(data);
        OutliersDetectors.Detection(data, 2, 0.05, true, 50, outliers);
        int nb = this.AF.Integral(outliers);
        if (nb != 0) {
            pos = 0;
            for (i2 = 0; i2 < values.length; ++i2) {
                if (excluded[i2] || !outliers[pos++]) continue;
                excluded[i2] = true;
            }
            data = null;
            data = new double[values.length - nb];
            pos = 0;
            for (i2 = 0; i2 < values.length; ++i2) {
                if (excluded[i2]) continue;
                data[pos++] = values[i2];
            }
        }
        CenterReduce.Compute(data);
        pos = 0;
        for (i2 = 0; i2 < values.length; ++i2) {
            if (excluded[i2]) continue;
            values[i2] = data[pos++];
        }
    }

    public void EvalutateFeaturesClassification(String directory, Object classifier, ClassifierParameterFunction cpf, FichierTabule targets) throws FileNotFoundException, Exception {
        String classe = "Hope";
        String targ = "RCBclassBin";
        int targetcol = targets.ColumnNumber(targ);
        GenericClassifier genclass = null;
        genclass = cpf != null ? new GenericClassifier(classifier, cpf, classe, new WeightedSampling()) : new GenericClassifier(classifier, classe, new WeightedSampling());
        FichierTabule result = null;
        File dir = new File(directory);
        if (!dir.exists()) {
            throw new IllegalArgumentException("!dir.exists()");
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("!dir.isDirectory()");
        }
        File[] files = dir.listFiles(this.fftxtv1);
        for (int f = 0; f < files.length; ++f) {
            if (files[f].getAbsolutePath().contains("AUC") || files[f].getAbsolutePath().contains("IE") || files[f].getAbsolutePath().contains("KtransFXL")) continue;
            FichierTabule f1 = new FichierTabule(files[f].getAbsolutePath(), true);
            FichierTabule f2 = new FichierTabule(files[f].getAbsolutePath().replace("_V1.txt", "_V2.txt"), true);
            int colfile = f1.Width() - 1;
            String map = files[f].getName().substring(1, files[f].getName().indexOf("_V1"));
            if (!this.CheckMatching(f1, f2)) {
                System.out.println("No matching => sorts");
                FichierTabuleTools.Sort(f1, colfile);
                FichierTabuleTools.Sort(f2, colfile);
                if (!this.CheckMatching(f1, f2)) {
                    throw new IllegalStateException("Still no matching :-(");
                }
            }
            String[] colnames = new String[]{"Feature", targ, "Patient"};
            int[] types = new int[]{1, 2, 2};
            FichierTabule inst = new FichierTabule(f1.Height(), types, "Instances");
            inst.setColumnsNames(colnames);
            colnames = null;
            types = null;
            block11: for (int row = 0; row < f1.Height(); ++row) {
                String s = f1.getValueString(row, f1.Width() - 1);
                int posend = s.length() - 1;
                while (s.charAt(posend--) != '/') {
                }
                while (s.charAt(posend) != '/') {
                    --posend;
                }
                int posstart = posend - 1;
                while (s.charAt(posstart) != '/') {
                    --posstart;
                }
                inst.setValue(row, 2, s.substring(++posstart, posend));
                s = null;
                targets.SelectWhere(0, 0, inst.getValueString(row, 2));
                switch (targets.nbSelected()) {
                    case 0: {
                        inst.setExcluded(row, true);
                        continue block11;
                    }
                    case 1: {
                        inst.setValue(row, 1, targets.getValueString(targets.FirstSelected(), targetcol));
                        continue block11;
                    }
                    default: {
                        throw new IllegalStateException("2 <= targets.nbSelected() => " + targets.nbSelected());
                    }
                }
            }
            if (result == null) {
                types = new int[genclass.checknames.length + 3];
                Arrays.fill(types, 1);
                types[0] = 0;
                types[1] = 2;
                types[2] = 2;
                colnames = new String[types.length];
                colnames[0] = "NB";
                colnames[1] = "Feature";
                colnames[2] = "Map";
                System.arraycopy(genclass.checknames, 0, colnames, 3, genclass.checknames.length);
                result = new FichierTabule(f1.Width() - 1, types, "Results");
                result.setColumnsNames(colnames);
                colnames = null;
                types = null;
            }
            inst.Target(1);
            inst.setExcludedColumn(2, true);
            double[] column = new double[f1.Height()];
            for (int col = 0; col < colfile; ++col) {
                if (f1.isExcludedColumn(col)) continue;
                switch (f1.ColumnType(col)) {
                    case 0: {
                        ArrayArithmetic.Subtract((int[])f1.getColumnInt(col), (int[])f2.getColumnInt(col), (int[])f1.getColumnInt(col));
                        CenterReduce.Compute(f1.getColumnInt(col), column);
                        break;
                    }
                    case 1: {
                        ArrayArithmetic.Subtract((double[])f1.getColumnDouble(col), (double[])f2.getColumnDouble(col), (double[])column);
                        CenterReduce.Compute(column);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Column (" + col + ") type not supported.");
                    }
                }
                FichierTabule toprocess = FichierTabuleTools.Clone(inst);
                toprocess.setColumn(0, column);
                this.Action(toprocess.getColumnDouble(0), toprocess.getExcluded());
                toprocess.Target(1);
                toprocess.setExcludedColumn(2, true);
                FichierTabule tp = FichierTabuleTools.DeleteExcluded(toprocess);
                try {
                    genclass.LearnPredictEvaluate(tp, 1, toprocess.Height(), classe);
                }
                catch (Exception e) {
                    System.out.flush();
                    System.err.flush();
                    System.err.println("Exception column " + col);
                    e.printStackTrace();
                    System.err.flush();
                    Arrays.fill(genclass.Checks(), 0.0);
                }
                int[] predictions = genclass.PredictionS();
                result.setValue(col, 0, predictions.length);
                double[] checks = genclass.Checks();
                result.setValue(col, 1, f1.getColumnName(col));
                result.setValue(col, 2, map);
                for (int i2 = 0; i2 < checks.length; ++i2) {
                    result.setValue(col, 3 + i2, checks[i2]);
                }
                tp.Kill();
                toprocess.Kill();
                tp = null;
                toprocess = null;
            }
            result.Write("Results_" + classifier.getClass().getSimpleName() + files[f].getName().substring(0, files[f].getName().lastIndexOf(95)) + ".txt", false);
        }
    }

    public void ConcatenateResultingFiles(String directory, String result) throws Exception {
        Object[] files = new File(directory).listFiles(this.fnfres);
        Arrays.sort(files);
        FichierTabule res = new FichierTabule(((File)files[0]).getAbsolutePath(), true);
        for (int i2 = 1; i2 < files.length; ++i2) {
            res = FichierTabuleTools.Merge(res, new FichierTabule(((File)files[i2]).getAbsolutePath(), true));
        }
        res.Write(result, false);
    }

    public FichierTabule AddMissingColumns(FichierTabule file) {
        FichierTabule result = FichierTabuleTools.AddColumns(file, new int[]{2, 0, 0, 0, 0, 0});
        result.setColumnName(result.Width() - 6, "FeatureFamily");
        result.setColumnName(result.Width() - 5, "Pearson>0.7");
        result.setColumnName(result.Width() - 4, "Spearman>0.7");
        result.setColumnName(result.Width() - 3, "GKG>0.7");
        result.setColumnName(result.Width() - 2, "Kendall>0.7");
        result.setColumnName(result.Width() - 1, "Sum>0.7");
        String[] features = result.getColumnString("Feature");
        String[] family = result.getColumnString(result.Width() - 6);
        for (int i2 = 0; i2 < features.length; ++i2) {
            if (features[i2].startsWith("F0")) {
                features[i2] = "Haralick_" + features[i2];
            } else if (features[i2].startsWith("F0")) {
                features[i2] = "Haralick_" + features[i2];
            } else if (features[i2].startsWith("F1")) {
                features[i2] = "Haralick_" + features[i2];
            } else if (features[i2].startsWith("F2")) {
                features[i2] = "Haralick_" + features[i2];
            } else if (features[i2].startsWith("F3")) {
                features[i2] = "Haralick_" + features[i2];
            } else if (features[i2].startsWith("F4")) {
                features[i2] = "Haralick_" + features[i2];
            } else if (features[i2].startsWith("F5")) {
                features[i2] = "Haralick_" + features[i2];
            } else if (features[i2].startsWith("F6")) {
                features[i2] = "Haralick_" + features[i2];
            } else if (features[i2].startsWith("F7")) {
                features[i2] = "Haralick_" + features[i2];
            } else if (features[i2].startsWith("F8")) {
                features[i2] = "Haralick_" + features[i2];
            } else if (features[i2].startsWith("F9")) {
                features[i2] = "Haralick_" + features[i2];
            } else if (features[i2].startsWith("F10")) {
                features[i2] = "Haralick_" + features[i2];
            } else if (features[i2].startsWith("F11")) {
                features[i2] = "Haralick_" + features[i2];
            } else if (features[i2].startsWith("F12")) {
                features[i2] = "Haralick_" + features[i2];
            } else if (features[i2].startsWith("F13")) {
                features[i2] = "Haralick_" + features[i2];
            } else if (features[i2].startsWith("F14")) {
                features[i2] = "Haralick_" + features[i2];
            } else if (features[i2].startsWith("F15")) {
                features[i2] = "Haralick_" + features[i2];
            } else if (features[i2].startsWith("Size")) {
                features[i2] = "BTF_" + features[i2];
            } else if (features[i2].startsWith("Sum")) {
                features[i2] = "BTF_" + features[i2];
            } else if (features[i2].startsWith("Average")) {
                features[i2] = "BTF_" + features[i2];
            } else if (features[i2].startsWith("Variance")) {
                features[i2] = "BTF_" + features[i2];
            } else if (features[i2].startsWith("Kurtosis")) {
                features[i2] = "BTF_" + features[i2];
            } else if (features[i2].startsWith("Skewness")) {
                features[i2] = "BTF_" + features[i2];
            }
            family[i2] = features[i2].substring(0, features[i2].indexOf(95));
        }
        ArrayComparator.Compare((double[])file.getColumnDouble("Correlation"), (String)">=", (double)0.7, (int)1, (int)0, (int[])result.getColumnInt("Pearson>0.7"));
        ArrayComparator.Compare((double[])file.getColumnDouble("Spearman"), (String)">=", (double)0.7, (int)1, (int)0, (int[])result.getColumnInt("Spearman>0.7"));
        ArrayComparator.Compare((double[])file.getColumnDouble("GoodmanKruskallGamma"), (String)">=", (double)0.7, (int)1, (int)0, (int[])result.getColumnInt("GKG>0.7"));
        file.SelectWhere("KendallA", 3, 0.7);
        file.ExtendSelectionWhere("KendallB", 3, 0.7);
        ArrayComparator.Compare((boolean[])file.getSelected(), (String)"==", (boolean)true, (int)1, (int)0, (int[])result.getColumnInt("Kendall>0.7"));
        result.setColumn("Sum>0.7", result.getColumnInt("Pearson>0.7"));
        ArrayArithmetic.Add((int[])result.getColumnInt("Spearman>0.7"), (int[])result.getColumnInt("Sum>0.7"), (int[])result.getColumnInt("Sum>0.7"));
        ArrayArithmetic.Add((int[])result.getColumnInt("GKG>0.7"), (int[])result.getColumnInt("Sum>0.7"), (int[])result.getColumnInt("Sum>0.7"));
        ArrayArithmetic.Add((int[])result.getColumnInt("Kendall>0.7"), (int[])result.getColumnInt("Sum>0.7"), (int[])result.getColumnInt("Sum>0.7"));
        return result;
    }
}

