/*
 * Decompiled with CFR 0.152.
 */
package softwares.ohsu.breastcancer;

import arrayTiTi.ArrayArithmetic;
import arrayTiTi.ArrayComparator;
import arrayTiTi.ArrayConverter;
import arrayTiTi.ArrayFeatures;
import dv.DV;
import dv.DvComparator;
import dv.DvConverter;
import dv.DvIO;
import dv.DvNew;
import dv.DvOperations;
import dv.DvTools;
import dv.DvTransformations;
import filesAndFolders.FileFilters;
import filesAndFolders.FileNameFilters;
import filesAndFolders.FilesFolders;
import filesAndFolders.fichiersTabules.FichierTabule;
import imageTiTi.ImageIO;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import listTiTi.ListIO;
import listTiTi.ListTools;
import mathematics.Interpolations;
import mathematics.primitives.pointsTiTi.Point;
import measures.BasicMeasures3D;
import processing.filters.DynamicExpansion;
import utils.LogFile;
import utils.strings.IntGenerator;

public class BreastTumorsFilesPreProcessor {
    private FileFilter ffpatients = file -> file.isDirectory() && file.getName().startsWith("S");
    private FileFilter ffvisits = file -> file.isDirectory() && file.getName().charAt(0) != '.' && (file.getName().contains("V1") || file.getName().contains("V2"));
    private FileFilter ffLX = file -> file.isDirectory() && file.getName().startsWith("L");
    private FileFilter fffiles = file -> file.isFile() && !file.getName().startsWith(".") && !file.getName().startsWith("_") && !file.getName().endsWith(".xls");
    private FileFilter fftp = file -> file.isDirectory() && file.getName().startsWith("TP");
    private FileFilter ffsq = file -> file.isDirectory() && (file.getName().equalsIgnoreCase("_AUC") || file.getName().equalsIgnoreCase("_IE") || file.getName().equalsIgnoreCase("_PIE") || file.getName().equalsIgnoreCase("_SER") || file.getName().equalsIgnoreCase("_SlopeIn"));
    private final ArrayFeatures AF = new ArrayFeatures();
    private FileFilter ffvis = file -> !file.getName().startsWith(".") && file.isFile() && (file.getName().contains(".png") || file.getName().contains(".tif")) || file.isDirectory() && file.getName().startsWith("L");
    private final int BaseLineStart = 0;
    private final int BaseLineEnd = 2;
    private final int BaseLineGap = 2;
    private final int MaxLineStart = 6;
    private final int MaxLineEnd = 11;
    private final int MaxLineGap = 5;
    private final int MaxLineMed = 8;
    private int maxindex = 0;
    private final int injection = 2;
    private final int margin = 2;

    public void SortImages(String srcdir, List<String> maps, String destdir) {
        File[] srcpatient = new File(srcdir).listFiles();
        for (int p = 0; p < srcpatient.length; ++p) {
            if (!srcpatient[p].isDirectory() || !srcpatient[p].getName().startsWith("S")) continue;
            String patientname = srcpatient[p].getName();
            File[] srcvisits = new File(srcpatient[p].getAbsolutePath()).listFiles(this.ffvisits);
            if (srcvisits == null || srcvisits.length != 2 || !this.CheckVisits(srcvisits)) continue;
            for (int v = 0; v < srcvisits.length; ++v) {
                File[] images;
                File[] tumors = new File(srcvisits[v].getAbsolutePath()).listFiles(this.ffLX);
                if (tumors.length != 0) {
                    for (int t = 0; t < tumors.length; ++t) {
                        for (String map : maps) {
                            FilenameFilter fnf = (dir, name) -> name.charAt(0) != '.' && name.endsWith(map + ".png");
                            images = new File(srcvisits[v].getAbsolutePath() + "/" + tumors[t].getName()).listFiles(fnf);
                            File destmap = new File(destdir + "/" + patientname + "_" + tumors[t].getName() + "/" + srcvisits[v].getName() + "/" + map);
                            if (!destmap.exists()) {
                                destmap.mkdirs();
                            }
                            if (images == null || images.length == 0) {
                                System.err.println("No images in '" + destmap.getAbsolutePath() + "'.");
                            } else {
                                for (int i2 = 0; i2 < images.length; ++i2) {
                                    FilesFolders.CopyFile(images[i2], new File(destmap.getAbsolutePath() + "/" + images[i2].getName()));
                                }
                            }
                            images = null;
                            destmap = null;
                            fnf = null;
                        }
                        Iterator<String> iter = null;
                    }
                } else {
                    for (String map : maps) {
                        FilenameFilter fnf = (dir, name) -> name.charAt(0) != '.' && name.contains(map + ".png");
                        File destmap = new File(destdir + "/" + patientname + "/" + srcvisits[v].getName() + "/" + map);
                        if (!destmap.exists()) {
                            destmap.mkdirs();
                        }
                        if ((images = new File(srcvisits[v].getAbsolutePath()).listFiles(fnf)) == null || images.length == 0) {
                            System.err.println("No images in '" + destmap.getAbsolutePath() + "'.");
                        } else {
                            for (int i3 = 0; i3 < images.length; ++i3) {
                                FilesFolders.CopyFile(images[i3], new File(destmap.getAbsolutePath() + "/" + images[i3].getName()));
                            }
                        }
                        images = null;
                        destmap = null;
                        fnf = null;
                    }
                    Iterator<String> iter = null;
                }
                tumors = null;
            }
        }
        srcpatient = null;
    }

    private boolean CheckVisits(File[] visits) {
        for (int v = 0; v < visits.length; ++v) {
            File[] files = visits[v].listFiles(this.ffvis);
            if (files.length == 0) {
                return false;
            }
            Object var3_3 = null;
        }
        return true;
    }

    public void ProcessT1(String T1dir, FichierTabule data, String resdir) throws IOException {
        int colpatients = data.ColumnNumber("Subject#");
        int colvisits = data.ColumnNumber("Visit#");
        int colslices = data.ColumnNumber("Slice");
        int coltp = data.ColumnNumber("Timepoints");
        LogFile log = new LogFile();
        log.StartNewLog(this, "./");
        File T1file = new File(T1dir);
        if (!T1file.exists()) {
            throw new IllegalArgumentException("!T1file.exists()");
        }
        if (!T1file.isDirectory()) {
            throw new IllegalArgumentException("!T1file.isDirectory()");
        }
        boolean work = false;
        Object[] patients = T1file.listFiles(this.ffpatients);
        Arrays.sort(patients);
        for (int p = 0; p < patients.length; ++p) {
            System.out.println("Patient: '" + ((File)patients[p]).getName() + "'");
            Object[] visits = ((File)patients[p]).listFiles(this.ffvisits);
            if (visits.length != 2) continue;
            Arrays.sort(visits);
            List<String> dirs = this.FindDirectories(resdir, ((File)patients[p]).getName());
            ListIO.Display(dirs, "\n");
            if (dirs.isEmpty()) continue;
            for (int v = 0; v < visits.length; ++v) {
                if (!work) {
                    if (!((File)patients[p]).getName().equalsIgnoreCase("S13_L2")) continue;
                    work = true;
                }
                if (work && ((File)patients[p]).getName().equalsIgnoreCase("S14")) {
                    work = false;
                }
                System.out.println("Visit: '" + ((File)visits[v]).getName() + "'");
                data.ClearAll();
                data.SelectWhere(colpatients, 0, ((File)patients[p]).getName());
                int posv = ((File)visits[v]).getName().indexOf(86);
                String visit = ((File)visits[v]).getName().substring(posv, posv + 2);
                data.SelectFromSelectionWhere(colvisits, 0, visit);
                try {
                    if (data.nbSelected() != 1) {
                        throw new IllegalStateException("data.nbSelected() != 1. " + ((File)patients[p]).getName() + " & " + visit + " => " + data.nbSelected());
                    }
                }
                catch (IllegalStateException | NullPointerException e) {
                    log.addNewException(e, new String[0]);
                    log.addComment("Patient: '" + ((File)patients[p]).getName() + "', Visit: '" + ((File)visits[v]).getName() + "'\n\n");
                    continue;
                }
                int row = data.FirstSelected();
                int nbslice = data.getValueInt(row, colslices);
                int nbtp = data.getValueInt(row, coltp);
                Object[] images = new File(((File)visits[v]).getAbsolutePath() + "/dce_concat/").listFiles(this.fffiles);
                if (images == null) {
                    images = new File(((File)visits[v]).getAbsolutePath() + "/DCE_concat/").listFiles(this.fffiles);
                }
                if (images == null) {
                    images = new File(((File)visits[v]).getAbsolutePath() + "/DCE_concatenated/").listFiles(this.fffiles);
                }
                if (images == null) {
                    images = new File(((File)visits[v]).getAbsolutePath() + "/" + ((File)patients[p]).getName() + ((File)visits[v]).getName() + "_concatenated/").listFiles(this.fffiles);
                }
                try {
                    if (images.length != nbslice * nbtp) {
                        throw new IllegalStateException("images.length != nbslice*nbtp => " + images.length + " " + nbslice + " " + nbtp);
                    }
                }
                catch (IllegalStateException | NullPointerException e) {
                    log.addNewException(e, new String[0]);
                    log.addComment("Patient: '" + ((File)patients[p]).getName() + "', Visit: '" + ((File)visits[v]).getName() + "'\n\n");
                    continue;
                }
                Arrays.sort(images);
                BufferedImage image = ImageIO.ReadWithImageJ(((File)images[0]).getAbsolutePath());
                if (image.getType() != 10) {
                    throw new IllegalStateException("image.getType() != BufferedImage.TYPE_BYTE_GRAY");
                }
                int width = image.getWidth();
                int height = image.getHeight();
                image = null;
                DV dv = new DV(width, height, nbslice, 1, 8);
                IntGenerator igtp = new IntGenerator(0, nbtp + 1);
                int pos = 0;
                for (int t = 0; t < nbtp; ++t) {
                    int s = 0;
                    while (s < nbslice) {
                        image = ImageIO.ReadWithImageJ(((File)images[pos]).getAbsolutePath());
                        if (image.getWidth() != width || image.getHeight() != height) {
                            throw new IllegalStateException(" image.getWidth() != width || image.getHeight() != height");
                        }
                        DvConverter.BufferedImageToDV(image, 0, 0, width, height, dv, 0, 0, s);
                        image = null;
                        ++s;
                        ++pos;
                    }
                    String TP = "TP" + igtp.Next();
                    for (int d = 0; d < dirs.size(); ++d) {
                        File dirout = new File(dirs.get(d) + "/V" + (v + 1) + "/T1/" + TP);
                        if (!dirout.exists()) {
                            dirout.mkdirs();
                        }
                        DvIO.WriteStack(dv, dirout.getAbsolutePath() + "/", TP, "png");
                        dirout = null;
                    }
                    TP = null;
                }
                dv.Kill();
                dv = null;
                igtp = null;
                Arrays.fill(images, null);
                images = null;
                System.gc();
                System.out.println("Visit '" + ((File)visits[v]).getName() + "' done.\n");
            }
            dirs.clear();
            dirs = null;
            Arrays.fill(visits, null);
            visits = null;
            System.out.println("Patient '" + ((File)patients[p]).getName() + "' done.\n\n\n\n\n");
        }
        Arrays.fill(patients, null);
        patients = null;
    }

    private List<String> FindDirectories(String resdir, String patient) throws IOException {
        ArrayList<String> list = new ArrayList<String>(2);
        File resfile = new File(resdir);
        if (!resfile.exists()) {
            throw new IOException("The result directory does not exist.");
        }
        File[] dirs = resfile.listFiles((dir, name) -> name.charAt(0) != '.' && !name.contains("DS_Store") && (name.equalsIgnoreCase(patient) || name.contains(patient + "_L")));
        for (int i2 = 0; i2 < dirs.length; ++i2) {
            list.add(dirs[i2].getAbsolutePath());
        }
        return list;
    }

    public void DeleteT1(String T1dir) throws IOException {
        File T1file = new File(T1dir);
        if (!T1file.exists()) {
            throw new IllegalArgumentException("!T1file.exists()");
        }
        if (!T1file.isDirectory()) {
            throw new IllegalArgumentException("!T1file.isDirectory()");
        }
        Object[] patients = T1file.listFiles(this.ffpatients);
        Arrays.sort(patients);
        for (int p = 0; p < patients.length; ++p) {
            Object[] visits = ((File)patients[p]).listFiles(this.ffvisits);
            Arrays.sort(visits);
            for (int v = 0; v < visits.length; ++v) {
                File t1 = new File(((File)visits[v]).getAbsolutePath() + "/T1");
                if (t1.exists()) {
                    FilesFolders.Delete(t1);
                }
                t1 = null;
            }
            Arrays.fill(visits, null);
            visits = null;
        }
        Arrays.fill(patients, null);
        patients = null;
    }

    public void DeleteExtractions(String directory) throws IOException {
        File file = new File(directory);
        if (!file.exists()) {
            throw new IllegalArgumentException("!file.exists()");
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("!file.isDirectory()");
        }
        Object[] patients = file.listFiles(this.ffpatients);
        Arrays.sort(patients);
        for (int p = 0; p < patients.length; ++p) {
            Object[] visits = ((File)patients[p]).listFiles(this.ffvisits);
            Arrays.sort(visits);
            for (int v = 0; v < visits.length; ++v) {
                File auc = new File(((File)visits[v]).getAbsolutePath() + "/_AUC");
                if (auc.exists()) {
                    FilesFolders.Delete(auc);
                }
                auc = null;
                auc = new File(((File)visits[v]).getAbsolutePath() + "/AUC");
                if (auc.exists()) {
                    FilesFolders.Delete(auc);
                }
                auc = null;
                File ie = new File(((File)visits[v]).getAbsolutePath() + "/_IE");
                if (ie.exists()) {
                    FilesFolders.Delete(ie);
                }
                ie = null;
                ie = new File(((File)visits[v]).getAbsolutePath() + "/IE");
                if (ie.exists()) {
                    FilesFolders.Delete(ie);
                }
                ie = null;
                File pie = new File(((File)visits[v]).getAbsolutePath() + "/_PIE");
                if (pie.exists()) {
                    FilesFolders.Delete(pie);
                }
                pie = null;
                pie = new File(((File)visits[v]).getAbsolutePath() + "/PIE");
                if (pie.exists()) {
                    FilesFolders.Delete(pie);
                }
                pie = null;
                File ser = new File(((File)visits[v]).getAbsolutePath() + "/_SER");
                if (ser.exists()) {
                    FilesFolders.Delete(ser);
                }
                ser = null;
                ser = new File(((File)visits[v]).getAbsolutePath() + "/SER");
                if (ser.exists()) {
                    FilesFolders.Delete(ser);
                }
                ser = null;
                File slope = new File(((File)visits[v]).getAbsolutePath() + "/_SlopeIn");
                if (slope.exists()) {
                    FilesFolders.Delete(slope);
                }
                slope = null;
                slope = new File(((File)visits[v]).getAbsolutePath() + "/SlopeIn");
                if (slope.exists()) {
                    FilesFolders.Delete(slope);
                }
                slope = null;
            }
            Arrays.fill(visits, null);
            visits = null;
        }
        Arrays.fill(patients, null);
        patients = null;
    }

    public void DeleteImages000andAddLasts(String dir, List<String> maps) throws IOException {
        File file = new File(dir);
        if (!file.exists()) {
            throw new IllegalArgumentException("!file.exists()");
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("!file.isDirectory()");
        }
        Object[] patients = file.listFiles(this.ffpatients);
        Arrays.sort(patients);
        for (int p = 0; p < patients.length; ++p) {
            Object[] visits = ((File)patients[p]).listFiles(this.ffvisits);
            Arrays.sort(visits);
            for (int v = 0; v < visits.length; ++v) {
                Iterator<String> iter = maps.iterator();
                while (iter.hasNext()) {
                    Object[] images = new File((File)visits[v] + "/" + iter.next() + "/").listFiles(FileNameFilters.ImagesPNG);
                    Arrays.sort(images);
                    ((File)images[0]).renameTo(new File(((File)images[0]).getParent() + "/" + ((File)images[0]).getName().replace("_000_", "_" + this.NewNum(images.length) + "_")));
                    images = null;
                }
                iter = null;
            }
            Arrays.fill(visits, null);
            visits = null;
        }
    }

    public void ExtractFromT1(String directory, FichierTabule data) throws IOException {
        File dirfile = new File(directory);
        if (!dirfile.exists()) {
            throw new IllegalArgumentException("!dirfile.exists()");
        }
        if (!dirfile.isDirectory()) {
            throw new IllegalArgumentException("!dirfile.isDirectory()");
        }
        int colpatients = data.ColumnNumber("Subject#");
        int colvisits = data.ColumnNumber("Visit#");
        int coltemporal = data.ColumnNumber("Temporal(s)");
        int error = 0;
        boolean work = true;
        DynamicExpansion dynexp = new DynamicExpansion();
        Object[] patients = dirfile.listFiles(this.ffpatients);
        Arrays.sort(patients);
        for (int p = 0; p < patients.length; ++p) {
            System.out.println("Patient: '" + ((File)patients[p]).getName() + "'");
            Object[] visits = ((File)patients[p]).listFiles(this.ffvisits);
            Arrays.sort(visits);
            for (int v = 0; v < visits.length; ++v) {
                if (!work) {
                    if (!((File)patients[p]).getName().contains("BC17")) continue;
                    work = true;
                }
                System.out.println("Visit: '" + ((File)visits[v]).getName() + "'");
                File t1 = new File(((File)visits[v]).getAbsolutePath() + "/T1/");
                if (!t1.exists()) {
                    System.out.flush();
                    System.err.println("T1 directory not found: " + t1.getAbsolutePath());
                    System.err.flush();
                    ++error;
                    continue;
                }
                data.ClearAll();
                data.SelectWhere(colpatients, 0, ((File)patients[p]).getName());
                if (data.nbSelected() == 0) {
                    data.SelectWhere(colpatients, 0, ((File)patients[p]).getName().substring(0, ((File)patients[p]).getName().indexOf(95)));
                }
                data.SelectFromSelectionWhere(colvisits, 0, ((File)visits[v]).getName());
                if (data.nbSelected() == 0 || 2 < data.nbSelected()) {
                    throw new IllegalStateException("data.nbSelected() = " + data.nbSelected() + ", " + ((File)patients[p]).getName() + " & " + ((File)visits[v]).getName() + " => " + data.nbSelected());
                }
                int row = data.FirstSelected();
                System.out.println("row= " + row + ", col = " + coltemporal + ", nbsel = " + data.nbSelected());
                double temporal = data.getValueInt(row, coltemporal);
                Object[] tps = t1.listFiles(this.fftp);
                DV[] dvs = new DV[tps.length];
                for (int t = 0; t < 11; ++t) {
                    dvs[t] = DvIO.ReadFromStack(tps[t].getAbsolutePath(), FileNameFilters.ImagesPNG);
                }
                dvs[tps.length - 2] = DvIO.ReadFromStack(tps[tps.length - 2].getAbsolutePath(), FileNameFilters.ImagesPNG);
                dvs[tps.length - 1] = DvIO.ReadFromStack(tps[tps.length - 1].getAbsolutePath(), FileNameFilters.ImagesPNG);
                DV ie = DvNew.Same((DV)dvs[0], (int)-32);
                DV ser = DvNew.Same((DV)ie);
                DV pie = DvNew.Same((DV)ie);
                DV slope = DvNew.Same((DV)ie);
                DV auc = DvNew.Same((DV)ie);
                DV dv = DvNew.Same((DV)ie, (int)8);
                this.Compute(dvs, temporal, ie, ser, pie, slope, auc);
                File iefile = new File(((File)visits[v]).getAbsolutePath() + "/IE/");
                if (!iefile.exists()) {
                    iefile.mkdirs();
                }
                DvIO.WriteStack(ie, iefile.getAbsolutePath() + "/", "IE", "TIFF");
                iefile = null;
                iefile = new File(((File)visits[v]).getAbsolutePath() + "/_IE/");
                if (!iefile.exists()) {
                    iefile.mkdirs();
                }
                dynexp.Filter(ie.getDataBufferFloat(0), ie.getDataBufferFloat(0), 0.0f, 5.0f, 0.0f, 255.0f);
                ArrayComparator.Compare((float[])ie.getDataBufferFloat(0), (String)"<=", (float)255.0f, (float[])ie.getDataBufferFloat(0), (float)255.0f, (float[])ie.getDataBufferFloat(0));
                ArrayConverter.FloatToByte((float[])ie.getDataBufferFloat(0), (byte[])dv.getDataBufferByte(0));
                DvIO.WriteStack(dv, iefile.getAbsolutePath() + "/", "IE", "PNG");
                iefile = null;
                ie.Kill();
                File serfile = new File(((File)visits[v]).getAbsolutePath() + "/SER/");
                if (!serfile.exists()) {
                    serfile.mkdirs();
                }
                DvIO.WriteStack(ser, serfile.getAbsolutePath() + "/", "SER", "TIFF");
                serfile = null;
                serfile = new File(((File)visits[v]).getAbsolutePath() + "/_SER/");
                if (!serfile.exists()) {
                    serfile.mkdirs();
                }
                dynexp.Filter(ser.getDataBufferFloat(0), ser.getDataBufferFloat(0), 0.0f, 7.5f, 0.0f, 255.0f);
                ArrayComparator.Compare((float[])ser.getDataBufferFloat(0), (String)"<=", (float)255.0f, (float[])ser.getDataBufferFloat(0), (float)255.0f, (float[])ser.getDataBufferFloat(0));
                ArrayConverter.FloatToByte((float[])ser.getDataBufferFloat(0), (byte[])dv.getDataBufferByte(0));
                DvIO.WriteStack(dv, serfile.getAbsolutePath() + "/", "SER", "PNG");
                serfile = null;
                ser.Kill();
                File piefile = new File(((File)visits[v]).getAbsolutePath() + "/PIE/");
                if (!piefile.exists()) {
                    piefile.mkdirs();
                }
                DvIO.WriteStack(pie, piefile.getAbsolutePath() + "/", "PIE", "TIFF");
                piefile = null;
                piefile = new File(((File)visits[v]).getAbsolutePath() + "/_PIE/");
                if (!piefile.exists()) {
                    piefile.mkdirs();
                }
                dynexp.Filter(pie.getDataBufferFloat(0), pie.getDataBufferFloat(0), -1.0f, 2.0f, 0.0f, 255.0f);
                ArrayComparator.Compare((float[])pie.getDataBufferFloat(0), (String)"<=", (float)255.0f, (float[])pie.getDataBufferFloat(0), (float)255.0f, (float[])pie.getDataBufferFloat(0));
                ArrayConverter.FloatToByte((float[])pie.getDataBufferFloat(0), (byte[])dv.getDataBufferByte(0));
                DvIO.WriteStack(dv, piefile.getAbsolutePath() + "/", "PIE", "PNG");
                piefile = null;
                pie.Kill();
                File slopefile = new File(((File)visits[v]).getAbsolutePath() + "/SlopeIn/");
                if (!slopefile.exists()) {
                    slopefile.mkdirs();
                }
                DvIO.WriteStack(slope, slopefile.getAbsolutePath() + "/", "SlopeIn", "TIFF");
                slopefile = null;
                slopefile = new File(((File)visits[v]).getAbsolutePath() + "/_SlopeIn/");
                if (!slopefile.exists()) {
                    slopefile.mkdirs();
                }
                dynexp.Filter(slope.getDataBufferFloat(0), slope.getDataBufferFloat(0), 0.0f, 4.0f, 0.0f, 255.0f);
                ArrayComparator.Compare((float[])slope.getDataBufferFloat(0), (String)"<=", (float)255.0f, (float[])slope.getDataBufferFloat(0), (float)255.0f, (float[])slope.getDataBufferFloat(0));
                ArrayConverter.FloatToByte((float[])slope.getDataBufferFloat(0), (byte[])dv.getDataBufferByte(0));
                DvIO.WriteStack(dv, slopefile.getAbsolutePath() + "/", "SlopeIn", "PNG");
                slopefile = null;
                slope.Kill();
                File aucfile = new File(((File)visits[v]).getAbsolutePath() + "/AUC/");
                if (!aucfile.exists()) {
                    aucfile.mkdirs();
                }
                DvIO.WriteStack(auc, aucfile.getAbsolutePath() + "/", "AUC", "TIFF");
                aucfile = null;
                aucfile = new File(((File)visits[v]).getAbsolutePath() + "/_AUC/");
                if (!aucfile.exists()) {
                    aucfile.mkdirs();
                }
                ArrayArithmetic.Multiply((float[])auc.getDataBufferFloat(0), (float)2.55f, (float[])auc.getDataBufferFloat(0));
                ArrayComparator.Compare((float[])auc.getDataBufferFloat(0), (String)"<=", (float)255.0f, (float[])auc.getDataBufferFloat(0), (float)255.0f, (float[])auc.getDataBufferFloat(0));
                ArrayConverter.FloatToByte((float[])auc.getDataBufferFloat(0), (byte[])dv.getDataBufferByte(0));
                DvIO.WriteStack(dv, aucfile.getAbsolutePath() + "/", "AUC", "PNG");
                aucfile = null;
                auc.Kill();
                for (int t = 0; t < tps.length; ++t) {
                    if (dvs[t] != null) {
                        dvs[t].Kill();
                    }
                    dvs[t] = null;
                }
                Arrays.fill(tps, null);
                tps = null;
                t1 = null;
                auc = null;
                slope = null;
                pie = null;
                ser = null;
                ie = null;
                System.gc();
                System.out.println("Visit '" + ((File)visits[v]).getName() + "' done.\n");
            }
            Arrays.fill(visits, null);
            visits = null;
            System.out.println("Patient '" + ((File)patients[p]).getName() + "' done.\n\n\n\n\n");
        }
        Arrays.fill(patients, null);
        patients = null;
        System.out.flush();
        System.err.println("Process over with " + error + " error" + (1 < error ? "s" : "") + ".");
        System.err.flush();
    }

    private void Compute(DV[] dvs, double temporal, DV ie, DV ser, DV pie, DV slope, DV auc) {
        int sizex = dvs[0].SizeX;
        int sizey = dvs[0].SizeY;
        int sizez = dvs[0].SizeZ;
        float[] fbie = ie.getDataBufferFloat(0);
        float[] fbser = ser.getDataBufferFloat(0);
        float[] fbpie = pie.getDataBufferFloat(0);
        float[] fbslope = slope.getDataBufferFloat(0);
        float[] fbauc = auc.getDataBufferFloat(0);
        int pos = 0;
        for (int z = 0; z < sizez; ++z) {
            for (int y = 0; y < sizey; ++y) {
                int x = 0;
                while (x < sizex) {
                    double s0 = this.ComputeS0(dvs, pos);
                    double sm = this.ComputeSMax(dvs, pos);
                    double sl = this.ComputeSLast(dvs, pos);
                    fbie[pos] = (float)(s0 == 0.0 ? sm : Math.abs(sm - s0) / s0);
                    fbser[pos] = sm - s0 <= 0.0 || sl - s0 <= 0.0 ? 0.0f : (float)((sm - s0) / (sl - s0));
                    fbpie[pos] = (float)(sm == 0.0 ? -sl : (sl - sm) / sm);
                    fbslope[pos] = (float)(sm / ((double)(this.maxindex - 2) * temporal));
                    float sum = 0.0f;
                    for (int i2 = 2; i2 <= 6; ++i2) {
                        sum += (float)Math.max((double)(dvs[i2].getVoxelByte(0, pos) & 0xFF) - s0, 0.0);
                    }
                    fbauc[pos] = sum / 5.0f;
                    ++x;
                    ++pos;
                }
            }
        }
        fbauc = null;
        fbslope = null;
        fbpie = null;
        fbser = null;
        fbie = null;
    }

    private double ComputeS0(DV[] dvs, int pos) {
        int sum = 0;
        for (int i2 = 0; i2 < 2; ++i2) {
            sum += dvs[i2].getVoxelByte(0, pos) & 0xFF;
        }
        return (double)sum / 2.0;
    }

    private double ComputeSMax(DV[] dvs, int pos) {
        int[] values = new int[5];
        for (int i2 = 0; i2 < values.length; ++i2) {
            values[i2] = dvs[6 + i2].getVoxelByte(0, pos) & 0xFF;
        }
        boolean steady = true;
        for (int i3 = 1; steady && i3 < values.length; ++i3) {
            if (values[i3 - 1] <= values[i3]) continue;
            steady = false;
        }
        if (steady) {
            this.maxindex = 8;
            return values[2];
        }
        int max = this.AF.Maximum(values);
        this.maxindex = 6 + this.AF.MaximumIndex();
        return max;
    }

    private double ComputeSLast(DV[] dvs, int pos) {
        int sum = (dvs[dvs.length - 2].getVoxelByte(0, pos) & 0xFF) + (dvs[dvs.length - 2].getVoxelByte(0, pos) & 0xFF);
        return (double)sum / 2.0;
    }

    public void MaskSemiQuantitative(String dirpath, String maskspath) throws IOException {
        boolean work = true;
        Object[] patients = new File(dirpath).listFiles(this.ffpatients);
        Arrays.sort(patients);
        for (int p = 0; p < patients.length; ++p) {
            System.out.println("Patient: '" + ((File)patients[p]).getName() + "'");
            Object[] visits = ((File)patients[p]).listFiles(this.ffvisits);
            Arrays.sort(visits);
            for (int v = 0; v < visits.length; ++v) {
                if (!work) {
                    if (!((File)patients[p]).getName().contains("BC17")) continue;
                    work = true;
                }
                System.out.println("Visit: '" + ((File)visits[v]).getName() + "'");
                DV mask = DvIO.ReadFromStack(maskspath + "/" + ((File)patients[p]).getName() + "/" + ((File)visits[v]).getName() + "/_chiFXL3/", FileNameFilters.ImagesPNGorTIF);
                DV dv = null;
                Object[] maps = ((File)visits[v]).listFiles(this.ffsq);
                Arrays.sort(maps);
                System.out.println(maps.length);
                for (int m = 0; m < maps.length; ++m) {
                    try {
                        dv = DvIO.ReadFromStack(((File)maps[m]).getAbsolutePath(), FileNameFilters.ImagesPNGorTIF);
                        DvComparator.Compare((DV)mask, (String)"!=", (int)0, (DV)dv, (int)0, (DV)dv);
                        File res = new File("./Result/" + ((File)patients[p]).getName() + "/" + ((File)visits[v]).getName() + "/" + ((File)maps[m]).getName());
                        res.mkdirs();
                        DvIO.WriteStack(dv, res.getAbsolutePath(), ((File)maps[m]).getName().substring(1), "PNG");
                        dv.Kill();
                        continue;
                    }
                    catch (Exception E) {
                        System.err.println(((File)patients[p]).getName() + "/" + ((File)visits[v]).getName() + "/" + ((File)maps[m]).getName());
                        System.err.println(mask.SizeX + " x " + mask.SizeY + " x " + mask.SizeZ + " => " + dv.SizeX + " x " + dv.SizeY + " x " + dv.SizeZ);
                    }
                }
                Arrays.fill(maps, null);
                maps = null;
                mask.Kill();
            }
            Arrays.fill(visits, null);
            visits = null;
            System.out.println("Patient '" + ((File)patients[p]).getName() + "' done.\n\n\n\n\n");
        }
        Arrays.fill(patients, null);
        patients = null;
    }

    public void AddMissingImages(String directory, List<String> maps, FichierTabule data) throws IOException {
        File dirfile = new File(directory);
        if (!dirfile.exists()) {
            throw new IllegalArgumentException("!dirfile.exists()");
        }
        if (!dirfile.isDirectory()) {
            throw new IllegalArgumentException("!dirfile.isDirectory()");
        }
        int colpatients = data.ColumnNumber("Subject#");
        int colvisits = data.ColumnNumber("Visit#");
        int colslices = data.ColumnNumber("Slice");
        BufferedImage image = new BufferedImage(320, 320, 10);
        Object[] patients = dirfile.listFiles(this.ffpatients);
        Arrays.sort(patients);
        for (int p = 0; p < patients.length; ++p) {
            Object[] visits = ((File)patients[p]).listFiles(this.ffvisits);
            if (visits.length != 2) continue;
            Arrays.sort(visits);
            for (int v = 0; v < visits.length; ++v) {
                data.ClearAll();
                data.SelectWhere(colpatients, 0, ((File)patients[p]).getName());
                if (data.nbSelected() == 0) {
                    data.SelectWhere(colpatients, 0, ((File)patients[p]).getName().substring(0, ((File)patients[p]).getName().indexOf(95)));
                }
                data.SelectFromSelectionWhere(colvisits, 0, ((File)visits[v]).getName());
                if (data.nbSelected() == 0 || 2 < data.nbSelected()) {
                    throw new IllegalStateException("data.nbSelected() = " + data.nbSelected() + ", " + ((File)patients[p]).getName() + " & " + ((File)visits[v]).getName() + " => " + data.nbSelected());
                }
                int row = data.FirstSelected();
                int nbslice = data.getValueInt(row, colslices);
                for (String map : maps) {
                    int i2;
                    File filemap = new File(((File)visits[v]).getAbsolutePath() + "/" + map + "/");
                    Object[] images = filemap.listFiles(FileNameFilters.ImagesPNG);
                    Arrays.sort(images);
                    int imstart = Integer.valueOf(this.FindNumber(((File)images[0]).getName()));
                    int imend = Integer.valueOf(this.FindNumber(((File)images[images.length - 1]).getName()));
                    String prefix = this.Prefix(((File)images[0]).getName());
                    String suffix = this.Suffix(((File)images[0]).getName());
                    for (i2 = 1; i2 < imstart; ++i2) {
                        ImageIO.Write(image, filemap.getAbsolutePath() + "/" + prefix + this.NewNum(i2) + suffix, 6);
                    }
                    for (i2 = 0; i2 < images.length; ++i2) {
                        String num = this.FindNumber(((File)images[i2]).getName());
                        if (Integer.valueOf(num) < 100) {
                            ((File)images[i2]).renameTo(new File(((File)images[i2]).getParentFile().getAbsolutePath() + "/" + ((File)images[i2]).getName().replace("_" + num + "_", "_" + this.NewNum(num) + "_")));
                        }
                        num = null;
                    }
                    for (i2 = imend + 1; i2 <= nbslice; ++i2) {
                        ImageIO.Write(image, filemap.getAbsolutePath() + "/" + prefix + this.NewNum(i2) + suffix, 6);
                    }
                    suffix = null;
                    prefix = null;
                    Arrays.fill(images, null);
                    images = null;
                    filemap = null;
                    map = null;
                }
                Iterator<String> iter = null;
            }
            Arrays.fill(visits, null);
            visits = null;
        }
        Arrays.fill(patients, null);
        patients = null;
        dirfile = null;
    }

    private String FindNumber(String string) {
        int start = 0;
        while (string.charAt(start) != '_') {
            ++start;
        }
        int end = ++start + 1;
        while (string.charAt(end) != '_') {
            ++end;
        }
        return string.substring(start, end);
    }

    private String Prefix(String string) {
        int pos = 0;
        while (string.charAt(pos) != '_') {
            ++pos;
        }
        return string.substring(0, pos + 1);
    }

    private String Suffix(String string) {
        int pos = string.length() - 1;
        while (string.charAt(pos) != '_') {
            --pos;
        }
        return string.substring(pos, string.length());
    }

    private String NewNum(String number) {
        return this.NewNum(Integer.valueOf(number));
    }

    private String NewNum(int number) {
        if (number < 10) {
            return "00" + number;
        }
        if (number < 100) {
            return "0" + number;
        }
        return String.valueOf(number);
    }

    public void FromImagesToTrainingSet(String srcdir, String maskdir, int dim, String destdir) throws FileNotFoundException, IOException {
        DV dvdim = new DV(dim, dim, dim, 1, 8);
        DV dvres = new DV(dim + 4, dim + 4, dim + 4, 1, 8);
        LogFile log = new LogFile();
        log.StartNewLog(this, "./");
        File[] srcpatient = new File(srcdir).listFiles();
        for (int p = 0; p < srcpatient.length; ++p) {
            if (!srcpatient[p].isDirectory() || !srcpatient[p].getName().contains("BC")) continue;
            String patientname = srcpatient[p].getName();
            File[] srcvisits = new File(srcpatient[p].getAbsolutePath()).listFiles(this.ffvisits);
            for (int v = 0; v < srcvisits.length; ++v) {
                String visit = srcvisits[v].getName();
                File[] maps = new File(srcvisits[v].getAbsolutePath()).listFiles(FileFilters.Directories);
                DV mask = DvIO.ReadFromStack(maskdir + "/" + patientname + "/" + visit + "/_chiFXL/", FileNameFilters.ImagesPNG);
                if (DvTools.isBlack((DV)mask)) {
                    log.addComment("Empty mask: " + patientname + " / " + visit);
                    continue;
                }
                BasicMeasures3D measures = new BasicMeasures3D();
                measures.Compute(mask, true);
                Point min = measures.BoundingBox.getMin();
                Point max = measures.BoundingBox.getMax();
                int sx = (int)(max.getX() - min.getX());
                int sy = (int)(max.getY() - min.getY());
                int sz = (int)(max.getZ() - min.getZ());
                measures = null;
                for (int m = 0; m < maps.length; ++m) {
                    String map = maps[m].getName();
                    DV dv = DvIO.ReadFromStack(maps[m].getAbsolutePath(), FileNameFilters.ImagesPNG);
                    DV dvcrop = DvNew.Crop((DV)dv, (int)((int)min.getX()), (int)((int)min.getY()), (int)((int)min.getZ()), (int)(sx + 1), (int)(sy + 1), (int)(sz + 1));
                    if (DvTools.isBlack((DV)dvcrop)) {
                        log.addComment("Empty DV: " + patientname + " / " + visit + " / " + map);
                        DvOperations.Fill((DV)dvres, (byte)0);
                        DvIO.WriteStack(dvres, destdir + "/" + map + "/" + visit + "/" + patientname + "/", "Slide", 6);
                        dv.Kill();
                        dvcrop.Kill();
                        dvcrop = null;
                        dv = null;
                        continue;
                    }
                    DV dvresh = DvTransformations.ReshapeGreatter(dvcrop, dim);
                    DvTransformations.Scale(dvresh, Interpolations.Methods3D.Tricubic, dvdim);
                    DvTransformations.ReshapeGreatter(dvdim, dvres);
                    DvIO.WriteStack(dvres, destdir + "/" + map + "/" + visit + "/" + patientname + "/", "Slide", 6);
                    dv.Kill();
                    dvcrop.Kill();
                    dvresh.Kill();
                    dvresh = null;
                    dvcrop = null;
                    dv = null;
                }
                max = null;
                min = null;
                maps = null;
                mask.Kill();
                mask = null;
            }
            srcvisits = null;
        }
        srcpatient = null;
        log.Stop();
    }

    public void ExtractTestSetFromTrainingSet(String srcdir, List<String> tomove, String destdir) throws FileNotFoundException, IOException {
        File[] maps = new File(srcdir).listFiles();
        for (int m = 0; m < maps.length; ++m) {
            if (!maps[m].isDirectory()) continue;
            String map = maps[m].getName();
            File[] srcvisits = new File(maps[m].getAbsolutePath()).listFiles(this.ffvisits);
            for (int v = 0; v < srcvisits.length; ++v) {
                String visit = srcvisits[v].getName();
                File dest = new File(destdir + "/" + map + "/" + visit + "/");
                if (!dest.exists()) {
                    dest.mkdirs();
                }
                Object[] patients = new File(srcvisits[v].getAbsolutePath()).listFiles(FileFilters.Directories);
                for (int p = 0; p < patients.length; ++p) {
                    if (!ListTools.isInList(tomove, (String)((File)patients[p]).getName())) continue;
                    FilesFolders.MoveFolder((File)patients[p], dest);
                }
                Arrays.fill(patients, null);
                patients = null;
                dest = null;
                visit = null;
            }
            srcvisits = null;
            map = null;
        }
        maps = null;
    }
}

