/*
 * Decompiled with CFR 0.152.
 */
package softwares.ohsu.breastcancer;

import characterization.ComputableFeatures;
import characterization.MasterCharacterizer;
import characterization.textures.BasicTexturalFeatures;
import characterization.textures.lbp.LocalBinaryPattern;
import characterization.textures.lbp.MultiLBP;
import characterization.textures.statisticalmatrices.com.Haralick;
import characterization.textures.statisticalmatrices.rlm.FuzzyRLMfeatures;
import characterization.textures.statisticalmatrices.rlm.MultiFuzzyRLM;
import characterization.textures.statisticalmatrices.rlm.MultiRLM;
import characterization.textures.statisticalmatrices.rlm.RLMfeatures;
import characterization.textures.statisticalmatrices.thibaultmatrices.dzm.DZMfeatures;
import characterization.textures.statisticalmatrices.thibaultmatrices.dzm.MultiDZM;
import characterization.textures.statisticalmatrices.thibaultmatrices.szm.FuzzySZMfeatures;
import characterization.textures.statisticalmatrices.thibaultmatrices.szm.MultiFuzzySZM;
import characterization.textures.statisticalmatrices.thibaultmatrices.szm.MultiSZM;
import characterization.textures.statisticalmatrices.thibaultmatrices.szm.SZMfeatures;
import dv.DV;
import dv.DvIO;
import dv.DvTools;
import filesAndFolders.FileFilters;
import filesAndFolders.FileNameFilters;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import mathematics.functions.LinearFunctions;
import mathematics.primitives.pointsTiTi.Point;
import measures.Measures3D;
import morphee.StructuringElement3D;
import morphee.granulometry.PatternSpectrum;
import processing.reducer.FuzzyGLR;
import processing.reducer.HistogramGLR;
import processing.reducer.MinMaxLinearGLR;
import utils.LogFile;

public class BreastTumorsCharacterizer {
    private FileFilter ffpatients = file -> file.isDirectory() && file.getName().startsWith("S");
    private FileFilter ffvisits = file -> file.isDirectory() && file.getName().charAt(0) != '.' && (file.getName().contains("V1") || file.getName().contains("V2"));
    private FileFilter ffdir = file -> file.isDirectory() && !file.getName().startsWith(".");

    public void BiggestBoundingBoxes(String directory, String map) {
        Object[] patients = new File(directory).listFiles(this.ffpatients);
        Arrays.sort(patients);
        if (patients == null || patients.length == 0) {
            throw new IllegalArgumentException("No patients found into directory " + directory);
        }
        int sizex1 = 0;
        int sizey1 = 0;
        int sizez1 = 0;
        int sizex2 = 0;
        int sizey2 = 0;
        int sizez2 = 0;
        for (int p = 0; p < patients.length; ++p) {
            try {
                Measures3D measures = new Measures3D(DvIO.ReadFromStack(((File)patients[p]).getAbsolutePath() + "/V1/" + map + "/", FileNameFilters.ImagesPNG));
                measures.Basics(26);
                Point min = measures.box.getMin();
                Point max = measures.box.getMax();
                int sx = (int)(max.getX() - min.getX());
                int sy = (int)(max.getY() - min.getY());
                int sz = (int)(max.getZ() - min.getZ());
                if (sizex1 < sx) {
                    sizex1 = sx;
                }
                if (sizey1 < sy) {
                    sizey1 = sy;
                }
                if (sizez1 < sz) {
                    sizez1 = sz;
                }
                max = null;
                min = null;
                measures = null;
                measures = new Measures3D(DvIO.ReadFromStack(((File)patients[p]).getAbsolutePath() + "/V2/" + map + "/", FileNameFilters.ImagesPNG));
                measures.Basics(26);
                min = measures.box.getMin();
                max = measures.box.getMax();
                sx = (int)(max.getX() - min.getX());
                sy = (int)(max.getY() - min.getY());
                sz = (int)(max.getZ() - min.getZ());
                if (sizex2 < sx) {
                    sizex2 = sx;
                }
                if (sizey2 < sy) {
                    sizey2 = sy;
                }
                if (sizez2 < sz) {
                    sizez2 = sz;
                }
                max = null;
                min = null;
                measures = null;
                continue;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        patients = null;
        System.out.println("V1 => " + sizex1 + " " + sizey1 + " " + sizez1);
        System.out.println("V2 => " + sizex2 + " " + sizey2 + " " + sizez2);
    }

    public void CompareMasks(String directory) throws FileNotFoundException, IOException {
        Object[] patients = new File(directory).listFiles(this.ffpatients);
        Arrays.sort(patients);
        if (patients == null || patients.length == 0) {
            throw new IllegalArgumentException("No patients found into directory " + directory);
        }
        LogFile log = new LogFile();
        log.StartNewLog(this, "./");
        for (int p = 0; p < patients.length; ++p) {
            Object[] visits = new File(((File)patients[p]).getAbsolutePath()).listFiles(FileFilters.Directories);
            for (int v = 0; v < visits.length; ++v) {
                try {
                    DV dv0 = DvIO.ReadFromStack(((File)visits[v]).getAbsolutePath() + "/_chiFXL/", FileNameFilters.ImagesPNG);
                    DV dv1 = DvIO.ReadFromStack(((File)visits[v]).getAbsolutePath() + "/_chiFXR2/", FileNameFilters.ImagesPNG);
                    DV dv2 = DvIO.ReadFromStack(((File)visits[v]).getAbsolutePath() + "/_chiFXR3/", FileNameFilters.ImagesPNG);
                    log.addComment(((File)patients[p]).getName() + "/" + ((File)visits[v]).getName());
                    if (!DvTools.areEqual((DV)dv0, (DV)dv1)) {
                        log.addComment("     - _chiFXL and _chiFXR2 are difference");
                    }
                    if (!DvTools.areEqual((DV)dv0, (DV)dv2)) {
                        log.addComment("     - _chiFXL and _chiFXR3 are difference");
                    }
                    if (DvTools.areEqual((DV)dv1, (DV)dv2)) continue;
                    log.addComment("     - _chiFXR2 and _chiFXR3 are difference");
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            Arrays.fill(visits, null);
            visits = null;
        }
        patients = null;
        log.Stop();
    }

    public void Characterize(String directory, List<String> maps, String result, int nbCPU) {
        ArrayList<File> files = new ArrayList<File>(1237);
        Object[] patients = new File(directory).listFiles(this.ffpatients);
        Arrays.sort(patients);
        if (patients == null || patients.length == 0) {
            throw new IllegalArgumentException("No patients found into directory " + directory);
        }
        for (int p = 0; p < patients.length; ++p) {
            Object[] visits = new File(((File)patients[p]).getAbsolutePath()).listFiles(this.ffvisits);
            Arrays.sort(visits);
            if (visits.length != 2) {
                throw new IllegalArgumentException(((File)patients[p]).getAbsolutePath() + " does not contain 2 visits (V1 and V2)");
            }
            for (int v = 0; v < visits.length; ++v) {
                Object[] pks = new File(((File)visits[v]).getAbsolutePath()).listFiles(this.ffdir);
                Arrays.sort(pks);
                for (int k = 0; k < pks.length; ++k) {
                    if (!this.ToProcess(((File)pks[k]).getName(), maps)) continue;
                    files.add((File)pks[k]);
                }
                pks = null;
            }
            visits = null;
        }
        patients = null;
        this.Characterize(files, null, result, nbCPU);
        files.clear();
        files = null;
    }

    public void CharacterizeWithMasks(String directory, List<String> maps, String maskname, String result, int nbCPU) {
        ArrayList<File> files = new ArrayList<File>(1237);
        ArrayList<File> masks = new ArrayList<File>(1237);
        Object[] patients = new File(directory).listFiles(this.ffpatients);
        Arrays.sort(patients);
        if (patients == null || patients.length == 0) {
            throw new IllegalArgumentException("No patients found into directory " + directory);
        }
        for (int p = 0; p < patients.length; ++p) {
            Object[] visits = new File(((File)patients[p]).getAbsolutePath()).listFiles(this.ffvisits);
            Arrays.sort(visits);
            if (visits.length != 2) {
                throw new IllegalArgumentException(((File)patients[p]).getAbsolutePath() + " does not contain 2 visits (V1 and V2)");
            }
            for (int v = 0; v < visits.length; ++v) {
                Object[] pks = new File(((File)visits[v]).getAbsolutePath()).listFiles(this.ffdir);
                Arrays.sort(pks);
                File mask = new File(((File)visits[v]).getAbsolutePath() + "/" + maskname + "/");
                for (int k = 0; k < pks.length; ++k) {
                    if (!this.ToProcess(((File)pks[k]).getName(), maps)) continue;
                    files.add((File)pks[k]);
                    masks.add(mask);
                }
                Arrays.fill(pks, null);
                pks = null;
                mask = null;
            }
            visits = null;
        }
        patients = null;
        this.Characterize(files, masks, result, nbCPU);
        files.clear();
        files = null;
    }

    private void Characterize(List<File> files, List<File> masks, String result, int nbCPU) {
        ArrayList<ComputableFeatures> characterizers = new ArrayList<ComputableFeatures>(43);
        this.AddBasics(characterizers);
        MasterCharacterizer mc = new MasterCharacterizer();
        mc.Margin(2);
        mc.Characterize(files, MasterCharacterizer.Source.ImageSequence, masks, characterizers, result, true, true, nbCPU);
        mc = null;
    }

    private void AddBasics(List<ComputableFeatures> characterizers) {
        BasicTexturalFeatures btf = new BasicTexturalFeatures();
        btf.Parameters(0);
        characterizers.add(btf);
    }

    private void AddSZM(List<ComputableFeatures> characterizers) {
        SZMfeatures szm8 = new SZMfeatures();
        szm8.Parameters(8, 1, new MinMaxLinearGLR(), 0, true);
        characterizers.add(szm8);
        SZMfeatures szm16 = new SZMfeatures();
        szm16.Parameters(16, 1, new MinMaxLinearGLR(), 0, true);
        characterizers.add(szm16);
        SZMfeatures szm32 = new SZMfeatures();
        szm32.Parameters(32, 1, new MinMaxLinearGLR(), 0, true);
        characterizers.add(szm32);
        SZMfeatures szm64 = new SZMfeatures();
        szm64.Parameters(64, 1, new MinMaxLinearGLR(), 0, true);
        characterizers.add(szm64);
        SZMfeatures szm128 = new SZMfeatures();
        szm128.Parameters(128, 1, new MinMaxLinearGLR(), 0, true);
        characterizers.add(szm128);
        SZMfeatures szm256 = new SZMfeatures();
        szm256.Parameters(256, 1, new MinMaxLinearGLR(), 0, true);
        characterizers.add(szm256);
        SZMfeatures szmhist8 = new SZMfeatures();
        szmhist8.Parameters(8, 1, new HistogramGLR(), 0, true);
        characterizers.add(szmhist8);
        SZMfeatures szmhist16 = new SZMfeatures();
        szmhist16.Parameters(16, 1, new HistogramGLR(), 0, true);
        characterizers.add(szmhist16);
        SZMfeatures szmhist32 = new SZMfeatures();
        szmhist32.Parameters(32, 1, new HistogramGLR(), 0, true);
        characterizers.add(szmhist32);
        SZMfeatures szmhist64 = new SZMfeatures();
        szmhist64.Parameters(64, 1, new HistogramGLR(), 0, true);
        characterizers.add(szmhist64);
        SZMfeatures szmhist128 = new SZMfeatures();
        szmhist128.Parameters(128, 1, new HistogramGLR(), 0, true);
        characterizers.add(szmhist128);
    }

    private void AddMultiSZM(List<ComputableFeatures> characterizers) {
        MultiSZM mmlin = new MultiSZM();
        mmlin.Parameters(1, new MinMaxLinearGLR(), 0, true);
        characterizers.add(mmlin);
        MultiSZM hist = new MultiSZM();
        hist.Parameters(1, new HistogramGLR(), 0, true);
        characterizers.add(hist);
    }

    private void AddFuzzySZM(List<ComputableFeatures> characterizers) {
        FuzzySZMfeatures fszm1 = new FuzzySZMfeatures();
        fszm1.Parameters(-1, new FuzzyGLR(1, 8, LinearFunctions.DecreasingLinearFrom_01_N0(1)), 0, true);
        characterizers.add(fszm1);
        FuzzySZMfeatures fszm3 = new FuzzySZMfeatures();
        fszm3.Parameters(-1, new FuzzyGLR(3, 8, LinearFunctions.DecreasingLinearFrom_01_N0(3)), 0, true);
        characterizers.add(fszm3);
        FuzzySZMfeatures fszm7 = new FuzzySZMfeatures();
        fszm7.Parameters(-1, new FuzzyGLR(7, 8, LinearFunctions.DecreasingLinearFrom_01_N0(7)), 0, true);
        characterizers.add(fszm7);
        FuzzySZMfeatures fszm11 = new FuzzySZMfeatures();
        fszm11.Parameters(-1, new FuzzyGLR(11, 8, LinearFunctions.DecreasingLinearFrom_01_N0(11)), 0, true);
        characterizers.add(fszm11);
    }

    private void AddMultiFuzzySZM(List<ComputableFeatures> characterizers) {
        double[] weights = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        MultiFuzzySZM mfszm = new MultiFuzzySZM();
        mfszm.Parameters(1, 11, 2, -1, 0, true, weights);
        characterizers.add(mfszm);
        MultiFuzzySZM mfszm3 = new MultiFuzzySZM();
        mfszm3.Parameters(2, 17, 3, -1, 0, true, weights);
        characterizers.add(mfszm3);
    }

    private void AddHaralick(List<ComputableFeatures> characterizers) {
        Haralick hmml8 = new Haralick();
        hmml8.Parameters(new MinMaxLinearGLR(), 8, 0);
        characterizers.add(hmml8);
    }

    private void AddRLM(List<ComputableFeatures> characterizers) {
        RLMfeatures rlm8 = new RLMfeatures();
        rlm8.Parameters(8, new MinMaxLinearGLR(), 0);
        characterizers.add(rlm8);
        RLMfeatures rlm16 = new RLMfeatures();
        rlm16.Parameters(16, new MinMaxLinearGLR(), 0);
        characterizers.add(rlm16);
        RLMfeatures rlm32 = new RLMfeatures();
        rlm32.Parameters(32, new MinMaxLinearGLR(), 0);
        characterizers.add(rlm32);
        RLMfeatures rlm64 = new RLMfeatures();
        rlm64.Parameters(64, new MinMaxLinearGLR(), 0);
        characterizers.add(rlm64);
        RLMfeatures rlm128 = new RLMfeatures();
        rlm128.Parameters(128, new MinMaxLinearGLR(), 0);
        characterizers.add(rlm128);
        RLMfeatures rlm256 = new RLMfeatures();
        rlm256.Parameters(256, new MinMaxLinearGLR(), 0);
        characterizers.add(rlm256);
        RLMfeatures rlmhist8 = new RLMfeatures();
        rlmhist8.Parameters(8, new HistogramGLR(), 0);
        characterizers.add(rlmhist8);
        RLMfeatures rlmhist16 = new RLMfeatures();
        rlmhist16.Parameters(16, new HistogramGLR(), 0);
        characterizers.add(rlmhist16);
        RLMfeatures rlmhist32 = new RLMfeatures();
        rlmhist32.Parameters(32, new HistogramGLR(), 0);
        characterizers.add(rlmhist32);
        RLMfeatures rlmhist64 = new RLMfeatures();
        rlmhist64.Parameters(64, new HistogramGLR(), 0);
        characterizers.add(rlmhist64);
        RLMfeatures rlmhist128 = new RLMfeatures();
        rlmhist128.Parameters(128, new HistogramGLR(), 0);
        characterizers.add(rlmhist128);
    }

    private void AddMultiRLM(List<ComputableFeatures> characterizers) {
        MultiRLM mmlin = new MultiRLM();
        mmlin.Parameters(new MinMaxLinearGLR(), 0);
        characterizers.add(mmlin);
        MultiRLM hist = new MultiRLM();
        hist.Parameters(new HistogramGLR(), 0);
        characterizers.add(hist);
    }

    private void AddFuzzyRLM(List<ComputableFeatures> characterizers) {
        FuzzyRLMfeatures frlm1 = new FuzzyRLMfeatures();
        int fuzzy = 1;
        frlm1.Parameters(-1, new FuzzyGLR(fuzzy, 8, LinearFunctions.DecreasingLinearFrom_01_N0(fuzzy)), 0);
        characterizers.add(frlm1);
        FuzzyRLMfeatures frlm3 = new FuzzyRLMfeatures();
        fuzzy = 3;
        frlm3.Parameters(-1, new FuzzyGLR(fuzzy, 8, LinearFunctions.DecreasingLinearFrom_01_N0(fuzzy)), 0);
        characterizers.add(frlm3);
        FuzzyRLMfeatures frlm7 = new FuzzyRLMfeatures();
        fuzzy = 7;
        frlm7.Parameters(-1, new FuzzyGLR(fuzzy, 8, LinearFunctions.DecreasingLinearFrom_01_N0(fuzzy)), 0);
        characterizers.add(frlm7);
        FuzzyRLMfeatures frlm11 = new FuzzyRLMfeatures();
        fuzzy = 11;
        frlm11.Parameters(-1, new FuzzyGLR(fuzzy, 8, LinearFunctions.DecreasingLinearFrom_01_N0(fuzzy)), 0);
        characterizers.add(frlm11);
    }

    private void AddMultiFuzzyRLM(List<ComputableFeatures> characterizers) {
        double[] weights = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        MultiFuzzyRLM mfrlm = new MultiFuzzyRLM();
        mfrlm.Parameters(1, 11, 2, -1, 0, weights);
        characterizers.add(mfrlm);
        MultiFuzzyRLM mfrlm3 = new MultiFuzzyRLM();
        mfrlm3.Parameters(2, 17, 3, -1, 0, weights);
        characterizers.add(mfrlm3);
        weights = null;
    }

    private void AddDZM(List<ComputableFeatures> characterizers) {
        DZMfeatures rlm8 = new DZMfeatures();
        rlm8.Parameters(8, 1, new StructuringElement3D(new Object[]{3, -15}), false, false, new MinMaxLinearGLR(), 0, true);
        characterizers.add(rlm8);
        DZMfeatures rlm16 = new DZMfeatures();
        rlm16.Parameters(16, 1, new StructuringElement3D(new Object[]{3, -15}), false, false, new MinMaxLinearGLR(), 0, true);
        characterizers.add(rlm16);
        DZMfeatures rlm32 = new DZMfeatures();
        rlm32.Parameters(32, 1, new StructuringElement3D(new Object[]{3, -15}), false, false, new MinMaxLinearGLR(), 0, true);
        characterizers.add(rlm32);
        DZMfeatures rlm64 = new DZMfeatures();
        rlm64.Parameters(64, 1, new StructuringElement3D(new Object[]{3, -15}), false, false, new MinMaxLinearGLR(), 0, true);
        characterizers.add(rlm64);
        DZMfeatures rlm128 = new DZMfeatures();
        rlm128.Parameters(128, 1, new StructuringElement3D(new Object[]{3, -15}), false, false, new MinMaxLinearGLR(), 0, true);
        characterizers.add(rlm128);
        DZMfeatures rlm256 = new DZMfeatures();
        rlm256.Parameters(256, 1, new StructuringElement3D(new Object[]{3, -15}), false, false, new MinMaxLinearGLR(), 0, true);
        characterizers.add(rlm256);
        DZMfeatures rlmhist8 = new DZMfeatures();
        rlmhist8.Parameters(8, 1, new StructuringElement3D(new Object[]{3, -15}), false, false, new HistogramGLR(), 0, true);
        characterizers.add(rlmhist8);
        DZMfeatures rlmhist16 = new DZMfeatures();
        rlmhist16.Parameters(16, 1, new StructuringElement3D(new Object[]{3, -15}), false, false, new HistogramGLR(), 0, true);
        characterizers.add(rlmhist16);
        DZMfeatures rlmhist32 = new DZMfeatures();
        rlmhist32.Parameters(32, 1, new StructuringElement3D(new Object[]{3, -15}), false, false, new HistogramGLR(), 0, true);
        characterizers.add(rlmhist32);
        DZMfeatures rlmhist64 = new DZMfeatures();
        rlmhist64.Parameters(64, 1, new StructuringElement3D(new Object[]{3, -15}), false, false, new HistogramGLR(), 0, true);
        characterizers.add(rlmhist64);
        DZMfeatures rlmhist128 = new DZMfeatures();
        rlmhist128.Parameters(128, 1, new StructuringElement3D(new Object[]{3, -15}), false, false, new HistogramGLR(), 0, true);
        characterizers.add(rlmhist128);
    }

    private void AddMultiDZM(List<ComputableFeatures> characterizers) {
        MultiDZM mmlin = new MultiDZM();
        mmlin.Parameters(1, new StructuringElement3D(new Object[]{3, -15}), false, false, new MinMaxLinearGLR(), 0, true);
        characterizers.add(mmlin);
        MultiDZM hist = new MultiDZM();
        hist.Parameters(1, new StructuringElement3D(new Object[]{3, -15}), false, false, new HistogramGLR(), 0, true);
        characterizers.add(hist);
    }

    private void AddLBP(List<ComputableFeatures> characterizers) {
        LocalBinaryPattern lbp1 = new LocalBinaryPattern();
        lbp1.Parameters(new StructuringElement3D(new Object[]{1, -13, 8}), 1, 0);
        characterizers.add(lbp1);
        LocalBinaryPattern lbp2 = new LocalBinaryPattern();
        lbp2.Parameters(new StructuringElement3D(new Object[]{2, -13, 8}), 1, 0);
        characterizers.add(lbp2);
        LocalBinaryPattern lbp21 = new LocalBinaryPattern();
        lbp21.Parameters(new StructuringElement3D(new Object[]{1, -13, 8}), 2, 0);
        characterizers.add(lbp21);
        LocalBinaryPattern lbp22 = new LocalBinaryPattern();
        lbp22.Parameters(new StructuringElement3D(new Object[]{2, -13, 8}), 2, 0);
        characterizers.add(lbp22);
    }

    private void AddMultiLBP(List<ComputableFeatures> characterizers) {
        double[] weights = new double[]{1.0, 1.0, 1.0};
        MultiLBP mlbp1 = new MultiLBP();
        mlbp1.Parameters(1, 3, 1, 0, 1, weights);
        characterizers.add(mlbp1);
        MultiLBP mlbp2 = new MultiLBP();
        mlbp2.Parameters(1, 5, 2, 0, 1, weights);
        characterizers.add(mlbp2);
        MultiLBP mlbp12 = new MultiLBP();
        mlbp12.Parameters(1, 3, 1, 0, 2, weights);
        characterizers.add(mlbp12);
        MultiLBP mlbp22 = new MultiLBP();
        mlbp22.Parameters(1, 5, 2, 0, 2, weights);
        characterizers.add(mlbp22);
        weights = null;
    }

    private void AddPatternSpectrum(List<ComputableFeatures> characterizers) {
        PatternSpectrum ps1 = new PatternSpectrum();
        ps1.Parameters(1, 5, 1, 0, -1);
        characterizers.add(ps1);
    }

    private boolean ToProcess(String name, List<String> maps) {
        Iterator<String> itermaps = maps.iterator();
        while (itermaps.hasNext()) {
            if (!name.contains(itermaps.next())) continue;
            return true;
        }
        itermaps = null;
        return false;
    }

    private String NewNum(String number) {
        return this.NewNum(Integer.valueOf(number));
    }

    private String NewNum(int number) {
        if (number < 10) {
            return "00" + number;
        }
        if (number < 100) {
            return "0" + number;
        }
        return String.valueOf(number);
    }
}

