/*
 * Decompiled with CFR 0.152.
 */
package softwares.ohsu.HE;

import characterization.ComputableFeatures;
import characterization.MasterCharacterizer;
import characterization.textures.BasicTexturalFeatures;
import characterization.textures.lbp.LocalBinaryPattern;
import characterization.textures.lbp.MultiLBP;
import characterization.textures.statisticalmatrices.com.Haralick;
import characterization.textures.statisticalmatrices.rlm.RLMfeatures;
import characterization.textures.statisticalmatrices.thibaultmatrices.dzm.DZMfeatures;
import characterization.textures.statisticalmatrices.thibaultmatrices.szm.FuzzySZMfeatures;
import characterization.textures.statisticalmatrices.thibaultmatrices.szm.MultiFuzzySZM;
import characterization.textures.statisticalmatrices.thibaultmatrices.szm.SZMfeatures;
import displays.Display;
import filesAndFolders.FileNameFilters;
import filesAndFolders.fichiersTabules.FichierTabule;
import imageTiTi.ImageConverter;
import imageTiTi.ImageIO;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mathematics.functions.LinearFunctions;
import measures.cclh.ConnectedComponentLabeling;
import measures.cclh.FillHole;
import measures.cclh.UnionFindCcl;
import morphee.Close;
import morphee.Open;
import morphee.StructuringElement;
import morphee.granulometry.PatternSpectrum;
import processing.reducer.FuzzyGLR;
import processing.reducer.LinearGLR;
import utils.memory.Allocator;

public class Placenta {
    private final Allocator allocator = Allocator.Instance();
    private final Close close = new Close();
    private final FillHole fh = new FillHole();
    private final Open open = new Open();
    private final UnionFindCcl ccl = new UnionFindCcl();
    private final StructuringElement sesquare1 = new StructuringElement(new Object[]{1, -1});
    private final StructuringElement sedisk1 = new StructuringElement(new Object[]{1, -2});
    private final StructuringElement sedisk2 = new StructuringElement(new Object[]{2, -2});
    private final StructuringElement sehex1 = new StructuringElement(new Object[]{1, -9});
    private final StructuringElement sehex2 = new StructuringElement(new Object[]{2, -9});
    public Display display = null;

    public void PreprocessMasks(String TilesPath, String MasksPath, String ResultsPath, int nbCPU) {
        File resfile = new File(ResultsPath);
        if (!resfile.exists()) {
            resfile.mkdirs();
        }
        resfile = null;
        Object[] masks = new File(MasksPath).listFiles(FileNameFilters.ImagesPNGorTIF);
        Arrays.sort(masks);
        for (Object fmask : masks) {
            try {
                BufferedImage mask = ImageIO.Read((File)fmask);
                BufferedImage maskop = this.open.Filter(mask, this.sedisk1, nbCPU);
                BufferedImage maskcl = this.close.Filter(maskop, this.sehex1, nbCPU);
                BufferedImage finalmask = this.fh.Fill(maskcl, (ConnectedComponentLabeling)this.ccl, 73, true);
                ImageIO.Write(finalmask, ResultsPath + "/" + ((File)fmask).getName(), 6);
                mask = this.allocator.Release(mask);
                maskop = this.allocator.Release(maskop);
                maskcl = this.allocator.Release(maskcl);
                finalmask = this.allocator.Release(finalmask);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            catch (Error er) {
                er.printStackTrace();
            }
        }
    }

    public void PreprocessTiles(String TilesPath, String ResultsPath, int nbCPU) {
        File resfile = new File(ResultsPath);
        if (!resfile.exists()) {
            resfile.mkdirs();
        }
        resfile = null;
        Object[] tiles = new File(TilesPath).listFiles(FileNameFilters.ImagesPNGorTIF);
        Arrays.sort(tiles);
        for (Object ftile : tiles) {
            try {
                BufferedImage tile = ImageIO.Read((File)ftile);
                BufferedImage gray = ImageConverter.RGB_To_GrayLevel((BufferedImage)tile, (int)1);
                ImageIO.Write(gray, ResultsPath + "/" + ((File)ftile).getName().replace(".tif", ".png"), 6);
                gray = this.allocator.Release(gray);
                tile = null;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            catch (Error er) {
                er.printStackTrace();
            }
        }
    }

    public void Run(String TilesPath, String MasksPath, int group, int nbGroups, String ResultsPath, int nbCPU) throws Exception {
        if (nbGroups < 0) {
            throw new Exception("nbGroups < 0.");
        }
        if (group < 0 || nbGroups <= group) {
            throw new Exception("group < 0 || nbGroups <= group.");
        }
        MasterCharacterizer mc = new MasterCharacterizer();
        List<ComputableFeatures> cflist = this.CreateList();
        Object[] tiles = new File(TilesPath).listFiles(FileNameFilters.ImagesPNG);
        Arrays.sort(tiles);
        Object[] masks = new File(MasksPath).listFiles(FileNameFilters.ImagesPNG);
        Arrays.sort(masks);
        if (tiles.length != masks.length) {
            throw new Exception("tiles.length != masks.length");
        }
        int step = tiles.length / nbGroups;
        int start = group * step;
        int end = group == nbGroups - 1 ? tiles.length : (group + 1) * step;
        List<File> tileslist = this.SubList((File[])tiles, start, end);
        List<File> maskslist = this.SubList((File[])masks, start, end);
        try {
            FichierTabule features = mc.Characterize(tileslist, MasterCharacterizer.Source.Image, maskslist, cflist, nbCPU);
            features.Write(ResultsPath, false, ",");
            System.out.println("Group " + group + "/" + nbGroups + " done.");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        tileslist.clear();
        maskslist.clear();
        maskslist = null;
        tileslist = null;
    }

    private List<File> SubList(File[] array, int start, int end) {
        ArrayList<File> list = new ArrayList<File>(end - start + 3);
        for (int i2 = start; i2 < end; ++i2) {
            list.add(array[i2]);
        }
        return list;
    }

    private List<ComputableFeatures> CreateList() {
        ArrayList<ComputableFeatures> list = new ArrayList<ComputableFeatures>(13);
        BasicTexturalFeatures btf = new BasicTexturalFeatures();
        btf.Parameters(0);
        list.add(btf);
        Haralick haralick = new Haralick();
        haralick.Parameters(new LinearGLR(64), 64, 0);
        list.add(haralick);
        RLMfeatures rlm = new RLMfeatures();
        rlm.Parameters(64, new LinearGLR(64), 0);
        list.add(rlm);
        SZMfeatures szm = new SZMfeatures();
        szm.Parameters(64, 1, new LinearGLR(64), 0, true);
        list.add(szm);
        FuzzySZMfeatures fszm = new FuzzySZMfeatures();
        fszm.Parameters(-1, new FuzzyGLR(5, 8, LinearFunctions.DecreasingLinearFrom_01_N0(5)), 0, true);
        list.add(fszm);
        MultiFuzzySZM mfszm = new MultiFuzzySZM();
        mfszm.Parameters(1, 11, 2, -1, 0, true, new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0});
        list.add(mfszm);
        DZMfeatures dzm = new DZMfeatures();
        dzm.Parameters(64, 1, new StructuringElement(new Object[]{3, -15}), false, false, new LinearGLR(64), 0, true);
        list.add(dzm);
        PatternSpectrum ps = new PatternSpectrum();
        ps.Parameters(1, 19, 3, 0, -2);
        list.add(ps);
        LocalBinaryPattern lbp = new LocalBinaryPattern();
        lbp.Parameters(new StructuringElement(new Object[]{1, -13, 8}), 2, 0);
        list.add(lbp);
        MultiLBP mlbp = new MultiLBP();
        mlbp.Parameters(1, 19, 3, 0, 2, new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0});
        list.add(mlbp);
        return list;
    }
}

