/*
 * Decompiled with CFR 0.152.
 */
package softwares.ohsu.HE;

import arrayTiTi.ArrayOperations;
import displays.Colors;
import filesAndFolders.FileFilters;
import filesAndFolders.fichiersTabules.FichierTabule;
import filesAndFolders.fichiersTabules.FichierTabuleTools;
import imageTiTi.ImageDrawer;
import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import listTiTi.ListTools;
import measures.cclh.UnionFindCcl;

public class HETools {
    private FilenameFilter ImagesMasks = (dir, name) -> name.charAt(0) != '.' && !name.contains("DS_Store") && name.endsWith(" - Masks.png");
    private UnionFindCcl ccl = new UnionFindCcl();

    public void SegmentationToPatches(String segdirpath, int dim, String patchesdirpath) {
        File resdir = new File(patchesdirpath);
        if (!resdir.exists()) {
            resdir.mkdirs();
        }
        String respath = resdir.getAbsolutePath();
        int margin = dim >> 1;
        Object[] directories = new File(segdirpath).listFiles(FileFilters.Directories);
        Arrays.sort(directories);
        for (int d = 0; d < directories.length; ++d) {
            Object[] images = new File(((File)directories[d]).getAbsolutePath()).listFiles(this.ImagesMasks);
            Arrays.sort(images);
            for (int im = 0; im < images.length; ++im) {
                try {
                    BufferedImage mask = ImageIO.Read(((File)images[im]).getAbsolutePath());
                    BufferedImage source = ImageIO.Read(((File)images[im]).getAbsolutePath().replace(" - Masks.png", ""));
                    String imname = ((File)images[im]).getName().replace(".png - Masks.png", "");
                    int width = mask.getWidth();
                    int height = mask.getHeight();
                    int wm1 = width - 1;
                    int hm1 = height - 1;
                    this.ccl.Label(mask, 0, true);
                    this.ccl.ComputeBoundingBoxes();
                    int[] minx = this.ccl.minx();
                    int[] maxx = this.ccl.maxx();
                    int[] miny = this.ccl.miny();
                    int[] maxy = this.ccl.maxy();
                    int nbccl = this.ccl.ConnectedComponentsNumber();
                    for (int i2 = 1; i2 < nbccl; ++i2) {
                        if (minx[i2] == 0 || miny[i2] == 0 || maxx[i2] == wm1 || maxy[i2] == hm1) continue;
                        int cx = minx[i2] + maxx[i2] >> 1;
                        int cy = miny[i2] + maxy[i2] >> 1;
                        int sx = cx - margin;
                        int sy = cy - margin;
                        int ex = cx + margin - 1;
                        int ey = cy + margin - 1;
                        if (sx <= 0 || sy <= 0 || width <= ex || height <= ey) continue;
                        BufferedImage patch = ImageNew.SubImage((BufferedImage)source, (int)sx, (int)sy, (int)ex, (int)ey);
                        ImageIO.Write(patch, respath + "/Dir=" + ((File)directories[d]).getName() + "_Im=" + imname + "_Label=" + i2 + "_Pos=" + sx + "_" + sy + "_" + ex + "_" + ey + ".png", 6);
                    }
                    maxy = null;
                    miny = null;
                    maxx = null;
                    minx = null;
                    continue;
                }
                catch (Exception e) {
                    System.out.flush();
                    e.printStackTrace();
                    System.err.println("dir = " + ((File)directories[d]).getAbsolutePath() + ", im = " + ((File)images[im]).getName());
                    System.err.flush();
                }
            }
        }
    }

    public void ClassicationToPatches(String filepath, String root, String resdirpath) throws Exception {
        FichierTabule file = new FichierTabule(filepath, false);
        FichierTabuleTools.Sort(file, 0);
        int width = -1;
        int height = -1;
        String currentdirname = "";
        String currentimagename = "";
        BufferedImage he = null;
        BufferedImage mask = null;
        int[] labels = null;
        ArrayList<String> list = new ArrayList<String>(300);
        for (int i2 = 0; i2 < file.Height(); ++i2) {
            String path = file.getValueString(i2, 0);
            int posim = path.indexOf("_Im=");
            int poslab = path.indexOf("_Label=");
            int pospos = path.indexOf("_Pos=");
            int pospng = path.indexOf(".png");
            String dirname = path.substring(4, posim);
            String imname = path.substring(posim + 4, poslab);
            String label = path.substring(poslab + 7, pospos);
            String coordinates = path.substring(pospos + 5, pospng);
            if (!currentdirname.equalsIgnoreCase(dirname) || !currentimagename.equalsIgnoreCase(imname)) {
                if (he != null) {
                    File resdir = new File(resdirpath + "/" + currentdirname + "/");
                    if (!resdir.exists()) {
                        resdir.mkdirs();
                    }
                    ImageIO.Write(he, resdir.getAbsolutePath() + "/" + currentimagename + ".png", 6);
                    mask = null;
                    he = null;
                    labels = null;
                }
                he = ImageIO.Read(root + "/" + dirname + "/" + imname + ".png");
                width = he.getWidth();
                height = he.getHeight();
                mask = ImageIO.Read(root + "/" + dirname + "/" + imname + ".png - Masks.png");
                this.ccl.Label(mask, 0, true);
                this.ccl.ComputeBoundingBoxes();
                labels = this.ccl.Labels1D();
                currentdirname = dirname;
                currentimagename = imname;
                if (ListTools.isInList(list, (String)path)) {
                    throw new IllegalStateException("In list :-(");
                }
                list.add(path);
            }
            int _1 = coordinates.indexOf(95);
            int _2 = coordinates.indexOf(95, _1 + 1);
            int _3 = coordinates.indexOf(95, _2 + 1);
            int minx = Integer.valueOf(coordinates.substring(0, _1));
            int miny = Integer.valueOf(coordinates.substring(_1 + 1, _2));
            int maxx = Integer.valueOf(coordinates.substring(_2 + 1, _3));
            int maxy = Integer.valueOf(coordinates.substring(_3 + 1));
            List contour = ArrayOperations.Contour((int[])labels, (int)width, (int)height, (boolean)true, (int)Integer.valueOf(label), (int)minx, (int)miny, (int)maxx, (int)maxy);
            ImageDrawer.Coordinates(he, contour, 0, file.getValueDouble(i2, 1) < 0.5 ? Colors.YELLOW : Colors.CYAN);
            contour.clear();
            contour = null;
            coordinates = null;
            imname = null;
            dirname = null;
            path = null;
        }
        File resdir = new File(resdirpath + "/" + currentdirname + "/");
        if (!resdir.exists()) {
            resdir.mkdirs();
        }
        ImageIO.Write(he, resdir.getAbsolutePath() + "/" + currentimagename + ".png", 6);
        mask = null;
        he = null;
        labels = null;
    }
}

