/*
 * Decompiled with CFR 0.152.
 */
package softwares.kidney;

import imageTiTi.ImageConverter;
import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mathematics.primitives.pointsTiTi.Coordinates;
import measures.Measures2D;
import measures.cclh.UnionFindCcl;
import morphee.Dilate;
import morphee.StructuringElement;
import morphee.filters.ASFilterCloseOpen;
import morphee.filters.AreaClosing;
import morphee.segmentation.watershed.Watershed;
import processing.filters.gradients.Sobel;
import processing.thresholding.Binary;

public class KidneySegmentation {
    public KidneySegmentation() throws IOException {
        int nbCPU = 2;
        Binary binary = new Binary(1);
        String source = "/Users/FiReTiTi/Post Doc/Kidney/";
        String num = "05";
        String dest = "/Users/FiReTiTi/Post Doc/Kidney/" + num + "/";
        BufferedImage image = ImageIO.ReadWithImageJ(source + "Rein " + num + ".tif");
        BufferedImage markers = ImageIO.ReadWithImageJ(source + "Markers " + num + ".png");
        AreaClosing areacl = new AreaClosing();
        BufferedImage resarea = ImageNew.Same((BufferedImage)image);
        areacl.Filter(image, resarea, 200, true);
        ASFilterCloseOpen asfco = new ASFilterCloseOpen();
        BufferedImage resasf = asfco.Filter(resarea, new StructuringElement(new Object[]{3, -2}), nbCPU);
        Sobel gradient = new Sobel();
        gradient.Parameters(2);
        BufferedImage resgradient = gradient.Filter(resarea, nbCPU);
        ImageIO.Write(resarea, dest + "/resarea.png", 6);
        ImageIO.Write(resasf, dest + "/resasf.png", 6);
        int min = 255;
        int max = 0;
        ArrayList<Coordinates> markerin = new ArrayList<Coordinates>(1321);
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                if (markers.getRaster().getSample(x, y, 0) != 255 || markers.getRaster().getSample(x, y, 1) >= 255 || markers.getRaster().getSample(x, y, 2) >= 255) continue;
                int v = resasf.getRaster().getSample(x, y, 0);
                if (v > max) {
                    max = v;
                }
                if (v < min) {
                    min = v;
                }
                markerin.add(new Coordinates(x, y));
            }
        }
        BufferedImage immarkin = ImageNew.Same((BufferedImage)image);
        ImageConverter.ListOfPointsToImage(markerin, (BufferedImage)immarkin);
        BufferedImage resbin = binary.Filter(resasf, min, nbCPU);
        ImageIO.Write(resbin, dest + "/resbin.png", 6);
        UnionFindCcl ccl = new UnionFindCcl();
        ccl.Label(resbin, 0, true);
        int[] labels = ccl.Labels1D();
        int numccl = labels[((Coordinates)markerin.get((int)0)).Y * resbin.getWidth() + ((Coordinates)markerin.get((int)0)).X];
        int pos = 0;
        for (int y = 0; y < image.getHeight(); ++y) {
            int x = 0;
            while (x < image.getWidth()) {
                if (labels[pos] != numccl) {
                    resbin.getRaster().setSample(x, y, 0, 0);
                }
                ++x;
                ++pos;
            }
        }
        ImageIO.Write(resbin, dest + "/resbinnew.png", 6);
        Dilate dilate = new Dilate();
        dilate.Parameters(new StructuringElement(new Object[]{13, -2}));
        BufferedImage resdil = dilate.Filter(resbin, nbCPU);
        Measures2D measures = new Measures2D(resdil);
        List<Coordinates> markerout = measures.Contour.Points();
        BufferedImage immarkout = ImageNew.Same((BufferedImage)image);
        ImageConverter.ListOfPointsToImage(markerout, (BufferedImage)immarkout);
        ImageIO.Write(immarkin, dest + "/markerin.png", 6);
        ImageIO.Write(immarkout, dest + "/markerout.png", 6);
        resbin = dilate.Filter(resbin, nbCPU);
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                if (resbin.getRaster().getSample(x, y, 0) != 0) continue;
                resgradient.getRaster().setSample(x, y, 0, 0);
            }
        }
        ImageIO.Write(resgradient, dest + "/resgradient.png", 6);
        Watershed watershed = new Watershed();
        throw new Error("Update watershed call.");
    }
}

