/*
 * Decompiled with CFR 0.152.
 */
package softwares.kcb;

import displays.Colors;
import displays.Display;
import imageTiTi.ImageConverter;
import imageTiTi.ImageDrawer;
import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import imageTiTi.ImageOperations;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.IOException;
import java.util.List;
import listTiTi.Queue;
import mathematics.Bresenham;
import mathematics.Geometry2D;
import mathematics.metrics.Euclidian;
import mathematics.metrics.Metric;
import mathematics.primitives.LineSegment;
import mathematics.primitives.pointsTiTi.Coordinates;
import mathematics.primitives.pointsTiTi.CoordinatesWeighted;
import morphee.Dilate;
import morphee.Erode;
import morphee.StructuringElement;
import processing.filters.DynamicExpansion;
import processing.thresholding.Binary;

public class KCB_Colorimetry {
    public final int ROI = 1;
    public final int RED = 2;
    public final int GREEN = 3;
    public final int CYAN = 4;
    public final int BLUE = 5;
    public final int YELLOW = 6;
    public final int MAGENTA = 7;
    public final int WHITE = 8;
    public final int GRAY1 = 9;
    public final int GRAY2 = 10;
    public final int GRAY3 = 11;
    public final int BLACK = 12;
    public final int QR = 13;
    public final int LINET = 30;
    public final int TR1 = 31;
    public final int TR2 = 32;
    public final int TR3 = 33;
    public final int TR4 = 34;
    public final int TR5 = 35;
    public final int TR6 = 36;
    public final int LINEA = 40;
    public final int RTA1 = 41;
    public final int RTA2 = 42;
    public final int RTA3 = 43;
    public final int RTA4 = 44;
    public final int RTA5 = 45;
    public final int RTA6 = 46;
    private Binary binary = new Binary(128, 128, 128);
    private Dilate dilate = new Dilate();
    private DynamicExpansion de = new DynamicExpansion();
    private Erode erode = new Erode();
    private Metric metric = new Euclidian();
    private final double ratio = 0.15;
    private final double ratioline = 0.4;
    private final double ratioline2 = 0.3;
    private double[][] Coefficients = new double[][]{new double[0], new double[0], new double[0], new double[0], new double[0], new double[0], {0.0642857142857143, 0.20357142857142857, 0.35714285714285715, 0.5, 0.6642857142857144, 0.8071428571428572}};
    public Display display = null;
    private StructuringElement ses2 = new StructuringElement(new Object[]{2, -1});
    private StructuringElement ses3 = new StructuringElement(new Object[]{3, -1});
    private StructuringElement ses5 = new StructuringElement(new Object[]{5, -1});
    private StructuringElement ses7 = new StructuringElement(new Object[]{7, -1});
    private StructuringElement ses11 = new StructuringElement(new Object[]{11, -1});
    private int counter = 0;

    public void Segmentation(BufferedImage image, int nbCPU) throws IOException {
        int width = image.getWidth();
        int height = image.getHeight();
        byte[] bbin = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        BufferedImage imgray = ImageConverter.RGB_To_GrayLevel((BufferedImage)image, (int)2);
        BufferedImage imbin = ImageNew.Same((BufferedImage)imgray);
        this.binary.Filter(imgray, imbin, nbCPU);
        Coordinates[] coordinates = new Coordinates[3];
        int pos = 0;
        int nb = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                if (bbin[pos] == 0 && bbin[pos + 1] == 0 && bbin[pos + 2] == -1) {
                    coordinates[nb++] = new Coordinates(x, y, 0, x + y * width);
                }
                ++x;
                pos += 3;
            }
        }
        this.SortCoordinates(coordinates);
        Coordinates virt = Geometry2D.SymmetricPointLine(new LineSegment(coordinates[2], coordinates[1], 2), coordinates[0]);
        BufferedImage rois = ImageNew.Same((BufferedImage)imgray);
        ImageOperations.Fill((BufferedImage)rois, (int)0);
        this.FindBlue(image, imbin, coordinates, virt, rois);
        this.FindRed(image, imbin, coordinates, virt, rois);
        this.FindGreen(image, imbin, coordinates, virt, rois);
        this.FindYellow(image, imbin, coordinates, virt, rois);
        this.FindLine1(image, imbin, coordinates, virt, rois);
        this.FindLine2(image, imbin, coordinates, virt, rois);
        BufferedImage imtmp = this.dilate.Filter(rois, this.ses5, nbCPU);
        this.erode.Filter(imtmp, this.ses11, rois, nbCPU);
        this.DrawFinalResults(image, rois);
        this.display.Image(image, "Results", 1.0);
        ImageIO.Write(image, "Shoot5_" + this.counter++ + " .png", 6);
    }

    private void FindLine2(BufferedImage src, BufferedImage bin, Coordinates[] coordinates, Coordinates virt, BufferedImage rois) {
        int width = src.getWidth();
        byte[] bbbin = ((DataBufferByte)bin.getRaster().getDataBuffer()).getData();
        byte[] bbroi = ((DataBufferByte)rois.getRaster().getDataBuffer()).getData();
        Coordinates c1 = Geometry2D.SymmetricPointPoint(coordinates[0], coordinates[2], 0.4);
        c1.Pos = c1.X + c1.Y * width;
        Coordinates c2 = Geometry2D.SymmetricPointPoint(coordinates[1], virt, 0.4);
        c2.Pos = c2.X + c2.Y * width;
        Coordinates vect1 = new Coordinates(c1.X - coordinates[0].X, c1.Y - coordinates[0].Y, 0);
        Coordinates vect2 = new Coordinates(c2.X - coordinates[1].X, c2.Y - coordinates[1].Y, 0);
        Coordinates vect = new Coordinates((int)((double)(vect1.X + vect2.X >> 1) * 0.3), (int)((double)(vect1.Y + vect2.Y >> 1) * 0.3), 0);
        vect.Pos = vect.X + vect.Y * width;
        for (int i2 = 0; i2 < bbroi.length; ++i2) {
            if (31 > (bbroi[i2] & 0xFF) || (bbroi[i2] & 0xFF) > 36) continue;
            bbroi[i2 + vect.Pos] = (byte)((bbroi[i2] & 0xFF) + 10);
            bbbin[i2 + vect.Pos] = -128;
        }
    }

    private void FindLine1(BufferedImage src, BufferedImage bin, Coordinates[] coordinates, Coordinates virt, BufferedImage rois) {
        int width = src.getWidth();
        int channel = src.getRaster().getNumBands();
        byte[] bbsrc = ((DataBufferByte)src.getRaster().getDataBuffer()).getData();
        byte[] bbbin = ((DataBufferByte)bin.getRaster().getDataBuffer()).getData();
        byte[] bbroi = ((DataBufferByte)rois.getRaster().getDataBuffer()).getData();
        Coordinates c1 = Geometry2D.SymmetricPointPoint(coordinates[0], coordinates[2], 0.4);
        c1.Pos = c1.X + c1.Y * width;
        Coordinates c2 = Geometry2D.SymmetricPointPoint(coordinates[1], virt, 0.4);
        c2.Pos = c2.X + c2.Y * width;
        Coordinates c3 = Geometry2D.SymmetricPointPoint(c2, c1, 0.4);
        c3.Pos = c3.X + c3.Y * width;
        Coordinates c4 = Geometry2D.SymmetricPointPoint(c1, c2, 0.4);
        c4.Pos = c4.X + c4.Y * width;
        Queue<Coordinates> queue = new Queue<Coordinates>();
        List list = Bresenham.Coordinates((int)c3.X, (int)c3.Y, (int)c4.X, (int)c4.Y);
        int[] X = new int[]{-1, 1, 0, 0};
        int[] Y = new int[]{0, 0, -1, 1};
        int[] offsets = new int[]{-1, 1, -width, width};
        this.ses2.PreComputePositions(width);
        double[] coeffs = this.Coefficients[6];
        for (int coef = 0; coef < coeffs.length; ++coef) {
            Coordinates seed = (Coordinates)list.get((int)((double)list.size() * coeffs[coef] + 0.5));
            seed.Pos = seed.X + seed.Y * width;
            CoordinatesWeighted[] coords = this.ses2.getSE();
            for (int i2 = 0; i2 < coords.length; ++i2) {
                CoordinatesWeighted c = coords[i2];
                int pos = (seed.Pos + c.Pos) * channel;
                if (bbbin[seed.Pos + c.Pos] == 0 && (bbsrc[pos] & 0xFF) + (bbsrc[pos + 1] & 0xFF) < (bbsrc[pos + 2] & 0xFF)) {
                    queue.Push(new Coordinates(seed.X + c.X, seed.Y + c.Y, 0, seed.Pos + c.Pos));
                }
                c = null;
            }
            byte marker = (byte)(31 + coef);
            do {
                Coordinates coord = (Coordinates)queue.FrontPop();
                bbroi[coord.Pos] = marker;
                bbbin[coord.Pos] = -128;
                for (int i3 = 0; i3 < offsets.length; ++i3) {
                    int p = coord.Pos + offsets[i3];
                    int pos = p * channel;
                    if (bbbin[p] != 0 || bbroi[p] != 0 || (bbsrc[pos] & 0xFF) + (bbsrc[pos + 1] & 0xFF) >= (bbsrc[pos + 2] & 0xFF)) continue;
                    queue.Push(new Coordinates(coord.X + X[i3], coord.Y + Y[i3], 0, p));
                    bbroi[p] = marker;
                    bbbin[p] = -128;
                }
                coord = null;
            } while (!queue.Empty());
        }
        queue = null;
        offsets = null;
        Y = null;
        X = null;
        bbroi = null;
        bbsrc = null;
        bbbin = null;
    }

    private void FindBlue(BufferedImage src, BufferedImage bin, Coordinates[] coordinates, Coordinates virt, BufferedImage rois) {
        int width = src.getWidth();
        int height = src.getHeight();
        int channel = src.getRaster().getNumBands();
        if (channel != 3) {
            throw new IllegalArgumentException("channel != 3");
        }
        byte[] bbsrc = ((DataBufferByte)src.getRaster().getDataBuffer()).getData();
        byte[] bbbin = ((DataBufferByte)bin.getRaster().getDataBuffer()).getData();
        byte[] bbroi = ((DataBufferByte)rois.getRaster().getDataBuffer()).getData();
        Coordinates c = Geometry2D.SymmetricPointPoint(coordinates[1], coordinates[0], 0.15);
        c.Pos = c.X + c.Y * width;
        int nb = 1;
        while (bbbin[c.Y * width + c.X] != 0) {
            c = Geometry2D.SymmetricPointPoint(coordinates[1], coordinates[0], 0.15 + (double)nb * 0.01);
            c.Pos = c.X + c.Y * width;
            if (c.X < 0 || width <= c.X || c.Y < 0 || height <= c.Y) {
                throw new IllegalStateException();
            }
            ++nb;
        }
        int[] X = new int[]{-1, 1, 0, 0};
        int[] Y = new int[]{0, 0, -1, 1};
        int[] offsets = new int[]{-1, 1, -width, width};
        Queue<Coordinates> queue = new Queue<Coordinates>();
        queue.Push(c);
        do {
            Coordinates coord = (Coordinates)queue.FrontPop();
            bbroi[coord.Pos] = 5;
            bbbin[coord.Pos] = -128;
            for (int i2 = 0; i2 < offsets.length; ++i2) {
                int p = coord.Pos + offsets[i2];
                int pos = p * channel;
                if ((bbbin[p] & 0xFF) != 0 || (bbroi[p] & 0xFF) != 0 || 127 >= (bbsrc[pos] & 0xFF) && (bbsrc[pos + 1] & 0xFF) + (bbsrc[pos + 2] & 0xFF) >= (bbsrc[pos] & 0xFF)) continue;
                queue.Push(new Coordinates(coord.X + X[i2], coord.Y + Y[i2], 0, p));
                bbroi[p] = 5;
                bbbin[p] = -128;
            }
            coord = null;
        } while (!queue.Empty());
        queue = null;
        offsets = null;
        Y = null;
        X = null;
        bbroi = null;
        bbsrc = null;
        bbbin = null;
    }

    private void FindRed(BufferedImage src, BufferedImage bin, Coordinates[] coordinates, Coordinates virt, BufferedImage rois) {
        int width = src.getWidth();
        int height = src.getHeight();
        int channel = src.getRaster().getNumBands();
        if (channel != 3) {
            throw new IllegalArgumentException("channel != 3");
        }
        byte[] bbsrc = ((DataBufferByte)src.getRaster().getDataBuffer()).getData();
        byte[] bbbin = ((DataBufferByte)bin.getRaster().getDataBuffer()).getData();
        byte[] bbroi = ((DataBufferByte)rois.getRaster().getDataBuffer()).getData();
        Coordinates c = Geometry2D.SymmetricPointPoint(virt, coordinates[2], 0.15);
        c.Pos = c.X + c.Y * width;
        int nb = 1;
        while (bbbin[c.Y * width + c.X] != 0) {
            c = Geometry2D.SymmetricPointPoint(virt, coordinates[2], 0.15 + (double)nb * 0.01);
            c.Pos = c.X + c.Y * width;
            if (c.X < 0 || width <= c.X || c.Y < 0 || height <= c.Y) {
                throw new IllegalStateException();
            }
            ++nb;
        }
        int[] X = new int[]{-1, 1, 0, 0};
        int[] Y = new int[]{0, 0, -1, 1};
        int[] offsets = new int[]{-1, 1, -width, width};
        Queue<Coordinates> queue = new Queue<Coordinates>();
        queue.Push(c);
        do {
            Coordinates coord = (Coordinates)queue.FrontPop();
            bbroi[coord.Pos] = 2;
            bbbin[coord.Pos] = -128;
            for (int i2 = 0; i2 < offsets.length; ++i2) {
                int p = coord.Pos + offsets[i2];
                int pos = p * channel;
                if ((bbbin[p] & 0xFF) != 0 || (bbroi[p] & 0xFF) != 0 || 127 >= (bbsrc[pos + 2] & 0xFF) || (bbsrc[pos] & 0xFF) + (bbsrc[pos + 1] & 0xFF) >= (bbsrc[pos + 2] & 0xFF)) continue;
                queue.Push(new Coordinates(coord.X + X[i2], coord.Y + Y[i2], 0, p));
                bbroi[p] = 2;
                bbbin[p] = -128;
            }
            coord = null;
        } while (!queue.Empty());
        queue = null;
        offsets = null;
        Y = null;
        X = null;
        bbroi = null;
        bbsrc = null;
        bbbin = null;
    }

    private void FindGreen(BufferedImage src, BufferedImage bin, Coordinates[] coordinates, Coordinates virt, BufferedImage rois) {
        int width = src.getWidth();
        int channel = src.getRaster().getNumBands();
        if (channel != 3) {
            throw new IllegalArgumentException("channel != 3");
        }
        byte[] bbsrc = ((DataBufferByte)src.getRaster().getDataBuffer()).getData();
        byte[] bbbin = ((DataBufferByte)bin.getRaster().getDataBuffer()).getData();
        byte[] bbroi = ((DataBufferByte)rois.getRaster().getDataBuffer()).getData();
        Coordinates blue = Geometry2D.SymmetricPointPoint(coordinates[1], coordinates[0], 0.15);
        Coordinates red = Geometry2D.SymmetricPointPoint(virt, coordinates[2], 0.15);
        Coordinates c = new Coordinates(blue.X + red.X >> 1, blue.Y + red.Y >> 1);
        c.Pos = c.X + c.Y * width;
        int[] X = new int[]{-1, 1, 0, 0};
        int[] Y = new int[]{0, 0, -1, 1};
        int[] offsets = new int[]{-1, 1, -width, width};
        Queue<Coordinates> queue = new Queue<Coordinates>();
        queue.Push(c);
        do {
            Coordinates coord = (Coordinates)queue.FrontPop();
            bbroi[coord.Pos] = 3;
            bbbin[coord.Pos] = -128;
            for (int i2 = 0; i2 < offsets.length; ++i2) {
                int p = coord.Pos + offsets[i2];
                int pos = p * channel;
                if ((bbbin[p] & 0xFF) != 0 || (bbroi[p] & 0xFF) != 0 || 127 >= (bbsrc[pos + 1] & 0xFF) && (bbsrc[pos] & 0xFF) + (bbsrc[pos + 2] & 0xFF) >= (bbsrc[pos + 1] & 0xFF)) continue;
                queue.Push(new Coordinates(coord.X + X[i2], coord.Y + Y[i2], 0, p));
                bbroi[p] = 3;
                bbbin[p] = -128;
            }
            coord = null;
        } while (!queue.Empty());
        queue = null;
        offsets = null;
        Y = null;
        X = null;
        bbroi = null;
        bbsrc = null;
        bbbin = null;
    }

    private void FindYellow(BufferedImage src, BufferedImage bin, Coordinates[] coordinates, Coordinates virt, BufferedImage rois) {
        int width = src.getWidth();
        int channel = src.getRaster().getNumBands();
        if (channel != 3) {
            throw new IllegalArgumentException("channel != 3");
        }
        byte[] bbsrc = ((DataBufferByte)src.getRaster().getDataBuffer()).getData();
        byte[] bbbin = ((DataBufferByte)bin.getRaster().getDataBuffer()).getData();
        byte[] bbroi = ((DataBufferByte)rois.getRaster().getDataBuffer()).getData();
        Coordinates c = Geometry2D.SymmetricPointPoint(coordinates[2], virt, 0.15);
        c.Pos = c.X + c.Y * width;
        int[] X = new int[]{-1, 1, 0, 0};
        int[] Y = new int[]{0, 0, -1, 1};
        int[] offsets = new int[]{-1, 1, -width, width};
        Queue<Coordinates> queue = new Queue<Coordinates>();
        queue.Push(c);
        do {
            Coordinates coord = (Coordinates)queue.FrontPop();
            bbroi[coord.Pos] = 6;
            bbbin[coord.Pos] = -128;
            for (int i2 = 0; i2 < offsets.length; ++i2) {
                int p = coord.Pos + offsets[i2];
                int pos = p * channel;
                if ((bbroi[p] & 0xFF) != 0 || (bbsrc[pos] & 0xFF) >= 100 || 127 >= (bbsrc[pos + 1] & 0xFF) || 127 >= (bbsrc[pos + 2] & 0xFF)) continue;
                queue.Push(new Coordinates(coord.X + X[i2], coord.Y + Y[i2], 0, p));
                bbroi[p] = 6;
                bbbin[p] = -128;
            }
            coord = null;
        } while (!queue.Empty());
        queue = null;
        offsets = null;
        Y = null;
        X = null;
        bbroi = null;
        bbsrc = null;
        bbbin = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void SortCoordinates(Coordinates[] coordinates) {
        double d01 = this.metric.Distance(coordinates[0], coordinates[1]);
        double d02 = this.metric.Distance(coordinates[0], coordinates[2]);
        double d12 = this.metric.Distance(coordinates[1], coordinates[2]);
        if (d01 > d02 && d01 > d12) {
            if (coordinates[0].Y < coordinates[1].Y) {
                if (!Geometry2D.TurnLeft(coordinates[0], coordinates[1], coordinates[2])) throw new IllegalStateException("1");
                throw new IllegalStateException("0");
            }
            if (!Geometry2D.TurnLeft(coordinates[0], coordinates[1], coordinates[2])) throw new IllegalStateException("3");
            throw new IllegalStateException("2");
        }
        if (d02 > d01 && d02 > d12) {
            if (coordinates[0].Y < coordinates[2].Y) {
                if (!Geometry2D.TurnLeft(coordinates[0], coordinates[2], coordinates[1])) throw new IllegalStateException("5");
                Coordinates c = coordinates[1];
                coordinates[1] = coordinates[0];
                coordinates[0] = c;
                return;
            }
            if (!Geometry2D.TurnLeft(coordinates[0], coordinates[2], coordinates[1])) throw new IllegalStateException("7");
            throw new IllegalStateException("6");
        }
        if (!(d12 > d01) || !(d12 > d02)) throw new IllegalStateException("Oops!");
        if (coordinates[1].Y < coordinates[2].Y) {
            if (Geometry2D.TurnLeft(coordinates[1], coordinates[2], coordinates[0])) return;
            throw new IllegalStateException("8");
        }
        if (!Geometry2D.TurnLeft(coordinates[1], coordinates[2], coordinates[0])) return;
        throw new IllegalStateException("9");
    }

    private void DrawFinalResults(BufferedImage src, BufferedImage rois) {
        int width = src.getWidth();
        int height = src.getHeight();
        byte[] bbroi = ((DataBufferByte)rois.getRaster().getDataBuffer()).getData();
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                if ((bbroi[pos] & 0xFF) != 0 && ((bbroi[pos - 1] & 0xFF) == 0 || (bbroi[pos + 1] & 0xFF) == 0 || (bbroi[pos - width] & 0xFF) == 0 || (bbroi[pos + width] & 0xFF) == 0)) {
                    ImageDrawer.Point(src, x, y, 2, Colors.CYAN);
                }
                ++x;
                ++pos;
            }
        }
        bbroi = null;
    }
}

