/*
 * Decompiled with CFR 0.152.
 */
package softwares.hackathons;

import displays.Colors;
import displays.Display;
import filesAndFolders.FileFilters;
import filesAndFolders.fichiersTabules.FichierTabule;
import imageTiTi.ImageComparator;
import imageTiTi.ImageConverter;
import imageTiTi.ImageDrawer;
import imageTiTi.ImageFeatures;
import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import imageTiTi.ImageTransformations;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.io.File;
import java.util.Arrays;
import measures.cclh.UnionFindCcl;
import morphee.StructuringElement;
import morphee.WhiteTopHat;
import processing.filters.DynamicExpansion;
import segmentation.cells.DapiMM;
import utils.memory.Allocator;

public class CsbcPson_Vanderbilt {
    private final Allocator allocator = Allocator.Instance();
    private final DapiMM dapi = new DapiMM(20, false);
    private final DynamicExpansion dynexp = new DynamicExpansion();
    private final ImageFeatures features = new ImageFeatures();
    private final UnionFindCcl ccl = new UnionFindCcl();
    private final WhiteTopHat wth = new WhiteTopHat();
    public Display display = null;

    public void Segment(String InputDir, String OutputDir, int nbCPU) {
        this.dapi.SubtractToTopHat = 150;
        this.dapi.AreaOpSize = 1501;
        this.dapi.AreaClSize = 501;
        int simplifytexture = 3;
        boolean equalize = false;
        boolean fillholes = true;
        boolean DeleteOnTop = true;
        boolean roi100saver = false;
        int minsurface = 2501;
        Object[] dirs = new File(InputDir).listFiles(FileFilters.Directories);
        Arrays.sort(dirs);
        for (Object dir : dirs) {
            File outdir = new File(OutputDir + "/" + ((File)dir).getName());
            if (!outdir.exists()) {
                outdir.mkdirs();
            }
            Object[] images = new File(((File)dir).getAbsolutePath()).listFiles(FileFilters.ImagesPNGorTIF);
            Arrays.sort(images);
            for (Object image : images) {
                try {
                    String imname = ((File)image).getName().replace(".png", "");
                    BufferedImage im = ImageIO.Read((File)image);
                    this.dapi.Segmentation(im, false, 3, false, true, true, false, null, 2501, outdir.getAbsolutePath(), nbCPU);
                    this.Rename(imname, outdir.getAbsolutePath());
                    im = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void Rename(String name, String output) {
        File f = new File(output + "/Intermediate - WhiteTopHat.png");
        if (f.exists()) {
            f.delete();
        }
        f = null;
        f = new File(output + "/Intermediate - AreaOpening.png");
        if (f.exists()) {
            f.delete();
        }
        f = null;
        f = new File(output + "/Intermediate - UltimateEroded.png");
        if (f.exists()) {
            f.delete();
        }
        f = null;
        f = new File(output + "/Watershed - Markers.png");
        if (f.exists()) {
            f.delete();
        }
        f = null;
        f = new File(output + "/Segmentation - Full Color.png");
        if (f.exists()) {
            f.renameTo(new File(output + "/" + name + " - Nuclei " + name + "+ Segmentation.png"));
        }
        f = null;
        f = new File(output + "/Segmentation - ROI.png");
        if (f.exists()) {
            f.delete();
        }
        f = null;
        f = new File(output + "/Watershed - Basins.tif");
        if (f.exists()) {
            f.renameTo(new File(output + "/" + name + " - Labels.tif"));
        }
        f = null;
    }

    public void Crop(String Originals, String Segmentation, String MIB, int WindowSize, String Results, int nbCPU) {
        File others;
        File speckles;
        boolean Speckles = true;
        int Others = 2;
        int halfwindow = WindowSize >> 1;
        StructuringElement wthse = new StructuringElement(new Object[]{29, -9});
        File OutputDir = new File(Results);
        if (!OutputDir.exists()) {
            OutputDir.mkdirs();
        }
        if (!(speckles = new File(OutputDir.getAbsolutePath() + "/Speckles/")).exists()) {
            speckles.mkdirs();
        }
        if (!(others = new File(OutputDir.getAbsolutePath() + "/Others/")).exists()) {
            others.mkdirs();
        }
        Object[] dirs = new File(MIB).listFiles(FileFilters.Directories);
        Arrays.sort(dirs);
        for (Object dir : dirs) {
            Object[] images = new File(((File)dir).getAbsolutePath()).listFiles(FileFilters.ImagesPNGorTIF);
            Arrays.sort(images);
            for (Object image : images) {
                try {
                    String imname = ((File)image).getName().replace(".png", "").replace(".tif", "");
                    BufferedImage mib = ImageIO.Read((File)image);
                    BufferedImage labels = ImageIO.Read(Segmentation + "/" + ((File)dir).getName() + "/" + imname + " - Labels.tif");
                    BufferedImage original = ImageIO.Read(Originals + "/" + ((File)dir).getName() + "/" + imname + ".png");
                    BufferedImage reswth = this.wth.Filter(original, wthse, nbCPU);
                    this.dynexp.FilterWithConditions(reswth, 1.0, 0.05, -1, 0, 65535, reswth, nbCPU);
                    if (this.display != null) {
                        this.display.Image(original, imname, 1.0);
                        this.display.Image(reswth, imname + " - Top Hat", 1.0);
                        this.display.Image(labels, imname + " - Labels", 1.0);
                        this.display.Image(mib, imname + " - MIB", 1.0);
                    }
                    int width = original.getWidth();
                    int height = original.getHeight();
                    switch (labels.getRaster().getDataBuffer().getDataType()) {
                        case 0: {
                            this.ccl.ImportLabels(((DataBufferByte)labels.getRaster().getDataBuffer()).getData(), width, height);
                            break;
                        }
                        case 3: {
                            this.ccl.ImportLabels(((DataBufferInt)labels.getRaster().getDataBuffer()).getData(), width, height);
                        }
                    }
                    this.ccl.ComputeBoundingBoxes();
                    int[] xmin = this.ccl.minx();
                    int[] ymin = this.ccl.miny();
                    int[] xmax = this.ccl.maxx();
                    int[] ymax = this.ccl.maxy();
                    BufferedImage lab_crop = ImageNew.Same((int)WindowSize, (int)WindowSize, (BufferedImage)labels);
                    BufferedImage mib_crop = ImageNew.Same((int)WindowSize, (int)WindowSize, (BufferedImage)mib);
                    int nb = this.ccl.ConnectedComponentsNumber();
                    for (int nuc = 1; nuc <= nb; ++nuc) {
                        int by;
                        int bx = xmin[nuc] + xmax[nuc] >> 1;
                        if (bx - halfwindow < 0) {
                            bx -= bx - halfwindow;
                        }
                        if (width < bx + halfwindow) {
                            bx += width - bx - halfwindow;
                        }
                        if ((by = ymin[nuc] + ymax[nuc] >> 1) - halfwindow < 0) {
                            by -= by - halfwindow;
                        }
                        if (height < by + halfwindow) {
                            by += height - by - halfwindow;
                        }
                        BufferedImage ori_crop = ImageNew.SubImageWH((BufferedImage)reswth, (int)(bx - halfwindow), (int)(by - halfwindow), (int)WindowSize, (int)WindowSize);
                        ImageNew.SubImageWH((BufferedImage)labels, (int)(bx - halfwindow), (int)(by - halfwindow), (int)WindowSize, (int)WindowSize, (BufferedImage)lab_crop);
                        ImageNew.SubImageWH((BufferedImage)mib, (int)(bx - halfwindow), (int)(by - halfwindow), (int)WindowSize, (int)WindowSize, (BufferedImage)mib_crop);
                        int width_crop = ori_crop.getWidth();
                        int height_crop = ori_crop.getHeight();
                        if (width_crop != WindowSize || height_crop != WindowSize) {
                            throw new Exception("width_crop != WindowSize || height_crop != WindowSize => " + width_crop + " x " + height_crop);
                        }
                        if (this.display != null && 18 <= nuc && nuc <= 19) {
                            System.out.println("Box = [" + xmin[nuc] + ", " + ymin[nuc] + "] [" + xmax[nuc] + ", " + ymax[nuc] + "] => [" + (bx - halfwindow) + "," + (by - halfwindow) + "]");
                            this.display.Image(ori_crop, "Ori_Crop - " + nuc, 1.0);
                            this.display.Image(lab_crop, "Lab_Crop - " + nuc, 1.0);
                            this.display.Image(mib_crop, "MIB_Crop - " + nuc, 1.0);
                        }
                        BufferedImage res_crop = ImageNew.Same((BufferedImage)ori_crop);
                        ImageComparator.Compare((BufferedImage)lab_crop, (String)"==", (int)nuc, (BufferedImage)ori_crop, (int)0, (BufferedImage)res_crop);
                        res_crop = ImageConverter.UShortGrayToGray((BufferedImage)res_crop, (boolean)true);
                        res_crop = ImageConverter.GrayToColor((BufferedImage)res_crop);
                        ImageComparator.Compare((BufferedImage)lab_crop, (String)"==", (int)nuc, (BufferedImage)mib_crop, (int)0, (BufferedImage)mib_crop);
                        if (this.features.Maximum(mib_crop) == 1.0) {
                            ImageIO.Write(res_crop, speckles.getAbsolutePath() + "/" + ((File)dir).getName() + " - " + imname + " - " + nuc + ".png", 6);
                            continue;
                        }
                        ImageIO.Write(res_crop, others.getAbsolutePath() + "/" + ((File)dir).getName() + " - " + imname + " - " + nuc + ".png", 6);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void CropAll(String Originals, String Segmentation, int WindowSize, String Results, int nbCPU) {
        int halfwindow = WindowSize >> 1;
        StructuringElement wthse = new StructuringElement(new Object[]{29, -9});
        File OutputDir = new File(Results);
        if (!OutputDir.exists()) {
            OutputDir.mkdirs();
        }
        Object[] dirs = new File(Originals).listFiles(FileFilters.Directories);
        Arrays.sort(dirs);
        for (Object dir : dirs) {
            Object[] images = new File(((File)dir).getAbsolutePath()).listFiles(FileFilters.ImagesPNGorTIF);
            Arrays.sort(images);
            for (Object image : images) {
                try {
                    String imname = ((File)image).getName().replace(".png", "").replace(".tif", "");
                    BufferedImage original = ImageIO.Read((File)image);
                    BufferedImage labels = ImageIO.Read(Segmentation + "/" + ((File)dir).getName() + "/" + imname + " - Labels.tif");
                    BufferedImage reswth = this.wth.Filter(original, wthse, nbCPU);
                    this.dynexp.FilterWithConditions(reswth, 1.0, 0.05, -1, 0, 65535, reswth, nbCPU);
                    if (this.display != null) {
                        this.display.Image(original, imname, 1.0);
                        this.display.Image(reswth, imname + " - Top Hat", 1.0);
                        this.display.Image(labels, imname + " - Labels", 1.0);
                    }
                    int width = original.getWidth();
                    int height = original.getHeight();
                    switch (labels.getRaster().getDataBuffer().getDataType()) {
                        case 0: {
                            this.ccl.ImportLabels(((DataBufferByte)labels.getRaster().getDataBuffer()).getData(), width, height);
                            break;
                        }
                        case 3: {
                            this.ccl.ImportLabels(((DataBufferInt)labels.getRaster().getDataBuffer()).getData(), width, height);
                        }
                    }
                    this.ccl.ComputeBoundingBoxes();
                    int[] xmin = this.ccl.minx();
                    int[] ymin = this.ccl.miny();
                    int[] xmax = this.ccl.maxx();
                    int[] ymax = this.ccl.maxy();
                    BufferedImage lab_crop = ImageNew.Same((int)WindowSize, (int)WindowSize, (BufferedImage)labels);
                    int nb = this.ccl.ConnectedComponentsNumber();
                    for (int nuc = 1; nuc <= nb; ++nuc) {
                        int by;
                        int bx = xmin[nuc] + xmax[nuc] >> 1;
                        if (bx - halfwindow < 0) {
                            bx -= bx - halfwindow;
                        }
                        if (width < bx + halfwindow) {
                            bx += width - bx - halfwindow;
                        }
                        if ((by = ymin[nuc] + ymax[nuc] >> 1) - halfwindow < 0) {
                            by -= by - halfwindow;
                        }
                        if (height < by + halfwindow) {
                            by += height - by - halfwindow;
                        }
                        BufferedImage ori_crop = ImageNew.SubImageWH((BufferedImage)reswth, (int)(bx - halfwindow), (int)(by - halfwindow), (int)WindowSize, (int)WindowSize);
                        ImageNew.SubImageWH((BufferedImage)labels, (int)(bx - halfwindow), (int)(by - halfwindow), (int)WindowSize, (int)WindowSize, (BufferedImage)lab_crop);
                        int width_crop = ori_crop.getWidth();
                        int height_crop = ori_crop.getHeight();
                        if (width_crop != WindowSize || height_crop != WindowSize) {
                            throw new Exception("width_crop != WindowSize || height_crop != WindowSize => " + width_crop + " x " + height_crop);
                        }
                        if (this.display != null && 18 <= nuc && nuc <= 19) {
                            System.out.println("Box = [" + xmin[nuc] + ", " + ymin[nuc] + "] [" + xmax[nuc] + ", " + ymax[nuc] + "] => [" + (bx - halfwindow) + "," + (by - halfwindow) + "]");
                            this.display.Image(ori_crop, "Ori_Crop - " + nuc, 1.0);
                            this.display.Image(lab_crop, "Lab_Crop - " + nuc, 1.0);
                        }
                        BufferedImage res_crop = ImageNew.Same((BufferedImage)ori_crop);
                        ImageComparator.Compare((BufferedImage)lab_crop, (String)"==", (int)nuc, (BufferedImage)ori_crop, (int)0, (BufferedImage)res_crop);
                        res_crop = ImageConverter.UShortGrayToGray((BufferedImage)res_crop, (boolean)true);
                        res_crop = ImageConverter.GrayToColor((BufferedImage)res_crop);
                        ImageIO.Write(res_crop, OutputDir.getAbsolutePath() + "/" + ((File)dir).getName() + " - " + imname + " - " + nuc + ".png", 6);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void Resize(String Dir, String Results, int nbCPU) {
        double coef = 0.5;
        Object[] dirs = new File(Dir).listFiles(FileFilters.Directories);
        Arrays.sort(dirs);
        for (Object dir : dirs) {
            if (!((File)dir).getName().contains("161124 u2os #5 ncs 6NCS_0")) continue;
            File outdir = new File(Results + "/" + ((File)dir).getName() + "/");
            if (!outdir.exists()) {
                outdir.mkdirs();
            }
            Object[] images = new File(((File)dir).getAbsolutePath()).listFiles(FileFilters.ImagesPNGorTIF);
            Arrays.sort(images);
            for (Object image : images) {
                try {
                    BufferedImage im = ImageIO.Read((File)image);
                    BufferedImage result = null;
                    switch (im.getRaster().getDataBuffer().getDataType()) {
                        case 0: 
                        case 1: {
                            result = ImageTransformations.Homothetic(im, 0.5, 0.5, 1.0, ImageTransformations.HomotheticInterpolation.CUBIC);
                            break;
                        }
                        case 3: {
                            result = ImageTransformations.Homothetic(im, 0.5, 0.5, 1.0, ImageTransformations.HomotheticInterpolation.NEAREST);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Default!");
                        }
                    }
                    if (((File)image).getName().endsWith(".png")) {
                        ImageIO.Write(result, outdir.getAbsolutePath() + "/" + ((File)image).getName(), 6);
                    } else if (((File)image).getName().endsWith(".tif") || ((File)image).getName().endsWith(".tiff")) {
                        ImageIO.Write(result, outdir.getAbsolutePath() + "/" + ((File)image).getName(), 8);
                    } else {
                        throw new IllegalStateException("Must not happen.");
                    }
                    result = null;
                    im = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void Classification(String Originals, String Segmentation, String classpath, String Results, int nbCPU) throws Exception {
        FichierTabule resfile = new FichierTabule(classpath, true);
        Object[] dirs = new File(Originals).listFiles(FileFilters.Directories);
        Arrays.sort(dirs);
        for (Object dir : dirs) {
            File OutputDir = new File(Results + "/" + ((File)dir).getName());
            if (!OutputDir.exists()) {
                OutputDir.mkdirs();
            }
            Object[] images = new File(((File)dir).getAbsolutePath()).listFiles(FileFilters.ImagesPNGorTIF);
            Arrays.sort(images);
            for (Object image : images) {
                try {
                    String imname = ((File)image).getName().replace(".png", "").replace(".tif", "");
                    BufferedImage original = ImageIO.Read((File)image);
                    BufferedImage labels = ImageIO.Read(Segmentation + "/" + ((File)dir).getName() + "/" + imname + " - Labels.tif");
                    ImageIO.Write(labels, OutputDir + "/" + imname + " - Nuclei.tif", 8);
                    int width = original.getWidth();
                    int height = original.getHeight();
                    switch (labels.getRaster().getDataBuffer().getDataType()) {
                        case 0: {
                            this.ccl.ImportLabels(((DataBufferByte)labels.getRaster().getDataBuffer()).getData(), width, height);
                            break;
                        }
                        case 3: {
                            this.ccl.ImportLabels(((DataBufferInt)labels.getRaster().getDataBuffer()).getData(), width, height);
                        }
                    }
                    int nb = this.ccl.ConnectedComponentsNumber();
                    for (int nuc = 1; nuc <= nb; ++nuc) {
                        String classification;
                        resfile.SelectWhere(0, 6, ((File)dir).getName() + " - " + imname + " - " + nuc + ".png");
                        if (resfile.getNbSelected() != 1) {
                            throw new Exception("Souci : resfile.getNbSelected() = " + resfile.getNbSelected());
                        }
                        int row = resfile.FirstSelected();
                        String string = classification = resfile.getValueDouble(row, 1) < resfile.getValueDouble(row, 2) ? "Speckles" : "Others";
                        if (!"Others".equals(classification)) continue;
                        this.ccl.DeleteCC(labels, nuc);
                    }
                    ImageComparator.Compare((BufferedImage)labels, (String)"!=", (int)0, (int)1, (int)0, (BufferedImage)labels);
                    ImageIO.Write(labels, OutputDir + "/" + imname + " - Speckles.tif", 8);
                    this.dynexp.FilterWithConditions(original, 1.0, 0.05, -1, 0, 65535, original, nbCPU);
                    original = ImageConverter.UShortGrayToGray((BufferedImage)original, (boolean)true);
                    BufferedImage color = ImageConverter.GrayToColor((BufferedImage)original);
                    ImageDrawer.Contour(color, labels, Colors.YELLOW);
                    ImageIO.Write(color, OutputDir + "/" + imname + " - Speckles.png", 6);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

