/*
 * Decompiled with CFR 0.152.
 */
package softwares.flieswings;

import arrayTiTi.ArrayFeatures;
import displays.Colors;
import imageTiTi.ImageConverter;
import imageTiTi.ImageDrawer;
import imageTiTi.ImageIO;
import imageTiTi.ImageTransformations;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import mathematics.primitives.pointsTiTi.Coordinates;
import mathematics.primitives.pointsTiTi.CoordinatesManager;
import measures.BasicMeasures;
import measures.cclh.ConnectedComponentLabeling;
import measures.cclh.UnionFindCcl;
import measures.histogram.IntegralProjectionFunction;
import morphee.Dilate;
import morphee.Erode;
import morphee.StructuringElement;
import morphee.filters.ASFilterCloseOpen;
import processing.filters.Invert;
import processing.filters.gradients.SignalGradient;
import processing.filters.gradients.Sobel;
import processing.thresholding.Binary;
import processing.thresholding.ImageThresholder;
import processing.thresholding.MeanThresholding;

public class WingSegmentation {
    int coucou;
    private final Dilate dilate = new Dilate();
    private final Erode erode = new Erode();
    private final ASFilterCloseOpen asfco = new ASFilterCloseOpen();
    private final ImageThresholder binary = new Binary();
    private final ImageThresholder meanthresholder = new MeanThresholding();
    private final IntegralProjectionFunction ipf = new IntegralProjectionFunction();
    private final ConnectedComponentLabeling ccl = new UnionFindCcl();
    private final Invert invert = new Invert();
    private final SignalGradient gradient = new Sobel();
    private final BasicMeasures bbcpsout = new BasicMeasures();
    private final BasicMeasures bbcpsin = new BasicMeasures();
    private final BasicMeasures bbcpsborder = new BasicMeasures();
    private String wingname = null;
    private int width = 0;
    private int height = 0;
    private boolean symx;
    private boolean symy;
    private BufferedImage result = null;
    private BufferedImage markers = null;
    private final ArrayFeatures AF = new ArrayFeatures();

    public WingSegmentation() {
        this.gradient.Parameters(new Object[]{2});
    }

    public void Segmentation(File sourcepath, String Extension2, int nbCPU) throws IOException {
        File[] folders = sourcepath.listFiles();
        for (int f = 0; f < folders.length; ++f) {
            this.wingname = folders[f].getName();
            BufferedImage image = ImageIO.Read(folders[f].getAbsolutePath() + "/ZProjection/" + this.wingname + " TT" + Extension2 + ".png");
            File out = new File(folders[f].getAbsolutePath() + "/Segmentation/");
            if (!out.exists()) {
                out.mkdirs();
            }
            this.Orientation(image, nbCPU);
            BufferedImage FF = ImageIO.Read(folders[f].getAbsolutePath() + "/ZProjection/" + this.wingname + " FF.png");
            BufferedImage FFmax = ImageIO.Read(folders[f].getAbsolutePath() + "/ZProjection/" + this.wingname + " FF Max.png");
            int wid = image.getWidth();
            int hei = image.getHeight();
            for (int y = 0; y < hei; ++y) {
                for (int x = 0; x < wid; ++x) {
                    if (this.result.getRaster().getSample(x, y, 0) != 0) continue;
                    FF.getRaster().setSample(x, y, 0, 0);
                    FFmax.getRaster().setSample(x, y, 0, 0);
                }
            }
            if (this.symx) {
                ImageTransformations.FlipX(FF);
                ImageTransformations.FlipX(FFmax);
                ImageTransformations.FlipX(this.markers);
                ImageTransformations.FlipX(this.result);
            }
            if (this.symy) {
                ImageTransformations.FlipY(FF);
                ImageTransformations.FlipY(FFmax);
                ImageTransformations.FlipY(this.markers);
                ImageTransformations.FlipY(this.result);
            }
            ImageIO.Write(this.result, out.getAbsolutePath() + "/" + this.wingname + " Mask.png", 6);
            ImageIO.Write(FF, out.getAbsolutePath() + "/" + this.wingname + " FF.png", 6);
            ImageIO.Write(FFmax, out.getAbsolutePath() + "/" + this.wingname + " FF Max.png", 6);
            ImageIO.Write(this.markers, out.getAbsolutePath() + "/" + this.wingname + " Markers.png", 6);
        }
    }

    private void Orientation(BufferedImage image, int nbCPU) {
        this.width = image.getWidth();
        this.height = image.getHeight();
        this.symy = false;
        this.symx = false;
        BufferedImage resasfco = this.asfco.Filter(image, new StructuringElement(new Object[]{5, -10}), nbCPU);
        BufferedImage bin = this.meanthresholder.Filter(resasfco, nbCPU);
        BufferedImage bininv = this.invert.Filter(bin, nbCPU);
        this.ccl.Label(bininv, 0, true);
        if (this.ccl.ConnectedComponentsNumber() > 1) {
            int max = this.AF.Maximum(this.ccl.Sizes());
            this.ccl.DeleteSmallerThan(bininv, max);
        }
        this.markers = ImageConverter.GrayToColor((BufferedImage)image);
        this.bbcpsborder.Compute(bininv, true);
        ImageDrawer.Coordinates(this.markers, this.bbcpsborder.Boundary, 0, Colors.WHITE);
        BufferedImage bineroded = this.erode.Filter(bininv, new StructuringElement(new Object[]{31, -1}), nbCPU);
        this.bbcpsin.Compute(bineroded, true);
        this.DeleteBorder(this.bbcpsin.Boundary);
        ImageDrawer.Coordinates(this.markers, this.bbcpsin.Boundary, 0, Colors.RED);
        BufferedImage bindilated = this.dilate.Filter(bininv, new StructuringElement(new Object[]{31, -1}), nbCPU);
        this.bbcpsout.Compute(bindilated, true);
        this.DeleteBorder(this.bbcpsout.Boundary);
        ImageDrawer.Coordinates(this.markers, this.bbcpsout.Boundary, 0, Colors.BLUE);
        throw new Error("Convertion not fixed.");
    }

    private void DeleteBorder(CoordinatesManager manager) {
        int i2 = 0;
        while (i2 < manager.Size()) {
            Coordinates p = manager.Point(i2);
            if (p.X == 0 || p.Y == 0 || p.X == this.width - 1 || p.Y == this.height - 1) {
                manager.Remove(i2);
                continue;
            }
            ++i2;
        }
    }
}

