/*
 * Decompiled with CFR 0.152.
 */
package softwares.flieswings;

import characterization.ComputableFeatures;
import imageTiTi.ImageIO;
import java.awt.image.BufferedImage;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;

public class CharacterizeWings {
    private int nbErrors;

    public void Characterize(File folderpath, String extension, ComputableFeatures computable, String fileout, int nbCPU) throws Exception {
        int i2;
        File[] list = folderpath.listFiles();
        DataOutputStream out = new DataOutputStream(new FileOutputStream(fileout));
        this.nbErrors = 0;
        String[] names = computable.FeaturesNames();
        for (i2 = 0; i2 < names.length; ++i2) {
            out.write(("\"" + names[i2] + "\" ").getBytes("ISO-8859-1"));
        }
        out.write("\" Image\"\n".getBytes("ISO-8859-1"));
        for (int f = 0; f < list.length; ++f) {
            if (!list[f].isDirectory()) continue;
            try {
                String name = list[f].getName();
                BufferedImage image = ImageIO.Read(list[f].getAbsoluteFile() + "/Segmentation/" + name + " FF" + extension + ".png");
                computable.Compute(image, null, computable.ForbiddenValue(), nbCPU);
                double[] features = computable.Features();
                for (i2 = 0; i2 < features.length; ++i2) {
                    out.write((features[i2] + " ").getBytes("ISO-8859-1"));
                }
                out.write(("\"" + name + " FF" + extension + ".png\"\n").getBytes("ISO-8859-1"));
                image = null;
                continue;
            }
            catch (Exception e) {
                ++this.nbErrors;
                e.printStackTrace();
                continue;
            }
            catch (Error e) {
                ++this.nbErrors;
                e.printStackTrace();
            }
        }
        System.err.println("Program finished with " + this.nbErrors + " error(s).");
    }
}

