/*
 * Decompiled with CFR 0.152.
 */
package softwares.cmm.teleOphta;

import displays.Display;
import filesAndFolders.FilesFolders;
import filesAndFolders.fichiersTabules.FichierTabule;
import filesAndFolders.fichiersTabules.FichierTabuleTools;
import imageTiTi.ImageArithmetic;
import imageTiTi.ImageComparator;
import imageTiTi.ImageConverter;
import imageTiTi.ImageFeatures;
import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import imageTiTi.ImageOperations;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import mathematics.fourier.JTransformsComplex;
import mathematics.statistics.CircularStatistics;
import measures.cclh.ConnectedComponentLabeling;
import measures.cclh.UnionFindCcl;
import morphee.Close;
import morphee.Erode;
import morphee.StructuringElement;
import morphee.filters.ASFilterOpenClose;
import morphee.geodesic.OverBuild;
import morphee.geodesic.UnderBuild;
import processing.filters.ConvolutionFilter;
import processing.filters.DynamicExpansion;
import processing.filters.Gabor;
import processing.filters.GaborCircular;
import processing.thresholding.MeanThresholding;
import processing.thresholding.PercentileThresholding;
import processing.thresholding.adaptive.LocalMedian;
import softwares.cmm.teleOphta.EvaluateVesselDetection;

public class VesselDetectionIter {
    private final int TeleOphta = 0;
    private final int Drive = 1;
    private final int Stare = 2;
    public int nbErrors = 0;
    private int mode = -1;
    public boolean usedecreasingfunction = true;
    public boolean displayoriginal = false;
    public boolean displayasf = false;
    public boolean displaygabors = false;
    public boolean displaygabormedmean = false;
    public boolean displayresult = false;
    public boolean computepreprocessing = false;
    public boolean computegabors = false;
    public boolean computegabormedmean = false;
    public boolean computeresult = false;
    public boolean writeoriginal = false;
    public boolean readpreprocessing = false;
    public boolean writepreprocessing = false;
    public boolean readgabors = false;
    public boolean writegabors = false;
    public boolean readgabormedmean = false;
    public boolean writegabormedmean = false;
    public boolean readresult = false;
    public boolean writeresult = false;
    public boolean quickdetection = false;
    public int ForbidenValue = 0;
    public int nbIteration = 10;
    private final ConnectedComponentLabeling ccl = new UnionFindCcl();
    private final DynamicExpansion dynexp = new DynamicExpansion();
    private final Gabor gabor = new Gabor();
    private final GaborCircular circgab = new GaborCircular();
    private final JTransformsComplex jt = new JTransformsComplex();
    private final Erode erode = new Erode();
    private final Close close = new Close();
    UnderBuild under = new UnderBuild();
    OverBuild over = new OverBuild();
    private int height;
    private int width;
    private double scale = 1.0;
    private int nbGabor = 0;
    private int sizese = 0;
    private Display display = null;
    private BufferedImage resgabor = null;
    private final ImageFeatures IF = new ImageFeatures();
    private final ASFilterOpenClose asoc = new ASFilterOpenClose();
    private StructuringElement seasf = null;
    private final double coefmax = 2.0;
    private final LocalMedian localmedian = new LocalMedian();
    public String NameResult = " - Result Median ";
    PercentileThresholding percentile = new PercentileThresholding();
    MeanThresholding meanthres = new MeanThresholding();
    private final ConvolutionFilter convolution = new ConvolutionFilter();
    private final CircularStatistics circstats = new CircularStatistics();

    public VesselDetectionIter(Display display) {
        this.display = display;
    }

    public void ExtractVesselsOphDiat(File src, boolean wait, String start, String end, String folderout, boolean delete, int nbCPU) {
        Object[] patients = src.listFiles();
        Arrays.sort(patients);
        this.nbErrors = 0;
        for (int p = 0; p < patients.length; ++p) {
            if (!((File)patients[p]).isDirectory() || !((File)patients[p]).getAbsoluteFile().getName().contains("P0")) continue;
            if (wait && ((File)patients[p]).getName().contains(start)) {
                wait = false;
            }
            if (!wait) {
                this.ExtractVesselsForOnePatient((File)patients[p], false, "", "", folderout + "/" + ((File)patients[p]).getName() + "/", delete, nbCPU);
            }
            if (wait || !((File)patients[p]).getName().contains(end)) continue;
            wait = true;
        }
    }

    public void ExtractVesselsForOnePatient(File src, boolean wait, String start, String end, String folderout, boolean delete, int nbCPU) {
        Object[] visits = src.listFiles();
        Arrays.sort(visits);
        for (int v = 0; v < visits.length; ++v) {
            if (!((File)visits[v]).isDirectory()) continue;
            if (wait && ((File)visits[v]).getName().contains(start)) {
                wait = false;
            }
            if (!wait) {
                this.ExtractVesselsForOneFolder(((File)visits[v]).getAbsoluteFile(), false, "", "", folderout + "/" + ((File)visits[v]).getName() + "/", delete, nbCPU);
            }
            if (wait || !((File)visits[v]).getName().contains(end)) continue;
            wait = true;
        }
    }

    public void ExtractVesselsForOneFolder(File src, boolean wait, String start, String end, String folderout, boolean delete, int nbCPU) {
        Object[] images = src.listFiles();
        BufferedImage result = null;
        int nb = 0;
        Arrays.sort(images);
        delete = false;
        for (Object image1 : images) {
            if (!((File)image1).isFile() || !((File)image1).getName().toLowerCase().contains(".jpg") && !((File)image1).getName().toLowerCase().contains(".png") && !((File)image1).getName().toLowerCase().contains(".tif")) continue;
            if (wait && ((File)image1).getName().contains(start)) {
                wait = false;
            }
            if (!wait) {
                try {
                    BufferedImage image = ImageConverter.Channel((BufferedImage)ImageIO.Read(((File)image1).getAbsolutePath()), (int)1);
                    result = new BufferedImage(image.getWidth(), image.getHeight(), 12);
                    String name = ((File)image1).getName().substring(0, ((File)image1).getName().length() - 4);
                    this.height = image.getHeight();
                    this.width = image.getWidth();
                    for (nb = 0; nb < this.nbIteration; ++nb) {
                        File dest = new File(folderout + "/Iter" + (nb < 10 ? "0" : "") + nb + "/");
                        if (!dest.exists()) {
                            dest.mkdirs();
                        }
                        if (this.writeoriginal) {
                            ImageIO.Write(image, dest + "/" + name + " - Original.png", 6);
                        }
                        this.ExtractVessels(((File)image1).getAbsolutePath(), image, name, result, dest.getAbsolutePath(), nbCPU);
                        if (nb >= this.nbIteration - 1) continue;
                        throw new UnsupportedOperationException("Method to upgrade.");
                    }
                    if (delete) {
                        FilesFolders.Delete((File)image1);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ++this.nbErrors;
                }
                catch (Error e) {
                    e.printStackTrace();
                    ++this.nbErrors;
                }
            }
            if (wait || !((File)image1).getName().contains(end)) continue;
            wait = true;
        }
    }

    public void ExtractVessels(String path, BufferedImage image, String name, BufferedImage result, String dest, int nbCPU) {
        try {
            if (this.displayoriginal) {
                this.display.Image(image, name + " - Original", 1.0);
            }
            BufferedImage imeroded = ImageNew.Same((BufferedImage)image);
            this.Parameters(image, new File(path), name);
            BufferedImage asf = this.Preprocessing(image, path, name, dest, imeroded, nbCPU);
            if (this.quickdetection) {
                this.QuickDetection(asf, result, path, name, dest, nbCPU);
            } else {
                this.Gabors(image, asf, imeroded, path, name, dest, nbCPU);
                this.FinalResult(this.resgabor, path, name, dest, nbCPU);
            }
            if (this.displayresult) {
                this.display.Image(result, name + " - Result", 1.0);
            }
            imeroded = null;
            asf = null;
        }
        catch (Exception e) {
            ++this.nbErrors;
            e.printStackTrace();
        }
        catch (Error e) {
            ++this.nbErrors;
            e.printStackTrace();
        }
    }

    private BufferedImage Preprocessing(BufferedImage image, String path, String name, String dest, BufferedImage imeroded, int nbCPU) throws IOException {
        int typese;
        BufferedImage asf = null;
        int n = typese = this.quickdetection ? -1 : -2;
        if (this.seasf == null || this.seasf.getOrder() != this.sizese || this.seasf.getType() != typese) {
            this.seasf = new StructuringElement(new Object[]{this.sizese, typese});
        }
        if (this.computepreprocessing) {
            BufferedImage resasoc = this.asoc.Filter(image, new StructuringElement(new Object[]{(int)(this.scale * 7.0 + 0.5), typese}), nbCPU);
            asf = ImageArithmetic.Subtract(resasoc, image, 0, 0);
            resasoc = null;
        } else if (this.readpreprocessing) {
            asf = ImageIO.Read(dest + "/" + name + " - PreProcessing.png");
        }
        this.erode.setStructuringElement(this.seasf);
        this.erode.Filter(image, imeroded, nbCPU);
        if (this.computepreprocessing) {
            ImageComparator.Compare((BufferedImage)imeroded, (String)"==", (int)0, (BufferedImage)imeroded, (BufferedImage)asf, (BufferedImage)asf);
        }
        if (this.writepreprocessing) {
            ImageIO.Write(asf, dest + "/" + name + " - PreProcessing.png", 6);
        }
        if (this.displayasf) {
            this.display.Image(asf, name + " - PreProcessing", 1.0);
        }
        return asf;
    }

    private void Gabors(BufferedImage image, BufferedImage asf, BufferedImage imeroded, String path, String name, String dest, int nbCPU) throws IOException {
        int x;
        int y;
        int start = 2;
        double lambda = 0.0;
        double phase = 0.0;
        double sigmax = 0.0;
        double sigmay = 0.0;
        double average = 0.0;
        double coefmin = 1.0;
        this.resgabor = new BufferedImage(this.width, this.height, 11);
        BufferedImage imspreaded = ImageNew.Same((BufferedImage)this.resgabor);
        BufferedImage resgaborcirc = ImageNew.Same((BufferedImage)this.resgabor);
        BufferedImage imcircspreaded = ImageNew.Same((BufferedImage)this.resgabor);
        BufferedImage minim = ImageNew.Same((BufferedImage)this.resgabor);
        double[][][] stochastic = null;
        if (this.computegabors || this.readgabors) {
            stochastic = new double[image.getHeight()][image.getWidth()][this.nbGabor - start + 1];
        }
        for (int p = start; p <= this.nbGabor; ++p) {
            if (this.computegabors) {
                sigmax = this.scale * (double)p;
                double a = (coefmin - 2.0) / (double)(this.nbGabor - start);
                double b = 2.0 - a * (double)start;
                switch (this.mode) {
                    case 1: {
                        sigmay = this.usedecreasingfunction ? a * sigmax + b + 1.0 : 1.5 * sigmax + 1.0;
                        lambda = 3.0 * sigmax;
                        break;
                    }
                    case 2: {
                        sigmay = 1.5 * sigmax + 1.0;
                        lambda = 3.0 * sigmax;
                        break;
                    }
                    case 0: {
                        sigmay = this.usedecreasingfunction ? a * sigmax + b + 1.0 : 2.0 * sigmax + 1.0;
                        lambda = 2.0 * sigmax;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown database (mode): " + this.mode);
                    }
                }
                this.gabor.Parameters(0, 165, 15, sigmax, sigmay, lambda, phase, this.jt, 0, 1, true, false);
                this.gabor.Filter(asf, this.resgabor, nbCPU);
                ImageIO.Write(this.resgabor, dest + "/" + name + " - GaborRough " + (p < 10 ? "0" : "") + p + ".png", 6);
                average = this.IF.Average(this.resgabor, 0);
                ImageArithmetic.Subtract(this.resgabor, (int)average, this.resgabor, 0, 0);
                this.dynexp.Filter(this.resgabor, 0, 65535, imspreaded, nbCPU);
                this.circgab.Parameters(sigmax, lambda, phase, this.jt, 0, true);
                this.circgab.Filter(asf, resgaborcirc, nbCPU);
                ImageIO.Write(resgaborcirc, dest + "/" + name + " - GaborCircRough " + (p < 10 ? "0" : "") + p + ".png", 6);
                ImageComparator.Compare((BufferedImage)imeroded, (String)"!=", (int)0, (BufferedImage)resgaborcirc, (int)0, (BufferedImage)resgaborcirc);
                average = this.IF.Average(resgaborcirc, 0);
                ImageArithmetic.Subtract(resgaborcirc, (int)average, resgaborcirc, 0, 0);
                this.dynexp.Filter(resgaborcirc, 0, 65535, imcircspreaded, nbCPU);
                ImageOperations.Minimum((BufferedImage)imspreaded, (BufferedImage)imcircspreaded, (BufferedImage)minim);
                ImageOperations.MoveForward((BufferedImage)minim, (BufferedImage)minim, (int)1, (int)1, (int)0);
                for (y = 0; y < image.getHeight(); ++y) {
                    for (x = 0; x < image.getWidth(); ++x) {
                        double[] dArray = stochastic[y][x];
                        int n = p - start;
                        dArray[n] = dArray[n] + minim.getRaster().getSampleDouble(x, y, 0);
                    }
                }
                if (this.writegabors) {
                    ImageIO.Write(imspreaded, dest + "/" + name + " - Gabor " + (p < 10 ? "0" : "") + p + ".png", 6);
                    ImageIO.Write(imcircspreaded, dest + "/" + name + " - GaborCirc " + (p < 10 ? "0" : "") + p + ".png", 6);
                    ImageIO.Write(minim, dest + "/" + name + " - GaborMin " + (p < 10 ? "0" : "") + p + ".png", 6);
                }
                if (!this.displaygabors) continue;
                this.display.Image(imspreaded, name + " - Gabor " + (p < 10 ? "0" : "") + p, 1.0);
                this.display.Image(imcircspreaded, name + " - GaborCirc " + (p < 10 ? "0" : "") + p, 1.0);
                this.display.Image(minim, name + " - GaborMin " + (p < 10 ? "0" : "") + p, 1.0);
                continue;
            }
            if (!this.readgabors) continue;
            System.out.flush();
            System.err.println("Incomplete readgabors");
            System.err.flush();
            System.exit(0);
            this.resgabor = ImageIO.Read(dest + "/" + name + " - Gabor " + (p < 10 ? "0" : "") + p + ".png");
            if (this.displaygabors) {
                this.display.Image(imspreaded, name + " - Gabor " + (p < 10 ? "0" : "") + p, 1.0);
            }
            for (y = 0; y < image.getHeight(); ++y) {
                for (x = 0; x < image.getWidth(); ++x) {
                    double[] dArray = stochastic[y][x];
                    int n = p - start;
                    dArray[n] = dArray[n] + imspreaded.getRaster().getSampleDouble(x, y, 0);
                }
            }
            this.resgabor = null;
        }
        if (this.computegabormedmean) {
            BufferedImage restochmedinf = ImageNew.Same((BufferedImage)this.resgabor);
            BufferedImage restochmedmid = ImageNew.Same((BufferedImage)this.resgabor);
            BufferedImage restochmedsup = ImageNew.Same((BufferedImage)this.resgabor);
            int step = (this.nbGabor - start + 1) / 2;
            double[] buffer = new double[step];
            for (y = 0; y < this.height; ++y) {
                for (x = 0; x < this.width; ++x) {
                    int p;
                    System.arraycopy(stochastic[y][x], 0, buffer, 0, step);
                    Arrays.sort(buffer);
                    restochmedinf.getRaster().setSample(x, y, 0, buffer[step / 2]);
                    for (p = 0; p < step; ++p) {
                        buffer[p] = stochastic[y][x][step / 2 + 1 + p];
                    }
                    Arrays.sort(buffer);
                    restochmedmid.getRaster().setSample(x, y, 0, buffer[step / 2]);
                    for (p = 0; p < step; ++p) {
                        buffer[p] = stochastic[y][x][this.nbGabor - start - p];
                    }
                    Arrays.sort(buffer);
                    restochmedsup.getRaster().setSample(x, y, 0, buffer[step / 2]);
                    this.resgabor.getRaster().setSample(x, y, 0, (double)(restochmedinf.getRaster().getSample(x, y, 0) + restochmedmid.getRaster().getSample(x, y, 0) + restochmedsup.getRaster().getSample(x, y, 0)) / 3.0);
                }
            }
        }
        if (this.readgabormedmean) {
            this.resgabor = ImageIO.Read(dest + "/" + name + " - MedianMean.png");
        }
        if (this.writegabormedmean) {
            ImageIO.Write(this.resgabor, dest + "/" + name + " - MedianMean.png", 6);
        }
        if (this.displaygabormedmean) {
            this.display.Image(this.resgabor, name + " - Gabor Median Mean", 1.0);
        }
    }

    private void FinalResult(BufferedImage gabormedmean, String path, String name, String dest, int nbCPU) throws Exception {
        BufferedImage result = null;
        if (this.computeresult) {
            result = new BufferedImage(gabormedmean.getWidth(), gabormedmean.getHeight(), 12);
            for (int percentage = 60; percentage <= 110; percentage += 10) {
                this.localmedian.Parameters(15, false, 0, percentage);
                this.localmedian.Filter(gabormedmean, result, nbCPU);
                this.ccl.Label(result, 0, true);
                this.ccl.DeleteSmallerThan(result, 15);
                ImageIO.Write(result, dest + "/" + name + this.NameResult + percentage + ".png", 6);
            }
        } else if (this.readresult) {
            result = ImageIO.Read(dest + "/" + name + " - Result.png");
        }
        if (this.displayresult) {
            this.display.Image(result, name + " - Result", 1.0);
        }
        result = null;
    }

    private BufferedImage QuickDetection(BufferedImage asf, String path, String name, String dest, int nbCPU) throws IOException {
        BufferedImage result = new BufferedImage(asf.getWidth(), asf.getHeight(), 12);
        this.QuickDetection(asf, result, path, name, dest, nbCPU);
        return result;
    }

    private void QuickDetection(BufferedImage resasf, BufferedImage result, String path, String name, String dest, int nbCPU) throws IOException {
        for (int t = 70; t <= 150; t += 10) {
            this.localmedian.Parameters(4, false, t);
            BufferedImage resthres = this.localmedian.Filter(resasf, 0, nbCPU);
            this.ccl.Label(resthres, this.ForbidenValue, true);
            this.ccl.DeleteSmallerThan(resthres, (int)(20.0 * this.scale + 0.5));
            this.close.setStructuringElement(new StructuringElement(new Object[]{this.sizese / 2, -1}));
            this.close.Filter(resthres, result, nbCPU);
            if (!this.writeresult) continue;
            ImageIO.Write(result, dest + "/" + name + " - Result ASF Median " + t + ".png", 6);
        }
    }

    private boolean isInList(List<String> list, String name) {
        Iterator<String> iter = list.iterator();
        while (iter.hasNext()) {
            if (!iter.next().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public void LearningOnDrive(String path, String groundtruth, int nbCPU) {
        File[] files = new File(path).listFiles();
        LinkedList<String> list = new LinkedList<String>();
        for (File file : files) {
            String name;
            if (file.getName().contains(".txt") || file.getName().contains(".DS_Store") || this.isInList(list, name = file.getName().substring(0, file.getName().indexOf(32)))) continue;
            list.add(name);
            try {
                this.LearnOnDrive(path, name, groundtruth, nbCPU);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        FichierTabule result = null;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            try {
                FichierTabule ft = new FichierTabule(path + "/" + (String)list.get(i2) + " - Characteristics.txt", true);
                if (result == null) {
                    result = ft;
                    continue;
                }
                result = FichierTabuleTools.Merge(result, ft);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        result.Write(path + "/Characteristics.txt", false);
    }

    private void LearnOnDrive(String path, String name, String groundtruth, int nbCPU) throws IOException {
        int x;
        int y;
        int p;
        int i2;
        File[] files = new File(path).listFiles((arg0, n) -> n.contains(name));
        int nbgabor = 0;
        for (i2 = 0; i2 < files.length; ++i2) {
            if (!files[i2].getName().contains("Orientation")) continue;
            ++nbgabor;
        }
        BufferedImage[] gabors = new BufferedImage[nbgabor];
        BufferedImage[] orientations = new BufferedImage[nbgabor];
        BufferedImage[] convgabors = new BufferedImage[nbgabor];
        for (p = 2; p < nbgabor + 2; ++p) {
            gabors[p - 2] = ImageIO.Read(path + "/" + name + " - Gabor " + (p < 10 ? "0" : "") + p + ".png");
            orientations[p - 2] = ImageIO.Read(path + "/" + name + " - Gabor " + (p < 10 ? "0" : "") + p + " Orientation.png");
        }
        BufferedImage medmean = ImageIO.Read(path + "/" + name + " - MedianMean.png");
        BufferedImage convmedmean = ImageNew.Same((BufferedImage)medmean);
        BufferedImage truth = ImageIO.Read(groundtruth + "/" + name.substring(0, 2) + "_manual1.gif");
        int wid = medmean.getWidth();
        int hei = medmean.getHeight();
        BufferedImage workingmask = new BufferedImage(wid, hei, 12);
        for (y = 0; y < hei; ++y) {
            for (x = 0; x < wid; ++x) {
                if (medmean.getRaster().getSample(x, y, 0) > 0 || truth.getRaster().getSample(x, y, 0) > 0) {
                    workingmask.getRaster().setSample(x, y, 0, 1);
                    continue;
                }
                workingmask.getRaster().setSample(x, y, 0, 0);
            }
        }
        int order = 3;
        double[][] convolutionmask = new double[2 * order + 1][2 * order + 1];
        Arrays.fill((Object[])convolutionmask, (Object)(1.0 / Math.pow(2 * order + 1, 2.0)));
        this.convolution.Parameters(new Object[]{convolutionmask, this.jt});
        convmedmean = this.convolution.Filter(medmean, nbCPU);
        for (p = 0; p < nbgabor; ++p) {
            convgabors[p] = this.convolution.Filter(gabors[p], nbCPU);
        }
        double[] buffer = new double[(2 * order + 1) * (2 * order + 1)];
        int[] types = new int[3 * nbgabor + 4];
        Arrays.fill(types, 1);
        types[types.length - 3] = 0;
        types[types.length - 2] = 0;
        types[types.length - 1] = 2;
        FichierTabule ft = new FichierTabule((int)this.IF.Counter(workingmask, 0, 0), types, "");
        int nb = 0;
        for (y = 0; y < hei; ++y) {
            for (x = 0; x < wid; ++x) {
                if (workingmask.getRaster().getSample(x, y, 0) != 1) continue;
                for (p = 0; p < nbgabor; ++p) {
                    ft.setValue(nb, p, gabors[p].getRaster().getSampleDouble(x, y, 0) - convgabors[p].getRaster().getSampleDouble(x, y, 0));
                }
                ft.setValue(nb, nbgabor, medmean.getRaster().getSampleDouble(x, y, 0) - convmedmean.getRaster().getSampleDouble(x, y, 0));
                for (p = 0; p < nbgabor; ++p) {
                    try {
                        int n2 = 0;
                        for (i2 = -order; i2 <= order; ++i2) {
                            for (int j = -order; j <= order; ++j) {
                                buffer[n2++] = orientations[p].getRaster().getSample(x + j, y + i2, 0);
                            }
                        }
                        this.circstats.ComputeDegres(buffer);
                        ft.setValue(nb, nbgabor + 1 + p, this.circstats.getStandardDeviation());
                        ft.setValue(nb, 2 * nbgabor + 1 + p, this.circstats.getDispersion());
                        if (!Double.isNaN(this.circstats.getStandardDeviation())) continue;
                        System.err.println("Souci NaN");
                        continue;
                    }
                    catch (Exception E) {
                        E.printStackTrace();
                        System.err.println(nb + " " + (nbgabor + 1 + p) + " " + this.circstats.getStandardDeviation());
                        System.exit(0);
                    }
                }
                ft.setValue(nb, ft.Width() - 3, x);
                ft.setValue(nb, ft.Width() - 2, y);
                ft.setValue(nb, ft.Width() - 1, truth.getRaster().getSample(x, y, 0) == 0 ? "Background" : "Vessel");
                ++nb;
            }
        }
        ft.Write(path + "/" + name + " - Characteristics.txt", false);
    }

    public void Evaluations(String detectionpath, String groundtruthpath, int start, int end, int step) throws Exception {
        for (int percentage = start; percentage <= end; percentage += step) {
            this.Evaluation(detectionpath, this.NameResult + percentage, groundtruthpath);
        }
    }

    public void Evaluation(String detectionpath, String Extension2, String groundtruthpath) throws Exception {
        EvaluateVesselDetection evd = new EvaluateVesselDetection();
        if (detectionpath.contains("Drive")) {
            evd.EvaluateOnDrive(detectionpath, Extension2, groundtruthpath);
        }
    }

    private void Parameters(BufferedImage image, File file, String name) throws IOException {
        this.height = image.getHeight();
        this.width = image.getWidth();
        switch (this.height) {
            case 584: {
                this.scale = 1.0;
                this.nbGabor = 5;
                this.sizese = 2;
                this.mode = 1;
                try {
                    BufferedImage mask = ImageIO.Read(file.getParentFile().getParent() + "/mask/" + name + "_mask.gif");
                    for (int y = 0; y < image.getHeight(); ++y) {
                        for (int x = 0; x < image.getWidth(); ++x) {
                            if (mask.getRaster().getSample(x, y, 0) != 0) continue;
                            image.getRaster().setSample(x, y, 0, 0);
                        }
                    }
                }
                catch (Exception E) {
                    E.printStackTrace();
                    System.exit(0);
                }
                catch (Error E) {
                    E.printStackTrace();
                    System.exit(0);
                }
                return;
            }
            case 960: {
                this.scale = 1.0;
                break;
            }
            case 1000: {
                this.scale = 1.06;
                break;
            }
            case 1288: {
                this.scale = 1.67;
                break;
            }
            case 1360: {
                this.scale = 1.724;
                break;
            }
            case 1696: {
                this.scale = 2.17;
                break;
            }
            case 1880: {
                this.scale = 2.5;
                break;
            }
            default: {
                throw new IllegalArgumentException("Dimensions not supported: w=" + this.width + ", h=" + this.height);
            }
        }
        this.nbGabor = 11;
        this.sizese = (int)(3.0 * this.scale + 0.5);
        this.mode = 0;
    }

    public String WhatHappened() {
        return "Program finished with " + this.nbErrors + " error(s).";
    }
}

