/*
 * Decompiled with CFR 0.152.
 */
package softwares.cmm.teleOphta;

import arrayTiTi.ArrayComparator;
import arrayTiTi.ArrayConverter;
import arrayTiTi.ArrayFeatures;
import displays.Display;
import imageTiTi.ImageArithmetic;
import imageTiTi.ImageComparator;
import imageTiTi.ImageConverter;
import imageTiTi.ImageDrawer;
import imageTiTi.ImageFeatures;
import imageTiTi.ImageNew;
import imageTiTi.ImageOperations;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.io.IOException;
import java.util.List;
import mathematics.primitives.pointsTiTi.CoordinatesWeighted;
import measures.cclh.UnionFindCcl;
import morphee.StructuringElement;
import morphee.geodesic.UnderBuild;
import morphee.segmentation.minmax.Minima;
import morphee.segmentation.watershed.Watershed;
import processing.filters.Invert;

public class VesselDetectionFM {
    int coucou;
    public Display display;
    public UnderBuild ub = new UnderBuild();
    public UnionFindCcl ccl = new UnionFindCcl();
    public Watershed zpe = new Watershed();
    public Watershed lpe = new Watershed();
    private final ImageDrawer drawer = new ImageDrawer();
    public Minima minima1 = new Minima();
    public Minima minima2 = new Minima();
    public BufferedImage im1;
    public BufferedImage im11;
    public BufferedImage im6;
    public BufferedImage im7;
    public BufferedImage imminima1;
    public BufferedImage imminima2;
    public BufferedImage imbasins;
    public BufferedImage imlines;
    public int[] nplex;
    private final ArrayFeatures AF = new ArrayFeatures();
    private final ImageFeatures IF = new ImageFeatures();
    Invert invert = new Invert();

    public VesselDetectionFM(Display display) {
        this.display = display;
    }

    public void Process() throws IOException {
    }

    public void Compute(BufferedImage imin, int addValue, BufferedImage imout, int nbCPU) {
        int MaxGrayLevel = -1;
        int width = imin.getWidth();
        int height = imin.getHeight();
        int size = width * height;
        switch (imin.getType()) {
            case 10: {
                MaxGrayLevel = 255;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
        this.im1 = ImageNew.Same((BufferedImage)imin);
        this.im11 = ImageNew.Same((BufferedImage)imin);
        this.nplex = new int[size];
        this.im6 = ImageNew.Same((BufferedImage)imin);
        this.im7 = ImageNew.Same((BufferedImage)imin);
        ImageArithmetic.Add(imin, addValue, this.im1, MaxGrayLevel, MaxGrayLevel);
        this.ub.Filter(this.im1, imin, this.im11, nbCPU);
        ImageNew.Copy((BufferedImage)this.im11, (BufferedImage)this.im1);
        this.display.Image(this.im1, "im1, reconstruction", 1.0);
        this.minima1.Filter(this.im1, 0, true);
        this.imminima1 = ImageNew.Integer((int)width, (int)height, (int)1, (int[])this.minima1.Labels());
        this.display.Image(this.imminima1, "im minima1", 1.0);
        this.zpe.watershed(imin, this.imminima1, new StructuringElement(new Object[]{1, -2}));
        this.display.Image(this.zpe.Edges(), "ZPE lines", 1.0);
        this.display.Image(this.zpe.Basins(), "ZPE basins", 1.0);
        this.AF.NplexStrict(((DataBufferInt)this.zpe.Basins().getRaster().getDataBuffer()).getData(), width, height, this.nplex, 3);
        this.display.ArrayImage(this.nplex, width, height, "Nplex", 1.0);
        ArrayComparator.Compare((int[])this.nplex, (String)"==", (int)0, (int)1, (int)0, (int[])this.nplex);
        ImageConverter.ArrayToImage((int[])this.nplex, (BufferedImage)this.im6);
        this.display.Image(this.im6, "im6 Nplex", 1.0);
        this.minima2.Filter(this.im6, -1, true);
        ImageOperations.Fill((BufferedImage)this.im7, (int)((int)this.IF.Maximum(this.im1)));
        ImageArithmetic.Subtract(this.im7, this.im1, this.im7);
        this.imminima2 = ImageNew.Integer((int)width, (int)height, (int)1, (int[])this.minima2.Labels());
        ImageComparator.Compare((BufferedImage)this.imminima2, (String)"!=", (int)1, (BufferedImage)this.imminima2, (int)0, (BufferedImage)this.imminima2);
        this.display.Image(this.imminima2, "im minima2", 1.0);
        this.lpe.watershed(this.im7, this.imminima2, new StructuringElement(new Object[]{1, -2}));
        this.display.Image(this.lpe.Basins(), "basins", 1.0);
        this.display.Image(this.lpe.Edges(), "Result", 1.0);
    }

    public void ComputeNew(BufferedImage imin, int addValue, BufferedImage imout, int nbCPU) {
        int width = imin.getWidth();
        int height = imin.getHeight();
        switch (imin.getType()) {
            case 10: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
        int nbmarkers = 100;
        BufferedImage markers = ImageNew.Integer((int)width, (int)height, (int)1);
        int[] imarkers = ((DataBufferInt)markers.getRaster().getDataBuffer()).getData();
        BufferedImage iminv = this.invert.Filter(imin, nbCPU);
        ImageComparator.Compare((BufferedImage)imin, (String)"!=", (int)0, (BufferedImage)iminv, (int)0, (BufferedImage)iminv);
        this.minima1.Filter(iminv, 0, true);
        int[] imini = this.minima1.Labels();
        List list = ArrayConverter.ArrayToList((int[])imini, (int)width, (int)height);
        if (list.size() < nbmarkers) {
            throw new IllegalArgumentException("Less minima than markers.");
        }
        StructuringElement se = new StructuringElement(new Object[]{1, -2});
        ImageOperations.Fill((BufferedImage)imout, (int)0);
        int[] buffer = ((DataBufferInt)imout.getRaster().getDataBuffer()).getData();
        for (int i2 = 0; i2 < 500; ++i2) {
            ImageOperations.Fill((BufferedImage)markers, (int)0);
            int nb = 0;
            while (nb < nbmarkers) {
                int p = ((CoordinatesWeighted)list.get((int)((int)(Math.random() * (double)list.size())))).Pos;
                if (imarkers[p] != 0) continue;
                imarkers[p] = ++nb;
            }
            this.lpe.watershed(iminv, markers, se);
            byte[] bedges = ((DataBufferByte)this.lpe.Edges().getRaster().getDataBuffer()).getData();
            for (int x = 0; x < bedges.length; ++x) {
                if (bedges[x] == 0) continue;
                int n = x;
                buffer[n] = buffer[n] + 1;
            }
        }
    }
}

