/*
 * Decompiled with CFR 0.152.
 */
package softwares.cmm.teleOphta;

import arrayTiTi.ArrayConverter;
import arrayTiTi.ArrayFeatures;
import characterization.shapes.shapeIndexes.Circularity;
import characterization.shapes.skeletons.Skeleton;
import characterization.shapes.skeletons.SkeletonGray;
import characterization.shapes.skeletons.SkeletonTools;
import characterization.shapes.skeletons.ThinningCM;
import characterization.shapes.skeletons.VincentSkel;
import dataMining.classifiers.Classification;
import displays.Display;
import filesAndFolders.FilesFolders;
import filesAndFolders.fichiersTabules.FichierTabule;
import imageTiTi.ImageArithmetic;
import imageTiTi.ImageComparator;
import imageTiTi.ImageConverter;
import imageTiTi.ImageDrawer;
import imageTiTi.ImageFeatures;
import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import imageTiTi.ImageOperations;
import java.awt.image.BufferedImage;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mathematics.fourier.JTransformsComplex;
import mathematics.metrics.Euclidian;
import mathematics.metrics.Metric;
import mathematics.primitives.pointsTiTi.Coordinates;
import measures.Measures2D;
import measures.cclh.ConnectedComponentLabeling;
import measures.cclh.UnionFindCcl;
import measures.hedgehop.Distance;
import measures.hedgehop.DistanceMapComputer;
import measures.hedgehop.DistanceTools;
import measures.histogram.Histogram;
import morphee.Dilate;
import morphee.Erode;
import morphee.StructuringElement;
import morphee.filters.ASFilterOpenClose;
import morphee.other.Paths;
import morphee.segmentation.Skiz;
import processing.filters.Average;
import processing.filters.DynamicExpansion;
import processing.filters.Gabor;
import processing.filters.GaborCircular;
import processing.filters.gradients.Sobel;
import processing.thresholding.Binary;
import softwares.cmm.teleOphta.AdaptativeLocalMeanVesselDetection;
import softwares.cmm.teleOphta.EvaluateVesselDetection;
import weka.classifiers.Classifier;
import weka.classifiers.functions.MultilayerPerceptron;
import weka.core.Instance;
import weka.core.Instances;

public class VesselDetection {
    private final int TeleOphta = 0;
    private final int Drive = 1;
    private final int Stare = 2;
    public int nbErrors = 0;
    private int mode = -1;
    public boolean usedecreasingfunction = false;
    public boolean displayoriginal = false;
    public boolean displayasf = false;
    public boolean displaygabors = false;
    public boolean displaygabormedmean = false;
    public boolean displayconnect = false;
    public boolean displayresult00 = false;
    public boolean computepreprocessing = true;
    public boolean computegabors = true;
    public boolean computegabormedmean = true;
    public boolean computeresult00 = true;
    public boolean computeshapecleaner = false;
    public boolean computeclassified = false;
    public boolean computeconnect = false;
    public boolean computefinalresult = false;
    public boolean writeoriginal = false;
    public boolean writepreprocessing = false;
    public boolean writegabors = false;
    public boolean writegabormedmean = false;
    public boolean writeresult00 = true;
    public boolean writeshapecleaner = false;
    public boolean writeclassified = false;
    public boolean writeconnect = false;
    public boolean writefinalresult = false;
    public boolean readpreprocessing = false;
    public boolean readgabors = false;
    public boolean readgabormedmean = false;
    public boolean readresult00 = false;
    public boolean readshapecleaner = false;
    public boolean readclassified = false;
    public boolean readconnect = false;
    public boolean readfinalresult = false;
    public int ForbidenValue = 0;
    private final Distance montanary_2_3 = DistanceTools.CreateMontanariDistance(2, 3);
    private final StructuringElement semont3 = new StructuringElement(new Object[]{3, -15});
    private final ConnectedComponentLabeling ccl = new UnionFindCcl();
    private final DynamicExpansion dynexp = new DynamicExpansion();
    private final Gabor gabor = new Gabor();
    private final GaborCircular circgab = new GaborCircular();
    private final JTransformsComplex jt = new JTransformsComplex();
    private final Erode erode = new Erode();
    private final Dilate dilate = new Dilate();
    private int height;
    private int width;
    private double scale = 1.0;
    private int nbGabor = 0;
    private int sizese = 0;
    private Display display = null;
    private final ArrayFeatures AF = new ArrayFeatures();
    private final ImageFeatures IF = new ImageFeatures();
    DataOutputStream output;
    FichierTabule learningfile = null;
    FichierTabule learningroughfile = null;
    Instances learninginstances = null;
    Instance instance = null;
    Classification classification = null;
    Classifier classifier = new MultilayerPerceptron();
    BufferedImage groundthruth;
    private BufferedImage imdilated = null;
    private BufferedImage imcont = null;
    private ASFilterOpenClose asoc = new ASFilterOpenClose();
    private Skiz skiz = new Skiz();
    private StructuringElement seasf = null;
    BufferedImage[] gabs = null;
    BufferedImage[] gabscirc = null;
    double[][][] stochastic = null;
    private final double coefmax = 2.0;
    public String NameResult = " - Result ";
    private final SkeletonGray skeleton = new SkeletonGray(new VincentSkel());
    private final Skeleton skel = new Skeleton(new ThinningCM(0, false));
    private final Binary binary = new Binary(1);
    private final DistanceMapComputer dmc = new DistanceMapComputer();
    private final AdaptativeLocalMeanVesselDetection almnew = new AdaptativeLocalMeanVesselDetection();
    private final double addvalue = 0.5;
    Measures2D measures = null;
    Circularity circ = new Circularity();
    Average average = new Average();
    Sobel sobel = new Sobel();
    Paths paths = new Paths();
    ImageDrawer drawer = new ImageDrawer();
    Metric metric = new Euclidian();
    BufferedImage connections = null;
    BufferedImage reconnected = null;
    int[][] labels;
    int[][] labelswithout;
    int[][] labelswith;
    int[][] labelcc;
    int[][] candpoint;
    boolean[][] boolarray;
    int[] sizes;
    List<Coordinates> candidates = new ArrayList<Coordinates>(13);
    List<Coordinates> trace = new ArrayList<Coordinates>(113);
    private final Histogram histogram = new Histogram();
    private final int nbpathiter = 5;

    public VesselDetection(Display display) {
        this.display = display;
    }

    public void ExtractVesselsOphDiat(File src, boolean wait, String start, String end, String folderout, boolean delete, int nbCPU) {
        Object[] patients = src.listFiles();
        Arrays.sort(patients);
        this.nbErrors = 0;
        for (int p = 0; p < patients.length; ++p) {
            if (!((File)patients[p]).isDirectory() || !((File)patients[p]).getAbsoluteFile().getName().contains("P0")) continue;
            if (wait && ((File)patients[p]).getName().contains(start)) {
                wait = false;
            }
            if (!wait) {
                this.ExtractVesselsForOnePatient((File)patients[p], false, "", "", folderout + "/" + ((File)patients[p]).getName() + "/", delete, nbCPU);
            }
            if (wait || !((File)patients[p]).getName().contains(end)) continue;
            wait = true;
        }
    }

    public void ExtractVesselsForOnePatient(File src, boolean wait, String start, String end, String folderout, boolean delete, int nbCPU) {
        Object[] visits = src.listFiles();
        Arrays.sort(visits);
        for (int v = 0; v < visits.length; ++v) {
            if (!((File)visits[v]).isDirectory()) continue;
            if (wait && ((File)visits[v]).getName().contains(start)) {
                wait = false;
            }
            if (!wait) {
                this.ExtractVesselsForOneFolder(((File)visits[v]).getAbsoluteFile(), false, "", "", folderout + "/" + ((File)visits[v]).getName() + "/", delete, nbCPU);
            }
            if (wait || !((File)visits[v]).getName().contains(end)) continue;
            wait = true;
        }
    }

    public void ExtractVesselsForOneFolder(File src, boolean wait, String start, String end, String folderout, boolean delete, int nbCPU) {
        Object[] images = src.listFiles();
        BufferedImage result = null;
        Arrays.sort(images);
        delete = false;
        File dest = new File(folderout);
        if (!dest.exists()) {
            dest.mkdirs();
        }
        for (int i2 = 0; i2 < images.length; ++i2) {
            if (!((File)images[i2]).isFile() || !((File)images[i2]).getName().toLowerCase().contains(".jpg") && !((File)images[i2]).getName().toLowerCase().contains(".png") && !((File)images[i2]).getName().toLowerCase().contains(".ppm") && !((File)images[i2]).getName().toLowerCase().contains(".tif")) continue;
            if (wait && ((File)images[i2]).getName().contains(start)) {
                wait = false;
            }
            if (!wait) {
                try {
                    BufferedImage image = ImageConverter.Channel((BufferedImage)ImageIO.Read(((File)images[i2]).getAbsolutePath()), (int)1);
                    result = new BufferedImage(image.getWidth(), image.getHeight(), 12);
                    String name = ((File)images[i2]).getName().substring(0, ((File)images[i2]).getName().length() - 4);
                    this.height = image.getHeight();
                    this.width = image.getWidth();
                    this.ExtractVessels(((File)images[i2]).getAbsolutePath(), image, name, result, dest.getAbsolutePath(), nbCPU);
                    if (delete) {
                        FilesFolders.Delete((File)images[i2]);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ++this.nbErrors;
                }
                catch (Error e) {
                    e.printStackTrace();
                    ++this.nbErrors;
                }
            }
            if (wait || !((File)images[i2]).getName().contains(end)) continue;
            wait = true;
        }
    }

    public void ExtractVessels(String path, BufferedImage image, String name, BufferedImage result, String dest, int nbCPU) {
        try {
            if (this.displayoriginal) {
                this.display.Image(image, name + " - Original", 1.0);
            }
            BufferedImage imeroded = ImageNew.Same((BufferedImage)image);
            this.Parameters(image, new File(path), name);
            if (this.writeoriginal) {
                ImageIO.Write(image, dest + "/" + name + " - Original.png", 6);
            }
            BufferedImage asf = this.Preprocessing(image, path, name, dest, imeroded, nbCPU);
            BufferedImage gab = this.Gabors(image, asf, imeroded, path, name, dest, nbCPU);
            BufferedImage res0 = this.Result00(gab, path, name, dest, nbCPU);
            BufferedImage shapecleaned = this.ShapeCleaner(res0, path, name, dest, nbCPU);
            BufferedImage recon = this.Reconnections(image, res0, path, name, dest, nbCPU);
            BufferedImage classified = this.ClassifyPixels(image, asf, gab, shapecleaned, res0, path, name, dest, nbCPU);
            this.FinalResult(path, name, dest, nbCPU);
            classified = null;
            recon = null;
            shapecleaned = null;
            res0 = null;
            gab = null;
            imeroded = null;
            asf = null;
        }
        catch (Exception e) {
            ++this.nbErrors;
            e.printStackTrace();
        }
        catch (Error e) {
            ++this.nbErrors;
            e.printStackTrace();
        }
    }

    private BufferedImage Preprocessing(BufferedImage image, String path, String name, String dest, BufferedImage imeroded, int nbCPU) throws IOException {
        BufferedImage asf = null;
        int typese = -2;
        if (this.seasf == null || this.seasf.getOrder() != this.sizese || this.seasf.getType() != typese) {
            this.seasf = new StructuringElement(new Object[]{this.sizese, typese});
        }
        this.erode.setStructuringElement(this.seasf);
        this.erode.Filter(image, imeroded, nbCPU);
        if (this.computepreprocessing) {
            int x;
            int y;
            this.imdilated = this.dilate.Filter(image, new StructuringElement(new Object[]{5, -2}), nbCPU);
            BufferedImage border = ImageNew.Clone((BufferedImage)image);
            this.imcont = ImageNew.Clone((BufferedImage)image);
            for (int y2 = 1; y2 < image.getHeight() - 1; ++y2) {
                for (int x2 = 1; x2 < image.getWidth() - 1; ++x2) {
                    if (imeroded.getRaster().getSample(x2, y2, 0) != 0 && SkeletonTools.CountNeighbor(imeroded, x2, y2, false) != 4) continue;
                    border.getRaster().setSample(x2, y2, 0, 0);
                }
            }
            BufferedImage reskiz = this.skiz.Filter(border, null, 0, nbCPU);
            reskiz = null;
            int[][] labe = null;
            int nbcc = this.AF.Maximum(labe) + 1;
            int[] lut = new int[nbcc];
            for (y = 1; y < image.getHeight() - 1; ++y) {
                for (x = 1; x < image.getWidth() - 1; ++x) {
                    if (border.getRaster().getSample(x, y, 0) == 0) continue;
                    lut[labe[y][x]] = border.getRaster().getSample(x, y, 0);
                }
            }
            for (y = 0; y < image.getHeight(); ++y) {
                for (x = 0; x < image.getWidth(); ++x) {
                    if (imeroded.getRaster().getSample(x, y, 0) != 0) continue;
                    this.imcont.getRaster().setSample(x, y, 0, lut[labe[y][x]]);
                }
            }
            ImageComparator.Compare((BufferedImage)this.imdilated, (String)"!=", (int)0, (BufferedImage)this.imcont, (int)0, (BufferedImage)this.imcont);
            BufferedImage resasoc = this.asoc.Filter(this.imcont, new StructuringElement(new Object[]{(int)(this.scale * 7.0 + 0.5), typese}), nbCPU);
            asf = ImageArithmetic.Subtract(resasoc, this.imcont, 0, 0);
        } else if (this.readpreprocessing) {
            asf = ImageIO.Read(dest + "/" + name + " - PreProcessing.png");
        }
        if (this.computepreprocessing) {
            ImageComparator.Compare((BufferedImage)image, (String)"==", (int)0, (BufferedImage)imeroded, (BufferedImage)asf, (BufferedImage)asf);
        }
        if (this.writepreprocessing) {
            ImageIO.Write(this.imcont, dest + "/" + name + " - OriginalCont.png", 6);
            ImageIO.Write(asf, dest + "/" + name + " - PreProcessing.png", 6);
        }
        if (this.displayasf) {
            this.display.Image(asf, name + " - PreProcessing", 1.0);
        }
        this.display.Image(ImageNew.Clone((BufferedImage)asf), "asf2", 1.0);
        return asf;
    }

    private BufferedImage Gabors(BufferedImage image, BufferedImage asf, BufferedImage imeroded, String path, String name, String dest, int nbCPU) throws IOException {
        int x;
        int y;
        int start = 2;
        double lambda = 0.0;
        double phase = 0.0;
        double sigmax = 0.0;
        double sigmay = 0.0;
        double ave = 0.0;
        double coefmin = 1.0;
        BufferedImage resgabor = new BufferedImage(this.width, this.height, 11);
        BufferedImage imspreaded = ImageNew.Same((BufferedImage)resgabor);
        BufferedImage resgaborcirc = ImageNew.Same((BufferedImage)resgabor);
        BufferedImage imcircspreaded = ImageNew.Same((BufferedImage)resgabor);
        BufferedImage minim = ImageNew.Same((BufferedImage)resgabor);
        if ((this.computegabors || this.readgabors) && (this.stochastic == null || this.stochastic.length != image.getHeight() || this.stochastic[0].length != image.getWidth())) {
            this.stochastic = new double[image.getHeight()][image.getWidth()][this.nbGabor - start + 1];
        }
        if (this.stochastic != null) {
            Arrays.fill((Object[])this.stochastic, (Object)0.0);
        }
        if (this.gabs == null) {
            this.gabs = new BufferedImage[this.nbGabor + 1];
            this.gabscirc = new BufferedImage[this.nbGabor + 1];
        }
        for (int p = start; p <= this.nbGabor; ++p) {
            if (this.computegabors) {
                sigmax = this.scale * (double)p;
                double a = (coefmin - 2.0) / (double)(this.nbGabor - start);
                double b = 2.0 - a * (double)start;
                switch (this.mode) {
                    case 1: {
                        sigmay = this.usedecreasingfunction ? a * sigmax + b + 1.0 : 1.5 * sigmax + 1.0;
                        lambda = 3.0 * sigmax;
                        break;
                    }
                    case 2: {
                        sigmay = 1.5 * sigmax + 1.0;
                        lambda = 3.0 * sigmax;
                        break;
                    }
                    case 0: {
                        sigmay = this.usedecreasingfunction ? a * sigmax + b + 1.0 : 2.0 * sigmax + 1.0;
                        lambda = 2.0 * sigmax;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown database (mode): " + this.mode);
                    }
                }
                this.gabor.Parameters(0, 165, 15, sigmax, sigmay, lambda, phase, this.jt, 0, 1, true, false);
                this.gabor.Filter(asf, resgabor, nbCPU);
                ImageComparator.Compare((BufferedImage)image, (String)"!=", (int)0, (BufferedImage)resgabor, (int)0, (BufferedImage)resgabor);
                ave = this.IF.Average(resgabor, 0);
                ImageArithmetic.Subtract(resgabor, (int)ave, resgabor, 0, 0);
                this.dynexp.Filter(resgabor, 0, 65535, imspreaded, nbCPU);
                ImageOperations.MoveForward((BufferedImage)imspreaded, (BufferedImage)imspreaded, (int)1, (int)1, (int)0);
                this.circgab.Parameters(sigmax, lambda, phase, this.jt, 0, true);
                this.circgab.Filter(asf, resgaborcirc, nbCPU);
                ImageComparator.Compare((BufferedImage)image, (String)"!=", (int)0, (BufferedImage)resgaborcirc, (int)0, (BufferedImage)resgaborcirc);
                ave = this.IF.Average(resgaborcirc, 0);
                ImageArithmetic.Subtract(resgaborcirc, (int)ave, resgaborcirc, 0, 0);
                this.dynexp.Filter(resgaborcirc, 0, 65535, imcircspreaded, nbCPU);
                ImageOperations.MoveForward((BufferedImage)imcircspreaded, (BufferedImage)imcircspreaded, (int)1, (int)1, (int)0);
                ImageOperations.Minimum((BufferedImage)imspreaded, (BufferedImage)imcircspreaded, (BufferedImage)minim);
                if (this.gabs[p] == null) {
                    this.gabs[p] = ImageNew.Clone((BufferedImage)imspreaded);
                    this.gabscirc[p] = ImageNew.Clone((BufferedImage)imcircspreaded);
                } else {
                    ImageNew.Copy((BufferedImage)imspreaded, (BufferedImage)this.gabs[p]);
                    ImageNew.Copy((BufferedImage)imcircspreaded, (BufferedImage)this.gabscirc[p]);
                }
                for (y = 0; y < image.getHeight(); ++y) {
                    for (x = 0; x < image.getWidth(); ++x) {
                        this.stochastic[y][x][p - start] = minim.getRaster().getSampleDouble(x, y, 0);
                    }
                }
                if (this.writegabors) {
                    ImageIO.Write(imspreaded, dest + "/" + name + " - Gabor " + (p < 10 ? "0" : "") + p + ".png", 6);
                    ImageIO.Write(ImageConverter.ArrayToImage((int[][])this.gabor.Orientations()), dest + "/" + name + " - Gabor Orientations " + (p < 10 ? "0" : "") + p + ".png", 6);
                    ImageIO.Write(imcircspreaded, dest + "/" + name + " - GaborCirc " + (p < 10 ? "0" : "") + p + ".png", 6);
                    ImageIO.Write(minim, dest + "/" + name + " - GaborMin " + (p < 10 ? "0" : "") + p + ".png", 6);
                }
                if (!this.displaygabors) continue;
                this.display.Image(imspreaded, name + " - Gabor " + (p < 10 ? "0" : "") + p, 1.0);
                this.display.Image(imcircspreaded, name + " - GaborCirc " + (p < 10 ? "0" : "") + p, 1.0);
                this.display.Image(minim, name + " - GaborMin " + (p < 10 ? "0" : "") + p, 1.0);
                continue;
            }
            if (!this.readgabors) continue;
            this.gabs[p] = ImageIO.Read(dest + "/" + name + " - Gabor " + (p < 10 ? "0" : "") + p + ".png");
            this.gabscirc[p] = ImageIO.Read(dest + "/" + name + " - GaborCirc " + (p < 10 ? "0" : "") + p + ".png");
            minim = ImageOperations.Minimum((BufferedImage)this.gabs[p], (BufferedImage)this.gabscirc[p]);
            for (y = 0; y < image.getHeight(); ++y) {
                for (x = 0; x < image.getWidth(); ++x) {
                    this.stochastic[y][x][p - start] = minim.getRaster().getSampleDouble(x, y, 0);
                }
            }
        }
        if (this.computegabormedmean) {
            BufferedImage restochmedinf = ImageNew.Same((BufferedImage)resgabor);
            BufferedImage restochmedmid = ImageNew.Same((BufferedImage)resgabor);
            BufferedImage restochmedsup = ImageNew.Same((BufferedImage)resgabor);
            int step = (this.nbGabor - start + 1) / 2;
            double[] buffer = new double[step];
            for (y = 0; y < this.height; ++y) {
                for (x = 0; x < this.width; ++x) {
                    int p;
                    System.arraycopy(this.stochastic[y][x], 0, buffer, 0, step);
                    Arrays.sort(buffer);
                    restochmedinf.getRaster().setSample(x, y, 0, buffer[step / 2]);
                    for (p = 0; p < step; ++p) {
                        buffer[p] = this.stochastic[y][x][step / 2 + 1 + p];
                    }
                    Arrays.sort(buffer);
                    restochmedmid.getRaster().setSample(x, y, 0, buffer[step / 2]);
                    for (p = 0; p < step; ++p) {
                        buffer[p] = this.stochastic[y][x][this.nbGabor - start - p];
                    }
                    Arrays.sort(buffer);
                    restochmedsup.getRaster().setSample(x, y, 0, buffer[step / 2]);
                    resgabor.getRaster().setSample(x, y, 0, (double)(restochmedinf.getRaster().getSample(x, y, 0) + restochmedmid.getRaster().getSample(x, y, 0) + restochmedsup.getRaster().getSample(x, y, 0)) / 3.0);
                }
            }
        }
        if (this.readgabormedmean) {
            resgabor = ImageIO.Read(dest + "/" + name + " - MedianMean.png");
        }
        if (this.writegabormedmean) {
            ImageIO.Write(resgabor, dest + "/" + name + " - MedianMean.png", 6);
        }
        if (this.displaygabormedmean) {
            this.display.Image(resgabor, name + " - Gabor Median Mean", 1.0);
        }
        return resgabor;
    }

    private BufferedImage Result00(BufferedImage gabormedmean, String path, String name, String dest, int nbCPU) throws Exception {
        throw new UnsupportedOperationException("Method to upgrade.");
    }

    private List<Integer> FindBiggestCCs(int[] sizes, double percentage) {
        int max;
        int[] size = Arrays.copyOf(sizes, sizes.length);
        ArrayList<Integer> list = new ArrayList<Integer>(13);
        int sum = (int)this.AF.Integral(size, 1, sizes.length);
        int count = 0;
        do {
            max = this.AF.MaximumIndex(size, 1, sizes.length);
            size[max] = 0;
            list.add(max);
        } while ((double)(count += sizes[max]) / (double)sum < percentage);
        size = null;
        return list;
    }

    private boolean isInList(List<Integer> values, int value) {
        for (int i2 = 0; i2 < values.size(); ++i2) {
            if (values.get(i2) != value) continue;
            return true;
        }
        return false;
    }

    private BufferedImage ShapeCleaner(BufferedImage res00, String path, String name, String dest, int nbCPU) throws Exception {
        if (!this.computeshapecleaner) {
            if (this.readshapecleaner) {
                return ImageIO.Read(dest + "/" + name + " - ShapeCleaner.png");
            }
            return null;
        }
        int wid = res00.getWidth();
        int hei = res00.getHeight();
        this.ccl.Label(res00, 0, true);
        int[] size = this.ccl.Sizes();
        int[][] lab = ArrayConverter.to2D((int[])this.ccl.Labels1D(), (int)wid, (int)hei);
        BufferedImage imcc = ImageNew.Clone((BufferedImage)res00);
        BufferedImage shapecleaned = ImageNew.Clone((BufferedImage)res00);
        List<Integer> biggestccs = this.FindBiggestCCs(size, 0.75);
        for (int cc = 1; cc < size.length; ++cc) {
            if (5 >= size[cc] || this.isInList(biggestccs, cc)) continue;
            for (int y = 0; y < hei; ++y) {
                for (int x = 0; x < wid; ++x) {
                    if (lab[y][x] == cc) {
                        imcc.getRaster().setSample(x, y, 0, 1);
                        continue;
                    }
                    imcc.getRaster().setSample(x, y, 0, 0);
                }
            }
            this.measures = new Measures2D(imcc);
            this.measures.Basics(true, false);
            this.measures.EuclidianRadii();
            this.circ.Compute(this.measures);
            int v = (int)(this.circ.LastValue() * 254.0) + 1;
            if (75 < v) {
                this.ccl.DeleteCC(shapecleaned, cc);
            }
            this.measures = null;
        }
        if (this.writeshapecleaner) {
            ImageIO.Write(shapecleaned, dest + "/" + name + " - ShapeCleaner.png", 6);
        }
        return shapecleaned;
    }

    private BufferedImage ClassifyPixels(BufferedImage image, BufferedImage asf, BufferedImage gabmedmean, BufferedImage shapecleaned, BufferedImage reconnected, String path, String name, String dest, int nbCPU) throws Exception {
        int x;
        int y;
        if (!this.computeclassified) {
            if (this.readclassified) {
                return ImageIO.Read(dest + "/" + name + " - Classified.png");
            }
            if (shapecleaned != null) {
                return ImageNew.Clone((BufferedImage)shapecleaned);
            }
            return null;
        }
        BufferedImage radius = ImageIO.Read(dest + "/" + name + " - Radius.png");
        int wid = image.getWidth();
        int hei = image.getHeight();
        this.sobel.Parameters(2);
        this.average.Parameters(7, false, null, 0);
        BufferedImage imsobel = this.sobel.Filter(image, nbCPU);
        BufferedImage imsobelave = this.average.Filter(imsobel, nbCPU);
        BufferedImage asfsobel = this.sobel.Filter(image, nbCPU);
        BufferedImage asfsobelave = this.average.Filter(asfsobel, nbCPU);
        BufferedImage skelet = this.skel.Filter(reconnected, nbCPU);
        this.ccl.Label(skelet, 0, true);
        this.ccl.DeleteSmallerThan(skelet, 5);
        BufferedImage branches = ImageNew.Clone((BufferedImage)skelet);
        for (y = 0; y < hei; ++y) {
            for (x = 0; x < wid; ++x) {
                if (skelet.getRaster().getSample(x, y, 0) == 0 || 3 > SkeletonTools.CountNeighbor(skelet, x, y, true)) continue;
                branches.getRaster().setSample(x, y, 0, 0);
            }
        }
        this.ccl.Label(branches, 0, true);
        int[][] labe = ArrayConverter.to2D((int[])this.ccl.Labels1D(), (int)wid, (int)hei);
        int[] size = this.ccl.Sizes();
        double[] imaverages = new double[this.ccl.Sizes().length];
        double[] asfaverages = new double[this.ccl.Sizes().length];
        for (y = 0; y < hei; ++y) {
            for (x = 0; x < wid; ++x) {
                if (branches.getRaster().getSample(x, y, 0) == 0) continue;
                int n = labe[y][x];
                imaverages[n] = imaverages[n] + (double)imsobelave.getRaster().getSample(x, y, 0);
                int n2 = labe[y][x];
                asfaverages[n2] = asfaverages[n2] + (double)asfsobelave.getRaster().getSample(x, y, 0);
            }
        }
        double imave = 0.0;
        double asfave = 0.0;
        for (x = 1; x < imaverages.length; ++x) {
            int n = x;
            imaverages[n] = imaverages[n] / (double)size[x];
            imave += imaverages[x];
            int n3 = x;
            asfaverages[n3] = asfaverages[n3] / (double)size[x];
            asfave += asfaverages[x];
        }
        imave /= (double)(imaverages.length - 1);
        asfave /= (double)(asfaverages.length - 1);
        BufferedImage imaverage = new BufferedImage(wid, hei, 10);
        BufferedImage asfaverage = new BufferedImage(wid, hei, 10);
        for (y = 0; y < hei; ++y) {
            for (x = 0; x < wid; ++x) {
                if (labe[y][x] == 0) continue;
                imaverage.getRaster().setSample(x, y, 0, (int)(imaverages[labe[y][x]] + 0.5));
                asfaverage.getRaster().setSample(x, y, 0, (int)(asfaverages[labe[y][x]] + 0.5));
            }
        }
        double[] gabave = new double[6];
        double[] gabcircave = new double[6];
        for (int p = 2; p <= 5; ++p) {
            this.histogram.Fill(this.gabs[p]);
            int count = (int)this.IF.Counter(this.gabs[p], 0, 0);
            x = 1;
            int nb = 0;
            while ((double)(nb += this.histogram.getValues(0)[x++]) / (double)count < 0.5) {
            }
            gabave[p] = x - 1;
            this.histogram.Fill(this.gabscirc[p]);
            count = (int)this.IF.Counter(this.gabscirc[p], 0, 0);
            x = 1;
            nb = 0;
            while ((double)(nb += this.histogram.getValues(0)[x++]) / (double)count < 0.5) {
            }
            gabcircave[p] = x - 1;
        }
        this.histogram.Fill(gabmedmean);
        int count = (int)this.IF.Counter(gabmedmean, 0, 0);
        x = 1;
        int nb = 0;
        while ((double)(nb += this.histogram.getValues(0)[x++]) / (double)count < 0.5) {
        }
        double avemedmean = x - 1;
        for (y = 0; y < hei; ++y) {
            for (x = 0; x < wid; ++x) {
                int p;
                int p2;
                if (gabmedmean.getRaster().getSample(x, y, 0) == 0) continue;
                for (p2 = 2; p2 <= 5; ++p2) {
                    this.output.write((this.gabs[p2].getRaster().getSampleDouble(x, y, 0) / gabave[p2] + " ").getBytes("ASCII"));
                }
                for (p2 = 2; p2 <= 5; ++p2) {
                    this.output.write((this.gabscirc[p2].getRaster().getSampleDouble(x, y, 0) / gabcircave[p2] + " ").getBytes("ASCII"));
                }
                double ave = 0.0;
                double var = 0.0;
                for (p = 2; p <= 5; ++p) {
                    ave += this.gabs[p].getRaster().getSampleDouble(x, y, 0);
                }
                ave /= 4.0;
                for (p = 2; p <= 5; ++p) {
                    var += Math.pow(this.gabs[p].getRaster().getSampleDouble(x, y, 0) - ave, 2.0);
                }
                var = Math.sqrt(var / 4.0);
                this.output.write((ave + " " + var + " ").getBytes("ASCII"));
                var = 0.0;
                ave = 0.0;
                for (p = 2; p <= 5; ++p) {
                    ave += this.gabscirc[p].getRaster().getSampleDouble(x, y, 0);
                }
                ave /= 4.0;
                for (p = 2; p <= 5; ++p) {
                    var += Math.pow(this.gabscirc[p].getRaster().getSampleDouble(x, y, 0) - ave, 2.0);
                }
                var = Math.sqrt(var / 4.0);
                this.output.write((ave + " " + var + " ").getBytes("ASCII"));
                this.output.write((gabmedmean.getRaster().getSampleDouble(x, y, 0) / avemedmean + " ").getBytes("ASCII"));
                this.output.write((imaverage.getRaster().getSampleDouble(x, y, 0) + " ").getBytes("ASCII"));
                this.output.write((imaverage.getRaster().getSampleDouble(x, y, 0) / imave + " ").getBytes("ASCII"));
                this.output.write((asfaverage.getRaster().getSampleDouble(x, y, 0) + " ").getBytes("ASCII"));
                this.output.write((asfaverage.getRaster().getSampleDouble(x, y, 0) / asfave + " ").getBytes("ASCII"));
                this.output.write((radius.getRaster().getSampleDouble(x, y, 0) + " ").getBytes("ASCII"));
                if (this.groundthruth.getRaster().getSample(x, y, 0) != 0) {
                    this.output.write("Vessel\n".getBytes("ASCII"));
                    continue;
                }
                this.output.write("Background\n".getBytes("ASCII"));
            }
        }
        return null;
    }

    private BufferedImage Reconnections(BufferedImage source, BufferedImage res00, String path, String name, String dest, int nbCPU) throws IOException {
        throw new Error("To upgrade");
    }

    public void FinalResult(String path, String name, String dest, int nbCPU) throws Exception {
    }

    public void Evaluations(String detectionpath, String groundtruthpath, int start, int end, int step) throws Exception {
        for (int percentage = start; percentage <= end; percentage += step) {
            this.Evaluation(detectionpath, this.NameResult + percentage, groundtruthpath);
        }
    }

    public void Evaluation(String detectionpath, String Extension2, String groundtruthpath) throws Exception {
        EvaluateVesselDetection evd = new EvaluateVesselDetection();
        if (detectionpath.contains("Drive")) {
            evd.EvaluateOnDrive(detectionpath, Extension2, groundtruthpath);
        } else if (detectionpath.contains("Stare")) {
            evd.EvaluateOnStare(detectionpath, Extension2, groundtruthpath);
        }
    }

    private void Parameters(BufferedImage image, File file, String name) throws IOException {
        this.height = image.getHeight();
        this.width = image.getWidth();
        switch (this.height) {
            case 584: {
                this.scale = 1.0;
                this.nbGabor = 5;
                this.sizese = 2;
                this.mode = 1;
                try {
                    BufferedImage mask = ImageIO.Read(file.getParentFile().getParent() + "/mask/" + name + "_mask.gif");
                    for (int y = 0; y < image.getHeight(); ++y) {
                        for (int x = 0; x < image.getWidth(); ++x) {
                            if (mask.getRaster().getSample(x, y, 0) != 0) continue;
                            image.getRaster().setSample(x, y, 0, 0);
                        }
                    }
                }
                catch (Exception E) {
                    E.printStackTrace();
                    System.exit(0);
                }
                catch (Error E) {
                    E.printStackTrace();
                    System.exit(0);
                }
                return;
            }
            case 605: {
                this.scale = 1.0;
                this.nbGabor = 5;
                this.sizese = 2;
                this.mode = 2;
                try {
                    BufferedImage mask = ImageIO.Read(file.getParentFile().getParent() + "/Background/" + name + ".png");
                    for (int y = 0; y < image.getHeight(); ++y) {
                        for (int x = 0; x < image.getWidth(); ++x) {
                            if (mask.getRaster().getSample(x, y, 0) != 0 || mask.getRaster().getSample(x, y, 2) != 0 || mask.getRaster().getSample(x, y, 2) != 0) continue;
                            image.getRaster().setSample(x, y, 0, 0);
                        }
                    }
                }
                catch (Exception E) {
                    E.printStackTrace();
                    System.exit(0);
                }
                catch (Error E) {
                    E.printStackTrace();
                    System.exit(0);
                }
                return;
            }
            case 960: {
                this.scale = 1.0;
                break;
            }
            case 1000: {
                this.scale = 1.06;
                break;
            }
            case 1288: {
                this.scale = 1.67;
                break;
            }
            case 1360: {
                this.scale = 1.724;
                break;
            }
            case 1696: {
                this.scale = 2.17;
                break;
            }
            case 1880: {
                this.scale = 2.5;
                break;
            }
            default: {
                throw new IllegalArgumentException("Dimensions not supported: w=" + this.width + ", h=" + this.height);
            }
        }
        this.nbGabor = 11;
        this.sizese = (int)(3.0 * this.scale + 0.5);
        this.mode = 0;
    }

    public String WhatHappened() {
        return "Program finished with " + this.nbErrors + " error(s).";
    }
}

