/*
 * Decompiled with CFR 0.152.
 */
package softwares.cmm.teleOphta;

import arrayTiTi.ArrayConverter;
import dataMining.classifiers.Classification;
import dataMining.variables.selections.SystematicResearch;
import filesAndFolders.fichiersTabules.FichierTabule;
import filesAndFolders.fichiersTabules.FichierTabuleTools;
import imageTiTi.ImageIO;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.List;
import weka.classifiers.Classifier;

public class SRtoImage {
    int coucou;
    private String currentimage;
    private String currentvisit;
    private int currentposition = 0;

    public void Process(FichierTabule workingfile, List<String> deletecolumns, FichierTabule sysres, Classifier classifier, String originalimages, String outfolder) throws Exception {
        int x;
        if (workingfile.Width() - deletecolumns.size() != sysres.Width()) {
            throw new IllegalArgumentException("workingfile.Width() != sysres.Width().");
        }
        File output = new File(outfolder + "/SRtoImage/");
        if (!output.exists()) {
            output.mkdirs();
        }
        String oldimagename = "";
        String oldvisit = "";
        BufferedImage image = null;
        workingfile.ClearSelection();
        workingfile.ClearExclusion();
        for (x = 0; x < deletecolumns.size(); ++x) {
            workingfile.setExcludedColumn(deletecolumns.get(x), true);
        }
        SystematicResearch sr = new SystematicResearch();
        FichierTabule best = sr.BestResults(sysres, 100);
        best.Write(output.getAbsolutePath() + "/Best.txt", false);
        for (x = 0; x < best.Width() - 1; ++x) {
            workingfile.setExcludedColumn(x, best.getValueInt(0, x) == 0);
        }
        FichierTabule modelfile = FichierTabuleTools.DeleteExcludedColumns(workingfile);
        modelfile.Write(output.getAbsolutePath() + "/ModelFile.txt", false);
        modelfile.setNominal(modelfile.Width() - 1, true);
        modelfile.Target(modelfile.Width() - 1);
        Classification classification = new Classification();
        classification.LearnAndPredict(modelfile, modelfile, classifier, null);
        double[][] probabilities = classification.Probabilities();
        String[] predictions = classification.Predictions();
        FichierTabule result = FichierTabuleTools.AddColumns(workingfile, new int[]{1, 1, 2});
        double[][] probas = ArrayConverter.Transpose((double[][])probabilities);
        result.setColumn(result.Width() - 3, probas[0]);
        result.setColumn(result.Width() - 2, probas[1]);
        result.setColumn(result.Width() - 1, predictions);
        result.Write(output.getAbsolutePath() + "/Result.txt", false);
        int colx = workingfile.ColumnNumber("coordX");
        int coly = workingfile.ColumnNumber("coordY");
        int colvisit = workingfile.ColumnNumber("Visit");
        int colimname = workingfile.ColumnNumber("Image");
        for (int y = 0; y < modelfile.Height(); ++y) {
            String imagename = workingfile.getValueString(y, colimname);
            String visit = workingfile.getValueString(y, colvisit);
            int coordx = workingfile.getValueInt(y, colx);
            int coordy = workingfile.getValueInt(y, coly);
            if (!oldimagename.equalsIgnoreCase(imagename) || !oldvisit.equalsIgnoreCase(visit)) {
                if (image != null) {
                    File out = new File(output.getAbsolutePath() + "/" + oldvisit + "/");
                    if (!out.exists()) {
                        out.mkdirs();
                    }
                    ImageIO.Write(image, output.getAbsolutePath() + "/" + oldvisit + "/" + oldimagename.substring(0, oldimagename.length() - 4) + ".png", 6);
                }
                BufferedImage imsrc = ImageIO.Read(originalimages + "/" + visit + "/" + imagename);
                image = new BufferedImage(imsrc.getWidth(), imsrc.getHeight(), 10);
            }
            image.getRaster().setSample(coordx, coordy, 0, (int)(probabilities[y][0] * 255.0 + 0.5));
            oldvisit = visit;
            oldimagename = imagename;
        }
    }

    public void ProcessWithValidation(FichierTabule workingfile, List<String> deletecolumns, FichierTabule sysres, Classifier classifier, String originalimages, String outfolder) throws Exception {
        boolean found;
        int x;
        if (workingfile.Width() - deletecolumns.size() != sysres.Width()) {
            throw new IllegalArgumentException("workingfile.Width() != sysres.Width().");
        }
        File output = new File(outfolder + "/SRtoImage/");
        if (!output.exists()) {
            output.mkdirs();
        }
        Classification classification = new Classification();
        SystematicResearch sr = new SystematicResearch();
        BufferedImage image = null;
        int colx = workingfile.ColumnNumber("coordX");
        int coly = workingfile.ColumnNumber("coordY");
        int colvisit = workingfile.ColumnNumber("Visit");
        int colimname = workingfile.ColumnNumber("Image");
        workingfile.ClearSelection();
        workingfile.ClearExclusion();
        for (x = 0; x < deletecolumns.size(); ++x) {
            workingfile.setExcludedColumn(deletecolumns.get(x), true);
        }
        FichierTabule best = sr.BestResults(sysres, 100);
        best.Write(output.getAbsolutePath() + "/Best.txt", false);
        for (x = 0; x < best.Width() - 1; ++x) {
            workingfile.setExcludedColumn(x, best.getValueInt(0, x) == 0);
        }
        FichierTabule modelfile = FichierTabuleTools.DeleteExcludedColumns(workingfile);
        modelfile.Write(output.getAbsolutePath() + "/ModelFile.txt", false);
        modelfile.setNominal(modelfile.Width() - 1, true);
        FichierTabule result = FichierTabuleTools.AddColumns(workingfile, new int[]{1, 1, 2});
        while (found = this.FindNextImage(workingfile, colvisit, colimname)) {
            String visit = this.currentvisit;
            String imagename = this.currentimage;
            workingfile.ClearSelection();
            workingfile.ClearExclusion();
            workingfile.SelectWhere(colvisit, 0, visit);
            workingfile.SelectFromSelectionWhere(colimname, 0, imagename);
            modelfile.setSelected(workingfile.getSelected());
            modelfile.InverseSelection();
            FichierTabule trainingset = FichierTabuleTools.SaveSelectedRows(modelfile);
            trainingset.setNominal(trainingset.Width() - 1, true);
            modelfile.InverseSelection();
            classification.LearnAndPredict(trainingset, modelfile, classifier, null);
            double[][] probabilities = classification.Probabilities();
            String[] predictions = classification.Predictions();
            int startpos = 0;
            while (!modelfile.isSelected(startpos)) {
                ++startpos;
            }
            File out = new File(output.getAbsolutePath() + "/" + visit + "/");
            if (!out.exists()) {
                out.mkdirs();
            }
            BufferedImage imsrc = ImageIO.Read(originalimages + "/" + visit + "/" + imagename);
            image = new BufferedImage(imsrc.getWidth(), imsrc.getHeight(), 10);
            for (int y = startpos; y < modelfile.Height() && modelfile.isSelected(y); ++y) {
                result.setValue(y, result.Width() - 3, probabilities[y][0]);
                result.setValue(y, result.Width() - 2, probabilities[y][1]);
                result.setValue(y, result.Width() - 1, predictions[y]);
                int coordx = workingfile.getValueInt(y, colx);
                int coordy = workingfile.getValueInt(y, coly);
                image.getRaster().setSample(coordx, coordy, 0, (int)(probabilities[y][1] * 255.0 + 0.5));
            }
            ImageIO.Write(image, output.getAbsolutePath() + "/" + visit + "/" + imagename.substring(0, imagename.length() - 4) + ".png", 6);
        }
        result.Write(output.getAbsolutePath() + "/Result.txt", false);
    }

    private boolean FindNextImage(FichierTabule file, int colvisit, int colimage) {
        while (0 < this.currentposition && this.currentposition < file.Height()) {
            String image = file.getValueString(this.currentposition, colimage);
            String visit = file.getValueString(this.currentposition, colvisit);
            if (!image.equalsIgnoreCase(this.currentimage) || !visit.equalsIgnoreCase(visit)) break;
            ++this.currentposition;
        }
        if (this.currentposition >= file.Height()) {
            return false;
        }
        this.currentimage = file.getValueString(this.currentposition, colimage);
        this.currentvisit = file.getValueString(this.currentposition, colvisit);
        ++this.currentposition;
        return true;
    }
}

