/*
 * Decompiled with CFR 0.152.
 */
package softwares.cmm.teleOphta;

import displays.Colors;
import imageTiTi.ImageDrawer;
import imageTiTi.ImageFeatures;
import imageTiTi.ImageIO;
import imageTiTi.ImageOperations;
import java.awt.image.BufferedImage;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import measures.histogram.Histogram;

public class ROCcurveLesionDetection {
    private final int Border = 10;
    private final Histogram histogram = new Histogram();
    private final ImageFeatures IF = new ImageFeatures();

    public void Compute(String detectionsfolder, String groundtruthfolder) throws Exception {
        File[] visits = new File(groundtruthfolder).listFiles();
        DataOutputStream outcm = new DataOutputStream(new FileOutputStream("Confusion_Matrix.txt"));
        DataOutputStream outacc = new DataOutputStream(new FileOutputStream("Curve_Accurracy.txt"));
        DataOutputStream outtp = new DataOutputStream(new FileOutputStream("CurveROC_Lesions.txt"));
        DataOutputStream outtn = new DataOutputStream(new FileOutputStream("CurveROC_NoLesion.txt"));
        int nbimages = 0;
        int nbErrors = 0;
        int[] hist = null;
        int[] fn = null;
        int[] fp = null;
        int[] tn = null;
        int[] tp = null;
        for (int v = 0; v < visits.length; ++v) {
            if (!visits[v].isDirectory()) continue;
            File[] images = visits[v].listFiles();
            for (int i2 = 0; i2 < images.length; ++i2) {
                if (!images[i2].isFile() || !images[i2].getName().toLowerCase().contains(".png")) continue;
                try {
                    BufferedImage groundtruth = ImageIO.Read(images[i2].getAbsolutePath());
                    BufferedImage detections = ImageIO.Read(detectionsfolder + "/" + visits[v].getName() + "/" + images[i2].getName());
                    this.IF.Integral(groundtruth);
                    long integral = this.IF.Integral();
                    boolean lesion = integral > 0L;
                    this.histogram.Fill(detections);
                    hist = this.histogram.getValues(0);
                    if (tp == null) {
                        tp = new int[hist.length];
                        tn = new int[hist.length];
                        fp = new int[hist.length];
                        fn = new int[hist.length];
                    }
                    if (tp.length != hist.length) {
                        throw new IllegalArgumentException("Images from result of detection not have identic type.");
                    }
                    boolean found = false;
                    for (int t = hist.length - 1; t >= 0; --t) {
                        if (hist[t] > 0) {
                            found = true;
                        }
                        if (lesion) {
                            if (found) {
                                int n = t;
                                tp[n] = tp[n] + 1;
                                continue;
                            }
                            int n = t;
                            fn[n] = fn[n] + 1;
                            continue;
                        }
                        if (found) {
                            int n = t;
                            fp[n] = fp[n] + 1;
                            continue;
                        }
                        int n = t;
                        tn[n] = tn[n] + 1;
                    }
                    ++nbimages;
                    continue;
                }
                catch (Exception e) {
                    System.out.flush();
                    System.out.println("fn " + fn.length);
                    e.printStackTrace();
                    System.err.flush();
                    ++nbErrors;
                    continue;
                }
                catch (Error e) {
                    System.out.flush();
                    e.printStackTrace();
                    System.err.flush();
                    ++nbErrors;
                }
            }
        }
        int marge = 20;
        BufferedImage cacc = new BufferedImage(20 + hist.length, 120, 10);
        ImageOperations.Fill((BufferedImage)cacc, (int)255);
        ImageDrawer.Line(cacc, 10, 10, cacc.getWidth() - 10, 10, 0, Colors.GRAY5);
        ImageDrawer.Line(cacc, 10, 10, 10, cacc.getHeight() - 10, 0, Colors.GRAY5);
        BufferedImage roctp = new BufferedImage(120, 120, 10);
        ImageOperations.Fill((BufferedImage)roctp, (int)255);
        ImageDrawer.Line(roctp, 10, 10, roctp.getWidth() - 10, 10, 0, Colors.GRAY5);
        ImageDrawer.Line(roctp, 10, 10, 10, roctp.getHeight() - 10, 0, Colors.GRAY5);
        BufferedImage roctn = new BufferedImage(120, 120, 10);
        ImageOperations.Fill((BufferedImage)roctn, (int)255);
        ImageDrawer.Line(roctn, 10, 10, roctn.getWidth() - 10, 10, 0, Colors.GRAY5);
        ImageDrawer.Line(roctn, 10, 10, 10, roctn.getHeight() - 10, 0, Colors.GRAY5);
        outcm.write("Threshold TP TN FP FN\n".getBytes("ISO-8859-1"));
        for (int t = 0; t < tp.length; ++t) {
            if (tp[t] + tn[t] + fp[t] + fn[t] != nbimages) {
                throw new Error("tp[t]+tn[t]+fp[t]+fn[t] != nbimages.");
            }
            outcm.write((t + " " + tp[t] + " " + tn[t] + " " + fp[t] + " " + fn[t] + "\n").getBytes("ISO-8859-1"));
            double accurracy = (double)(tp[t] + tn[t]) / (double)nbimages;
            outacc.write((t + " " + accurracy + "\n").getBytes("ISO-8859-1"));
            cacc.getRaster().setSample(10 + t, 10 + (int)(accurracy * 100.0 + 0.5), 0, 0);
            double specificity = 1.0 - (double)tn[t] / (double)(tn[t] + fp[t]);
            double sensitivity = (double)tp[t] / (double)(tp[t] + fn[t]);
            outtp.write((specificity + " " + sensitivity + "\n").getBytes("ISO-8859-1"));
            roctp.getRaster().setSample(10 + (int)(specificity * 100.0 + 0.5), 10 + (int)(sensitivity * 100.0 + 0.5), 0, 0);
            sensitivity = (double)tn[t] / (double)(tn[t] + fp[t]);
            specificity = 1.0 - (double)tp[t] / (double)(tp[t] + fn[t]);
            outtn.write((specificity + " " + sensitivity + "\n").getBytes("ISO-8859-1"));
            roctn.getRaster().setSample(10 + (int)(specificity * 100.0 + 0.5), 10 + (int)(sensitivity * 100.0 + 0.5), 0, 0);
        }
        outcm.close();
        outacc.close();
        outtp.close();
        outtn.close();
        ImageIO.Write(cacc, "Curve_Accurracy.png", 6);
        ImageIO.Write(roctp, "CurveROC_Lesions.png", 6);
        ImageIO.Write(roctn, "CurveROC_NoLesion.png", 6);
        System.err.println("Program finished with " + nbErrors + " error(s).");
    }
}

