/*
 * Decompiled with CFR 0.152.
 */
package softwares.cmm.teleOphta;

import imageTiTi.ImageIO;
import imageTiTi.colorSpace.HLS;
import imageTiTi.colorSpace.HSV;
import imageTiTi.colorSpace.Lab;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class PathologyColorAnalysis {
    private HLS hls = new HLS();
    private HSV hsv = new HSV();
    private Lab lab = new Lab();

    public void BuildFile(String originalpath, String groundtruthpath, String extension, String nameoutput) throws Exception {
        File[] visits = new File(groundtruthpath).listFiles();
        DataOutputStream output = new DataOutputStream(new FileOutputStream(nameoutput));
        this.WriteColums(output);
        for (int v = 0; v < visits.length; ++v) {
            if (!visits[v].isDirectory()) continue;
            File[] images = visits[v].listFiles();
            for (int i2 = 0; i2 < images.length; ++i2) {
                if (!images[i2].getName().contains(extension)) continue;
                String nameimage = images[i2].getName().substring(0, images[i2].getName().indexOf(extension));
                BufferedImage imgt = ImageIO.Read(images[i2].getAbsolutePath());
                WritableRaster wrgt = imgt.getRaster();
                BufferedImage imori = ImageIO.Read(originalpath + "/" + visits[v].getName() + "/" + nameimage + ".png");
                WritableRaster wrori = imori.getRaster();
                int width = imori.getWidth();
                int height = imori.getHeight();
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        if (wrgt.getSample(x, y, 0) <= 0) continue;
                        this.Write(wrori.getSampleFloat(x, y, 0) / 255.0f, wrori.getSampleFloat(x, y, 1) / 255.0f, wrori.getSampleFloat(x, y, 2) / 255.0f, output);
                        output.write((x + " " + y + " " + visits[v].getName() + " " + nameimage + "\n").getBytes("ASCII"));
                    }
                }
            }
        }
        visits = null;
    }

    private void WriteColums(DataOutputStream output) throws Exception {
        output.write("Red Green Blue NormRed NormGreen NormBlue HLS_H HLS_L HLS_S HSV_S HSV_V Lab_L Lab_A Lab_B ".getBytes("ASCII"));
        output.write("X Y Visit Image\n".getBytes("ASCII"));
    }

    private void Write(float r, float g, float b, DataOutputStream output) throws Exception {
        float[] rgb = new float[]{r, g, b};
        float sum = r + g + b;
        output.write((r + " " + g + " " + b + " ").getBytes("ASCII"));
        output.write((rgb[0] / sum + " " + rgb[1] / sum + " " + rgb[2] / sum + " ").getBytes("ASCII"));
        float[] reshls = this.hls.fromRGB(rgb);
        output.write((reshls[0] + " " + reshls[1] + " " + reshls[2] + " ").getBytes("ASCII"));
        float[] reshsv = this.hsv.fromRGB(rgb);
        output.write((reshsv[1] + " " + reshsv[2] + " ").getBytes("ASCII"));
        float[] reslab = this.lab.fromRGB(rgb);
        output.write((reslab[0] + " " + reslab[1] + " " + reslab[2] + " ").getBytes("ASCII"));
        reslab = null;
        reshsv = null;
        reshls = null;
        rgb = null;
    }

    public void Binariser(String path, String outpath) throws IOException {
        File[] visits = new File(path).listFiles();
        File outfile = null;
        for (int v = 0; v < visits.length; ++v) {
            if (!visits[v].isDirectory()) continue;
            File[] images = visits[v].listFiles();
            outfile = new File(outpath + "/" + visits[v].getName());
            if (!outfile.exists()) {
                outfile.mkdirs();
            }
            for (int i2 = 0; i2 < images.length; ++i2) {
                if (!images[i2].getName().contains(".png")) continue;
                BufferedImage im = ImageIO.Read(images[i2].getAbsolutePath());
                WritableRaster wr = im.getRaster();
                int width = im.getWidth();
                int height = im.getHeight();
                BufferedImage bin = new BufferedImage(width, height, 12);
                WritableRaster wrbin = bin.getRaster();
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        if (wr.getSample(x, y, 0) != 255 || wr.getSample(x, y, 1) != 255 || wr.getSample(x, y, 2) != 255) {
                            wrbin.setSample(x, y, 0, 0);
                            continue;
                        }
                        wrbin.setSample(x, y, 0, 1);
                    }
                }
                ImageIO.Write(bin, outfile.getAbsolutePath() + "/" + images[i2].getName(), 6);
            }
        }
        visits = null;
    }
}

