/*
 * Decompiled with CFR 0.152.
 */
package softwares.cmm.teleOphta;

import arrayTiTi.ArrayConverter;
import arrayTiTi.ArrayFeatures;
import dataMining.pca.PCA;
import imageTiTi.ImageArithmetic;
import imageTiTi.ImageFeatures;
import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import imageTiTi.ImageOperations;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import mathematics.Bresenham;
import mathematics.metrics.Euclidian;
import mathematics.metrics.Metric;
import mathematics.primitives.LineSegment;
import mathematics.primitives.pointsTiTi.Point3DI;
import mathematics.primitives.pointsTiTi.PointI;
import measures.cclh.UnionFindCcl;
import morphee.BlackTopHat;
import morphee.Close;
import morphee.StructuringElement;
import morphee.geodesic.CloseHoleRec;
import morphee.geodesic.Hminima;
import processing.filters.Gabor;
import processing.filters.Invert;

public class MicroAneurismProfiler {
    private final FilenameFilter fnf = (arg0, name) -> name.contains(".png") || name.contains(".jpg") || name.contains(".pgm");
    private final Gabor g = new Gabor();
    private final PCA pca = new PCA();
    private final Close close = new Close(new StructuringElement(new Object[]{1, -1}));
    private final BlackTopHat bth = new BlackTopHat(new StructuringElement(new Object[]{3, -2}));
    private final CloseHoleRec chrec = new CloseHoleRec();
    private final UnionFindCcl ccl = new UnionFindCcl();
    public Hminima hminima = new Hminima(2);
    private final Invert invert = new Invert();
    private final List<Integer> forbiden = new Vector<Integer>(13);
    private DataOutputStream out;
    private final Metric metric = new Euclidian();
    private final ArrayFeatures AF = new ArrayFeatures();
    private final ImageFeatures IF = new ImageFeatures();
    private final int Object = 0;
    private final int Background = 1;
    private final int[] sizes = new int[2];
    private final int[] min = new int[2];
    private final int[] max = new int[2];
    private final double[] averages = new double[2];
    private final double[] variances = new double[2];
    private final double[] Michelson = new double[2];
    private final double[] contrast = new double[2];
    private double average;
    private double bx;
    private double by;
    private double radius;
    private double radiusmin;
    private double radiusmax;
    private double variance;
    private double WeberFechner;
    private double skewness;
    private double kurtosis;
    private double skewnessma;
    private double kurtosisma;

    public MicroAneurismProfiler() {
        double lambda = 10.0;
        double psi = 1.5707963267948966;
        double sigmax = 2.0;
        double sigmay = 4.0;
        this.g.Parameters(0, 350, 10, sigmax, sigmay, lambda, psi, null, 0, true);
        this.ToExclude();
    }

    public void Compute(String path, int start, int end, String resultfile, int nbCPU) {
        File[] files = new File(path).listFiles(this.fnf);
        int threshold = 200;
        Vector<Point3DI> list = new Vector<Point3DI>(113);
        Vector<PointI> liste = new Vector<PointI>(113);
        boolean work = true;
        try {
            this.out = new DataOutputStream(new FileOutputStream(resultfile));
            this.WriteColumnNames();
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
            System.exit(0);
        }
        for (int i2 = start; i2 < end; ++i2) {
            if (!this.isAvailable(i2)) continue;
            try {
                int x;
                int y;
                BufferedImage image = ImageIO.Read(path + "/" + files[i2].getName());
                BufferedImage imclone = ImageNew.Clone((BufferedImage)image);
                BufferedImage bin = new BufferedImage(image.getWidth(), image.getHeight(), 12);
                BufferedImage bintmp = ImageNew.Same((BufferedImage)bin);
                BufferedImage whitesquare = new BufferedImage(image.getWidth(), image.getHeight(), 12);
                ImageOperations.Fill((BufferedImage)whitesquare, (int)1);
                BufferedImage result = ImageNew.Same((BufferedImage)image);
                this.g.Filter(image, result, nbCPU);
                double[][] res = this.g.Result();
                double maxi = this.AF.Maximum(res);
                if (maxi >= (double)threshold) {
                    for (y = 0; y < res.length; ++y) {
                        for (x = 0; x < res[0].length; ++x) {
                            if (!(res[y][x] >= (double)threshold)) continue;
                            bin.getRaster().setSample(x, y, 0, 1);
                        }
                    }
                    for (y = 0; y < res.length; ++y) {
                        for (x = 0; x < res[0].length; ++x) {
                            if (bin.getRaster().getSample(x, y, 0) != 1) continue;
                            for (int v = 0; v < res.length; ++v) {
                                for (int u = 0; u < res[0].length; ++u) {
                                    if (bin.getRaster().getSample(u, v, 0) != 1) continue;
                                    Bresenham.Draw((BufferedImage)bintmp, (int)x, (int)y, (int)u, (int)v, (int)1);
                                }
                            }
                        }
                    }
                    this.IF.Integral(bintmp);
                    if (this.IF.Integral() > 0L) {
                        bin = bintmp;
                        this.pca.Compute(bin, null);
                        LineSegment ads = new LineSegment(this.pca.getBarycenter(), this.pca.getEigenVectors()[0], 2);
                        LineSegment ext = ads.FindExtremities(whitesquare, false);
                        throw new Error("Method to upgrade.");
                    }
                }
                BufferedImage resclose = this.close.Filter(image, nbCPU);
                BufferedImage tophat = this.bth.Filter(resclose, nbCPU);
                BufferedImage tophatinv = this.invert.Filter(tophat, nbCPU);
                BufferedImage closehole = this.chrec.Filter(tophatinv, nbCPU);
                BufferedImage differences = ImageArithmetic.Subtract(closehole, tophatinv, 0, 0);
                this.ccl.Label(differences, 0, false);
                int[][] labels = ArrayConverter.to2D((int[])this.ccl.Labels1D(), (int)differences.getWidth(), (int)differences.getHeight());
                int[] sizess = this.ccl.Sizes();
                int mini = 255;
                list.clear();
                for (y = 0; y < differences.getHeight(); ++y) {
                    for (x = 0; x < differences.getWidth(); ++x) {
                        if (differences.getRaster().getSample(x, y, 0) <= 0 || image.getRaster().getSample(x, y, 0) > mini || sizess[labels[y][x]] <= 1) continue;
                        if (image.getRaster().getSample(x, y, 0) < mini) {
                            mini = image.getRaster().getSample(x, y, 0);
                            list.clear();
                        }
                        list.add(new Point3DI(x, y));
                    }
                }
                liste.clear();
                work = true;
                boolean[][] done = new boolean[image.getHeight()][image.getWidth()];
                int level = mini;
                result = ImageNew.Same((BufferedImage)image);
                BufferedImage copy = ImageNew.Clone((BufferedImage)image);
                int h = this.IF.Contrast(imclone) >= 0.5 && this.IF.Michelson(imclone) > 0.3 ? 2 : 1;
                this.hminima.Parameters(h);
                this.hminima.Filter(copy, image, nbCPU);
                while (work) {
                    int py;
                    int px;
                    PointI p;
                    Arrays.fill((Object[])done, (Object)false);
                    for (x = 0; x < list.size(); ++x) {
                        p = (PointI)list.get(x);
                        px = p.getX();
                        py = p.getY();
                        liste.add(p);
                        result.getRaster().setSample(px, py, 0, image.getRaster().getSample(px, py, 0));
                    }
                    while (work && liste.size() > 0) {
                        p = (PointI)liste.get(0);
                        px = p.getX();
                        py = p.getY();
                        done[py][px] = true;
                        if (px - 1 >= 0 && !done[py][px - 1]) {
                            if (image.getRaster().getSample(px - 1, py, 0) == level || result.getRaster().getSample(px - 1, py, 0) != 0) {
                                liste.add(new Point3DI(px - 1, py));
                                result.getRaster().setSample(px - 1, py, 0, image.getRaster().getSample(px - 1, py, 0));
                            } else if (image.getRaster().getSample(px - 1, py, 0) < level) {
                                this.EraseLevel(result, level);
                                work = false;
                            }
                        }
                        if (px + 1 < image.getWidth() && !done[py][px + 1]) {
                            if (image.getRaster().getSample(px + 1, py, 0) == level || result.getRaster().getSample(px + 1, py, 0) != 0) {
                                liste.add(new Point3DI(px + 1, py));
                                result.getRaster().setSample(px + 1, py, 0, image.getRaster().getSample(px + 1, py, 0));
                            } else if (image.getRaster().getSample(px + 1, py, 0) < level) {
                                this.EraseLevel(result, level);
                                work = false;
                            }
                        }
                        if (py - 1 >= 0 && !done[py - 1][px]) {
                            if (image.getRaster().getSample(px, py - 1, 0) == level || result.getRaster().getSample(px, py - 1, 0) != 0) {
                                liste.add(new Point3DI(px, py - 1));
                                result.getRaster().setSample(px, py - 1, 0, image.getRaster().getSample(px, py - 1, 0));
                            } else if (image.getRaster().getSample(px, py - 1, 0) < level) {
                                this.EraseLevel(result, level);
                                work = false;
                            }
                        }
                        if (py + 1 < image.getHeight() && !done[py + 1][px]) {
                            if (image.getRaster().getSample(px, py + 1, 0) == level || result.getRaster().getSample(px, py + 1, 0) != 0) {
                                liste.add(new Point3DI(px, py + 1));
                                result.getRaster().setSample(px, py + 1, 0, image.getRaster().getSample(px, py + 1, 0));
                            } else if (image.getRaster().getSample(px, py + 1, 0) < level) {
                                this.EraseLevel(result, level);
                                work = false;
                            }
                        }
                        liste.remove(0);
                    }
                    if (!work) continue;
                    ++level;
                }
                this.Characterize(image, result);
                this.WriteResults(files[i2].getName());
                continue;
            }
            catch (IOException e) {
                System.out.flush();
                e.printStackTrace();
                System.err.flush();
            }
        }
    }

    private void EraseLevel(BufferedImage image, int level) {
        WritableRaster wr = image.getRaster();
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                if (wr.getSample(x, y, 0) != level) continue;
                wr.setSample(x, y, 0, 0);
            }
        }
        wr = null;
    }

    private boolean isAvailable(int v) {
        for (int i2 = 0; i2 < this.forbiden.size(); ++i2) {
            if (this.forbiden.get(i2) != v) continue;
            return false;
        }
        return true;
    }

    private void Characterize(BufferedImage source, BufferedImage mask) {
        int x;
        int y;
        int border = 0;
        WritableRaster wrs = source.getRaster();
        WritableRaster wrm = mask.getRaster();
        this.radiusmax = 0.0;
        this.radius = 0.0;
        this.by = 0.0;
        this.bx = 0.0;
        this.variance = 0.0;
        this.average = 0.0;
        this.radiusmin = Double.MAX_VALUE;
        Arrays.fill(this.sizes, 0);
        Arrays.fill(this.min, 255);
        Arrays.fill(this.max, 0);
        Arrays.fill(this.averages, 0.0);
        Arrays.fill(this.variances, 0.0);
        for (y = 0; y < source.getHeight(); ++y) {
            for (x = 0; x < source.getWidth(); ++x) {
                if (wrm.getSample(x, y, 0) > 0) {
                    this.sizes[0] = this.sizes[0] + 1;
                    this.averages[0] = this.averages[0] + wrm.getSampleDouble(x, y, 0);
                    if (this.min[0] > wrm.getSample(x, y, 0)) {
                        this.min[0] = wrm.getSample(x, y, 0);
                    }
                    if (this.max[0] < wrm.getSample(x, y, 0)) {
                        this.max[0] = wrm.getSample(x, y, 0);
                    }
                    this.bx += (double)x;
                    this.by += (double)y;
                    continue;
                }
                if (wrs.getSample(x, y, 0) >= 255) continue;
                this.sizes[1] = this.sizes[1] + 1;
                this.averages[1] = this.averages[1] + wrs.getSampleDouble(x, y, 0);
                if (this.min[1] > wrs.getSample(x, y, 0)) {
                    this.min[1] = wrs.getSample(x, y, 0);
                }
                if (this.max[1] >= wrs.getSample(x, y, 0)) continue;
                this.max[1] = wrs.getSample(x, y, 0);
            }
        }
        this.average = (this.averages[0] + this.averages[1]) / (double)(this.sizes[0] + this.sizes[1]);
        this.averages[0] = this.averages[0] / (double)this.sizes[0];
        this.averages[1] = this.averages[1] / (double)this.sizes[1];
        this.bx /= (double)this.sizes[0];
        this.by /= (double)this.sizes[1];
        this.kurtosisma = 0.0;
        this.skewnessma = 0.0;
        for (y = 0; y < source.getHeight(); ++y) {
            for (x = 0; x < source.getWidth(); ++x) {
                if (wrm.getSample(x, y, 0) > 0) {
                    this.variances[0] = this.variances[0] + Math.pow(this.averages[0] - wrs.getSampleDouble(x, y, 0), 2.0);
                    this.variance += Math.pow(wrm.getSampleDouble(x, y, 0) - this.average, 2.0);
                    this.skewnessma += Math.pow(wrm.getSampleDouble(x, y, 0) - this.average, 3.0);
                    this.kurtosisma += Math.pow(wrm.getSampleDouble(x, y, 0) - this.average, 4.0);
                    if (!this.OnBorder(mask, x, y)) continue;
                    double d = this.metric.Distance(this.bx, this.by, 0.0, (double)x, (double)y, 0.0);
                    this.radius += d;
                    ++border;
                    if (d < this.radiusmin) {
                        this.radiusmin = d;
                    }
                    if (!(d > this.radiusmax)) continue;
                    this.radiusmax = d;
                    continue;
                }
                if (wrs.getSample(x, y, 0) >= 255) continue;
                this.variances[1] = this.variances[1] + Math.pow(this.averages[1] - wrs.getSampleDouble(x, y, 0), 2.0);
                this.variance += Math.pow(wrs.getSampleDouble(x, y, 0) - this.average, 2.0);
            }
        }
        this.radius /= (double)border;
        this.skewnessma = this.skewnessma / (double)this.sizes[0] / Math.pow(this.variances[0], 3.0);
        this.kurtosisma = this.kurtosisma / (double)this.sizes[0] / Math.pow(this.variances[0], 4.0);
        for (x = 0; x < 2; ++x) {
            this.variances[x] = Math.sqrt(this.variances[x] / (double)this.sizes[x]);
            this.Michelson[x] = (double)(this.max[x] - this.min[x]) / (double)(this.max[x] + this.min[x]);
            this.contrast[x] = (double)(this.max[x] - this.min[x]) / this.average;
        }
        this.variance = Math.sqrt(this.variance / (double)(this.sizes[0] + this.sizes[1]));
        this.IF.Moments(source);
        this.skewness = this.IF.Skewness();
        this.kurtosis = this.IF.Kurtosis();
        this.WeberFechner = Math.abs(this.averages[0] - this.averages[1]) / this.averages[1];
        wrm = null;
        wrs = null;
    }

    private void WriteResults(String name) {
        try {
            this.out.write(String.valueOf(this.sizes[0] + " ").getBytes("ASCII"));
            this.out.write(String.valueOf(this.average + " " + this.averages[0] + " " + this.averages[1] + " ").getBytes("ASCII"));
            this.out.write(String.valueOf(this.averages[0] - this.averages[1] + " ").getBytes("ASCII"));
            this.out.write(String.valueOf(this.variance + " " + this.variances[0] + " " + this.variances[1] + " ").getBytes("ASCII"));
            this.out.write(String.valueOf(this.variances[0] - this.variances[1] + " ").getBytes("ASCII"));
            this.out.write(String.valueOf(this.skewness + " " + this.kurtosis + " " + this.skewnessma + " " + this.kurtosisma + " ").getBytes("ASCII"));
            this.out.write(String.valueOf(this.Michelson[0] + " " + this.Michelson[1] + " ").getBytes("ASCII"));
            this.out.write(String.valueOf(this.contrast[0] + " " + this.contrast[1] + " ").getBytes("ASCII"));
            this.out.write(String.valueOf(this.WeberFechner + " " + (this.max[0] - this.min[0]) + " ").getBytes("ASCII"));
            this.out.write(String.valueOf(this.radius + " " + this.radiusmin + " " + this.radiusmax + " ").getBytes("ASCII"));
            this.out.write(String.valueOf(name + "\n").getBytes("ASCII"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void WriteColumnNames() {
        try {
            this.out.write(String.valueOf("SizeMA Average AverageMA AverageBack AverageGap ").getBytes("ASCII"));
            this.out.write(String.valueOf("Variance VarianceMA VarianceBack VarianceGap ").getBytes("ASCII"));
            this.out.write(String.valueOf("Skewness Kurtosis SkewnessMA KurtosisMA ").getBytes("ASCII"));
            this.out.write(String.valueOf("MichelsonMA MichelsonBack ContrastMA ContrastBack WeberFechner Depth ").getBytes("ASCII"));
            this.out.write(String.valueOf("RadiusMA RadiusMinMA RadiusMaxMA MicroAneurism\n").getBytes("ASCII"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean OnBorder(BufferedImage ma, int x, int y) {
        if (x == 0 || ma.getRaster().getSample(x - 1, y, 0) == 0) {
            return true;
        }
        if (x == ma.getWidth() - 1 || ma.getRaster().getSample(x + 1, y, 0) == 0) {
            return true;
        }
        if (y == 0 || ma.getRaster().getSample(x, y - 1, 0) == 0) {
            return true;
        }
        if (y == ma.getHeight() - 1 || ma.getRaster().getSample(x, y + 1, 0) == 0) {
            return true;
        }
        if (ma.getRaster().getSample(x - 1, y - 1, 0) == 0) {
            return true;
        }
        if (ma.getRaster().getSample(x - 1, y + 1, 0) == 0) {
            return true;
        }
        if (ma.getRaster().getSample(x + 1, y - 1, 0) == 0) {
            return true;
        }
        return ma.getRaster().getSample(x + 1, y + 1, 0) == 0;
    }

    private void ToExclude() {
        this.forbiden.add(8);
        this.forbiden.add(11);
        this.forbiden.add(19);
        this.forbiden.add(21);
        this.forbiden.add(23);
        this.forbiden.add(25);
        this.forbiden.add(28);
        this.forbiden.add(28);
        this.forbiden.add(37);
        this.forbiden.add(42);
        this.forbiden.add(43);
        this.forbiden.add(46);
        this.forbiden.add(61);
        this.forbiden.add(63);
        this.forbiden.add(66);
        this.forbiden.add(68);
        this.forbiden.add(71);
        this.forbiden.add(71);
        this.forbiden.add(74);
        this.forbiden.add(75);
        this.forbiden.add(91);
        this.forbiden.add(95);
        this.forbiden.add(96);
        this.forbiden.add(97);
        this.forbiden.add(100);
        this.forbiden.add(102);
        this.forbiden.add(111);
        this.forbiden.add(113);
        this.forbiden.add(116);
        this.forbiden.add(117);
        this.forbiden.add(122);
        this.forbiden.add(124);
        this.forbiden.add(125);
        this.forbiden.add(130);
        this.forbiden.add(142);
        this.forbiden.add(143);
        this.forbiden.add(152);
        this.forbiden.add(153);
        this.forbiden.add(164);
        this.forbiden.add(169);
        this.forbiden.add(176);
        this.forbiden.add(180);
        this.forbiden.add(181);
        this.forbiden.add(182);
        this.forbiden.add(193);
        this.forbiden.add(204);
        this.forbiden.add(206);
        this.forbiden.add(216);
        this.forbiden.add(217);
        this.forbiden.add(219);
        this.forbiden.add(225);
        this.forbiden.add(227);
        this.forbiden.add(228);
        this.forbiden.add(231);
        this.forbiden.add(232);
        this.forbiden.add(246);
        this.forbiden.add(248);
        this.forbiden.add(249);
        this.forbiden.add(252);
        this.forbiden.add(258);
        this.forbiden.add(261);
        this.forbiden.add(263);
        this.forbiden.add(266);
        this.forbiden.add(269);
        this.forbiden.add(271);
        this.forbiden.add(273);
        this.forbiden.add(275);
        this.forbiden.add(278);
        this.forbiden.add(279);
        this.forbiden.add(281);
        this.forbiden.add(286);
        this.forbiden.add(291);
        this.forbiden.add(295);
        this.forbiden.add(300);
        this.forbiden.add(302);
        this.forbiden.add(303);
        this.forbiden.add(307);
        this.forbiden.add(309);
        this.forbiden.add(310);
        this.forbiden.add(312);
        this.forbiden.add(313);
        this.forbiden.add(316);
        this.forbiden.add(317);
        this.forbiden.add(328);
        this.forbiden.add(329);
        this.forbiden.add(332);
        this.forbiden.add(335);
        this.forbiden.add(338);
        this.forbiden.add(340);
        this.forbiden.add(345);
        this.forbiden.add(347);
        this.forbiden.add(349);
        this.forbiden.add(351);
        this.forbiden.add(353);
        this.forbiden.add(355);
        this.forbiden.add(359);
        this.forbiden.add(361);
        this.forbiden.add(363);
        this.forbiden.add(364);
        this.forbiden.add(365);
        this.forbiden.add(366);
        this.forbiden.add(379);
        this.forbiden.add(382);
        this.forbiden.add(390);
        this.forbiden.add(393);
        this.forbiden.add(396);
        this.forbiden.add(398);
        this.forbiden.add(399);
        this.forbiden.add(401);
        this.forbiden.add(402);
        this.forbiden.add(403);
        this.forbiden.add(405);
        this.forbiden.add(407);
        this.forbiden.add(412);
        this.forbiden.add(415);
        this.forbiden.add(419);
        this.forbiden.add(420);
        this.forbiden.add(424);
        this.forbiden.add(427);
        this.forbiden.add(428);
        this.forbiden.add(429);
        this.forbiden.add(430);
        this.forbiden.add(432);
        this.forbiden.add(434);
        this.forbiden.add(435);
        this.forbiden.add(438);
        this.forbiden.add(441);
        this.forbiden.add(442);
        this.forbiden.add(445);
        this.forbiden.add(450);
        this.forbiden.add(453);
        this.forbiden.add(454);
        this.forbiden.add(455);
        this.forbiden.add(459);
        this.forbiden.add(462);
        this.forbiden.add(467);
        this.forbiden.add(468);
        this.forbiden.add(470);
        this.forbiden.add(471);
        this.forbiden.add(475);
        this.forbiden.add(478);
        this.forbiden.add(479);
        this.forbiden.add(485);
        this.forbiden.add(489);
        this.forbiden.add(500);
        this.forbiden.add(502);
        this.forbiden.add(505);
        this.forbiden.add(506);
        this.forbiden.add(508);
        this.forbiden.add(509);
        this.forbiden.add(510);
        this.forbiden.add(511);
        this.forbiden.add(515);
        this.forbiden.add(517);
        this.forbiden.add(519);
        this.forbiden.add(521);
        this.forbiden.add(523);
        this.forbiden.add(533);
        this.forbiden.add(535);
        this.forbiden.add(538);
        this.forbiden.add(539);
        this.forbiden.add(543);
        this.forbiden.add(547);
        this.forbiden.add(551);
        this.forbiden.add(552);
        this.forbiden.add(555);
        this.forbiden.add(556);
        this.forbiden.add(559);
        this.forbiden.add(562);
        this.forbiden.add(563);
        this.forbiden.add(566);
        this.forbiden.add(569);
        this.forbiden.add(573);
        this.forbiden.add(574);
        this.forbiden.add(575);
        this.forbiden.add(576);
    }
}

