/*
 * Decompiled with CFR 0.152.
 */
package softwares.cmm.teleOphta;

import arrayTiTi.ArrayConverter;
import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import java.awt.image.BufferedImage;
import java.io.File;
import mathematics.metrics.Euclidian;
import mathematics.metrics.Metric;
import measures.cclh.ConnectedComponentLabeling;
import measures.cclh.UnionFindCcl;
import measures.hedgehop.Distance;
import measures.hedgehop.DistanceTools;
import morphee.segmentation.Skiz;

public class IsolateLesions {
    private ConnectedComponentLabeling ccl = new UnionFindCcl();
    private int[] minx;
    private int[] maxx;
    private int[] miny;
    private int[] maxy;
    private int[] sizes;
    private double[][] distances;
    private Metric metric = new Euclidian();
    private Skiz skiz = new Skiz();
    private Distance dist = DistanceTools.CreateMontanariDistance(2, 7);
    private int nbErrors;

    public void Isolate(File annotationspath, String sourcepath, String dest, int size, int security, int nbCPU) {
        File[] visits = annotationspath.listFiles();
        this.nbErrors = 0;
        for (int v = 0; v < visits.length; ++v) {
            if (!visits[v].isDirectory()) continue;
            File[] images = visits[v].listFiles();
            for (int i2 = 0; i2 < images.length; ++i2) {
                if (!images[i2].isFile() || !images[i2].getName().toLowerCase().contains(".png")) continue;
                try {
                    String name = images[i2].getName().substring(0, images[i2].getName().indexOf(95));
                    BufferedImage annotation = ImageIO.Read(images[i2].getAbsolutePath());
                    BufferedImage source = ImageIO.Read(sourcepath + "/" + visits[v].getName() + "/" + name + ".png");
                    this.ccl.Label(annotation, 0, true);
                    this.BoudingBoxesAndDistances(annotation, size, security, nbCPU);
                    for (int cc = 1; cc <= this.ccl.ConnectedComponentsNumber(); ++cc) {
                        BufferedImage result = ImageNew.SubImageWH((BufferedImage)source, (int)(this.minx[cc] - this.sizes[cc]), (int)(this.miny[cc] - this.sizes[cc]), (int)(this.maxx[cc] - this.minx[cc] + 2 * this.sizes[cc]), (int)(this.maxy[cc] - this.miny[cc] + 2 * this.sizes[cc]));
                        ImageIO.Write(result, dest + "/" + visits[v].getName() + "_" + images[i2].getName().substring(0, images[i2].getName().length() - 4) + "_" + (cc < 10 ? "0" : "") + cc + "_BB" + (this.minx[cc] - this.sizes[cc]) + "x" + (this.miny[cc] - this.sizes[cc]) + "X" + (this.maxx[cc] + this.sizes[cc]) + "x" + (this.maxy[cc] + this.sizes[cc]) + "_ImDim" + source.getWidth() + "x" + source.getHeight() + ".png", 6);
                        result = null;
                    }
                    annotation = null;
                    source = null;
                    continue;
                }
                catch (Exception e) {
                    System.out.flush();
                    System.err.println(++this.nbErrors + " - Exception - " + e.getMessage());
                    System.err.flush();
                    e.printStackTrace();
                    continue;
                }
                catch (Error e) {
                    System.out.flush();
                    System.err.println(++this.nbErrors + " - Error - " + e.getMessage());
                    System.err.flush();
                    e.printStackTrace();
                }
            }
            images = null;
        }
        System.err.println("Program finished with " + this.nbErrors + " error(s).");
    }

    private void BoudingBoxesAndDistances(BufferedImage annotation, int size, int security, int nbCPU) {
        int x;
        int y;
        int i2;
        int counter = this.ccl.ConnectedComponentsNumber();
        int[][] labels = ArrayConverter.to2D((int[])this.ccl.Labels1D(), (int)annotation.getWidth(), (int)annotation.getHeight());
        int width = labels[0].length;
        int height = labels.length;
        if (this.maxx == null || counter + 1 != this.maxx.length) {
            this.minx = new int[counter + 1];
            this.maxx = new int[counter + 1];
            this.miny = new int[counter + 1];
            this.maxy = new int[counter + 1];
            this.distances = new double[counter + 1][counter + 1];
            this.sizes = new int[counter + 1];
        }
        for (i2 = 1; i2 <= counter; ++i2) {
            this.minx[i2] = width;
            this.miny[i2] = height;
            this.maxy[i2] = 0;
            this.maxx[i2] = 0;
            this.sizes[i2] = size;
        }
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                if (labels[y][x] <= 0) continue;
                if (x < this.minx[labels[y][x]]) {
                    this.minx[labels[y][x]] = x;
                }
                if (x > this.maxx[labels[y][x]]) {
                    this.maxx[labels[y][x]] = x;
                }
                if (y < this.miny[labels[y][x]]) {
                    this.miny[labels[y][x]] = y;
                }
                if (y <= this.maxy[labels[y][x]]) continue;
                this.maxy[labels[y][x]] = y;
            }
        }
        labels = null;
        boolean pointmode = true;
        i2 = 1;
        while (pointmode & i2 <= counter) {
            if (this.minx[i2] != this.maxx[i2]) {
                pointmode = false;
            }
            ++i2;
        }
        if (pointmode) {
            for (y = 1; y < counter; ++y) {
                this.distances[y][y] = 0.0;
                for (x = y + 1; x <= counter; ++x) {
                    double d = this.metric.Distance((double)this.minx[x], (double)this.miny[x], 0.0, (double)this.minx[y], (double)this.miny[y], 0.0);
                    this.distances[x][y] = d;
                    this.distances[y][x] = d;
                    if (!(this.distances[x][y] < (double)(size + security))) continue;
                    if ((double)this.sizes[x] > this.distances[x][y] - (double)security) {
                        this.sizes[x] = (int)this.distances[x][y] - security;
                    }
                    if (!((double)this.sizes[y] > this.distances[x][y] - (double)security)) continue;
                    this.sizes[y] = (int)this.distances[x][y] - security;
                }
            }
        } else {
            this.skiz.Filter(annotation, null, 0, nbCPU);
            labels = null;
            for (i2 = 1; i2 <= counter; ++i2) {
                while (this.sizes[i2] > 0 && labels[this.miny[i2] - this.sizes[i2]][this.minx[i2] - this.sizes[i2]] != labels[this.miny[i2]][this.minx[i2]] && labels[this.maxy[i2] + this.sizes[i2]][this.minx[i2] - this.sizes[i2]] != labels[this.miny[i2]][this.minx[i2]] && labels[this.maxy[i2] + this.sizes[i2]][this.maxx[i2] + this.sizes[i2]] != labels[this.miny[i2]][this.minx[i2]] && labels[this.miny[i2] - this.sizes[i2]][this.maxx[i2] + this.sizes[i2]] != labels[this.miny[i2]][this.minx[i2]]) {
                    int n = i2;
                    this.sizes[n] = this.sizes[n] - 1;
                }
            }
            labels = null;
        }
    }
}

