/*
 * Decompiled with CFR 0.152.
 */
package softwares.cmm.teleOphta;

import displays.Display;
import imageTiTi.ImageConverter;
import imageTiTi.ImageIO;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

public class IsolateChannel {
    private int nbErrors;
    private Display display = new Display();

    public void Isolate(String folder, String dest, int channel, String extension) {
        File[] folders = new File(folder).listFiles();
        for (int i2 = 0; i2 < folders.length; ++i2) {
            if (!folders[i2].isDirectory()) continue;
            String outfolder = dest + "/" + folders[i2].getName();
            File outfile = new File(outfolder);
            if (!outfile.exists()) {
                outfile.mkdirs();
            }
            this.Isolate(folders[i2], outfolder, channel, extension);
        }
    }

    public void Isolate(File sourcepath, String dest, int channel, String extension) {
        File[] images = sourcepath.listFiles();
        for (int i2 = 0; i2 < images.length; ++i2) {
            if (!images[i2].isFile() || !images[i2].getName().contains(".png")) continue;
            try {
                BufferedImage image = ImageIO.Read(images[i2].getAbsolutePath());
                BufferedImage result = ImageConverter.Channel((BufferedImage)image, (int)channel);
                ImageIO.Write(result, dest + "/" + images[i2].getName().substring(0, images[i2].getName().length() - 4) + extension + ".png", 6);
                continue;
            }
            catch (Exception E) {
                System.out.flush();
                System.err.println(++this.nbErrors + " - Exception - " + E.getMessage());
                System.err.flush();
                E.printStackTrace();
                continue;
            }
            catch (Error E) {
                System.out.flush();
                System.err.println(++this.nbErrors + " - Error - " + E.getMessage());
                System.err.flush();
                E.printStackTrace();
            }
        }
    }

    public void Watch(File image, int zoom) throws IOException {
        this.Watch(ImageIO.Read(image.getAbsolutePath()), image.getName(), zoom);
    }

    public void Watch(BufferedImage image, String name, int zoom) {
        BufferedImage red = ImageConverter.Channel((BufferedImage)image, (int)0);
        BufferedImage green = ImageConverter.Channel((BufferedImage)image, (int)1);
        BufferedImage blue = ImageConverter.Channel((BufferedImage)image, (int)2);
        this.display.Image(image, name, (double)zoom);
        this.display.Image(red, name + " - red", (double)zoom);
        this.display.Image(green, name + " - green", (double)zoom);
        this.display.Image(blue, name + " - blue", (double)zoom);
    }
}

