/*
 * Decompiled with CFR 0.152.
 */
package softwares.cmm.teleOphta;

import arrayTiTi.ArrayArithmetic;
import arrayTiTi.ArrayFeatures;
import filesAndFolders.fichiersTabules.FichierTabule;
import filesAndFolders.fichiersTabules.FichierTabuleTools;
import imageTiTi.ImageComparator;
import imageTiTi.ImageConverter;
import imageTiTi.ImageFeatures;
import imageTiTi.ImageIO;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Arrays;
import mathematics.fourier.JTransformsComplex;
import measures.histogram.IntegralProjectionFunction;
import measures.histogram.RadialProjectionFunction;
import morphee.StructuringElement;
import morphee.gradients.GradientOC;
import processing.filters.Gaussian;

public class ImageQuality {
    private final GradientOC gradient = new GradientOC();
    private final Gaussian gauss = new Gaussian();
    private final IntegralProjectionFunction ipf = new IntegralProjectionFunction();
    private final RadialProjectionFunction rpf = new RadialProjectionFunction();
    private final ArrayFeatures AF = new ArrayFeatures();
    private final ImageFeatures IF = new ImageFeatures();

    public ImageQuality() {
        this.gauss.Parameters(13, 13.0, new JTransformsComplex());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ComputeOphDiat(String imagespath, String asfpath, String vesselspath, boolean wait, String start, String end, String fileout, int nbCPU) {
        int nbErrors = 0;
        Object[] patients = new File(imagespath).listFiles();
        Arrays.sort(patients);
        double[] features = new double[9];
        String name = null;
        DataOutputStream out = null;
        try {
            out = new DataOutputStream(new FileOutputStream(fileout));
            out.write(String.valueOf("RatioGradient AverageGradient RatioASF AverageASF ").getBytes("ASCII"));
            out.write(String.valueOf("RatioASFwithoutVessels AverageASFwithoutVessels Variance ").getBytes("ASCII"));
            out.write(String.valueOf("Patients Visits Images\n").getBytes("ASCII"));
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        this.gradient.setStructuringElement(new StructuringElement(new Object[]{1, -1}));
        for (int p = 0; p < patients.length; ++p) {
            if (wait && ((File)patients[p]).getName().contains(start)) {
                wait = false;
            }
            if (!wait && ((File)patients[p]).isDirectory() && ((File)patients[p]).getName().contains("P0")) {
                File[] visits = ((File)patients[p]).listFiles();
                for (int v = 0; v < visits.length; ++v) {
                    if (!visits[v].isDirectory()) continue;
                    File[] images = visits[v].listFiles();
                    for (int i2 = 0; i2 < images.length; ++i2) {
                        if (!images[i2].isFile() || !images[i2].getName().contains(".png")) continue;
                        try {
                            int x;
                            Arrays.fill(features, -1.0);
                            name = images[i2].getName().substring(0, images[i2].getName().length() - 4);
                            BufferedImage image = ImageConverter.Channel((BufferedImage)ImageIO.Read(images[i2].getAbsolutePath()), (int)1);
                            BufferedImage resasf = ImageIO.Read(asfpath + "/" + ((File)patients[p]).getName() + "/" + visits[v].getName() + "/" + name + " - ASF.png");
                            BufferedImage vessels = ImageIO.Read(vesselspath + "/" + ((File)patients[p]).getName() + "/" + visits[v].getName() + "/" + name + " - QuickVessels.png");
                            int nbpixels = (int)this.IF.Counter(image, 0, 0);
                            BufferedImage grad = this.gradient.Filter(image, 2);
                            ImageComparator.Compare((BufferedImage)vessels, (String)"==", (int)0, (BufferedImage)vessels, (BufferedImage)grad, (BufferedImage)grad);
                            features[0] = (double)this.IF.Counter(grad, 0, 0) / (double)nbpixels;
                            this.IF.Integral(grad);
                            features[1] = (double)this.IF.Integral() / (double)nbpixels;
                            features[2] = (double)this.IF.Counter(resasf, 0, 0) / (double)nbpixels;
                            this.IF.Integral(resasf);
                            features[3] = (double)this.IF.Integral() / (double)nbpixels;
                            ImageComparator.Compare((BufferedImage)vessels, (String)"==", (int)0, (BufferedImage)vessels, (BufferedImage)resasf, (BufferedImage)resasf);
                            features[4] = (double)this.IF.Counter(resasf, 0, 0) / (double)nbpixels;
                            this.IF.Integral(resasf);
                            features[5] = (double)this.IF.Integral() / (double)nbpixels;
                            BufferedImage resgauss = this.gauss.Filter(image, nbCPU);
                            byte[] imbuffer = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                            byte[] gaussbuffer = ((DataBufferByte)resgauss.getRaster().getDataBuffer()).getData();
                            double variance = 0.0;
                            double average = 0.0;
                            int nb = 0;
                            for (x = 0; x < imbuffer.length; x += 50) {
                                if ((imbuffer[x] & 0xFF) <= 0) continue;
                                average += (double)(gaussbuffer[x] & 0xFF);
                                ++nb;
                            }
                            average /= (double)nb;
                            for (x = 0; x < imbuffer.length; x += 50) {
                                if ((imbuffer[x] & 0xFF) <= 0) continue;
                                variance += Math.pow((double)(gaussbuffer[x] & 0xFF) - average, 2.0);
                            }
                            variance /= (double)nb;
                            features[6] = variance = Math.sqrt(variance);
                            this.ipf.Compute(image, 0);
                            average = this.IF.Average(image, 0);
                            ArrayArithmetic.Divide((double[])this.ipf.AverageHorizontal(), (double)average, (double[])this.ipf.AverageHorizontal());
                            ArrayArithmetic.Divide((double[])this.ipf.AverageVertical(), (double)average, (double[])this.ipf.AverageVertical());
                            ArrayArithmetic.Divide((double[])this.ipf.AverageDiagonalRight(), (double)average, (double[])this.ipf.AverageDiagonalRight());
                            ArrayArithmetic.Divide((double[])this.ipf.AverageDiagonalLeft(), (double)average, (double[])this.ipf.AverageDiagonalLeft());
                            this.AF.Moments(this.ipf.AverageHorizontal(), 0.0);
                            double var1 = this.AF.StandardDeviation();
                            this.AF.Moments(this.ipf.AverageVertical(), 0.0);
                            double var2 = this.AF.StandardDeviation();
                            this.AF.Moments(this.ipf.AverageDiagonalRight(), 0.0);
                            double var3 = this.AF.StandardDeviation();
                            this.AF.Moments(this.ipf.AverageDiagonalLeft(), 0.0);
                            double var4 = this.AF.StandardDeviation();
                            features[7] = Math.max(var1, Math.max(var2, Math.max(var3, var4)));
                            this.rpf.Compute(image, 36, 0);
                            ArrayArithmetic.Divide((double[])this.rpf.Averages(), (double)average, (double[])this.rpf.Averages());
                            this.AF.Moments(this.rpf.Averages(), 0.0);
                            features[8] = this.AF.StandardDeviation();
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            ++nbErrors;
                            continue;
                        }
                        catch (Error e) {
                            e.printStackTrace();
                            ++nbErrors;
                            continue;
                        }
                        finally {
                            try {
                                for (int f = 0; f < features.length; ++f) {
                                    out.write(String.valueOf(features[f] + " ").getBytes("ASCII"));
                                }
                                out.write(String.valueOf(((File)patients[p]).getName() + " ").getBytes("ASCII"));
                                out.write(String.valueOf(visits[v].getName() + " ").getBytes("ASCII"));
                                out.write(String.valueOf("\"" + name + "\"\n").getBytes("ASCII"));
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                ++nbErrors;
                            }
                        }
                    }
                }
            }
            if (wait || !((File)patients[p]).getName().contains(end)) continue;
            wait = true;
        }
    }

    public void Correlations(FichierTabule qualities, FichierTabule features) {
        int i2;
        int od = qualities.ColumnNumber("OD_Qualite");
        int og = qualities.ColumnNumber("OG_Qualite");
        int idpat = qualities.ColumnNumber("IDPAT");
        int idexam = qualities.ColumnNumber("IDEXAM");
        int patient = features.ColumnNumber("Patients");
        int visit = features.ColumnNumber("Visits");
        int height = qualities.nbRows();
        for (i2 = 0; i2 < height; ++i2) {
            if (qualities.getValueString(i2, od).equalsIgnoreCase(qualities.getValueString(i2, og))) continue;
            qualities.setSelected(i2, true);
        }
        for (i2 = 0; i2 < height; ++i2) {
            if (!qualities.getValueString(i2, og).equalsIgnoreCase("?") && !qualities.getValueString(i2, od).equalsIgnoreCase("?")) continue;
            qualities.setSelected(i2, true);
        }
        qualities.ExcludeSelected();
        System.out.println("qualities excluded:" + qualities.nbExcluded());
        for (i2 = 0; i2 < height; ++i2) {
            if (!qualities.isExcluded(i2)) continue;
            features.ClearSelection();
            features.SelectWhere(patient, 0, qualities.getValueString(i2, idpat));
            features.SelectFromSelectionWhere(visit, 0, qualities.getValueString(i2, idexam));
            features.ExcludeSelected();
        }
        System.out.println("features excluded:" + features.nbExcluded());
        FichierTabule quality = FichierTabuleTools.DeleteExcluded(qualities);
        features.ClearSelection();
        features.SelectWhere(0, 2, 0.0);
        features.ExtendSelectionWhere(0, 0, Double.NaN);
        System.out.println("nb soucis in features: " + features.nbSelected());
        features.ExcludeSelected();
        features.ClearSelection();
        FichierTabule resfeatures1 = FichierTabuleTools.DeleteExcluded(features);
        FichierTabule res = FichierTabuleTools.AddColumn(resfeatures1, "");
        res.setColumnName(res.nbColumn() - 1, "Quality");
        height = res.Height();
        block7: for (i2 = 0; i2 < height; ++i2) {
            quality.ClearSelection();
            quality.SelectWhere(idpat, 0, res.getValueString(i2, patient));
            quality.SelectFromSelectionWhere(idexam, 0, res.getValueString(i2, visit));
            switch (quality.nbSelected()) {
                case 0: {
                    res.setSelected(i2, true);
                    continue block7;
                }
                case 1: {
                    int j = 0;
                    while (!quality.isSelected(j)) {
                        ++j;
                    }
                    res.setValue(i2, res.nbAttribut() - 1, quality.getValueString(j, od));
                    continue block7;
                }
                default: {
                    System.out.println("nbselected = " + quality.nbSelected() + " => " + res.getValueString(i2, patient) + " " + res.getValueString(i2, visit));
                }
            }
        }
        FichierTabule result = FichierTabuleTools.DeleteExcluded(res);
        result.Write("Result_Correlation_Qualities_Features.txt", false);
    }
}

