/*
 * Decompiled with CFR 0.152.
 */
package softwares.cmm.teleOphta;

import arrayTiTi.ArrayOperations;
import imageTiTi.ImageConverter;
import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.WritableRaster;
import java.io.File;
import processing.filters.DynamicExpansion;

public class ImageEnhancer {
    private int width;
    private int height;
    private DynamicExpansion dynexp = new DynamicExpansion();
    public int[][] maxima;
    public double[][] result;
    public double[][] resultgreen;
    public double[][] resultred;
    public double[][] resultblue;
    public double[][] mahalanobis;
    public double[][] mu;
    public double[][] sigma;
    private int nbErrors;
    private StatisticThread[] threads = null;
    private int nbFreeThreads = 0;

    public void Enhance(File src, int Windowsize1, double threshold, int Windowsize2, int maxi, String folderout, int nbCPU) {
        File[] visits = src.listFiles();
        this.nbErrors = 0;
        for (int v = 0; v < visits.length; ++v) {
            if (!visits[v].isDirectory()) continue;
            File[] images = visits[v].listFiles();
            File dest = new File(folderout + "/" + visits[v].getName() + "/");
            if (!dest.exists()) {
                dest.mkdirs();
            }
            for (int i2 = 0; i2 < images.length; ++i2) {
                if (!images[i2].isFile() || !images[i2].getName().toLowerCase().contains(".png")) continue;
                try {
                    BufferedImage image = ImageIO.Read(images[i2].getAbsolutePath());
                    BufferedImage res = this.Enhance(image, Windowsize1, threshold, Windowsize2, maxi, nbCPU);
                    ImageIO.Write(res, dest + "/" + images[i2].getName().substring(0, images[i2].getName().length() - 4) + ".png", 6);
                    image = null;
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ++this.nbErrors;
                    continue;
                }
                catch (Error e) {
                    e.printStackTrace();
                    ++this.nbErrors;
                }
            }
            dest = null;
        }
        System.err.println("Program finished with " + this.nbErrors + " error(s).");
    }

    public BufferedImage Enhance(BufferedImage source, int Windowsize1, double threshold, int Windowsize2, int maxi, int nbCPU) {
        BufferedImage res = ImageNew.Same((BufferedImage)source);
        this.Enhance(source, Windowsize1, threshold, Windowsize2, res, maxi, nbCPU);
        return res;
    }

    public void Enhance(BufferedImage source, int Windowsize1, double threshold, int Windowsize2, BufferedImage Result, int maxi, int nbCPU) {
        int x;
        int y;
        if (!ImageTools.isColored((BufferedImage)source)) {
            throw new IllegalArgumentException("Color image required.");
        }
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)source, (BufferedImage)Result)) {
            throw new IllegalArgumentException("Images source and result have different type or dimensions.");
        }
        BufferedImage green = ImageConverter.Channel((BufferedImage)source, (int)1);
        BufferedImage back = ImageConverter.Channel((BufferedImage)source, (int)1);
        WritableRaster wr = source.getRaster();
        WritableRaster wrgreen = green.getRaster();
        WritableRaster wrback = back.getRaster();
        WritableRaster wrres = Result.getRaster();
        if (green.getWidth() != this.width || green.getHeight() != this.height) {
            this.width = green.getWidth();
            this.height = green.getHeight();
            this.maxima = new int[this.height][this.width];
            this.mahalanobis = new double[this.height][this.width];
            this.mu = new double[this.height][this.width];
            this.sigma = new double[this.height][this.width];
            this.result = new double[this.height][this.width];
            this.resultgreen = new double[this.height][this.width];
            this.resultred = new double[this.height][this.width];
            this.resultblue = new double[this.height][this.width];
        }
        if (maxi > 0) {
            ArrayOperations.Fill((int[][])this.maxima, (int)0);
            this.Maxima(green, this.maxima);
            for (y = 0; y < this.height; ++y) {
                for (x = 0; x < this.width; ++x) {
                    if (this.maxima[y][x] <= maxi) continue;
                    this.CorrectSalt(green, x, y);
                }
            }
        }
        ArrayOperations.Fill((double[][])this.mu, (double)0.0);
        ArrayOperations.Fill((double[][])this.sigma, (double)0.0);
        this.Statistics(green, green, this.mu, this.sigma, Windowsize1 / 2, nbCPU);
        for (y = 0; y < this.height; ++y) {
            for (x = 0; x < this.width; ++x) {
                if (Double.isNaN(this.mu[y][x])) {
                    this.CorrectNan(this.mu, x, y);
                }
                if (!Double.isNaN(this.sigma[y][x])) continue;
                this.CorrectNan(this.sigma, x, y);
            }
        }
        for (y = 0; y < this.height; ++y) {
            for (x = 0; x < this.width; ++x) {
                this.mahalanobis[y][x] = wrgreen.getSample(x, y, 0) > 0 ? Math.abs((wrgreen.getSampleDouble(x, y, 0) - this.mu[y][x]) / this.sigma[y][x]) : 0.0;
            }
        }
        for (y = 0; y < this.height; ++y) {
            for (x = 0; x < this.width; ++x) {
                if (wrgreen.getSample(x, y, 0) > 0 && this.mahalanobis[y][x] <= threshold) {
                    wrback.setSample(x, y, 0, wrgreen.getSample(x, y, 0));
                    continue;
                }
                wrback.setSample(x, y, 0, 0);
            }
        }
        ArrayOperations.Fill((double[][])this.mu, (double)0.0);
        ArrayOperations.Fill((double[][])this.sigma, (double)0.0);
        this.Statistics(green, back, this.mu, this.sigma, Windowsize2 / 2, nbCPU);
        for (y = 0; y < this.height; ++y) {
            for (x = 0; x < this.width; ++x) {
                if (Double.isNaN(this.mu[y][x])) {
                    this.CorrectNan(this.mu, x, y);
                }
                if (!Double.isNaN(this.sigma[y][x])) continue;
                this.CorrectNan(this.sigma, x, y);
            }
        }
        for (y = 0; y < this.height; ++y) {
            for (x = 0; x < this.width; ++x) {
                this.result[y][x] = wrgreen.getSample(x, y, 0) > 0 ? (wrgreen.getSampleDouble(x, y, 0) - this.mu[y][x]) / this.sigma[y][x] : 0.0;
            }
        }
        for (y = 0; y < this.height; ++y) {
            for (x = 0; x < this.width; ++x) {
                if (!Double.isNaN(this.result[y][x])) continue;
                this.CorrectNan(this.result, x, y);
            }
        }
        this.dynexp.Filter(this.result, this.result, 1.0, 255.0);
        for (y = 0; y < this.height; ++y) {
            for (x = 0; x < this.width; ++x) {
                if (wrgreen.getSample(x, y, 0) == 0) {
                    this.resultblue[y][x] = 0.0;
                    this.resultgreen[y][x] = 0.0;
                    this.resultred[y][x] = 0.0;
                    this.result[y][x] = 0.0;
                    continue;
                }
                int max = Math.max(wr.getSample(x, y, 0), wr.getSample(x, y, 1));
                max = Math.max(max, wr.getSample(x, y, 2));
                this.resultred[y][x] = wr.getSampleDouble(x, y, 0) * this.result[y][x] / (double)max;
                this.resultgreen[y][x] = wr.getSampleDouble(x, y, 1) * this.result[y][x] / (double)max;
                this.resultblue[y][x] = wr.getSampleDouble(x, y, 2) * this.result[y][x] / (double)max;
            }
        }
        for (y = 0; y < this.height; ++y) {
            for (x = 0; x < this.width; ++x) {
                wrres.setSample(x, y, 0, (int)(this.resultred[y][x] + 0.5));
                wrres.setSample(x, y, 1, (int)(this.resultgreen[y][x] + 0.5));
                wrres.setSample(x, y, 2, (int)(this.resultblue[y][x] + 0.5));
            }
        }
    }

    public void Maxima(BufferedImage source, int[][] maxima) {
        int x;
        int y;
        int wid = source.getWidth();
        int hei = source.getHeight();
        WritableRaster wr = source.getRaster();
        ArrayOperations.Fill((int[][])maxima, (int)0);
        for (y = 0; y < hei; ++y) {
            for (x = 1; x < wid - 1; ++x) {
                maxima[y][x] = Math.min(wr.getSample(x, y, 0) - wr.getSample(x - 1, y, 0), wr.getSample(x, y, 0) - wr.getSample(x + 1, y, 0));
            }
        }
        for (x = 0; x < wid; ++x) {
            for (y = 1; y < hei - 1; ++y) {
                maxima[y][x] = Math.min(maxima[y][x], Math.min(wr.getSample(x, y, 0) - wr.getSample(x, y - 1, 0), wr.getSample(x, y, 0) - wr.getSample(x, y + 1, 0)));
            }
        }
    }

    private void CorrectSalt(BufferedImage source, int x, int y) {
        WritableRaster wr = source.getRaster();
        double mean = 0.0;
        int nb = 0;
        for (int i2 = -1; i2 <= 1; ++i2) {
            for (int j = -1; j <= 1; ++j) {
                if (i2 == 0 && j == 0 || wr.getSample(x + j, y + i2, 0) <= 0) continue;
                mean += wr.getSampleDouble(x + j, y + i2, 0);
                ++nb;
            }
        }
        wr.setSample(x, y, 0, (int)(mean / (double)nb + 0.5));
    }

    private void CorrectNan(double[][] tab, int x, int y) {
        double mean = 0.0;
        int nb = 0;
        for (int i2 = -1; i2 <= 1; ++i2) {
            for (int j = -1; j <= 1; ++j) {
                if (Double.isNaN(tab[y + i2][x + j]) || !(tab[y + i2][x + j] > 0.0)) continue;
                mean += tab[y + i2][x + j];
                ++nb;
            }
        }
        tab[y][x] = mean / (double)nb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Statistics(BufferedImage workzone, BufferedImage data, double[][] mu, double[][] sigma, int size, int nbCPU) {
        Object object;
        int i2;
        if (this.threads == null || this.threads.length != nbCPU) {
            this.nbFreeThreads = 0;
            this.threads = null;
            this.threads = new StatisticThread[nbCPU];
            for (i2 = 0; i2 < nbCPU; ++i2) {
                this.threads[i2] = new StatisticThread();
                this.threads[i2].start();
            }
            object = this;
            synchronized (object) {
                while (this.nbFreeThreads != nbCPU) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.nbFreeThreads = 0;
        switch (nbCPU) {
            case 1: {
                this.threads[0].setConditions(workzone, data, mu, sigma, size, 0, workzone.getHeight());
                object = this.threads[0].lock;
                synchronized (object) {
                    this.threads[0].lock.notify();
                    break;
                }
            }
            default: {
                Object e;
                int step = workzone.getHeight() / nbCPU;
                for (i2 = 0; i2 < nbCPU - 1; ++i2) {
                    this.threads[i2].setConditions(workzone, data, mu, sigma, size, i2 * step, (i2 + 1) * step);
                    e = this.threads[i2].lock;
                    synchronized (e) {
                        this.threads[i2].lock.notify();
                        continue;
                    }
                }
                this.threads[i2].setConditions(workzone, data, mu, sigma, size, i2 * step, workzone.getHeight());
                e = this.threads[i2].lock;
                synchronized (e) {
                    this.threads[i2].lock.notify();
                    break;
                }
            }
        }
        ImageEnhancer imageEnhancer = this;
        synchronized (imageEnhancer) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected synchronized void addFreeThread() {
        ++this.nbFreeThreads;
        this.notify();
    }

    private class StatisticThread
    extends Thread {
        private double[][] mu = null;
        private double[][] sigma = null;
        private int starty;
        private int endy;
        private int size;
        private byte[] data;
        private byte[] work;
        public Object lock = new Object();

        public void setConditions(BufferedImage workzone, BufferedImage data, double[][] mu, double[][] sigma, int size, int starty, int endy) {
            this.data = ((DataBufferByte)data.getRaster().getDataBuffer()).getData();
            this.work = ((DataBufferByte)workzone.getRaster().getDataBuffer()).getData();
            this.mu = mu;
            this.sigma = sigma;
            this.starty = starty;
            this.endy = endy;
            this.size = size;
            ImageEnhancer.this.width = workzone.getRaster().getWidth();
            ImageEnhancer.this.height = workzone.getRaster().getHeight();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block5: while (true) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        ImageEnhancer.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                int y = this.starty;
                int poswork = this.starty * ImageEnhancer.this.width;
                while (true) {
                    if (y >= this.endy) continue block5;
                    for (int x = 0; x < ImageEnhancer.this.width; ++x) {
                        int j;
                        if ((this.work[poswork + x] & 0xFF) <= 0) continue;
                        int minx = x - this.size < 0 ? 0 : x - this.size;
                        int miny = y - this.size < 0 ? 0 : y - this.size;
                        int maxx = x + this.size < ImageEnhancer.this.width ? x + this.size : ImageEnhancer.this.width - 1;
                        int maxy = y + this.size < ImageEnhancer.this.height ? y + this.size : ImageEnhancer.this.height - 1;
                        int sum = 0;
                        int nb = 0;
                        int i2 = miny;
                        int posdata = miny * ImageEnhancer.this.width;
                        while (i2 <= maxy) {
                            for (j = minx; j <= maxx; ++j) {
                                if ((this.data[posdata + j] & 0xFF) <= 0) continue;
                                sum += this.data[posdata + j] & 0xFF;
                                ++nb;
                            }
                            ++i2;
                            posdata += ImageEnhancer.this.width;
                        }
                        this.mu[y][x] = (double)sum / (double)nb;
                        this.sigma[y][x] = 0.0;
                        i2 = miny;
                        posdata = miny * ImageEnhancer.this.width;
                        while (i2 <= maxy) {
                            for (j = minx; j <= maxx; ++j) {
                                if ((this.data[posdata + j] & 0xFF) <= 0) continue;
                                double[] dArray = this.sigma[y];
                                int n = x;
                                dArray[n] = dArray[n] + Math.pow((double)(this.data[posdata + j] & 0xFF) - this.mu[y][x], 2.0);
                            }
                            ++i2;
                            posdata += ImageEnhancer.this.width;
                        }
                        double[] dArray = this.sigma[y];
                        int n = x;
                        dArray[n] = dArray[n] / (double)nb;
                        this.sigma[y][x] = Math.sqrt(this.sigma[y][x]);
                    }
                    ++y;
                    poswork += ImageEnhancer.this.width;
                }
                break;
            }
        }
    }
}

