/*
 * Decompiled with CFR 0.152.
 */
package softwares.cmm.teleOphta;

import imageTiTi.ImageComparator;
import imageTiTi.ImageDrawer;
import imageTiTi.ImageIO;
import imageTiTi.ImageOperations;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Scanner;

public class GiancardoFromLatimToImage {
    private int nbErrors;
    private int cote = 780;
    private ImageDrawer drawer = new ImageDrawer();
    private int ci;
    private int cj;

    public void Process(String imagespath, String xmlpath, String originalpath, String outpath) {
        double risk;
        int start;
        int end;
        String line;
        String nameimage;
        int i2;
        String namevisit;
        File[] images;
        int v;
        double max = 0.0;
        BufferedImage resbin = new BufferedImage(this.cote, this.cote, 12);
        BufferedImage resgray = new BufferedImage(this.cote, this.cote, 10);
        File[] visits = new File(imagespath).listFiles();
        File xmlfile = null;
        File folderout = null;
        File originalfile = null;
        Scanner xmlreader = null;
        String suffix = ".ex.xml";
        float[] color = null;
        for (v = 0; v < visits.length; ++v) {
            if (!visits[v].isDirectory()) continue;
            images = visits[v].listFiles();
            namevisit = visits[v].getName();
            for (i2 = 0; i2 < images.length; ++i2) {
                if (!images[i2].isFile() || !images[i2].getName().toLowerCase().contains(".png")) continue;
                try {
                    nameimage = images[i2].getName().substring(0, images[i2].getName().length() - 4);
                    xmlfile = new File(xmlpath + "/" + namevisit + "_" + nameimage + ".jpg");
                    if (!xmlfile.exists()) {
                        xmlfile = new File(xmlpath + "/" + namevisit + "_" + nameimage + ".JPG" + suffix);
                    }
                    if (!xmlfile.exists()) {
                        throw new IOException("Unknown file: " + xmlpath + "/" + namevisit + "_" + nameimage + ".*" + suffix);
                    }
                    xmlreader = new Scanner(new FileInputStream(xmlfile));
                    do {
                        if (!(line = xmlreader.nextLine()).contains("<vertex ")) continue;
                        start = end = line.indexOf("ty=\"") + 4;
                        while (line.charAt(end) != '\"') {
                            ++end;
                        }
                        risk = Double.valueOf(line.substring(start, end));
                        if (!(max < risk)) continue;
                        max = risk;
                    } while (!line.equalsIgnoreCase("</selection>"));
                    continue;
                }
                catch (Exception e) {
                    System.out.flush();
                    e.printStackTrace();
                    System.err.flush();
                    continue;
                }
                catch (Error e) {
                    System.out.flush();
                    e.printStackTrace();
                    System.err.flush();
                }
            }
        }
        for (v = 0; v < visits.length; ++v) {
            if (!visits[v].isDirectory()) continue;
            images = visits[v].listFiles();
            namevisit = visits[v].getName();
            for (i2 = 0; i2 < images.length; ++i2) {
                if (!images[i2].isFile() || !images[i2].getName().toLowerCase().contains(".png")) continue;
                try {
                    BufferedImage annotations = ImageIO.Read(images[i2].getAbsolutePath());
                    nameimage = images[i2].getName().substring(0, images[i2].getName().length() - 4);
                    originalfile = new File(originalpath + "/" + namevisit + "/" + nameimage + ".jpg");
                    if (!originalfile.exists()) {
                        originalfile = new File(originalpath + "/" + namevisit + "/" + nameimage + ".JPG");
                    }
                    if (!originalfile.exists()) {
                        throw new IOException("Unknown image: " + originalpath + "/" + namevisit + "_" + nameimage + ".*");
                    }
                    BufferedImage original = ImageIO.Read(originalfile.getAbsolutePath());
                    ImageOperations.Fill((BufferedImage)resbin, (int)0);
                    ImageOperations.Fill((BufferedImage)resgray, (int)0);
                    xmlfile = new File(xmlpath + "/" + namevisit + "_" + nameimage + ".jpg");
                    if (!xmlfile.exists()) {
                        xmlfile = new File(xmlpath + "/" + namevisit + "_" + nameimage + ".JPG" + suffix);
                    }
                    if (!xmlfile.exists()) {
                        throw new IOException("Unknown file: " + xmlpath + "/" + namevisit + "_" + nameimage + ".*" + suffix);
                    }
                    xmlreader = new Scanner(new FileInputStream(xmlfile));
                    do {
                        if (!(line = xmlreader.nextLine()).contains("<vertex ")) continue;
                        start = end = line.indexOf("x=\"") + 3;
                        while (line.charAt(end) != '\"') {
                            ++end;
                        }
                        int x = Integer.valueOf(line.substring(start, end));
                        start = end = line.indexOf("y=\"") + 3;
                        while (line.charAt(end) != '\"') {
                            ++end;
                        }
                        int y = Integer.valueOf(line.substring(start, end));
                        start = end = line.indexOf("ty=\"") + 4;
                        while (line.charAt(end) != '\"') {
                            ++end;
                        }
                        risk = Double.valueOf(line.substring(start, end));
                        start = end = line.indexOf("a=\"") + 3;
                        while (line.charAt(end) != '\"') {
                            ++end;
                        }
                        int area = Integer.valueOf(line.substring(start, end));
                        int radius = (int)(Math.sqrt((double)area / Math.PI) + 0.5);
                        radius = radius == 0 ? 1 : radius;
                        color = new float[]{(float)risk / (float)max, (float)risk / (float)max, (float)risk / (float)max};
                        resbin.getRaster().setSample(x, y, 0, 1);
                        ImageDrawer.Disk(resgray, x, y, radius, 0, color);
                    } while (!line.equalsIgnoreCase("</selection>"));
                    folderout = new File(outpath + "/Giancardo/Bin/" + namevisit + "/");
                    if (!folderout.exists()) {
                        folderout.mkdirs();
                    }
                    ImageIO.Write(resbin, folderout.getAbsolutePath() + "/" + nameimage + ".png", 6);
                    folderout = new File(outpath + "/Giancardo/Gray/" + namevisit + "/");
                    if (!folderout.exists()) {
                        folderout.mkdirs();
                    }
                    ImageIO.Write(resgray, folderout.getAbsolutePath() + "/" + nameimage + ".png", 6);
                    folderout = new File(outpath + "/Annotations/" + namevisit + "/");
                    if (!folderout.exists()) {
                        folderout.mkdirs();
                    }
                    ImageIO.Write(this.NormalisationImage(annotations, original), folderout.getAbsolutePath() + "/" + nameimage + ".png", 6);
                    continue;
                }
                catch (Exception e) {
                    System.out.flush();
                    e.printStackTrace();
                    System.err.flush();
                    ++this.nbErrors;
                    continue;
                }
                catch (Error e) {
                    System.out.flush();
                    e.printStackTrace();
                    System.err.flush();
                    ++this.nbErrors;
                }
            }
        }
        System.err.println("Program finished with " + this.nbErrors + " errors.");
        System.err.println("Max risk = " + max);
    }

    private BufferedImage NormalisationImage(BufferedImage entree, BufferedImage original) {
        int j;
        int i2;
        double facteurEchelle;
        BufferedImage redimensionne = null;
        switch (entree.getHeight()) {
            case 960: {
                if (entree.getWidth() != 1440) {
                    throw new Error("Souci");
                }
                facteurEchelle = 0.81;
                break;
            }
            case 1000: {
                if (entree.getWidth() != 1504) {
                    throw new Error("Souci");
                }
                facteurEchelle = 0.78;
                break;
            }
            case 1288: {
                if (entree.getWidth() != 1936) {
                    throw new Error("Souci");
                }
                facteurEchelle = 0.6;
                break;
            }
            case 1360: {
                if (entree.getWidth() != 2048) {
                    throw new Error("Souci");
                }
                facteurEchelle = 0.58;
                break;
            }
            case 1696: {
                if (entree.getWidth() != 2544) {
                    throw new Error("Souci");
                }
                facteurEchelle = 0.46;
                break;
            }
            case 1880: {
                if (entree.getWidth() != 2816) {
                    throw new Error("Souci");
                }
                facteurEchelle = 0.4;
                break;
            }
            default: {
                facteurEchelle = 1.0;
                ++this.nbErrors;
                System.out.println("Unknown: " + entree.getWidth() + " " + entree.getHeight());
            }
        }
        if (facteurEchelle > 0.9999) {
            double invFacteurEchelle = 1.0 / facteurEchelle;
            int m = (int)((double)entree.getWidth() * facteurEchelle);
            int n = (int)((double)entree.getHeight() * facteurEchelle);
            redimensionne = new BufferedImage(m, n, entree.getType());
            i2 = 0;
            double I = 0;
            while (i2 < m) {
                j = 0;
                double J = 0;
                while (j < n) {
                    int I0 = (int)I;
                    int J0 = (int)J;
                    int I1 = I0 + 1;
                    int J1 = J0 + 1;
                    I1 = I1 == entree.getWidth() ? I1 - 1 : I1;
                    J1 = J1 == entree.getHeight() ? J1 - 1 : J1;
                    double x = I - (double)I0;
                    double y = J - (double)J0;
                    redimensionne.getRaster().setSample(i2, j, 0, (1.0 - x) * (1.0 - y) * (double)entree.getRaster().getSample(I0, J0, 0) + x * (1.0 - y) * (double)entree.getRaster().getSample(I1, J0, 0) + (1.0 - x) * y * (double)entree.getRaster().getSample(I0, J1, 0) + x * y * (double)entree.getRaster().getSample(I1, J1, 0));
                    ++j;
                    J += invFacteurEchelle;
                }
                ++i2;
                I += invFacteurEchelle;
            }
        } else {
            redimensionne = entree;
        }
        this.chercherCentreGravite(original);
        BufferedImage sortie = new BufferedImage(this.cote, this.cote, 10);
        int i0 = this.ci - this.cote / 2;
        int j0 = this.cj - this.cote / 2;
        for (i2 = 0; i2 < this.cote; ++i2) {
            for (j = 0; j < this.cote; ++j) {
                if (i0 + i2 >= 0 && i0 + i2 < redimensionne.getWidth() && j0 + j >= 0 && j0 + j < redimensionne.getHeight()) {
                    sortie.getRaster().setSample(i2, j, 0, redimensionne.getRaster().getSample(i0 + i2, j0 + j, 0));
                    continue;
                }
                sortie.getRaster().setSample(i2, j, 0, 0);
            }
        }
        ImageComparator.Compare((BufferedImage)sortie, (String)"!=", (int)0, (int)255, (int)0, (BufferedImage)sortie);
        return sortie;
    }

    private void chercherCentreGravite(BufferedImage image) {
        int sommeOrdonnees = 0;
        int sommeAbscisses = 0;
        int nbPixels = 0;
        for (int i2 = 0; i2 < image.getWidth(); ++i2) {
            for (int j = 0; j < image.getHeight(); ++j) {
                if (image.getRaster().getSample(i2, j, 0) <= 10) continue;
                sommeOrdonnees += i2;
                sommeAbscisses += j;
                ++nbPixels;
            }
        }
        this.ci = (int)Math.round((double)sommeOrdonnees / (double)nbPixels);
        this.cj = (int)Math.round((double)sommeAbscisses / (double)nbPixels);
    }
}

