/*
 * Decompiled with CFR 0.152.
 */
package softwares.cmm.teleOphta;

import imageTiTi.ImageIO;
import java.awt.image.BufferedImage;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Calendar;

public class EvaluateVesselDetection {
    private int nbErrors;

    public void EvaluateOnDrive(String detectionpath, String Extension2, String drivepath) throws Exception {
        File[] images = new File(drivepath + "/test/1st_manual/").listFiles();
        Calendar cal = Calendar.getInstance();
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        String time = (month < 10 ? "0" : "") + month + " " + (day < 10 ? "0" : "") + day + " at " + (hour < 10 ? "0" : "") + hour + "h" + (minute < 10 ? "0" : "") + minute + "m" + (second < 10 ? "0" : "") + second + "s";
        DataOutputStream out = new DataOutputStream(new FileOutputStream(detectionpath + "/EvaluationVesselDetection" + Extension2 + " " + time + ".txt"));
        out.write(("detection " + detectionpath + "\n").getBytes("ISO-8859-1"));
        out.write(("groundtruth " + drivepath + "/test/1st_manual/\n").getBytes("ISO-8859-1"));
        out.write(("Extension '" + Extension2 + "'\n\n").getBytes("ISO-8859-1"));
        out.write("TP TN FP FN => TP% FP% AC Images\n".getBytes("ISO-8859-1"));
        int nb = 0;
        this.nbErrors = 0;
        int FalseNegative = 0;
        int FalsePositive = 0;
        int TrueNegative = 0;
        int TruePositive = 0;
        double accuracy = 0.0;
        for (int v = 0; v < images.length; ++v) {
            try {
                String name = images[v].getName().substring(0, 2) + "_test";
                BufferedImage detections = ImageIO.Read(detectionpath + "/" + name + Extension2 + ".png");
                BufferedImage groundtruth = ImageIO.Read(drivepath + "/test/1st_manual/" + name.substring(0, 2) + "_manual1.gif");
                BufferedImage roi = ImageIO.Read(drivepath + "/test/mask/" + name.substring(0, 7) + "_mask.gif");
                int width = detections.getWidth();
                int height = detections.getHeight();
                BufferedImage differences = new BufferedImage(width, height, 5);
                int size = 0;
                int fn = 0;
                int fp = 0;
                int tn = 0;
                int tp = 0;
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        if (roi.getRaster().getSample(x, y, 0) == 0) continue;
                        ++size;
                        if (groundtruth.getRaster().getSample(x, y, 0) != 0) {
                            if (detections.getRaster().getSample(x, y, 0) != 0) {
                                ++tp;
                                differences.getRaster().setSample(x, y, 0, 255);
                                differences.getRaster().setSample(x, y, 1, 255);
                                differences.getRaster().setSample(x, y, 2, 255);
                                continue;
                            }
                            ++fn;
                            differences.getRaster().setSample(x, y, 0, 255);
                            differences.getRaster().setSample(x, y, 1, 0);
                            differences.getRaster().setSample(x, y, 2, 0);
                            continue;
                        }
                        if (detections.getRaster().getSample(x, y, 0) != 0) {
                            ++fp;
                            differences.getRaster().setSample(x, y, 0, 0);
                            differences.getRaster().setSample(x, y, 1, 255);
                            differences.getRaster().setSample(x, y, 2, 0);
                            continue;
                        }
                        ++tn;
                    }
                }
                TruePositive += tp;
                TrueNegative += tn;
                FalsePositive += fp;
                FalseNegative += fn;
                accuracy += (double)(tp + tn) / (double)size;
                ++nb;
                ImageIO.Write(differences, detectionpath + "/" + name + Extension2 + " - Differences.png", 6);
                out.write((tp + " " + tn + " " + fp + " " + fn + " => " + (double)tp / (double)(tp + fn) + " " + (double)fp / (double)(fp + tn) + " " + (double)(tp + tn) / (double)size + " " + name + "\n").getBytes("ISO-8859-1"));
                continue;
            }
            catch (Exception e) {
                System.out.flush();
                e.printStackTrace();
                System.err.flush();
                ++this.nbErrors;
                continue;
            }
            catch (Error e) {
                System.out.flush();
                e.printStackTrace();
                System.err.flush();
                ++this.nbErrors;
            }
        }
        out.write(("\n\n" + TruePositive + " " + TrueNegative + " " + FalsePositive + " " + FalseNegative + " => " + (double)TruePositive / (double)(TruePositive + FalseNegative) + " " + (double)FalsePositive / (double)(FalsePositive + TrueNegative) + " " + accuracy / (double)nb + "\n").getBytes("ISO-8859-1"));
        out.close();
        System.err.println("Program finished with " + this.nbErrors + " error(s).");
    }

    public void EvaluateOnStare(String detectionpath, String Extension2, String starepath) throws Exception {
        File[] images = new File(starepath + "/Images/").listFiles();
        Calendar cal = Calendar.getInstance();
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        String time = (month < 10 ? "0" : "") + month + " " + (day < 10 ? "0" : "") + day + " at " + (hour < 10 ? "0" : "") + hour + "h" + (minute < 10 ? "0" : "") + minute + "m" + (second < 10 ? "0" : "") + second + "s";
        DataOutputStream out = new DataOutputStream(new FileOutputStream(detectionpath + "/EvaluationVesselDetection" + Extension2 + " " + time + ".txt"));
        out.write(("detection " + detectionpath + "\n").getBytes("ISO-8859-1"));
        out.write(("groundtruth " + starepath + "/test/1st_manual/\n").getBytes("ISO-8859-1"));
        out.write(("Extension '" + Extension2 + "'\n\n").getBytes("ISO-8859-1"));
        out.write("TP TN FP FN => TP% FP% AC Images\n".getBytes("ISO-8859-1"));
        int nb = 0;
        this.nbErrors = 0;
        int FalseNegative = 0;
        int FalsePositive = 0;
        int TrueNegative = 0;
        int TruePositive = 0;
        double accuracy = 0.0;
        for (int v = 0; v < images.length; ++v) {
            try {
                String name = images[v].getName().substring(0, 6);
                BufferedImage detections = ImageIO.Read(detectionpath + "/" + name + Extension2 + ".png");
                BufferedImage groundtruth = ImageIO.Read(starepath + "/Labels - Adam Hoover/" + name.substring(0, 6) + ".ah.ppm");
                BufferedImage roi = ImageIO.Read(starepath + "/Background/" + name + ".png");
                int width = detections.getWidth();
                int height = detections.getHeight();
                BufferedImage differences = new BufferedImage(width, height, 5);
                int size = 0;
                int fn = 0;
                int fp = 0;
                int tn = 0;
                int tp = 0;
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        if (roi.getRaster().getSample(x, y, 0) == 0 && roi.getRaster().getSample(x, y, 1) == 0 && roi.getRaster().getSample(x, y, 2) == 0) continue;
                        ++size;
                        if (groundtruth.getRaster().getSample(x, y, 0) != 0) {
                            if (detections.getRaster().getSample(x, y, 0) != 0) {
                                ++tp;
                                differences.getRaster().setSample(x, y, 0, 255);
                                differences.getRaster().setSample(x, y, 1, 255);
                                differences.getRaster().setSample(x, y, 2, 255);
                                continue;
                            }
                            ++fn;
                            differences.getRaster().setSample(x, y, 0, 255);
                            differences.getRaster().setSample(x, y, 1, 0);
                            differences.getRaster().setSample(x, y, 2, 0);
                            continue;
                        }
                        if (detections.getRaster().getSample(x, y, 0) != 0) {
                            ++fp;
                            differences.getRaster().setSample(x, y, 0, 0);
                            differences.getRaster().setSample(x, y, 1, 255);
                            differences.getRaster().setSample(x, y, 2, 0);
                            continue;
                        }
                        ++tn;
                    }
                }
                TruePositive += tp;
                TrueNegative += tn;
                FalsePositive += fp;
                FalseNegative += fn;
                accuracy += (double)(tp + tn) / (double)size;
                ++nb;
                ImageIO.Write(differences, detectionpath + "/" + name + Extension2 + " - Differences.png", 6);
                out.write((tp + " " + tn + " " + fp + " " + fn + " => " + (double)tp / (double)(tp + fn) + " " + (double)fp / (double)(fp + tn) + " " + (double)(tp + tn) / (double)size + " " + name + "\n").getBytes("ISO-8859-1"));
                continue;
            }
            catch (Exception e) {
                System.out.flush();
                e.printStackTrace();
                System.err.flush();
                ++this.nbErrors;
                continue;
            }
            catch (Error e) {
                System.out.flush();
                e.printStackTrace();
                System.err.flush();
                ++this.nbErrors;
            }
        }
        out.write(("\n\n" + TruePositive + " " + TrueNegative + " " + FalsePositive + " " + FalseNegative + " => " + (double)TruePositive / (double)(TruePositive + FalseNegative) + " " + (double)FalsePositive / (double)(FalsePositive + TrueNegative) + " " + accuracy / (double)nb + "\n").getBytes("ISO-8859-1"));
        out.close();
        System.err.println("Program finished with " + this.nbErrors + " error(s).");
    }
}

