/*
 * Decompiled with CFR 0.152.
 */
package softwares.cmm.teleOphta;

import imageTiTi.ImageIO;
import java.awt.image.BufferedImage;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.Calendar;
import measures.cclh.ConnectedComponentLabeling;
import measures.cclh.UnionFindCcl;
import measures.hedgehop.Distance;
import measures.hedgehop.DistanceTools;
import measures.qef.MaximumSymmetricQEF;
import measures.qef.NumberQEF;
import measures.qef.RootMeanSquareSymmetricQEF;
import measures.qef.SimpleDetectionQEF;
import measures.qef.SurfaceQEF;
import morphee.segmentation.Skiz;
import processing.thresholding.Binary;

public class EvaluateLesionDetection {
    private int nbErrors;
    private int[][] confusionmatrix = new int[2][2];
    private int[][] confusionmatrixpixels = new int[2][2];
    private ConnectedComponentLabeling ccl = new UnionFindCcl();
    private Skiz skiz = new Skiz();
    private Distance montanary = DistanceTools.CreateMontanariDistance(2, 7);
    private Binary binary = new Binary(1);
    private int TruePositive;
    private int FalsePositive;
    private int FalseNegative;
    private int TruePositivePixel;
    private int FalsePositivePixel;
    private int FalseNegativePixel;
    private int ltp;
    private int lfp;
    private int lfn;
    private int ltppix;
    private int lfppix;
    private int lfnpix;
    private double distdetection;
    private double distgroundtruth;
    private double localdistdetection;
    private double localdistgroundtruth;
    private final double Epsilon = 0.001;
    private MaximumSymmetricQEF maxqef = new MaximumSymmetricQEF();
    private NumberQEF numqef = new NumberQEF();
    private RootMeanSquareSymmetricQEF rmssqef = new RootMeanSquareSymmetricQEF();
    private SimpleDetectionQEF simqef = new SimpleDetectionQEF();
    private SurfaceQEF surfqef = new SurfaceQEF();

    public void EvaluateDot(File detectionsfile, String groundtruthfile, double distancesecurity) throws Exception {
        int total = 0;
        File[] visits = detectionsfile.listFiles();
        this.nbErrors = 0;
        Calendar cal = Calendar.getInstance();
        DataOutputStream out = new DataOutputStream(new FileOutputStream("Evaluation_" + (cal.get(2) + 1) + "_" + cal.get(5) + "_at_" + cal.get(11) + "_" + cal.get(12) + "_" + cal.get(13) + ".txt"));
        out.write(("detection " + detectionsfile.getAbsolutePath() + "\n").getBytes("ISO-8859-1"));
        out.write(("groundtruth " + groundtruthfile + "\n").getBytes("ISO-8859-1"));
        out.write(("security " + Double.toString(distancesecurity) + "\n").getBytes("ISO-8859-1"));
        Arrays.fill((Object[])this.confusionmatrix, (Object)0);
        Arrays.fill((Object[])this.confusionmatrixpixels, (Object)0);
        for (int v = 0; v < visits.length; ++v) {
            if (!visits[v].isDirectory()) continue;
            File[] images = visits[v].listFiles();
            for (int i2 = 0; i2 < images.length; ++i2) {
                if (!images[i2].isFile() || !images[i2].getName().toLowerCase().contains(".png")) continue;
                try {
                    BufferedImage detections = ImageIO.Read(images[i2].getAbsolutePath());
                    BufferedImage groundtruth = ImageIO.Read(groundtruthfile + "/" + visits[v].getName() + "/" + images[i2].getName());
                    int nb = this.EvaluateDot(detections, groundtruth, distancesecurity);
                    out.write((this.ltp + "/" + nb + " " + this.lfp + " " + this.lfn + " " + visits[v].getName() + "/" + images[i2].getName() + "\n").getBytes("ISO-8859-1"));
                    this.TruePositive += this.ltp;
                    this.FalsePositive += this.lfp;
                    this.FalseNegative += this.lfn;
                    total += nb;
                    continue;
                }
                catch (Exception e) {
                    System.out.flush();
                    e.printStackTrace();
                    System.err.flush();
                    ++this.nbErrors;
                    continue;
                }
                catch (Error e) {
                    System.out.flush();
                    e.printStackTrace();
                    System.err.flush();
                    ++this.nbErrors;
                }
            }
        }
        out.write(("Final " + this.TruePositive + "/" + total + " " + this.FalsePositive + " " + this.FalseNegative + "\n").getBytes("ISO-8859-1"));
        out.close();
        System.err.println("Program finished with " + this.nbErrors + " error(s).");
    }

    private int EvaluateDot(BufferedImage detections, BufferedImage groundtruth, double distancesecurity) {
        throw new UnsupportedOperationException("Outdated, upgrade required!");
    }

    public void Evaluate(File detectionsfile, String groundtruthfile) throws Exception {
        int total = 0;
        File[] visits = detectionsfile.listFiles();
        int nbimage = 0;
        this.nbErrors = 0;
        Calendar cal = Calendar.getInstance();
        DataOutputStream out = new DataOutputStream(new FileOutputStream("Evaluation_" + (cal.get(2) + 1) + "_" + cal.get(5) + "_at_" + cal.get(11) + "_" + cal.get(12) + "_" + cal.get(13) + ".txt"));
        out.write(("detection " + detectionsfile.getAbsolutePath() + "\n").getBytes("ISO-8859-1"));
        out.write(("groundtruth " + groundtruthfile + "\n").getBytes("ISO-8859-1"));
        Arrays.fill((Object[])this.confusionmatrix, (Object)0);
        Arrays.fill((Object[])this.confusionmatrixpixels, (Object)0);
        for (int v = 0; v < visits.length; ++v) {
            if (!visits[v].isDirectory()) continue;
            File[] images = visits[v].listFiles();
            for (int i2 = 0; i2 < images.length; ++i2) {
                if (!images[i2].isFile() || !images[i2].getName().toLowerCase().contains(".png")) continue;
                try {
                    BufferedImage detections = ImageIO.Read(images[i2].getAbsolutePath());
                    BufferedImage groundtruth = ImageIO.Read(groundtruthfile + "/" + visits[v].getName() + "/" + images[i2].getName());
                    if (detections.getType() != 12) {
                        detections = this.binary.Filter(detections, 1);
                    }
                    int nb = this.Evaluate(detections, groundtruth);
                    out.write((this.ltp + "/" + nb + " " + this.lfp + " " + this.lfn + " " + this.ltppix + " " + this.lfppix + " " + this.lfnpix + " " + this.localdistgroundtruth + " " + this.localdistdetection + " " + visits[v].getName() + "/" + images[i2].getName() + "\n").getBytes("ISO-8859-1"));
                    this.TruePositive += this.ltp;
                    this.FalsePositive += this.lfp;
                    this.FalseNegative += this.lfn;
                    this.TruePositivePixel += this.ltppix;
                    this.FalsePositivePixel += this.lfppix;
                    this.FalseNegativePixel += this.lfnpix;
                    this.distgroundtruth += this.localdistgroundtruth;
                    this.distdetection += this.localdistdetection;
                    total += nb;
                    ++nbimage;
                    continue;
                }
                catch (Exception e) {
                    System.out.flush();
                    e.printStackTrace();
                    System.err.flush();
                    ++this.nbErrors;
                    continue;
                }
                catch (Error e) {
                    System.out.flush();
                    e.printStackTrace();
                    System.err.flush();
                    ++this.nbErrors;
                }
            }
        }
        this.distdetection /= (double)nbimage;
        this.distgroundtruth /= (double)nbimage;
        out.write(("Final " + this.TruePositive + "/" + total + " " + this.FalsePositive + " " + this.FalseNegative + "\n").getBytes("ISO-8859-1"));
        out.write(("Final Pixel " + this.TruePositivePixel + " " + this.FalsePositivePixel + " " + this.FalseNegativePixel + "\n").getBytes("ISO-8859-1"));
        out.write(("Distances " + this.localdistgroundtruth + " " + this.distdetection + "\n").getBytes("ISO-8859-1"));
        out.close();
        System.err.println("Program finished with " + this.nbErrors + " error(s).");
    }

    private int Evaluate(BufferedImage detections, BufferedImage groundtruth) {
        throw new UnsupportedOperationException("Outdated, upgrade required!");
    }

    public void Evaluate(File detectionsfile, String groundtruthfile, int sizese, int nbCPU) throws Exception {
        File[] visits = detectionsfile.listFiles();
        int nbimage = 0;
        this.nbErrors = 0;
        Calendar cal = Calendar.getInstance();
        DataOutputStream out = new DataOutputStream(new FileOutputStream("Evaluation_" + (cal.get(2) + 1) + "_" + cal.get(5) + "_at_" + cal.get(11) + "_" + cal.get(12) + "_" + cal.get(13) + ".txt"));
        out.write(("detection " + detectionsfile.getAbsolutePath() + "\n").getBytes("ISO-8859-1"));
        out.write(("groundtruth " + groundtruthfile + "\n\n").getBytes("ISO-8859-1"));
        out.write("Detection Number Surface Distance Maximum\n".getBytes("ISO-8859-1"));
        Arrays.fill((Object[])this.confusionmatrix, (Object)0);
        Arrays.fill((Object[])this.confusionmatrixpixels, (Object)0);
        double surf = 0.0;
        double sim = 0.0;
        double rms = 0.0;
        double num = 0.0;
        double max = 0.0;
        for (int v = 0; v < visits.length; ++v) {
            if (!visits[v].isDirectory()) continue;
            File[] images = visits[v].listFiles();
            for (int i2 = 0; i2 < images.length; ++i2) {
                if (!images[i2].isFile() || !images[i2].getName().toLowerCase().contains(".png")) continue;
                try {
                    BufferedImage detections = ImageIO.Read(images[i2].getAbsolutePath());
                    BufferedImage groundtruth = ImageIO.Read(groundtruthfile + "/" + visits[v].getName() + "/" + images[i2].getName());
                    if (detections.getType() != 12) {
                        detections = this.binary.Filter(detections, 1);
                    }
                    if (groundtruth.getType() != 12) {
                        groundtruth = this.binary.Filter(groundtruth, 1);
                    }
                    double lmax = this.maxqef.Evaluate(detections, sizese, nbCPU, groundtruth);
                    double lnum = this.numqef.Evaluate(detections, sizese, nbCPU, groundtruth);
                    double lrms = this.rmssqef.Evaluate(detections, sizese, nbCPU, groundtruth);
                    double lsim = this.simqef.Evaluate(detections, sizese, nbCPU, groundtruth);
                    double lsurf = this.surfqef.Evaluate(detections, sizese, nbCPU, groundtruth);
                    max += lmax;
                    num += lnum;
                    rms += lrms;
                    sim += lsim;
                    surf += lsurf;
                    out.write((lsim + " " + lnum + " " + lsurf + " " + lrms + " " + lmax + " " + visits[v].getName() + "/" + images[i2].getName() + "\n").getBytes("ISO-8859-1"));
                    ++nbimage;
                    continue;
                }
                catch (Exception e) {
                    System.out.flush();
                    e.printStackTrace();
                    System.err.flush();
                    ++this.nbErrors;
                    continue;
                }
                catch (Error e) {
                    System.out.flush();
                    e.printStackTrace();
                    System.err.flush();
                    ++this.nbErrors;
                }
            }
        }
        out.write(((sim /= (double)nbimage) + " " + (num /= (double)nbimage) + " " + (surf /= (double)nbimage) + " " + (rms /= (double)nbimage) + " " + (max /= (double)nbimage) + "\n").getBytes("ISO-8859-1"));
        out.close();
        System.err.println("Program finished with " + this.nbErrors + " error(s).");
    }
}

