/*
 * Decompiled with CFR 0.152.
 */
package softwares.cmm.teleOphta;

import imageTiTi.ImageIO;
import java.awt.image.BufferedImage;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Calendar;
import measures.qef.QualityEvaluationFunction;

public class EvaluateDetection {
    private int nbErrors;

    public void EvaluateDot(File detectionsfile, String groundtruthfile, QualityEvaluationFunction qef, int precision, int nbCPU) throws Exception {
        int nb = 0;
        File[] visits = detectionsfile.listFiles();
        this.nbErrors = 0;
        Calendar cal = Calendar.getInstance();
        DataOutputStream out = new DataOutputStream(new FileOutputStream("Evaluation_" + (cal.get(2) + 1) + "_" + cal.get(5) + "_at_" + cal.get(11) + "_" + cal.get(12) + "_" + cal.get(13) + ".txt"));
        out.write(("detection " + detectionsfile.getAbsolutePath() + "\n").getBytes("ISO-8859-1"));
        out.write(("groundtruth " + groundtruthfile + "\n").getBytes("ISO-8859-1"));
        out.write(("Quality evaluation function: " + qef.getClass().getName() + "\n").getBytes("ISO-8859-1"));
        out.write(("precision " + Double.toString(precision) + "\n\n").getBytes("ISO-8859-1"));
        out.write("Score  TruePositive TrueNegative FalsePositive FalseNegative\n".getBytes("ISO-8859-1"));
        double Score = 0.0;
        double FalseNegative = 0.0;
        double FalsePositive = 0.0;
        double TrueNegative = 0.0;
        double TruePositive = 0.0;
        for (int v = 0; v < visits.length; ++v) {
            if (!visits[v].isDirectory()) continue;
            File[] images = visits[v].listFiles();
            for (int i2 = 0; i2 < images.length; ++i2) {
                if (!images[i2].isFile() || !images[i2].getName().toLowerCase().contains(".png")) continue;
                try {
                    BufferedImage detections = ImageIO.Read(images[i2].getAbsolutePath());
                    BufferedImage groundtruth = ImageIO.Read(groundtruthfile + "/" + visits[v].getName() + "/" + images[i2].getName());
                    double score = qef.Evaluate(detections, precision, nbCPU, groundtruth);
                    double TP = qef.TruePositive();
                    double TN = qef.TrueNegative();
                    double FP = qef.FalsePositive();
                    double FN = qef.FalseNegative();
                    out.write((score + " " + TP + " " + TN + " " + FP + " " + FN + " " + visits[v].getName() + "/" + images[i2].getName() + "\n").getBytes("ISO-8859-1"));
                    TruePositive += TP;
                    TrueNegative += TN;
                    FalsePositive += FP;
                    FalseNegative += FN;
                    Score += score;
                    ++nb;
                    continue;
                }
                catch (Exception e) {
                    System.out.flush();
                    e.printStackTrace();
                    System.err.flush();
                    ++this.nbErrors;
                    continue;
                }
                catch (Error e) {
                    System.out.flush();
                    e.printStackTrace();
                    System.err.flush();
                    ++this.nbErrors;
                }
            }
        }
        out.write(("Final " + Score + " " + TruePositive + " " + TrueNegative + " " + FalsePositive + " " + FalseNegative + "\n").getBytes("ISO-8859-1"));
        out.close();
        System.err.println("Program finished with " + this.nbErrors + " error(s).");
    }
}

