/*
 * Decompiled with CFR 0.152.
 */
package softwares.cmm.teleOphta;

import filesAndFolders.FilesFolders;
import imageTiTi.ImageArithmetic;
import imageTiTi.ImageIO;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import processing.thresholding.Binary;

public class CleanAndSortAnnotations {
    private int nbErrors;
    private Binary binary = new Binary(1);

    public void Start(File src, File dest) {
        if (!dest.isDirectory()) {
            throw new IllegalArgumentException("dest is not a directory.");
        }
        if (!src.isDirectory()) {
            throw new IllegalArgumentException("src is not a directory.");
        }
        File[] visits = src.listFiles();
        this.nbErrors = 0;
        for (int v = 0; v < visits.length; ++v) {
            if (!visits[v].isDirectory()) continue;
            File[] images = visits[v].listFiles();
            for (int i2 = 0; i2 < images.length; ++i2) {
                if (!images[i2].getName().contains(".tif")) continue;
                try {
                    BufferedImage image = ImageIO.Read16BitsSpecial(images[i2].getAbsolutePath());
                    BufferedImage bin = this.binary.Filter(image, 1);
                    File file = new File(dest.getAbsolutePath() + "/Crihan Annotations/" + visits[v].getName() + "/");
                    if (!file.exists()) {
                        file.mkdirs();
                    }
                    ImageIO.Write(bin, file.getAbsolutePath() + "/" + images[i2].getName().substring(0, images[i2].getName().length() - 3) + "png", 6);
                    file = null;
                    if (images[i2].getName().contains("_MA.")) {
                        file = new File(dest.getAbsolutePath() + "/Crihan Annotations MicroAneurysms/" + visits[v].getName() + "/");
                    } else if (images[i2].getName().contains("_HD.")) {
                        file = new File(dest.getAbsolutePath() + "/Crihan Annotations MicroHemorrhages/" + visits[v].getName() + "/");
                    } else if (images[i2].getName().contains("_HB.")) {
                        file = new File(dest.getAbsolutePath() + "/Crihan Annotations HemorrhagesStain/" + visits[v].getName() + "/");
                    } else if (images[i2].getName().contains("_HF.")) {
                        file = new File(dest.getAbsolutePath() + "/Crihan Annotations HemorrhagesSpark/" + visits[v].getName() + "/");
                    } else if (images[i2].getName().contains("_EX.")) {
                        file = new File(dest.getAbsolutePath() + "/Crihan Annotations Exudates/" + visits[v].getName() + "/");
                    } else if (images[i2].getName().contains("_NC.")) {
                        file = new File(dest.getAbsolutePath() + "/Crihan Annotations CottonWhools/" + visits[v].getName() + "/");
                    } else if (images[i2].getName().contains("_AMIR.")) {
                        file = new File(dest.getAbsolutePath() + "/Crihan Annotations Amirs/" + visits[v].getName() + "/");
                    } else if (images[i2].getName().contains("_NV.")) {
                        file = new File(dest.getAbsolutePath() + "/Crihan Annotations NewVessels/" + visits[v].getName() + "/");
                    } else {
                        throw new Error("File extension not supported:" + images[i2].getName());
                    }
                    if (!file.exists()) {
                        file.mkdirs();
                    }
                    ImageIO.Write(bin, file.getAbsolutePath() + "/" + images[i2].getName().substring(0, images[i2].getName().length() - 3) + "png", 6);
                    file = null;
                    bin = null;
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ++this.nbErrors;
                    continue;
                }
                catch (Error e) {
                    e.printStackTrace();
                    ++this.nbErrors;
                }
            }
        }
    }

    public void Merge(File src1, File src2, File dest) throws IOException {
        if (!dest.exists()) {
            dest.mkdirs();
        }
        if (!src1.isDirectory()) {
            throw new IllegalArgumentException("src1 is not a directory.");
        }
        if (!src2.isDirectory()) {
            throw new IllegalArgumentException("src2 is not a directory.");
        }
        File[] visits1 = src1.listFiles();
        File[] visits2 = src2.listFiles();
        this.nbErrors = 0;
        for (int v = 0; v < visits1.length; ++v) {
            int i2;
            if (!visits1[v].isDirectory()) continue;
            File file = new File(src2.getAbsolutePath() + "/" + visits1[v].getName());
            if (!file.exists()) {
                FilesFolders.CopyFolder(visits1[v], dest);
            } else {
                int j;
                File destvisit = new File(dest.getAbsolutePath() + "/" + visits1[v].getName());
                if (!destvisit.exists()) {
                    destvisit.mkdirs();
                }
                File[] images2 = null;
                boolean found = false;
                for (i2 = 0; !found && i2 < visits2.length; ++i2) {
                    if (visits2[i2] == null || !visits2[i2].getName().equalsIgnoreCase(visits1[v].getName())) continue;
                    images2 = visits2[i2].listFiles();
                    visits2[i2] = null;
                    found = true;
                }
                if (!found) {
                    throw new Error("Souci 1... not found");
                }
                File[] images1 = visits1[v].listFiles();
                for (i2 = 0; i2 < images1.length; ++i2) {
                    if (!images1[i2].getName().contains(".png")) continue;
                    file = new File(src2.getAbsolutePath() + "/" + visits1[v].getName() + "/" + images1[i2].getName());
                    if (!file.exists()) {
                        FilesFolders.CopyFile(images1[i2], destvisit);
                        continue;
                    }
                    found = false;
                    BufferedImage image2 = null;
                    for (j = 0; !found && j < images2.length; ++j) {
                        if (images2[j] == null || !images2[j].getName().equalsIgnoreCase(images1[i2].getName())) continue;
                        image2 = ImageIO.Read(images2[j].getAbsolutePath());
                        images2[j] = null;
                        found = true;
                    }
                    if (!found) {
                        throw new Error("Souci 2... not found");
                    }
                    BufferedImage image1 = ImageIO.Read(images1[i2].getAbsolutePath());
                    ImageIO.Write(ImageArithmetic.Add(image1, image2, 1, 1), destvisit.getAbsolutePath() + "/" + images1[i2].getName(), 6);
                }
                for (j = 0; j < images2.length; ++j) {
                    if (images2[j] == null) continue;
                    FilesFolders.CopyFile(images2[j], destvisit);
                }
            }
            for (i2 = 0; i2 < visits2.length; ++i2) {
                if (visits2[i2] == null || !visits2[i2].isDirectory()) continue;
                FilesFolders.CopyFolder(visits2[i2], dest);
            }
        }
    }
}

