/*
 * Decompiled with CFR 0.152.
 */
package softwares.cmm.teleOphta;

import filesAndFolders.fichiersTabules.FichierTabule;
import filesAndFolders.fichiersTabules.FichierTabuleConverter;
import filesAndFolders.fichiersTabules.FichierTabuleTools;
import imageTiTi.ImageIO;
import imageTiTi.ImageOperations;
import imageTiTi.colorSpace.HLS;
import imageTiTi.colorSpace.HSV;
import imageTiTi.colorSpace.Lab;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.List;
import measures.cclh.ConnectedComponentLabeling;
import measures.cclh.UnionFindCcl;
import weka.classifiers.Classifier;
import weka.classifiers.meta.Bagging;
import weka.classifiers.trees.RandomForest;
import weka.core.Instance;
import weka.core.Instances;

public class ClassifyPixelsExsudats {
    private int nbErrors;
    private Instances instances = null;
    private HLS hls = new HLS();
    private HSV hsv = new HSV();
    private Lab lab = new Lab();
    private ConnectedComponentLabeling ccl = new UnionFindCcl();
    private DataOutputStream out = null;
    private int colcx;
    private int colcy;
    private int colarea;
    private int[] buffer = new int[10000];

    public void ClassifyFromCharOphDiat(File rootchar, File rootim, FichierTabule trainingset, List<String> deletecolumns, List<String> deletecolumns2, String[] columnames, FichierTabule bestsysres, Classifier classifier, String folderout, String namecolcx, String namecolcy, String namecolarea, boolean wait, String start, String end) throws Exception {
        int x;
        if (trainingset.Width() - deletecolumns.size() != bestsysres.Width()) {
            throw new IllegalArgumentException("workingfile.Width() != sysres.Width().");
        }
        File dest = new File(folderout + "/");
        if (!dest.exists()) {
            dest.mkdirs();
        }
        trainingset.ClearSelection();
        trainingset.ClearExclusion();
        for (x = 0; x < deletecolumns.size(); ++x) {
            trainingset.setExcludedColumn(deletecolumns.get(x), true);
        }
        for (x = 0; x < bestsysres.Width() - 1; ++x) {
            trainingset.setExcludedColumn(x, bestsysres.getValueInt(0, x) == 0);
        }
        FichierTabule modelfile = FichierTabuleTools.DeleteExcludedColumns(trainingset);
        modelfile.Write(folderout + "/ModelFile.txt", false);
        modelfile.setNominal(modelfile.Width() - 1, true);
        modelfile.Target(modelfile.Width() - 1);
        this.instances = FichierTabuleConverter.FichierTabuleToWekaInstances(modelfile, "LearningSet");
        classifier.buildClassifier(this.instances);
        Instance instance = this.instances.firstInstance();
        this.instances.delete();
        Object[] patients = rootchar.listFiles();
        BufferedImage result = null;
        Arrays.sort(patients);
        this.nbErrors = 0;
        for (int p = 0; p < patients.length; ++p) {
            if (!((File)patients[p]).isDirectory() || !((File)patients[p]).getName().contains("P")) continue;
            if (wait && ((File)patients[p]).getName().contains(start)) {
                wait = false;
            }
            if (!wait) {
                dest = new File(folderout + "/" + ((File)patients[p]).getName() + "/");
                if (!dest.exists()) {
                    dest.mkdirs();
                }
                this.out = new DataOutputStream(new FileOutputStream(folderout + "/" + ((File)patients[p]).getName() + "/" + ((File)patients[p]).getName() + ".xml"));
                File[] visits = ((File)patients[p]).listFiles();
                for (int v = 0; v < visits.length; ++v) {
                    if (!visits[v].isDirectory()) continue;
                    File[] characteristics = visits[v].listFiles();
                    dest = new File(folderout + "/" + ((File)patients[p]).getName() + "/" + visits[v].getName() + "/");
                    if (!dest.exists()) {
                        dest.mkdirs();
                    }
                    for (int i2 = 0; i2 < characteristics.length; ++i2) {
                        if (!characteristics[i2].isFile() || !characteristics[i2].getName().contains(".txt")) continue;
                        try {
                            FichierTabule filechar;
                            String name = characteristics[i2].getName().substring(0, characteristics[i2].getName().length() - 4);
                            BufferedImage image = ImageIO.Read(rootim.getAbsolutePath() + "/" + ((File)patients[p]).getName() + "/" + visits[v].getName() + "/" + name + ".png");
                            int width = image.getWidth();
                            int height = image.getHeight();
                            FichierTabule filecharough = new FichierTabule(characteristics[i2].getAbsolutePath(), false);
                            if (0 < filecharough.Height()) {
                                filecharough.setColumnsNames(columnames);
                                for (x = 0; x < deletecolumns2.size(); ++x) {
                                    filecharough.setExcludedColumn(deletecolumns2.get(x), true);
                                }
                                filechar = FichierTabuleTools.DeleteExcludedColumns(filecharough);
                                for (x = 0; x < bestsysres.Width() - 1; ++x) {
                                    filechar.setExcludedColumn(x, bestsysres.getValueInt(0, x) == 0);
                                }
                                filechar = FichierTabuleTools.DeleteExcludedColumns(filechar);
                            } else {
                                filechar = filecharough;
                            }
                            if (result == null || result.getWidth() != width || result.getHeight() != height) {
                                result = null;
                                result = new BufferedImage(width, height, 10);
                            } else {
                                ImageOperations.Fill((BufferedImage)result, (int)0);
                            }
                            this.out.write("<detectionsimage>\n".getBytes("ISO-8859-1"));
                            this.out.write("<imagedescription ".getBytes("ISO-8859-1"));
                            this.out.write(("patient=\"" + ((File)patients[p]).getName() + "\" ").getBytes("ISO-8859-1"));
                            this.out.write(("visit=\"" + visits[v].getName() + "\" ").getBytes("ISO-8859-1"));
                            this.out.write(("image=\"" + name + "\"/>\n").getBytes("ISO-8859-1"));
                            if (0 < filecharough.Height()) {
                                this.colcx = filecharough.ColumnNumber(namecolcx);
                                this.colcy = filecharough.ColumnNumber(namecolcy);
                                this.colarea = filecharough.ColumnNumber(namecolarea);
                                this.Classify(filechar, classifier, instance, result, filecharough, this.out);
                            }
                            this.out.write("</detectionsimage>\n".getBytes("ISO-8859-1"));
                            ImageIO.Write(result, dest + "/" + name + ".png", 6);
                            image = null;
                            filechar = null;
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            ++this.nbErrors;
                            continue;
                        }
                        catch (Error e) {
                            e.printStackTrace();
                            ++this.nbErrors;
                        }
                    }
                }
                this.out.close();
            }
            if (wait || !((File)patients[p]).getName().contains(end)) continue;
            wait = true;
        }
        System.err.println("Program finished with " + this.nbErrors + " error(s).");
    }

    private void Classify(FichierTabule chars, Classifier classifier, Instance instance, BufferedImage result, FichierTabule training, DataOutputStream out) throws Exception {
        if (instance.numAttributes() != chars.Width() + 1) {
            throw new IllegalArgumentException("instance.numAttributes() != chars.Width()+1 => " + instance.numAttributes() + " vs " + chars.Width() + "+1");
        }
        byte[] res = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
        int width = result.getWidth();
        for (int i2 = 0; i2 < chars.Height(); ++i2) {
            block5: for (int a = 0; a < chars.Width(); ++a) {
                switch (chars.ColumnType(a)) {
                    case 0: {
                        instance.setValue(a, (double)chars.getValueInt(i2, a));
                        continue block5;
                    }
                    case 1: {
                        instance.setValue(a, chars.getValueDouble(i2, a));
                        continue block5;
                    }
                    default: {
                        throw new IllegalArgumentException("Attribute is neither INTEGER or DOUBLE. Must not occured.");
                    }
                }
            }
            double[] distribution = classifier.distributionForInstance(instance);
            double p = distribution[1];
            int bx = training.getValueInt(i2, this.colcx);
            int by = training.getValueInt(i2, this.colcy);
            int size = training.getValueInt(i2, this.colarea);
            res[by * width + bx] = (byte)(255.0 * p + 0.5);
            out.write("<detection type=\"exsudat\" ".getBytes("ISO-8859-1"));
            out.write(("xcentre=\"" + bx + "\" ").getBytes("ISO-8859-1"));
            out.write(("ycentre=\"" + by + "\" ").getBytes("ISO-8859-1"));
            out.write(("area=\"" + size + "\" ").getBytes("ISO-8859-1"));
            out.write(("risk=\"" + p + "\"/>\n").getBytes("ISO-8859-1"));
            distribution = null;
        }
        res = null;
    }

    public void Classify(File src, File masks, Classifier classifier, FichierTabule file, String folderout, String fileout, boolean replacebymean) throws Exception {
        File[] visits = masks.listFiles();
        BufferedImage result = null;
        this.out = new DataOutputStream(new FileOutputStream(fileout));
        this.nbErrors = 0;
        file.setNominal(file.nbAttribut() - 1, true);
        this.instances = FichierTabuleConverter.FichierTabuleToWekaInstances(file, "LearningSet");
        this.instances.setClassIndex(file.nbAttribut() - 1);
        classifier.buildClassifier(this.instances);
        Instance instance = this.instances.firstInstance();
        this.instances.delete();
        this.out.write("<?xml version=\"1.0\" encoding=\"iso-8859-1\"?>\n".getBytes("ISO-8859-1"));
        for (int v = 0; v < visits.length; ++v) {
            if (!visits[v].isDirectory()) continue;
            File[] images = visits[v].listFiles();
            File dest = new File(folderout + "/" + visits[v].getName() + "/");
            if (!dest.exists()) {
                dest.mkdirs();
            }
            for (int i2 = 0; i2 < images.length; ++i2) {
                if (!images[i2].isFile() || !images[i2].getName().toLowerCase().contains(".png")) continue;
                try {
                    BufferedImage image = ImageIO.Read(src.getAbsolutePath() + "/" + visits[v].getName() + "/" + images[i2].getName());
                    BufferedImage mask = ImageIO.Read(images[i2].getAbsolutePath());
                    int width = image.getWidth();
                    int height = image.getHeight();
                    if (result == null || result.getWidth() != width || result.getHeight() != height) {
                        result = new BufferedImage(width, height, 10);
                    } else {
                        ImageOperations.Fill((BufferedImage)result, (int)0);
                    }
                    this.out.write("<detectionsimage>\n".getBytes("ISO-8859-1"));
                    this.out.write("<imagedescription ".getBytes("ISO-8859-1"));
                    this.out.write(("visit=\"" + visits[v].getName() + "\" ").getBytes("ISO-8859-1"));
                    this.out.write(("image=\"" + images[i2].getName() + "\"/>\n").getBytes("ISO-8859-1"));
                    this.Classify(image, mask, classifier, instance, result, this.out, replacebymean);
                    this.out.write("</detectionsimage>\n".getBytes("ISO-8859-1"));
                    ImageIO.Write(result, dest + "/" + images[i2].getName().substring(0, images[i2].getName().length() - 4) + ".png", 6);
                    image = null;
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ++this.nbErrors;
                    continue;
                }
                catch (Error e) {
                    e.printStackTrace();
                    ++this.nbErrors;
                }
            }
            dest = null;
        }
        System.err.println("Program finished with " + this.nbErrors + " error(s).");
    }

    public void ClassifyDiabRet(File src, File masks, Classifier classifier, FichierTabule file, String folderout, String fileout, boolean replacebymean) throws Exception {
        BufferedImage result = null;
        this.out = new DataOutputStream(new FileOutputStream(fileout));
        this.nbErrors = 0;
        file.setNominal(file.nbAttribut() - 1, true);
        this.instances = FichierTabuleConverter.FichierTabuleToWekaInstances(file, "LearningSet");
        this.instances.setClassIndex(file.nbAttribut() - 1);
        classifier.buildClassifier(this.instances);
        Instance instance = this.instances.firstInstance();
        this.instances.delete();
        this.out.write("<?xml version=\"1.0\" encoding=\"iso-8859-1\"?>\n".getBytes("ISO-8859-1"));
        File dest = new File(folderout + "/");
        if (!dest.exists()) {
            dest.mkdirs();
        }
        File[] images = src.listFiles();
        for (int i2 = 0; i2 < images.length; ++i2) {
            if (!images[i2].isFile() || !images[i2].getName().toLowerCase().contains(".png")) continue;
            try {
                BufferedImage image = ImageIO.Read(src.getAbsolutePath() + "/" + images[i2].getName());
                BufferedImage mask = ImageIO.Read(masks.getAbsolutePath() + "/" + images[i2].getName());
                int width = image.getWidth();
                int height = image.getHeight();
                if (result == null || result.getWidth() != width || result.getHeight() != height) {
                    result = new BufferedImage(width, height, 10);
                } else {
                    ImageOperations.Fill((BufferedImage)result, (int)0);
                }
                this.out.write("<detectionsimage>\n".getBytes("ISO-8859-1"));
                this.out.write("<imagedescription ".getBytes("ISO-8859-1"));
                this.out.write(("image=\"" + images[i2].getName() + "\"/>\n").getBytes("ISO-8859-1"));
                this.Classify(image, mask, classifier, instance, result, this.out, replacebymean);
                this.out.write("</detectionsimage>\n".getBytes("ISO-8859-1"));
                ImageIO.Write(result, dest + "/" + images[i2].getName().substring(0, images[i2].getName().length() - 4) + ".png", 6);
                image = null;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                ++this.nbErrors;
                continue;
            }
            catch (Error e) {
                e.printStackTrace();
                ++this.nbErrors;
            }
        }
        System.err.println("Program finished with " + this.nbErrors + " error(s).");
    }

    private void Classify(BufferedImage image, BufferedImage mask, Classifier classifier, Instance instance, BufferedImage result, DataOutputStream out, boolean replacebymean) throws Exception {
        float sum;
        int v;
        int width = image.getWidth();
        int height = image.getHeight();
        float[] rgb = new float[3];
        byte[] im = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        byte[] mas = ((DataBufferByte)mask.getRaster().getDataBuffer()).getData();
        byte[] res = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
        int length = im.length;
        int xres = 0;
        int x = 0;
        while (x < length) {
            if ((mas[xres] & 0xFF) > 0) {
                int r = im[x + 2] & 0xFF;
                v = im[x + 1] & 0xFF;
                int b = im[x] & 0xFF;
                if (r == 0 && v == 0 && b == 0) {
                    res[xres++] = 0;
                } else {
                    rgb[0] = (float)r / 255.0f;
                    rgb[1] = (float)v / 255.0f;
                    rgb[2] = (float)b / 255.0f;
                    sum = rgb[0] + rgb[1] + rgb[2];
                    float[] reshls = this.hls.fromRGB(rgb);
                    float[] reshsv = this.hsv.fromRGB(rgb);
                    float[] reslab = this.lab.fromRGB(rgb);
                    int nb = 0;
                    if (classifier instanceof Bagging) {
                        instance.setValue(nb++, (double)rgb[2]);
                        instance.setValue(nb++, (double)(rgb[0] / sum));
                        instance.setValue(nb++, (double)reshls[0]);
                        instance.setValue(nb++, (double)reshsv[2]);
                        instance.setValue(nb++, (double)reslab[0]);
                        instance.setValue(nb++, (double)reslab[1]);
                        instance.setValue(nb++, (double)reslab[2]);
                    } else if (classifier instanceof RandomForest) {
                        instance.setValue(nb++, (double)(rgb[0] / sum));
                        instance.setValue(nb++, (double)(rgb[1] / sum));
                        instance.setValue(nb++, (double)(rgb[2] / sum));
                        instance.setValue(nb++, (double)reshls[0]);
                        instance.setValue(nb++, (double)reshls[1]);
                        instance.setValue(nb++, (double)reshls[2]);
                        instance.setValue(nb++, (double)reshsv[1]);
                        instance.setValue(nb++, (double)reshsv[2]);
                        instance.setValue(nb++, (double)reslab[0]);
                        instance.setValue(nb++, (double)reslab[1]);
                        instance.setValue(nb++, (double)reslab[2]);
                    }
                    try {
                        double[] distribution = classifier.distributionForInstance(instance);
                        res[xres] = (byte)(distribution[0] * 255.0 + 0.5);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            x += 3;
            ++xres;
        }
        this.ccl.Label(mask, 0, true);
        int[] labels = this.ccl.Labels1D();
        int[] sizes = this.ccl.Sizes();
        int nbccl = this.ccl.ConnectedComponentsNumber();
        for (int c = 1; c <= nbccl; ++c) {
            int size = 0;
            sum = 0.0f;
            int min = 255;
            int max = 0;
            int by = 0;
            int bx = 0;
            if (this.buffer.length < sizes[c]) {
                this.buffer = null;
                this.buffer = new int[sizes[c]];
            }
            out.write("<detection type=\"exsudat\" ".getBytes("ISO-8859-1"));
            int pos = 0;
            for (int y = 0; y < height; ++y) {
                x = 0;
                while (x < width) {
                    if (labels[pos] == c) {
                        v = res[pos] & 0xFF;
                        this.buffer[size++] = v;
                        sum += (float)v;
                        if (v < min) {
                            min = v;
                        }
                        if (max < v) {
                            max = v;
                        }
                        bx += x;
                        by += y;
                    }
                    ++x;
                    ++pos;
                }
            }
            if (size != sizes[c]) {
                throw new Error("souci size");
            }
            Arrays.sort(this.buffer, 0, size);
            out.write(("xcentre=\"" + (int)((float)bx / (float)size + 0.5f) + "\" ").getBytes("ISO-8859-1"));
            out.write(("ycentre=\"" + (int)((float)by / (float)size + 0.5f) + "\" ").getBytes("ISO-8859-1"));
            out.write(("area=\"" + size + "\" ").getBytes("ISO-8859-1"));
            out.write(("average=\"" + sum / (float)size / 255.0f + "\" ").getBytes("ISO-8859-1"));
            out.write(("median=\"" + (float)this.buffer[size / 2] / 255.0f + "\" ").getBytes("ISO-8859-1"));
            out.write(("min=\"" + (float)min / 255.0f + "\" ").getBytes("ISO-8859-1"));
            out.write(("max=\"" + (float)max / 255.0f + "\"/>\n").getBytes("ISO-8859-1"));
            if (!replacebymean) continue;
            int s = width * height;
            int average = (int)((double)sum / (double)size + 0.5);
            for (pos = 0; pos < s; ++pos) {
                if (labels[pos] != c) continue;
                res[pos] = (byte)average;
            }
        }
    }
}

