/*
 * Decompiled with CFR 0.152.
 */
package softwares.cmm.teleOphta;

import filesAndFolders.FilesFolders;
import imageTiTi.ImageIO;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import measures.cclh.ConnectedComponentLabeling;
import measures.cclh.FifoCcl;
import measures.cclh.FillHole;
import morphee.Close;
import morphee.Erode;
import morphee.Open;
import morphee.StructuringElement;

public class BackGroundCleaner {
    private Open open = new Open(new StructuringElement(new Object[]{1, -1}));
    private Close close = new Close(new StructuringElement(new Object[]{1, -1}));
    private Erode erode = new Erode(new StructuringElement(new Object[]{1, -1}));
    private FifoCcl ccl = new FifoCcl();
    private FillHole fill = new FillHole();
    private BufferedImage bin;
    private BufferedImage binres;
    private int nbErrors;

    public void CleanOphDiat(File src, int threshold, boolean check, boolean delete, String folderout, int nbCPU) {
        File[] patients = src.listFiles();
        this.nbErrors = 0;
        for (int p = 0; p < patients.length; ++p) {
            if (!patients[p].isDirectory() || !patients[p].getAbsoluteFile().getName().contains("P")) continue;
            File[] visits = patients[p].listFiles();
            for (int v = 0; v < visits.length; ++v) {
                if (!visits[v].isDirectory()) continue;
                File[] images = visits[v].listFiles();
                File dest = new File(folderout + "/" + patients[p].getName() + "/" + visits[v].getName() + "/");
                if (!dest.exists()) {
                    dest.mkdirs();
                }
                for (int i2 = 0; i2 < images.length; ++i2) {
                    if (!images[i2].isFile() || !images[i2].getName().toLowerCase().contains(".jpg")) continue;
                    try {
                        BufferedImage image = ImageIO.Read(images[i2].getAbsolutePath());
                        BufferedImage result = this.Clean(image, threshold, check, nbCPU);
                        ImageIO.Write(result, dest + "/" + images[i2].getName().substring(0, images[i2].getName().length() - 4) + ".png", 6);
                        if (delete) {
                            FilesFolders.Delete(images[i2]);
                        }
                        image = null;
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    catch (Error e) {
                        e.printStackTrace();
                    }
                }
                dest = null;
            }
        }
        System.err.println("Program finished with " + this.nbErrors + " error(s).");
    }

    public void CleanPatient(File src, int threshold, boolean check, String folderout, int nbCPU) {
        File[] visits = src.listFiles();
        this.nbErrors = 0;
        for (int v = 0; v < visits.length; ++v) {
            if (!visits[v].isDirectory()) continue;
            File[] images = visits[v].listFiles();
            File dest = new File(folderout + "/" + visits[v].getName() + "/");
            if (!dest.exists()) {
                dest.mkdirs();
            }
            for (int i2 = 0; i2 < images.length; ++i2) {
                if (!images[i2].isFile() || !images[i2].getName().toLowerCase().contains(".jpg") && !images[i2].getName().toLowerCase().contains(".ppm")) continue;
                try {
                    BufferedImage image = ImageIO.Read(images[i2].getAbsolutePath());
                    BufferedImage result = this.Clean(image, threshold, check, nbCPU);
                    ImageIO.Write(result, dest + "/" + images[i2].getName().substring(0, images[i2].getName().length() - 4) + ".png", 6);
                    image = null;
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                catch (Error e) {
                    e.printStackTrace();
                }
            }
            dest = null;
        }
        System.err.println("Program finished with " + this.nbErrors + " error(s).");
    }

    public void Clean(File src, int threshold, boolean check, String folderout, int nbCPU) {
        File[] images = src.listFiles();
        this.nbErrors = 0;
        File dest = new File(folderout + "/");
        if (!dest.exists()) {
            dest.mkdirs();
        }
        for (int i2 = 0; i2 < images.length; ++i2) {
            if (!images[i2].isFile() || !images[i2].getName().toLowerCase().contains(".jpg") && !images[i2].getName().toLowerCase().contains(".ppm")) continue;
            try {
                BufferedImage image = ImageIO.Read(images[i2].getAbsolutePath());
                BufferedImage result = this.Clean(image, threshold, check, nbCPU);
                ImageIO.Write(result, dest + "/" + images[i2].getName().substring(0, images[i2].getName().length() - 4) + ".png", 6);
                image = null;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            catch (Error e) {
                e.printStackTrace();
            }
        }
        dest = null;
        System.err.println("Program finished with " + this.nbErrors + " error(s).");
    }

    public BufferedImage Clean(BufferedImage image, int threshold, boolean check, int nbCPU) {
        BufferedImage result = new BufferedImage(image.getWidth(), image.getHeight(), image.getType());
        this.Clean(image, result, threshold, check, nbCPU);
        return result;
    }

    public void Clean(BufferedImage image, BufferedImage result, int threshold, boolean check, int nbCPU) {
        int pos;
        int max;
        int[] labels;
        int[] sizes;
        int c;
        int x;
        int y;
        int channel;
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)image, (BufferedImage)result)) {
            throw new IllegalArgumentException("");
        }
        int height = image.getHeight();
        int width = image.getWidth();
        WritableRaster wr = image.getRaster();
        WritableRaster wrres = result.getRaster();
        switch (image.getType()) {
            case 10: 
            case 11: {
                channel = 1;
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                channel = 3;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
        if (this.bin == null || this.bin.getWidth() != image.getWidth() || this.bin.getHeight() != image.getHeight()) {
            this.bin = null;
            this.bin = new BufferedImage(image.getWidth(), image.getHeight(), 12);
            this.binres = null;
            this.binres = new BufferedImage(image.getWidth(), image.getHeight(), 12);
        }
        WritableRaster wrbin = this.bin.getRaster();
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                int s = wr.getSample(x, y, 0);
                for (c = 1; c < channel; ++c) {
                    s += wr.getSample(x, y, c);
                }
                if (s <= threshold) {
                    wrbin.setSample(x, y, 0, 0);
                    continue;
                }
                wrbin.setSample(x, y, 0, 1);
            }
        }
        this.ccl.Label(this.bin, 0, false);
        if (this.ccl.ConnectedComponentsNumber() != 1) {
            sizes = this.ccl.Sizes();
            labels = this.ccl.Labels1D();
            max = 1;
            for (x = 2; x < sizes.length; ++x) {
                if (sizes[max] >= sizes[x]) continue;
                max = x;
            }
            pos = 0;
            for (y = 0; y < height; ++y) {
                x = 0;
                while (x < width) {
                    if (0 < labels[pos] && labels[pos] != max) {
                        wrbin.setSample(x, y, 0, 0);
                    }
                    ++x;
                    ++pos;
                }
            }
            sizes = null;
            labels = null;
        }
        this.close.Filter(this.bin, this.binres, nbCPU);
        this.fill.Fill(this.binres, (ConnectedComponentLabeling)this.ccl, 10000000, false, this.bin);
        this.open.Filter(this.bin, this.binres, nbCPU);
        this.erode.Filter(this.binres, this.bin, nbCPU);
        this.open.Filter(this.bin, this.binres, nbCPU);
        this.ccl.Label(this.binres, 0, false);
        WritableRaster wrbinres = this.binres.getRaster();
        if (this.ccl.ConnectedComponentsNumber() != 1) {
            sizes = this.ccl.Sizes();
            labels = this.ccl.Labels1D();
            max = 1;
            for (x = 2; x < sizes.length; ++x) {
                if (sizes[max] >= sizes[x]) continue;
                max = x;
            }
            pos = 0;
            for (y = 0; y < height; ++y) {
                x = 0;
                while (x < width) {
                    if (0 < labels[pos] && labels[pos] != max) {
                        wrbinres.setSample(x, y, 0, 0);
                    }
                    ++x;
                    ++pos;
                }
            }
            sizes = null;
            labels = null;
        }
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                if (wrbinres.getSample(x, y, 0) == 0) {
                    for (c = 0; c < channel; ++c) {
                        wrres.setSample(x, y, c, 0);
                    }
                    continue;
                }
                for (c = 0; c < channel; ++c) {
                    wrres.setSample(x, y, c, wr.getSample(x, y, c) == 0 ? 1 : wr.getSample(x, y, c));
                }
            }
        }
        if (check) {
            this.ccl.Label(this.binres, -1, false);
            if (this.ccl.ConnectedComponentsNumber() != 2) {
                System.out.flush();
                System.err.println(++this.nbErrors + " - Error - Number of connected component = " + this.ccl.ConnectedComponentsNumber());
                System.err.flush();
            }
        }
        wr = null;
        wrbin = null;
        wrbinres = null;
        wrres = null;
    }
}

