/*
 * Decompiled with CFR 0.152.
 */
package softwares.cmm.teleOphta;

import arrayTiTi.ArrayArithmetic;
import arrayTiTi.ArrayFeatures;
import arrayTiTi.ArrayOperations;
import dv.DV;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.List;
import mathematics.metrics.Euclidian;
import mathematics.metrics.Metric;
import measures.histogram.Histogram;
import processing.filters.ConvolutionFilterAdaptative;
import processing.filters.ConvolutionFilterAdaptativeI;
import processing.thresholding.ImageThresholder;

public class AdaptativeLocalMeanVesselDetection
implements ImageThresholder,
ConvolutionFilterAdaptativeI {
    private final ConvolutionFilterAdaptative filter = new ConvolutionFilterAdaptative();
    private BufferedImage thresholds = null;
    private int ForbidenValue = -1;
    private int[][] radiusmap = null;
    private int maxradius = -1;
    private boolean square = false;
    private double[] percentages = null;
    private final Histogram histogram = new Histogram();
    private double[][][] masks = null;
    private final Metric metric = new Euclidian();
    private final ArrayFeatures AF = new ArrayFeatures();

    public BufferedImage Filter(BufferedImage source, int nbCPU) {
        return this.Filter(source, this.ForbidenValue, nbCPU);
    }

    @Override
    public BufferedImage Filter(BufferedImage source, int ForbidenValue, int nbCPU) {
        BufferedImage result = new BufferedImage(source.getWidth(), source.getHeight(), 12);
        this.Filter(source, result, ForbidenValue, nbCPU);
        return result;
    }

    public void Filter(BufferedImage Original, BufferedImage Result, int nbCPU) {
        this.Filter(Original, Result, this.ForbidenValue, nbCPU);
    }

    @Override
    public void Filter(BufferedImage Original, BufferedImage Result, int ForbidenValue, int nbCPU) {
        if (Result.getType() != 12) {
            throw new IllegalArgumentException("Result image must be binary.");
        }
        if (this.maxradius <= 0) {
            throw new IllegalArgumentException("Any radius map defined.");
        }
        int width = Original.getWidth();
        int height = Original.getHeight();
        WritableRaster wrr = Result.getRaster();
        if (this.thresholds == null || !ImageTools.areDimensionsAndTypeEqual((BufferedImage)Original, (BufferedImage)this.thresholds)) {
            this.thresholds = null;
            this.thresholds = ImageNew.Same((BufferedImage)Original);
        }
        this.ForbidenValue = ForbidenValue;
        this.filter.Parameters(this, ForbidenValue);
        this.filter.Filter(Original, this.thresholds, nbCPU);
        switch (Original.getType()) {
            case 10: {
                byte[] ori = ((DataBufferByte)Original.getRaster().getDataBuffer()).getData();
                byte[] thres = ((DataBufferByte)this.thresholds.getRaster().getDataBuffer()).getData();
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        if (this.radiusmap[y][x] == 0) {
                            wrr.setSample(x, y, 0, 0);
                        } else if ((double)(ori[pos] & 0xFF) <= (double)(thres[pos] & 0xFF) * this.percentages[this.radiusmap[y][x]]) {
                            wrr.setSample(x, y, 0, 0);
                        } else {
                            wrr.setSample(x, y, 0, 1);
                        }
                        ++x;
                        ++pos;
                    }
                }
                thres = null;
                ori = null;
                break;
            }
            case 11: {
                short[] orishort = ((DataBufferUShort)Original.getRaster().getDataBuffer()).getData();
                short[] threshort = ((DataBufferUShort)this.thresholds.getRaster().getDataBuffer()).getData();
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        if (this.radiusmap[y][x] == 0) {
                            wrr.setSample(x, y, 0, 0);
                        } else if ((double)(orishort[pos] & 0xFFFF) <= (double)(threshort[pos] & 0xFFFF) * this.percentages[this.radiusmap[y][x]]) {
                            wrr.setSample(x, y, 0, 0);
                        } else {
                            wrr.setSample(x, y, 0, 1);
                        }
                        ++x;
                        ++pos;
                    }
                }
                threshort = null;
                orishort = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
        wrr = null;
    }

    public DV Filter(DV source, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public void Filter(DV source, DV result, int nbCPU) {
        throw new Error("Empty method, not implemented (yet)");
    }

    public BufferedImage Tresholds() {
        return this.thresholds;
    }

    @Override
    public int[] getThresholds() {
        return null;
    }

    @Override
    public int getThreshold(int channel) {
        return -1;
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 2) {
            throw new IllegalArgumentException("Exactly 3 parameters required.");
        }
        this.radiusmap = (int[][])parameters[0];
        this.square = (Boolean)parameters[1];
        this.MaskMaker();
    }

    public List<Object> Parameters() {
        ArrayList<Object> params = new ArrayList<Object>(1);
        params.add(this.thresholds);
        return params;
    }

    public int BorderEffectSizeX() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeY() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public int BorderEffectSizeZ() {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public ImageThresholder Clone() {
        throw new UnsupportedOperationException("Not supported (yet).");
    }

    private void MaskMaker() {
        int i2;
        if (this.AF.Minimum(this.radiusmap) < 0) {
            throw new IllegalArgumentException("The radius map contains negative value(s)");
        }
        this.maxradius = this.AF.Maximum(this.radiusmap);
        this.histogram.Fill(this.radiusmap, this.maxradius + 1);
        int[] hist = this.histogram.getValues(0);
        this.masks = new double[hist.length][][];
        for (i2 = 0; i2 < hist.length; ++i2) {
            if (hist[i2] <= 0) continue;
            int size = 2 * i2 + 1;
            this.masks[i2] = new double[size][size];
            if (this.square) {
                ArrayOperations.Fill((double[][])this.masks[i2], (double)(1.0 / Math.pow(size, 2.0)));
                continue;
            }
            for (int y = 0; y < size; ++y) {
                for (int x = 0; x < size; ++x) {
                    this.masks[i2][y][x] = this.metric.Distance((double)x, (double)y, 0.0, (double)i2, (double)i2, 0.0) <= (double)i2 ? 1.0 : 0.0;
                }
            }
            ArrayArithmetic.Divide((double[][])this.masks[i2], (double)this.AF.Sum(this.masks[i2]), (double[][])this.masks[i2]);
        }
        this.percentages = new double[this.maxradius + 1];
        double pmax = 1.0;
        double pmin = 0.3;
        double alpha = (pmin - pmax) / (double)(this.maxradius - 1);
        double beta = pmax - alpha;
        for (i2 = 1; i2 < this.percentages.length; ++i2) {
            this.percentages[i2] = (double)i2 * alpha + beta;
        }
    }

    @Override
    public double[][] Mask(int x, int y, int v) {
        return this.masks[this.radiusmap[y][x]];
    }

    @Override
    public int MaximumSize() {
        return this.maxradius;
    }
}

