/*
 * Decompiled with CFR 0.152.
 */
package softwares.cmm.ramis.queries;

import displays.Colors;
import filesAndFolders.fichiersTabules.FichierTabule;
import filesAndFolders.fichiersTabules.FichierTabuleTools;
import imageTiTi.ImageDrawer;
import imageTiTi.ImageIO;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.List;
import mathematics.metrics.Euclidian;
import utils.times.Chronometer;

public class QueriesProcessing {
    private int nbErrors;

    public FichierTabule Combo(FichierTabule ann, FichierTabule cha, int AnnotationReference, List<Integer> list, String path, boolean drawresult, boolean verbose, Chronometer Chrono) {
        this.nbErrors = 0;
        int marker = 0;
        if (Chrono != null) {
            System.out.print("Nettoyage des requetes (suppression des redondances ET des annotations imposees) : ");
            marker = Chrono.NewMarker();
        }
        FichierTabule annclean = this.Clean1(ann, list);
        if (Chrono != null) {
            System.out.print(ann.getNbSelected() + " annotations selected/deleted ( ");
            for (int i2 = 0; i2 < ann.Height(); ++i2) {
                if (!ann.isExcluded(i2)) continue;
                System.out.print(ann.getValueInt(i2, 0) + " ");
            }
            System.out.println(") " + Chrono.getTimeSinceMarker(marker) + "s");
            Chrono.FreeMarker(marker);
            System.out.print("Jointure des requetes : ");
            marker = Chrono.NewMarker();
        }
        FichierTabule result = this.Merge2(annclean, cha, AnnotationReference);
        if (Chrono != null) {
            System.out.println(Chrono.getTimeSinceMarker(marker) + "s");
            Chrono.FreeMarker(marker);
            System.out.println("Mise en correspondance des coordonnees : ");
            marker = Chrono.NewMarker();
        }
        this.FindVignettes3(result, path, drawresult, verbose);
        if (Chrono != null) {
            System.out.println("Finished in " + Chrono.getTimeSinceMarker(marker) + "s with " + this.nbErrors + " errors/exceptions.");
            Chrono.FreeMarker(marker);
        }
        annclean = null;
        return result;
    }

    public FichierTabule Clean1(FichierTabule file, List<Integer> list) {
        int y;
        int height = file.Height();
        int ColLame = file.ColumnNumber("Lame");
        int ColCenter = file.ColumnNumber("Center");
        int ColField = file.ColumnNumber("Field");
        int ColX1 = file.ColumnNumber("X1");
        int ColY1 = file.ColumnNumber("Y1");
        int ColX2 = file.ColumnNumber("X2");
        int ColY2 = file.ColumnNumber("Y2");
        int ColOp = file.ColumnNumber("Operator");
        Iterator<Integer> iter = list.iterator();
        file.ClearSelection();
        for (y = height - 1; y > 0; --y) {
            if (file.isSelected(y)) continue;
            String center = file.getValueString(y, ColCenter);
            int field = file.getValueInt(y, ColField);
            String lame = file.getValueString(y, ColLame);
            String operator = file.getValueString(y, ColOp);
            int x1 = file.getValueInt(y, ColX1);
            int y1 = file.getValueInt(y, ColY1);
            int x2 = file.getValueInt(y, ColX2);
            int y2 = file.getValueInt(y, ColY2);
            for (int x = y - 1; x >= 0; --x) {
                if (x1 != file.getValueInt(x, ColX1) || x2 != file.getValueInt(x, ColX2) || y1 != file.getValueInt(x, ColY1) || y2 != file.getValueInt(x, ColY2) || !lame.equalsIgnoreCase(file.getValueString(x, ColLame)) || !center.equalsIgnoreCase(file.getValueString(x, ColCenter)) || field != file.getValueInt(x, ColField) || !operator.equalsIgnoreCase(file.getValueString(x, ColOp))) continue;
                file.setSelected(x, true);
            }
        }
        while (iter.hasNext()) {
            int ann = iter.next();
            for (y = 0; y < height; ++y) {
                if (ann != file.getValueInt(y, 0)) continue;
                file.setSelected(y, true);
            }
        }
        file.ExcludeSelected();
        return FichierTabuleTools.DeleteExcludedRows(file);
    }

    public FichierTabule Merge2(FichierTabule ann, FichierTabule cha, int AnnotationReference) {
        int heightann = ann.Height();
        int heightcha = cha.Height();
        int ColDesc = cha.ColumnNumber("Descriptor");
        int ColChar = cha.ColumnNumber("Characteristic");
        FichierTabule res = null;
        int[] Types = null;
        String[] Names = null;
        String s = null;
        cha.SelectWhere(0, 0, AnnotationReference);
        int nb = cha.getNbSelected();
        nb = nb * 3 + 3;
        Types = new int[nb];
        Names = new String[nb];
        int x = 0;
        while (x < nb - 2) {
            if (x % 3 == 0) {
                Types[x] = 2;
                s = cha.getValueString(x / 3, 2);
                Names[x++] = s.substring(0);
                continue;
            }
            Types[x + 1] = 0;
            Types[x] = 0;
            Names[x++] = s.substring(0) + " SfP";
            Names[x++] = s.substring(0) + " SfC";
        }
        Types[nb - 3] = 0;
        Names[nb - 3] = "Vignette1";
        Types[nb - 2] = 0;
        Names[nb - 2] = "Vignette2";
        Types[nb - 1] = 2;
        Names[nb - 1] = "Comment";
        res = new FichierTabule(heightann, Types, "Characteristics");
        res.setColumnsNames(Names);
        for (int y = 0; y < heightann; ++y) {
            int annid = ann.getValueInt(y, 0);
            for (x = 0; x < heightcha; ++x) {
                if (cha.getValueInt(x, 0) != annid) continue;
                nb = res.ColumnNumber(cha.getValueString(x, ColDesc).substring(0));
                res.setValue(y, nb++, cha.getValueString(x, ColChar).substring(0));
                res.setValue(y, nb++, cha.getValueInt(x, ColChar + 1));
                res.setValue(y, nb++, cha.getValueInt(x, ColChar + 2));
                res.setValue(y, res.Width() - 1, cha.getValueString(x, ColChar + 3).substring(0));
            }
        }
        return FichierTabuleTools.MergeSideBySide(ann, res);
    }

    public void FindVignettes3(FichierTabule file, String path, boolean drawresult, boolean verbose) {
        int height = file.Height();
        String lame = null;
        String center = null;
        String ramis = null;
        int ColLame = file.ColumnNumber("Lame");
        int ColCenter = file.ColumnNumber("Center");
        int ColField = file.ColumnNumber("Field");
        int ColX1 = file.ColumnNumber("X1");
        int ColY1 = file.ColumnNumber("Y1");
        int ColX2 = file.ColumnNumber("X2");
        int ColY2 = file.ColumnNumber("Y2");
        int colpha = file.ColumnNumber("Phase");
        FichierTabule bb = null;
        Euclidian metric = new Euclidian();
        BufferedImage im = null;
        ImageDrawer draw = new ImageDrawer();
        for (int y = 0; y < height; ++y) {
            int bby2;
            int bbx2;
            int bby1;
            int bbx1;
            int x;
            int tmp;
            int anid = file.getValueInt(y, 0);
            center = file.getValueString(y, ColCenter);
            int field = file.getValueInt(y, ColField);
            lame = file.getValueString(y, ColLame);
            int x1 = file.getValueInt(y, ColX1);
            int y1 = file.getValueInt(y, ColY1);
            int x2 = file.getValueInt(y, ColX2);
            int y2 = file.getValueInt(y, ColY2);
            if (x1 > x2) {
                tmp = x1;
                x1 = x2;
                x2 = tmp;
            }
            if (y1 > y2) {
                tmp = y1;
                y1 = y2;
                y2 = tmp;
            }
            try {
                ramis = Integer.parseInt(lame.substring(6)) < 50 ? "RAMIS_13" : "RAMIS_15";
                bb = new FichierTabule(path + "/" + ramis + "/" + lame + "/Center_" + center + "/Field_" + (field < 10 ? "0" : "") + field + "/Informations/" + lame + "_" + center + "_" + (field < 10 ? "0" : "") + field + "_BoundingBoxes.txt", false);
            }
            catch (Error E) {
                file.setValue(y, file.Width() - 2, 0);
                file.setValue(y, file.Width() - 3, 0);
                System.out.println("Error - " + this.nbErrors++ + " => " + E.getMessage() + "\n");
                continue;
            }
            catch (Exception E) {
                file.setValue(y, file.Width() - 2, 0);
                file.setValue(y, file.Width() - 3, 0);
                System.out.println("Exception - " + this.nbErrors++ + " => " + E.getMessage() + "\n");
                continue;
            }
            if (drawresult) {
                try {
                    im = ImageIO.Read(path + "/" + ramis + "/" + lame + "/Center_" + center + "/Field_" + (field < 10 ? "0" : "") + field + "/Segmented/" + lame + "_" + center + "_" + (field < 10 ? "0" : "") + field + "_Contours_ColourSegment.png");
                    ImageDrawer.Rectangle(im, x1, y1, x2, y2, 0, Colors.CYAN);
                }
                catch (Exception E) {
                    System.out.println("Exception - " + this.nbErrors++ + " => " + E.getMessage() + "\n");
                }
            }
            if (verbose) {
                System.out.println(" - " + y + " - Phase = " + file.getValueString(y, colpha) + "   (" + x1 + " " + y1 + ")  (" + x2 + " " + y2 + ")");
            }
            int nb = 0;
            int h = bb.Height();
            for (x = 0; x < h; ++x) {
                bbx1 = bb.getValueInt(x, 0);
                bby1 = bb.getValueInt(x, 1);
                bbx2 = bb.getValueInt(x, 2);
                if (!this.isInside((bbx1 + bbx2) / 2, (bby1 + (bby2 = bb.getValueInt(x, 3))) / 2, x1, y1, x2, y2)) continue;
                ++nb;
            }
            int dist2 = -1;
            int dist1 = -1;
            int vig2 = -1;
            int vig1 = -1;
            for (x = 0; x < h; ++x) {
                bbx1 = bb.getValueInt(x, 0);
                bby1 = bb.getValueInt(x, 1);
                bbx2 = bb.getValueInt(x, 2);
                if (!this.isInside((bbx1 + bbx2) / 2, (bby1 + (bby2 = bb.getValueInt(x, 3))) / 2, x1, y1, x2, y2)) continue;
                int d = (int)metric.Distance((double)(bbx1 + bbx2) / 2.0, (double)(bby1 + bby2) / 2.0, 0.0, (double)(x1 + x2) / 2.0, (double)(y1 + y2) / 2.0, 0.0);
                int p = this.Percentage(bbx1, bby1, bbx2, bby2, x1, y1, x2, y2);
                if (nb == 1) {
                    dist1 = d;
                    vig1 = x;
                } else if (p >= 60) {
                    if (vig1 == -1) {
                        dist1 = d;
                        vig1 = x;
                    } else if (d < dist1) {
                        dist2 = dist1;
                        vig2 = vig1;
                        dist1 = d;
                        vig1 = x;
                    } else if (vig2 == -1 || d < dist2) {
                        dist2 = d;
                        vig2 = x;
                    }
                }
                if (verbose) {
                    System.out.println("Trouve " + (x + 1) + " : (" + bbx1 + " " + bby1 + ")  (" + bbx2 + " " + bby2 + ")  =>  distance = " + d + ", percentage = " + p);
                }
                if (!drawresult || im == null) continue;
                ImageDrawer.Rectangle(im, bbx1, bby1, bbx2, bby2, 0, Colors.YELLOW);
            }
            bbx1 = bb.getValueInt(vig1, 0);
            bby1 = bb.getValueInt(vig1, 1);
            bbx2 = bb.getValueInt(vig1, 2);
            bby2 = bb.getValueInt(vig1, 3);
            if (drawresult && im != null) {
                ImageDrawer.Rectangle(im, bbx1, bby1, bbx2, bby2, 0, Colors.RED);
            }
            file.setValue(y, file.Width() - 3, vig1 + 1);
            if (vig2 != -1) {
                bbx1 = bb.getValueInt(vig2, 0);
                bby1 = bb.getValueInt(vig2, 1);
                bbx2 = bb.getValueInt(vig2, 2);
                bby2 = bb.getValueInt(vig2, 3);
                if (drawresult && im != null) {
                    ImageDrawer.Rectangle(im, bbx1, bby1, bbx2, bby2, 0, Colors.RED);
                }
                file.setValue(y, file.Width() - 2, vig2 + 1);
            } else {
                file.setValue(y, file.Width() - 2, 0);
            }
            if (drawresult) {
                try {
                    ImageIO.Write(im, (anid < 10 ? "0" : "") + anid + "_" + lame + "_" + center + "_" + (field < 10 ? "0" : "") + field + "_" + file.getValueString(y, colpha) + ".png", 6);
                }
                catch (Exception E) {
                    System.out.println("Exception - " + this.nbErrors++ + " => " + E.getMessage() + "\n");
                }
            }
            if (verbose) {
                System.out.println("solution : " + (vig1 + 1) + (String)(vig2 != -1 ? " & " + (vig2 + 1) : "") + "\n");
            }
            center = null;
            lame = null;
        }
    }

    private boolean isInside(int bx, int by, int x1, int y1, int x2, int y2) {
        return x1 <= bx && bx <= x2 && y1 <= by && by <= y2;
    }

    private int Percentage(int bx1, int by1, int bx2, int by2, int x1, int y1, int x2, int y2) {
        if (bx1 > bx2 || by1 > by2 || x1 > x2 || y1 > y2) {
            throw new IllegalArgumentException("Must not occured: not crescent coordinates.");
        }
        int surface = (bx2 - bx1 + 1) * (by2 - by1 + 1);
        int nb = 0;
        for (int y = by1; y <= by2; ++y) {
            for (int x = bx1; x <= bx2; ++x) {
                if (!this.isInside(x, y, x1, y1, x2, y2)) continue;
                ++nb;
            }
        }
        return (int)((double)nb / (double)surface * 100.0);
    }

    public int TestRedondancesOfCoordinates(FichierTabule file) {
        int nb = 0;
        int height = file.Height();
        int ColLame = file.ColumnNumber("Lame");
        int ColCenter = file.ColumnNumber("Center");
        int ColField = file.ColumnNumber("Field");
        int ColX1 = file.ColumnNumber("X1");
        int ColY1 = file.ColumnNumber("Y1");
        int ColX2 = file.ColumnNumber("X2");
        int ColY2 = file.ColumnNumber("Y2");
        for (int y = 0; y < height - 1; ++y) {
            String center = file.getValueString(y, ColCenter);
            int field = file.getValueInt(y, ColField);
            String lame = file.getValueString(y, ColLame);
            int x1 = file.getValueInt(y, ColX1);
            int y1 = file.getValueInt(y, ColY1);
            int x2 = file.getValueInt(y, ColX2);
            int y2 = file.getValueInt(y, ColY2);
            for (int x = y + 1; x < height; ++x) {
                if (x1 != file.getValueInt(x, ColX1) || x2 != file.getValueInt(x, ColX2) || y1 != file.getValueInt(x, ColY1) || y2 != file.getValueInt(x, ColY2) || !lame.equalsIgnoreCase(file.getValueString(x, ColLame)) || !center.equalsIgnoreCase(file.getValueString(x, ColCenter)) || field != file.getValueInt(x, ColField)) continue;
                ++nb;
                System.out.println("Annotations " + file.getValueInt(y, 0) + " and " + file.getValueInt(x, 0) + " equals.");
            }
        }
        return nb;
    }
}

