/*
 * Decompiled with CFR 0.152.
 */
package softwares.cmm.ramis.queries;

import arrayTiTi.ArrayTools;
import filesAndFolders.fichiersTabules.FichierTabule;
import filesAndFolders.fichiersTabules.FichierTabuleTools;
import java.util.Iterator;
import java.util.List;

public class MergeQueriesAndCharacteristics {
    private int nbErrors = -1;
    private FichierTabule filefound = null;
    private int rowfound = -1;

    public FichierTabule Merge(List<FichierTabule> listchar, FichierTabule ann) {
        int x;
        int middle;
        if (!this.CheckFiles(listchar)) {
            throw new IllegalArgumentException("List contains different types of files (check file failed).");
        }
        System.out.print("Merging annotations and estracted characteristics => ");
        int colLame = ann.ColumnNumber("Lame");
        int colCenter = ann.ColumnNumber("Center");
        int colField = ann.ColumnNumber("Field");
        int colVig1 = ann.ColumnNumber("Vignette1");
        int colVig2 = ann.ColumnNumber("Vignette2");
        this.nbErrors = 0;
        ann.SelectWhere(colVig1, 5, 0);
        ann.SelectFromSelectionWhere(colVig2, 5, 0);
        int nbDoubles = ann.getNbSelected();
        ann.SelectWhere(colVig1, 0, 0);
        int nbNulles = ann.getNbSelected();
        int[] Types = this.FillTypes(listchar.get(0), ann.ColumnType());
        FichierTabule result = new FichierTabule(ann.Height() - nbNulles + nbDoubles, Types, "Result_MergeQueriesAndChars.txt");
        int nb = middle = listchar.get(0).Width() - 6;
        for (x = 0; x < nb; ++x) {
            result.setColumnName(x, listchar.get(0).getColumnName(x));
        }
        for (x = 0; x < ann.Width(); ++x) {
            result.setColumnName(nb++, ann.getColumnName(x));
        }
        result.setColumnName(result.ColumnNumber("Vignette1"), "Vignette");
        int colResVig1 = result.ColumnNumber("Vignette");
        int colResVig2 = result.ColumnNumber("Vignette2");
        nb = 0;
        for (int y = 0; y < ann.Height(); ++y) {
            if (ann.getValueInt(y, colVig1) <= 0) continue;
            boolean res = this.FindFileAndRow(listchar, ann.getValueString(y, colLame), Integer.parseInt(ann.getValueString(y, colCenter)), ann.getValueInt(y, colField), ann.getValueInt(y, colVig1));
            if (res) {
                for (x = 0; x < middle; ++x) {
                    result.setValue(nb, x, this.filefound.getValueDouble(this.rowfound, x));
                }
            } else {
                for (x = 0; x < middle; ++x) {
                    result.setValue(nb, x, 0.0);
                }
                result.setSelected(nb, true);
                ++this.nbErrors;
            }
            block15: for (x = 0; x < ann.Width(); ++x) {
                switch (Types[middle + x]) {
                    case 1: {
                        result.setValue(nb, middle + x, ann.getValueDouble(y, x));
                        continue block15;
                    }
                    case 0: {
                        result.setValue(nb, middle + x, ann.getValueInt(y, x));
                        continue block15;
                    }
                    case 2: {
                        result.setValue(nb, middle + x, ann.getValueString(y, x));
                        continue block15;
                    }
                    default: {
                        throw new Error("Default: must not occured.");
                    }
                }
            }
            ++nb;
            if (ann.getValueInt(y, colVig2) <= 0) continue;
            res = this.FindFileAndRow(listchar, ann.getValueString(y, colLame), Integer.parseInt(ann.getValueString(y, colCenter)), ann.getValueInt(y, colField), ann.getValueInt(y, colVig2));
            if (res) {
                for (x = 0; x < middle; ++x) {
                    result.setValue(nb, x, this.filefound.getValueDouble(this.rowfound, x));
                }
            } else {
                for (x = 0; x < middle; ++x) {
                    result.setValue(nb, x, 0.0);
                }
                result.setSelected(nb, true);
                ++this.nbErrors;
            }
            block18: for (x = 0; x < ann.Width(); ++x) {
                switch (Types[middle + x]) {
                    case 1: {
                        result.setValue(nb, middle + x, ann.getValueDouble(y, x));
                        continue block18;
                    }
                    case 0: {
                        result.setValue(nb, middle + x, ann.getValueInt(y, x));
                        continue block18;
                    }
                    case 2: {
                        result.setValue(nb, middle + x, ann.getValueString(y, x));
                        continue block18;
                    }
                    default: {
                        throw new Error("Default: must not occured.");
                    }
                }
            }
            int tmp = result.getValueInt(nb, colResVig1);
            result.setValue(nb, colResVig1, result.getValueInt(nb, colResVig2));
            result.setValue(nb, colResVig2, tmp);
            ++nb;
        }
        if (nb != result.Height()) {
            throw new Error("Souci => nb != height.");
        }
        System.out.println("Program finished successfully. Generated " + nb + " rows with " + this.nbErrors + " error(s).");
        System.out.flush();
        if (this.nbErrors > 0) {
            System.err.println("Errors occured => deleting row(s).");
            System.err.flush();
            result.ExcludeSelected();
            return FichierTabuleTools.DeleteColumn(FichierTabuleTools.DeleteExcludedRows(result), colResVig2);
        }
        return FichierTabuleTools.DeleteColumn(result, colResVig2);
    }

    private boolean CheckFiles(List<FichierTabule> list) {
        Iterator<FichierTabule> iter = list.iterator();
        int[] types = iter.next().ColumnType();
        while (iter.hasNext()) {
            if (ArrayTools.AreEqual((int[])types, (int[])iter.next().ColumnType())) continue;
            return false;
        }
        iter = null;
        types = null;
        return true;
    }

    private int[] FillTypes(FichierTabule list, int[] types) {
        int size = list.Width() - 6;
        int[] T = list.ColumnType();
        int[] result = new int[size + types.length];
        for (int i2 = 0; i2 < size; ++i2) {
            result[i2] = T[i2];
        }
        int nb = size;
        for (int result[nb++] : types) {
        }
        return result;
    }

    private boolean FindFileAndRow(List<FichierTabule> list, String lame, int center, int field, int vignette) {
        Iterator<FichierTabule> iter = list.iterator();
        FichierTabule file = null;
        this.filefound = null;
        this.rowfound = -1;
        while (iter.hasNext()) {
            file = iter.next();
            if (!file.getValueString(0, file.ColumnNumber("Lame")).equalsIgnoreCase(lame)) continue;
            int colcenter = file.ColumnNumber("Center");
            int colfield = file.ColumnNumber("Field");
            int colvig = file.ColumnNumber("Number");
            for (int y = 0; y < file.Height(); ++y) {
                if (!file.getValueString(y, colcenter).contains((center < 10 ? "0" : "") + center) || !file.getValueString(y, colfield).contains((field < 10 ? "0" : "") + field) || file.getValueInt(y, colvig) != vignette) continue;
                this.filefound = file;
                this.rowfound = y;
                iter = null;
                file = null;
                return true;
            }
        }
        return false;
    }
}

