/*
 * Decompiled with CFR 0.152.
 */
package softwares.cmm.ramis.organize;

import filesAndFolders.FilesFolders;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import utils.times.Chronometer;

public class CleanAndSave {
    private int nbErrors = -1;

    public void Launch(File RAMIS, File dest, List<String> keywords, Chronometer Chrono) {
        if (!RAMIS.isDirectory()) {
            throw new IllegalArgumentException("This file is not a directory.");
        }
        File[] listLames = RAMIS.listFiles();
        int marker = 0;
        if (Chrono != null) {
            System.out.print("Clean and Save... ");
            marker = Chrono.NewMarker();
        }
        if (!dest.exists()) {
            dest.mkdirs();
        }
        this.nbErrors = 0;
        for (int l = 0; l < listLames.length; ++l) {
            if (!listLames[l].getName().contains("AIM_00")) continue;
            if (listLames[l].isFile()) {
                FilesFolders.CopyFile(listLames[l], dest);
                continue;
            }
            File[] listCenters = listLames[l].listFiles();
            for (int c = 0; c < listCenters.length; ++c) {
                if (!listCenters[c].isDirectory() || !listCenters[c].getName().contains("Center_")) continue;
                File[] listFields = listCenters[c].listFiles();
                for (int f = 0; f < listFields.length; ++f) {
                    if (!listFields[f].isDirectory() || !listFields[f].getName().contains("Field_")) continue;
                    File[] listFolders = listFields[f].listFiles();
                    File current = new File(dest.getAbsolutePath() + "/" + listLames[l].getName() + "/" + listCenters[c].getName() + "/" + listFields[f].getName());
                    if (!current.exists()) {
                        current.mkdirs();
                    }
                    for (int i2 = 0; i2 < listFolders.length; ++i2) {
                        if (!listFolders[i2].isDirectory() || this.ToDelete(listFolders[i2].getName(), keywords) || FilesFolders.CopyFolder(listFolders[i2], current)) continue;
                        System.err.println(++this.nbErrors + " - Copy failed");
                    }
                    FilesFolders.FindAndDelete(current, 0, "_00.");
                    current = null;
                }
            }
        }
        if (Chrono != null) {
            System.out.println("done " + Chrono.getTimeSinceMarker(marker));
            Chrono.FreeMarker(marker);
        }
        listLames = null;
        System.err.println("Program finished with " + this.nbErrors + " error(s)/exception(s).");
    }

    private boolean ToDelete(String name, List<String> keywords) {
        Iterator<String> iter = keywords.iterator();
        while (iter.hasNext()) {
            if (!name.contains(iter.next())) continue;
            return true;
        }
        return false;
    }
}

