/*
 * Decompiled with CFR 0.152.
 */
package softwares.cmm.ramis.characterize;

import imageTiTi.SubImage;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import measures.cclh.ConnectedComponentLabeling;
import measures.cclh.FifoCcl;
import morphee.BlackTopHat;
import morphee.Close;
import morphee.Dilate;
import morphee.StructuringElement;
import morphee.geodesic.CloseHole;
import morphee.geodesic.OpeningByReconstruction;
import processing.filters.DynamicExpansion;
import processing.thresholding.Binary;
import utils.times.Chronometer;

public class NucleolesExtractor {
    private int nbErrors = -1;
    private DataOutputStream Out = null;
    private Binary binary = new Binary(1);
    private ConnectedComponentLabeling ccl = new FifoCcl();
    private DynamicExpansion dynexp = new DynamicExpansion();
    private StructuringElement disk4 = new StructuringElement(new Object[]{4, -2});
    private StructuringElement disk5 = new StructuringElement(new Object[]{5, -2});
    private StructuringElement square1 = new StructuringElement(new Object[]{1, -1});
    private StructuringElement square2 = new StructuringElement(new Object[]{2, -1});
    private StructuringElement square3 = new StructuringElement(new Object[]{3, -1});
    private BlackTopHat bth = new BlackTopHat();
    private Close close = new Close();
    private CloseHole closehole = new CloseHole();
    private Dilate dilate = new Dilate();
    private OpeningByReconstruction oprec = new OpeningByReconstruction();

    public void Extract(File FileIn, File FileOut, int Algo, int nbCPU, Chronometer Chrono) {
        int i2;
        if (!FileIn.isDirectory()) {
            throw new IllegalArgumentException("File FileIn is not a directory.");
        }
        int marker = 0;
        File[] list = null;
        File file = null;
        if (Chrono != null) {
            System.out.print("Nucleoles detection : ");
            marker = Chrono.NewMarker();
        }
        this.nbErrors = 0;
        try {
            if (!FileOut.exists()) {
                FileOut.mkdirs();
            }
            if (!(file = new File(FileOut.getAbsolutePath() + "/Results_NucleiDetection.txt")).exists()) {
                file.createNewFile();
            }
            this.Out = new DataOutputStream(new FileOutputStream(file.getAbsolutePath()));
            file = null;
            this.WriteColumnNames();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Error(e.getMessage());
        }
        file = new File(FileIn.getAbsolutePath() + "/Nucleoles/");
        list = file.listFiles();
        for (i2 = 0; i2 < list.length; ++i2) {
            if (!list[i2].getName().contains(".png")) continue;
            if (Algo == 1) {
                this.ReadCharacterizeWrite(list[i2].getAbsoluteFile(), FileOut, list[i2].getName().substring(0, 8), list[i2].getName().substring(9, 11), list[i2].getName().substring(12, 14), list[i2].getName().substring(17, 19), "Nucleoles", nbCPU);
                continue;
            }
            if (Algo == 2) {
                this.ReadCharacterizeTHWrite(list[i2].getAbsoluteFile(), FileOut, list[i2].getName().substring(0, 8), list[i2].getName().substring(9, 11), list[i2].getName().substring(12, 14), list[i2].getName().substring(17, 19), "Nucleoles", nbCPU);
                continue;
            }
            throw new IllegalArgumentException("Bad value of Algo (1 or 2 wished).");
        }
        file = null;
        list = null;
        file = new File(FileIn.getAbsolutePath() + "/Non Nucleoles/");
        list = file.listFiles();
        for (i2 = 0; i2 < list.length; ++i2) {
            if (!list[i2].getName().contains(".png")) continue;
            if (Algo == 1) {
                this.ReadCharacterizeWrite(list[i2].getAbsoluteFile(), FileOut, list[i2].getName().substring(0, 8), list[i2].getName().substring(9, 11), list[i2].getName().substring(12, 14), list[i2].getName().substring(17, 19), "Nucleoles", nbCPU);
                continue;
            }
            if (Algo == 2) {
                this.ReadCharacterizeTHWrite(list[i2].getAbsoluteFile(), FileOut, list[i2].getName().substring(0, 8), list[i2].getName().substring(9, 11), list[i2].getName().substring(12, 14), list[i2].getName().substring(17, 19), "Nucleoles", nbCPU);
                continue;
            }
            throw new IllegalArgumentException("Bad value of Algo (1 or 2 wished).");
        }
        file = null;
        list = null;
        if (Chrono != null) {
            System.out.println(Chrono.getTimeSinceMarker(marker));
            Chrono.FreeMarker(marker);
        }
        System.err.println("Program finished with " + this.nbErrors + " error(s)/exception(s).");
    }

    private void ReadCharacterizeWrite(File name, File FileOut, String Lame, String Center2, String Field2, String Number2, String Folder, int nbCPU) {
        throw new UnsupportedOperationException("To upgrade");
    }

    private void ReadCharacterizeTHWrite(File name, File FileOut, String Lame, String Center2, String Field2, String Number2, String Folder, int nbCPU) {
        throw new UnsupportedOperationException("To upgrade");
    }

    private double Average(BufferedImage source) {
        int width = source.getWidth();
        int height = source.getHeight();
        int nb = 0;
        int sum = 0;
        WritableRaster wr = source.getRaster();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (wr.getSample(x, y, 0) <= 0) continue;
                sum += wr.getSample(x, y, 0);
                ++nb;
            }
        }
        wr = null;
        return (double)sum / (double)nb;
    }

    private double Average(BufferedImage source, SubImage sub) {
        int width = sub.SubImage().getWidth();
        int height = sub.SubImage().getHeight();
        int minx = sub.getMinx();
        int miny = sub.getMiny();
        int nb = 0;
        int sum = 0;
        BufferedImage subim = sub.SubImage();
        WritableRaster wr = source.getRaster();
        WritableRaster wrsubim = subim.getRaster();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (wrsubim.getSample(x, y, 0) <= 0) continue;
                sum += wr.getSample(x + minx, y + miny, 0);
                ++nb;
            }
        }
        wr = null;
        wrsubim = null;
        subim = null;
        return (double)sum / (double)nb;
    }

    private double Variance(BufferedImage source, SubImage sub, double average) {
        int width = sub.SubImage().getWidth();
        int height = sub.SubImage().getHeight();
        int minx = sub.getMinx();
        int miny = sub.getMiny();
        double nb = 0.0;
        double sum = 0.0;
        BufferedImage subim = sub.SubImage();
        WritableRaster wr = source.getRaster();
        WritableRaster wrsubim = subim.getRaster();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (wrsubim.getSample(x, y, 0) <= 0) continue;
                sum += Math.pow(wr.getSampleDouble(x + minx, y + miny, 0) - average, 2.0);
                nb += 1.0;
            }
        }
        wr = null;
        wrsubim = null;
        return Math.sqrt(sum / nb);
    }

    private void WriteColumnNames() {
        try {
            this.Out.write(String.valueOf("Size AvIn AvOut DeltaAv VarIn VarOut Nucleole Image Lame Center Field Nucleus Number\n").getBytes("ASCII"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (Error e) {
            e.printStackTrace();
        }
    }
}

