/*
 * Decompiled with CFR 0.152.
 */
package softwares.cmm.ramis.characterize;

import imageTiTi.ImageIO;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import mathematics.metrics.Euclidian;
import mathematics.metrics.Metric;
import measures.cclh.ConnectedComponentLabeling;
import measures.cclh.FifoCcl;
import utils.times.Chronometer;

public class CharacterizeCentrosomes {
    private int nbErrors = -1;
    private String[] FeaturesNames = new String[]{"Number", "NumberInside", "SizeAv", "SizeMin", "SizeMax", "DistanceAv", "DistanceMin", "DistanceMax", "DistZAv", "DistZMin", "DistZMax"};
    private double[] Features = new double[11];
    private DataOutputStream Out = null;
    private ConnectedComponentLabeling ccl = new FifoCcl();
    private BufferedImage zfocus = null;
    private Metric metric = new Euclidian();

    public void Extract(File RAMIS, File Result, Chronometer Chrono) throws IOException {
        if (!RAMIS.isDirectory()) {
            throw new IllegalArgumentException("This file is not a directory.");
        }
        File[] listLames = RAMIS.listFiles();
        int marker = 0;
        if (Chrono != null) {
            System.out.print("Extraction des caract\ufffdristiques : ");
            marker = Chrono.NewMarker();
        }
        try {
            if (!Result.exists()) {
                Result.createNewFile();
            }
            this.Out = new DataOutputStream(new FileOutputStream(Result));
            this.WriteColumnNames();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Error(e.getMessage());
        }
        this.nbErrors = 0;
        for (int l = 0; l < listLames.length; ++l) {
            if (!listLames[l].isDirectory()) continue;
            this.ExtractFromLame(listLames[l], Result, null);
        }
        if (Chrono != null) {
            System.out.println(Chrono.getTimeSinceMarker(marker));
            Chrono.FreeMarker(marker);
        }
        listLames = null;
        System.err.println("Program finished with " + this.nbErrors + " error(s)/exception(s).");
    }

    public void ExtractFromLame(File Lame, File Result, Chronometer Chrono) throws IOException {
        if (!Lame.isDirectory()) {
            throw new IllegalArgumentException("This file is not a directory.");
        }
        File[] listCenters = Lame.listFiles();
        File[] listFields = null;
        File[] listFolders = null;
        File[] listVignettes = null;
        int marker = 0;
        if (Chrono != null) {
            System.out.print("Extraction des caract\ufffdristiques d'une lame : ");
            marker = Chrono.NewMarker();
        }
        try {
            if (!Result.exists()) {
                Result.createNewFile();
            }
            this.Out = new DataOutputStream(new FileOutputStream(Result));
            this.WriteColumnNames();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Error(e.getMessage());
        }
        this.nbErrors = 0;
        for (int c = 0; c < listCenters.length; ++c) {
            if (!listCenters[c].isDirectory()) continue;
            listFields = listCenters[c].listFiles();
            for (int f = 0; f < listFields.length; ++f) {
                if (!listFields[f].isDirectory()) continue;
                try {
                    listFolders = listFields[f].listFiles();
                    this.zfocus = ImageIO.Read(listFields[f].getAbsolutePath() + "/ZProjection/" + Lame.getName() + "_" + listCenters[c].getName().substring(7) + "_" + listFields[f].getName().substring(6) + "_c_WindexMaxZskelproj_evol.png");
                    for (int r = 0; r < listFolders.length; ++r) {
                        if (!listFolders[r].isDirectory() || !listFolders[r].getName().contains("_c_Vignettes")) continue;
                        listVignettes = listFolders[r].listFiles();
                        for (int v = 0; v < listVignettes.length; ++v) {
                            if (!listVignettes[v].getName().contains(".png")) continue;
                            this.Characterize(listFields[f].getAbsolutePath(), Lame.getName(), listCenters[c].getName(), listFields[f].getName(), listVignettes[v].getName().substring(listVignettes[v].getName().length() - 6, listVignettes[v].getName().length() - 4));
                        }
                    }
                    listFolders = null;
                    this.zfocus = null;
                    continue;
                }
                catch (Error E) {
                    Arrays.fill(this.Features, 0.0);
                    System.err.println("Error " + this.nbErrors++ + "(computation) => ");
                    E.printStackTrace();
                    continue;
                }
                catch (Exception E) {
                    Arrays.fill(this.Features, 0.0);
                    System.err.println("Exception " + this.nbErrors++ + "(computation) => ");
                    E.printStackTrace();
                }
            }
            listFields = null;
        }
        listCenters = null;
        if (Chrono != null) {
            System.out.println(Chrono.getTimeSinceMarker(marker));
            Chrono.FreeMarker(marker);
        }
        System.err.println("Program finished with " + this.nbErrors + " error(s)/exception(s).");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void Characterize(String PathField, String Lame, String Center2, String Field2, String Number2) {
        int i2;
        BufferedImage adn = null;
        BufferedImage centrosome = null;
        int[] label = null;
        int[] sizes = null;
        boolean[] in = null;
        double[][] dist = null;
        double[] zave = null;
        try {
            Arrays.fill(this.Features, 0.0);
            WritableRaster wrfocus = this.zfocus.getRaster();
            adn = ImageIO.Read(PathField + "/Marker_d_Vignettes/" + Lame + "_" + Center2.substring(7) + "_" + Field2.substring(6) + "_D_" + Number2 + ".png");
            WritableRaster wradn = adn.getRaster();
            centrosome = ImageIO.Read(PathField + "/Marker_c_Vignettes/" + Lame + "_" + Center2.substring(7) + "_" + Field2.substring(6) + "_C_" + Number2 + ".png");
            int width = centrosome.getWidth();
            int height = centrosome.getHeight();
            this.ccl.Label(centrosome, 0, true);
            int nbccl = this.ccl.ConnectedComponentsNumber();
            if (nbccl > 0) {
                int j;
                int x;
                int y;
                label = this.ccl.Labels1D();
                in = new boolean[nbccl];
                Arrays.fill(in, false);
                sizes = new int[nbccl];
                Arrays.fill(sizes, 0);
                dist = new double[nbccl][nbccl];
                Arrays.fill((Object[])dist, (Object)Double.MAX_VALUE);
                zave = new double[nbccl];
                Arrays.fill(zave, 0.0);
                int pos = 0;
                for (y = 0; y < height; ++y) {
                    x = 0;
                    while (x < width) {
                        if (0 < label[pos]) {
                            if (wradn.getSample(x, y, 0) > 0) {
                                in[label[pos] - 1] = true;
                            }
                            int n = label[pos] - 1;
                            sizes[n] = sizes[n] + 1;
                            int n2 = label[pos] - 1;
                            zave[n2] = zave[n2] + wrfocus.getSampleDouble(x, y, 0);
                        }
                        ++x;
                        ++pos;
                    }
                }
                for (y = 0; y < height; ++y) {
                    for (x = 0; x < width; ++x) {
                        if (0 >= label[pos]) continue;
                        for (i2 = 0; i2 < height; ++i2) {
                            for (j = 0; j < width; ++j) {
                                if (label[i2 * width + j] <= 0 || !(this.metric.Distance((double)x, (double)y, 0.0, (double)j, (double)i2, 0.0) < dist[label[y * width + x] - 1][label[i2 * width + j] - 1])) continue;
                                dist[label[y * width + x] - 1][label[i2 * width + j] - 1] = this.metric.Distance((double)x, (double)y, 0.0, (double)j, (double)i2, 0.0);
                            }
                        }
                    }
                }
                int nbdist = 0;
                double mindist = Double.MAX_VALUE;
                double maxdist = 0.0;
                for (y = 0; y < nbccl; ++y) {
                    for (x = 0; x < nbccl; ++x) {
                        if (x == y) continue;
                        if (dist[y][x] < mindist) {
                            mindist = dist[y][x];
                        }
                        if (dist[y][x] > maxdist) {
                            maxdist = dist[y][x];
                        }
                        this.Features[5] = this.Features[5] + dist[y][x];
                        ++nbdist;
                    }
                }
                this.Features[0] = nbccl;
                double minsize = Double.MAX_VALUE;
                double maxsize = 0.0;
                for (i2 = 0; i2 < nbccl; ++i2) {
                    if (in[i2]) {
                        this.Features[1] = this.Features[1] + 1.0;
                    }
                    this.Features[2] = this.Features[2] + (double)sizes[i2];
                    if ((double)sizes[i2] < minsize) {
                        minsize = sizes[i2];
                    }
                    if (maxsize < (double)sizes[i2]) {
                        maxsize = sizes[i2];
                    }
                    int n = i2;
                    zave[n] = zave[n] / (double)sizes[i2];
                }
                int nbzave = 0;
                double minzave = Double.MAX_VALUE;
                double maxzave = 0.0;
                for (i2 = 0; i2 < nbccl - 1; ++i2) {
                    for (j = i2 + 1; j < nbccl; ++j) {
                        double zdist = Math.abs(zave[i2] - zave[j]);
                        this.Features[8] = this.Features[8] + zdist;
                        if (zdist < minzave) {
                            minzave = zdist;
                        }
                        if (maxzave < zdist) {
                            maxzave = zdist;
                        }
                        ++nbzave;
                    }
                }
                this.Features[2] = this.Features[2] / (double)nbccl;
                this.Features[3] = minsize;
                this.Features[4] = maxsize;
                if (nbccl > 1) {
                    this.Features[5] = this.Features[5] / (double)nbdist;
                    this.Features[6] = mindist;
                    this.Features[7] = maxdist;
                    this.Features[8] = this.Features[8] / (double)nbzave;
                    this.Features[9] = minzave;
                    this.Features[10] = maxzave;
                } else {
                    this.Features[10] = 0.0;
                    this.Features[9] = 0.0;
                    this.Features[8] = 0.0;
                    this.Features[7] = 0.0;
                    this.Features[6] = 0.0;
                    this.Features[5] = 0.0;
                }
            }
        }
        catch (Error E) {
            Arrays.fill(this.Features, 0.0);
            System.err.println("Error " + this.nbErrors++ + "(computation) => ");
            E.printStackTrace();
        }
        catch (Exception E) {
            Arrays.fill(this.Features, 0.0);
            System.err.println("Exception " + this.nbErrors++ + "(computation) => ");
            E.printStackTrace();
        }
        finally {
            adn = null;
            centrosome = null;
            label = null;
            dist = null;
            sizes = null;
            zave = null;
        }
        try {
            for (i2 = 0; i2 < this.Features.length; ++i2) {
                this.Out.write(String.valueOf(this.Features[i2] + " ").getBytes("ASCII"));
            }
            this.Out.write(String.valueOf(Lame + Center2.substring(6) + Field2.substring(5) + "_C_" + Number2 + ".png " + Lame + " " + Center2 + " " + Field2 + " C " + Number2 + "\n").getBytes("ASCII"));
        }
        catch (Error E) {
            System.err.println("Error " + this.nbErrors++ + "(writting) => ");
            E.printStackTrace();
        }
        catch (Exception E) {
            System.err.println("Exception " + this.nbErrors++ + "(writting) => ");
            E.printStackTrace();
        }
    }

    private void WriteColumnNames() {
        try {
            for (int i2 = 0; i2 < this.FeaturesNames.length; ++i2) {
                this.Out.write(String.valueOf(this.FeaturesNames[i2] + " ").getBytes("ASCII"));
            }
            this.Out.write(String.valueOf("Image Lame Center Field Marker Number\n").getBytes("ASCII"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (Error e) {
            e.printStackTrace();
        }
    }
}

