/*
 * Decompiled with CFR 0.152.
 */
package softwares.cmm.ramis.characterize;

import characterization.textures.BasicTexturalFeatures2;
import imageTiTi.ImageIO;
import java.awt.image.BufferedImage;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import utils.times.Chronometer;

public class CharacterizeCells2 {
    private final int TEXTURAL_FEATURES = 0;
    private int nbErrors = -1;
    private int CurrentAction = -1;
    private String[] FeaturesNames = null;
    private double[] Features = null;
    private DataOutputStream Out = null;
    private BasicTexturalFeatures2 btf = null;

    public void Extract(File RAMIS, String MarkerMask, String MarkerTexture, File Result, Chronometer Chrono) {
        if (!RAMIS.isDirectory()) {
            throw new IllegalArgumentException("This file is not a directory.");
        }
        File[] listLames = RAMIS.listFiles();
        int marker = 0;
        if (Chrono != null) {
            System.out.print("Extraction des caracteristiques : ");
            marker = Chrono.NewMarker();
        }
        try {
            if (!Result.exists()) {
                Result.createNewFile();
            }
            this.Out = new DataOutputStream(new FileOutputStream(Result));
            this.WriteColumnNames();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Error(e.getMessage());
        }
        this.nbErrors = 0;
        for (int l = 0; l < listLames.length; ++l) {
            if (!listLames[l].isDirectory()) continue;
            this.ExtractFromLame(listLames[l], MarkerMask, MarkerTexture, Result, null);
        }
        if (Chrono != null) {
            System.out.println(Chrono.getTimeSinceMarker(marker));
            Chrono.FreeMarker(marker);
        }
        listLames = null;
        System.err.println("Program finished with " + this.nbErrors + " error(s)/exception(s).");
    }

    public void ExtractFromLame(File Lame, String MarkerMask, String MarkerTexture, File Result, Chronometer Chrono) {
        if (!Lame.isDirectory()) {
            throw new IllegalArgumentException("This file is not a directory.");
        }
        File[] listCenters = Lame.listFiles();
        File[] listFields = null;
        File masks = null;
        File textures = null;
        int marker = 0;
        if (Chrono != null) {
            System.out.print("Extraction des caracteristiques d'une lame : ");
            marker = Chrono.NewMarker();
        }
        try {
            if (!Result.exists()) {
                Result.createNewFile();
            }
            this.Out = new DataOutputStream(new FileOutputStream(Result));
            this.WriteColumnNames();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Error(e.getMessage());
        }
        this.nbErrors = 0;
        for (int c = 0; c < listCenters.length; ++c) {
            if (!listCenters[c].isDirectory()) continue;
            listFields = listCenters[c].listFiles();
            for (int f = 0; f < listFields.length; ++f) {
                if (!listFields[f].isDirectory()) continue;
                masks = new File(listFields[f].getAbsolutePath() + "/Marker_" + MarkerMask + "_Vignettes");
                textures = new File(listFields[f].getAbsolutePath() + "/Marker_" + MarkerTexture + "_Vignettes");
                if (masks == null || masks.listFiles() == null || textures == null || textures.listFiles() == null) continue;
                int length = masks.listFiles().length;
                if (length != textures.listFiles().length) {
                    throw new Error("Number of vignettes different between mask and textures.");
                }
                for (int v = 1; v <= length; ++v) {
                    this.Characterize(listFields[f], Lame.getName(), listCenters[c].getName(), listFields[f].getName(), MarkerMask, MarkerTexture, (v < 10 ? "0" : "") + v);
                }
                masks = null;
                textures = null;
            }
            listFields = null;
        }
        listCenters = null;
        if (Chrono != null) {
            System.out.println(Chrono.getTimeSinceMarker(marker));
            Chrono.FreeMarker(marker);
        }
        System.err.println("Program finished with " + this.nbErrors + " error(s)/exception(s).");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void Characterize(File field, String Lame, String Center2, String Field2, String MarkerMask, String MarkerTexture, String Number2) {
        BufferedImage mask = null;
        BufferedImage texture = null;
        String prefix = Lame + "_" + Center2.substring(7) + "_" + Field2.substring(6) + "_";
        String path = field.getAbsolutePath() + "/";
        try {
            try {
                mask = ImageIO.Read(path + "Marker_" + MarkerMask + "_Vignettes/" + prefix + MarkerMask.toUpperCase() + "_" + Number2 + ".png");
                texture = ImageIO.Read(path + "Marker_" + MarkerTexture + "_Vignettes/" + prefix + MarkerTexture.toUpperCase() + "_" + Number2 + ".png");
                switch (this.CurrentAction) {
                    case 0: {
                        this.ComputeTexturalFeatures(texture, mask);
                        break;
                    }
                    default: {
                        throw new Error("Default: Current action not defined or managed.");
                    }
                }
                mask = null;
                texture = null;
            }
            catch (Error E) {
                Arrays.fill(this.Features, 0.0);
                System.err.println("Error " + this.nbErrors++ + "(computation) => ");
                E.printStackTrace();
                mask = null;
                texture = null;
            }
            catch (Exception E) {
                Arrays.fill(this.Features, 0.0);
                System.err.println("Exception " + this.nbErrors++ + "(computation) => ");
                E.printStackTrace();
                mask = null;
                texture = null;
            }
        }
        catch (Throwable throwable) {
            mask = null;
            texture = null;
            throw throwable;
        }
        try {
            int i2 = 0;
            while (true) {
                if (i2 >= this.Features.length) {
                    this.Out.write(String.valueOf(prefix + MarkerMask + "_" + Number2 + ".png " + Lame + " " + Center2 + " " + Field2 + " " + MarkerMask + " " + Number2 + "\n").getBytes("ASCII"));
                    return;
                }
                this.Out.write(String.valueOf(this.Features[i2] + " ").getBytes("ASCII"));
                ++i2;
            }
        }
        catch (Error E) {
            System.err.println("Error " + this.nbErrors++ + "(writting) => ");
            E.printStackTrace();
            return;
        }
        catch (Exception E) {
            System.err.println("Exception " + this.nbErrors++ + "(writting) => ");
            E.printStackTrace();
        }
    }

    public void setTexturalFeatures() {
        this.btf = new BasicTexturalFeatures2();
        this.FeaturesNames = this.btf.FeaturesNames();
        this.CurrentAction = 0;
    }

    private void ComputeTexturalFeatures(BufferedImage vignette, BufferedImage mask) {
        this.btf.Extract(vignette, mask, 0);
        this.Features = this.btf.Features();
    }

    private void WriteColumnNames() {
        try {
            for (int i2 = 0; i2 < this.FeaturesNames.length; ++i2) {
                this.Out.write(String.valueOf(this.FeaturesNames[i2] + " ").getBytes("ASCII"));
            }
            this.Out.write(String.valueOf("Image Lame Center Field Marker Number\n").getBytes("ASCII"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (Error e) {
            e.printStackTrace();
        }
    }
}

